/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.webview;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.webkit.WebView;
import android.widget.RelativeLayout;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.RxBus;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.basicchanneltemplate.component.PopupComponent;
import com.yy.mobile.ui.webview.WebViewPopupComponent$$EventBinder;
import com.yy.mobile.ui.webview.WebViewPopupController;
import com.yy.mobile.ui.webview.event.WebViewPopupComponentDismissEvent;
import com.yy.mobile.util.ActivityUtilKt;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewEventListener;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewTitleFragmentInterface;
import com.yy.mobile.ylink.bridge.coreapi.WebViewFragmentApi;
import com.yymobile.core.channel.ChannelInfo;
import org.json.JSONException;
import org.json.JSONObject;

public class WebViewPopupComponent
extends PopupComponent
implements EventCompat {
    private static int landscapeWidth;
    private static int landscapeHeight;
    private static int landscapeDistanceX;
    private static int landscapeDistanceY;
    private static int portraitWidth;
    private static int portraitHeight;
    private static int portraitDistanceX;
    private static int portraitDistanceY;
    public static boolean isTitle;
    private static boolean resizeSoftInput;
    private static boolean closeOnTouchOutside;
    private static String url;
    private static MobileActTagInfo actTagInfo;
    private static WebViewPopupComponent component;
    public BaseLinkFragment commonTitleFragment;
    public IWebViewTitleFragmentInterface mWebViewTitleFragmentInterface;
    private WebViewPopupController.OperationReporter mOperationReporter;
    private BaseLinkFragment rootFragment;
    private EventBinder mWebViewPopupComponentSniperEventBinder;

    public BaseLinkFragment getRootFragment() {
        return this.rootFragment;
    }

    public static WebViewPopupComponent newInstance(JSONObject json) {
        WebViewPopupComponent.loadJson(json);
        component = new WebViewPopupComponent();
        return component;
    }

    public static boolean isScreenOriatationPortrait(Context context) {
        if (context instanceof Activity) {
            return ActivityUtilKt.isLandScape((Activity)((Activity)context));
        }
        Activity activity = YYActivityManager.INSTANCE.getCurrentActivity();
        return ActivityUtilKt.isLandScape((Activity)activity);
    }

    public static void loadJson(JSONObject json) {
        if (json != null) {
            try {
                String actId = json.getString("actId");
                url = json.getString("actUrl");
                actTagInfo = new MobileActTagInfo("WebViewPopupComponent", actId);
                JSONObject portraitJson = json.getJSONObject("portrait");
                portraitDistanceX = portraitJson.getInt("x");
                portraitDistanceY = portraitJson.getInt("y");
                portraitWidth = portraitJson.getInt("width");
                portraitHeight = portraitJson.getInt("height");
                Log.d((String)"WebViewPopupComponent", (String)("portraitDistanceX:" + portraitDistanceX + " portraitDistanceY:" + portraitDistanceY + " portraitWidth:" + portraitWidth + " portraitHeight:" + portraitHeight));
                JSONObject landscapeJson = json.getJSONObject("landscape");
                landscapeDistanceX = landscapeJson.getInt("x");
                landscapeDistanceY = landscapeJson.getInt("y");
                landscapeWidth = landscapeJson.getInt("width");
                landscapeHeight = landscapeJson.getInt("height");
                isTitle = json.optBoolean("isTitle", false);
                resizeSoftInput = json.optBoolean("resizeSoftInput", false);
                closeOnTouchOutside = json.optBoolean("closeOnTouchOutside", true);
                MLog.info((Object)"WebViewPopupComponent", (String)("landscapeDistanceX:" + landscapeDistanceX + " landscapeDistanceY:" + landscapeDistanceY + " landscapeWidth:" + landscapeWidth + " landscapeHeight:" + landscapeHeight + " isTitle:" + isTitle), (Object[])new Object[0]);
            }
            catch (JSONException e) {
                Log.e((String)"WebViewPopupComponent", (String)"Empty Catch on loadJson", (Throwable)e);
            }
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.setCanceledOnTouchOutside(closeOnTouchOutside);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        dialog.getWindow().setFlags(1024, 1024);
        if (!resizeSoftInput) {
            dialog.getWindow().getDecorView().setPadding(0, 0, 0, 0);
        }
        if (isTitle) {
            dialog.getWindow().setBackgroundDrawableResource(R.color.white);
        }
        this.setDialogPrepare(dialog);
        if (resizeSoftInput) {
            dialog.getWindow().setSoftInputMode(16);
        }
        return dialog;
    }

    public void setComponent(WebViewPopupController.OperationReporter wpc) {
        this.mOperationReporter = wpc;
    }

    public void onDestroy() {
        super.onDestroy();
        this.mOperationReporter = null;
        actTagInfo = null;
        component = null;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        BaseLinkFragment mWVFragment;
        View layout2 = inflater.inflate(R.layout.webview_dialog, container);
        RelativeLayout webLayout = (RelativeLayout)layout2.findViewById(R.id.webview_fragment);
        if (WebViewPopupComponent.isScreenOriatationPortrait((Context)this.getActivity())) {
            if (isTitle) {
                RelativeLayout.LayoutParams portraitParams = new RelativeLayout.LayoutParams((int)ResolutionUtils.convertDpToPixel((float)portraitWidth, (Context)this.getActivity()), (int)ResolutionUtils.convertDpToPixel((float)portraitHeight, (Context)this.getActivity()));
                portraitParams.addRule(3, R.id.web_title);
                webLayout.setLayoutParams((ViewGroup.LayoutParams)portraitParams);
            } else {
                webLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams((int)ResolutionUtils.convertDpToPixel((float)portraitWidth, (Context)this.getActivity()), (int)ResolutionUtils.convertDpToPixel((float)portraitHeight, (Context)this.getActivity())));
            }
        } else if (isTitle) {
            RelativeLayout.LayoutParams landParams = new RelativeLayout.LayoutParams((int)ResolutionUtils.convertDpToPixel((float)landscapeWidth, (Context)this.getActivity()), (int)ResolutionUtils.convertDpToPixel((float)landscapeHeight, (Context)this.getActivity()));
            landParams.addRule(3, R.id.web_title);
            webLayout.setLayoutParams((ViewGroup.LayoutParams)landParams);
        } else {
            webLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams((int)ResolutionUtils.convertDpToPixel((float)landscapeWidth, (Context)this.getActivity()), (int)ResolutionUtils.convertDpToPixel((float)landscapeHeight, (Context)this.getActivity())));
        }
        FragmentTransaction ft = this.getChildFragmentManager().beginTransaction();
        if (isTitle) {
            RelativeLayout fl = (RelativeLayout)layout2.findViewById(R.id.web_title);
            fl.setVisibility(0);
            this.commonTitleFragment = this.getOrCreateWebViewTitleFragment();
            this.mWebViewTitleFragmentInterface = ((WebViewFragmentApi)CoreApiManager.getInstance().getApi(WebViewFragmentApi.class)).getWebViewTitleFragmentMethod(this.commonTitleFragment);
            if (this.commonTitleFragment.isDetached()) {
                ft.attach((Fragment)this.commonTitleFragment);
            } else if (!this.commonTitleFragment.isAdded()) {
                ft.add(R.id.web_title, (Fragment)this.commonTitleFragment);
            }
        }
        this.rootFragment = mWVFragment = this.getOrCreatWebViewFragment(url, actTagInfo);
        if (mWVFragment.isDetached()) {
            ft.attach((Fragment)mWVFragment);
            ft.commitAllowingStateLoss();
        } else if (!mWVFragment.isAdded()) {
            ft.add(R.id.webview_fragment, (Fragment)mWVFragment);
            ft.commitAllowingStateLoss();
        }
        return layout2;
    }

    private BaseLinkFragment getOrCreatWebViewFragment(String url, MobileActTagInfo actInfo) {
        MyWebViewEventListener listener2 = new MyWebViewEventListener();
        BaseLinkFragment wvFragment = ((WebViewFragmentApi)CoreApiManager.getInstance().getApi(WebViewFragmentApi.class)).createWebViewFragment(url, true, (IWebViewEventListener)listener2, false);
        return wvFragment;
    }

    private BaseLinkFragment getOrCreateWebViewTitleFragment() {
        BaseLinkFragment wvTitleFragment = ((WebViewFragmentApi)CoreApiManager.getInstance().getApi(WebViewFragmentApi.class)).createWebViewTitleFragment();
        return wvTitleFragment;
    }

    private void setDialogPrepare(Dialog dialog) {
        Window win = dialog.getWindow();
        WindowManager.LayoutParams lp = win.getAttributes();
        if (WebViewPopupComponent.isScreenOriatationPortrait((Context)this.getActivity())) {
            lp.x = portraitDistanceX;
            lp.y = portraitDistanceY;
            lp.width = (int)ResolutionUtils.convertDpToPixel((float)portraitWidth, (Context)this.getActivity());
            lp.height = (int)ResolutionUtils.convertDpToPixel((float)portraitHeight, (Context)this.getActivity());
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"zjl", (String)"WebViewPopupComponent", (Object[])new Object[]{"portraitDistanceX:" + lp.x + " portraitDistanceY:" + lp.y + " portraitWidth:" + lp.width + " portraitHeight:" + lp.height});
            }
        } else {
            lp.x = landscapeDistanceX;
            lp.y = landscapeDistanceY;
            lp.width = (int)ResolutionUtils.convertDpToPixel((float)landscapeWidth, (Context)this.getActivity());
            lp.height = (int)ResolutionUtils.convertDpToPixel((float)landscapeHeight, (Context)this.getActivity());
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"zjl", (String)"WebViewPopupComponent", (Object[])new Object[]{"landscapeDistanceX:" + lp.x + " landscapeDistanceY:" + lp.y + " landscapeWidth:" + lp.width + " landscapeHeight:" + lp.height});
            }
        }
        win.setAttributes(lp);
    }

    @BusEvent(sync=true)
    public void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs busEventArgs) {
        ChannelInfo channelInfo = busEventArgs.getInfo();
        if (this.getActivity() != null && !this.getActivity().isFinishing()) {
            this.dismissAllowingStateLoss();
        }
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        RxBus.getDefault().post((Object)new WebViewPopupComponentDismissEvent());
        if (this.mOperationReporter != null) {
            this.mOperationReporter.dismissedSelf(this);
        }
    }

    static {
        closeOnTouchOutside = true;
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mWebViewPopupComponentSniperEventBinder == null) {
            this.mWebViewPopupComponentSniperEventBinder = new WebViewPopupComponent$$EventBinder();
        }
        this.mWebViewPopupComponentSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mWebViewPopupComponentSniperEventBinder != null) {
            this.mWebViewPopupComponentSniperEventBinder.unBindEvent();
        }
    }

    class MyWebViewEventListener
    implements IWebViewEventListener {
        MyWebViewEventListener() {
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        }

        public void onReceivedTitle(WebView view, String title) {
            if (isTitle && WebViewPopupComponent.this.commonTitleFragment != null && WebViewPopupComponent.this.mWebViewTitleFragmentInterface != null) {
                WebViewPopupComponent.this.mWebViewTitleFragmentInterface.setTitleText(title);
            }
        }

        public void handleBackAction() {
        }

        public void shouldOverrideUrlLoading(WebView view, String url) {
        }

        public void onActWebData(String param) {
        }

        public void onViewCreated(View view) {
        }

        public void onPageStarted(WebView view, String url, Bitmap favIcon) {
            if (isTitle && WebViewPopupComponent.this.commonTitleFragment != null && WebViewPopupComponent.this.mWebViewTitleFragmentInterface != null) {
                WebViewPopupComponent.this.mWebViewTitleFragmentInterface.setBackBtnEnableState(true);
                WebViewPopupComponent.this.mWebViewTitleFragmentInterface.setBackListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        WebViewPopupComponent.this.dismiss();
                    }
                });
            }
        }

        public void onPageFinished(WebView view, String url) {
        }

        public void changeHeight(int height) {
        }

        public Animation createAnim(int transit, boolean enter, int nextAnim) {
            return null;
        }
    }

    public static class MobileActTagInfo {
        public String actTag;
        public String tagId;

        public MobileActTagInfo() {
        }

        public MobileActTagInfo(String actTag, String tagId) {
            this.actTag = actTag;
            this.tagId = tagId;
        }

        public String toString() {
            return "MobileActTagInfo{actTag='" + this.actTag + '\'' + ", tagId='" + this.tagId + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MobileActTagInfo that = (MobileActTagInfo)o;
            return this.actTag != null ? this.actTag.equals(that.actTag) : that.actTag == null;
        }

        public int hashCode() {
            int result = this.actTag != null ? this.actTag.hashCode() : 0;
            result = 31 * result + (this.tagId != null ? this.tagId.hashCode() : 0);
            return result;
        }
    }
}

