/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.dialog;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.EditText;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.ui.utils.dialog.FeedbackDialogListener;
import com.yy.mobile.util.ImeUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.valid.BlankUtil;

public class LiveDialogLinkManager
extends DialogLinkManager {
    public LiveDialogLinkManager(Context context) {
        super(context);
    }

    public void showStartLiveInviteInputDialog(String message, String defaultInput, String inputHint, String okBtnText, boolean cancelable, boolean autoShowIme, final boolean autoHideIme, final DialogLinkManager.InputDialogListener listener2) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)"LiveDialogLinkManager", (String)"showStartLiveInviteInputDialog ActivityInvalid....", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
        this.mDialog = this.mBuilder.create();
        this.mDialog.setCancelable(cancelable);
        this.mDialog.show();
        Window window = this.mDialog.getWindow();
        window.setContentView(R.layout.layout_start_live_invite_dialog);
        window.clearFlags(131072);
        window.setSoftInputMode(4);
        TextView tvTitle = (TextView)window.findViewById(R.id.tv_title);
        if (!TextUtils.isEmpty((CharSequence)message)) {
            tvTitle.setText((CharSequence)message);
        }
        final EditText etInput = (EditText)window.findViewById(R.id.et_input_text);
        if (autoShowIme) {
            etInput.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (etInput.isFocused()) {
                        ImeUtil.showIME((Activity)((Activity)LiveDialogLinkManager.this.mContext.get()), (View)etInput);
                        if (Build.VERSION.SDK_INT >= 16) {
                            etInput.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        } else {
                            etInput.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        }
                    }
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)inputHint)) {
            etInput.setHint((CharSequence)inputHint);
        }
        final TextView btnOk = (TextView)window.findViewById(R.id.btn_ok);
        if (okBtnText != null) {
            btnOk.setText((CharSequence)okBtnText);
        }
        if (defaultInput != null) {
            etInput.setText((CharSequence)defaultInput);
            btnOk.setEnabled(true);
        }
        etInput.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start2, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start2, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (BlankUtil.isBlank((String)s.toString())) {
                    btnOk.setEnabled(false);
                } else {
                    btnOk.setEnabled(true);
                }
            }
        });
        btnOk.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                boolean confirmResult = true;
                if (listener2 != null) {
                    String input = etInput.getText().toString();
                    confirmResult = listener2.confirm(input);
                }
                if (autoHideIme) {
                    ImeUtil.hideIME((Context)((Context)LiveDialogLinkManager.this.mContext.get()), (View)etInput);
                }
                if (confirmResult) {
                    LiveDialogLinkManager.this.dismissDialog();
                }
            }
        });
        window.findViewById(R.id.btn_cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (listener2 != null) {
                    listener2.cancel();
                }
                if (autoHideIme) {
                    ImeUtil.hideIME((Context)((Context)LiveDialogLinkManager.this.mContext.get()), (View)etInput);
                }
                LiveDialogLinkManager.this.dismissDialog();
            }
        });
    }

    public void showFeedbackContentMessageOkCancelDialogWithTitle(CharSequence titleText, CharSequence contentMessage, CharSequence okLabel, CharSequence cancelLabel, boolean cancelable, boolean outSideCancelable, final DialogLinkManager.OkCancelDialogListener l, boolean isNeedCenter, final FeedbackDialogListener listener2, boolean showFeedbackBtn) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)"LiveDialogLinkManager", (String)"showNeedCenterOkCancelDialog ActivityInvalid....", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog.isShowing()) {
            this.mDialog.hide();
        }
        this.mDialog = this.mBuilder.create();
        this.mDialog.setCancelable(cancelable);
        this.mDialog.setCanceledOnTouchOutside(outSideCancelable);
        this.mDialog.show();
        Window window = this.mDialog.getWindow();
        window.setContentView(R.layout.layout_mobilelive_feedback_ok_cancel_color_context_link_dialog_with_title);
        TextView tip = (TextView)window.findViewById(R.id.message_content);
        TextView title = (TextView)window.findViewById(R.id.message_title);
        if (!TextUtils.isEmpty((CharSequence)titleText)) {
            title.setText(titleText);
        }
        if (!TextUtils.isEmpty((CharSequence)contentMessage)) {
            tip.setText(contentMessage);
        }
        if (isNeedCenter) {
            tip.setGravity(17);
        } else {
            tip.setGravity(19);
        }
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        if (!TextUtils.isEmpty((CharSequence)okLabel)) {
            ok.setText(okLabel);
        }
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LiveDialogLinkManager.this.mDialog.dismiss();
                if (l != null) {
                    l.onOk();
                }
            }
        });
        TextView cancel = (TextView)window.findViewById(R.id.btn_cancel);
        if (!TextUtils.isEmpty((CharSequence)cancelLabel)) {
            cancel.setText(cancelLabel);
        }
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LiveDialogLinkManager.this.mDialog.dismiss();
                if (l != null) {
                    l.onCancel();
                }
            }
        });
        TextView contactServer = (TextView)window.findViewById(R.id.contact_server);
        if (showFeedbackBtn) {
            contactServer.setVisibility(0);
            contactServer.setClickable(true);
            contactServer.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    LiveDialogLinkManager.this.mDialog.dismiss();
                    if (listener2 != null) {
                        listener2.gotoFeedbackServerCenter();
                    }
                }
            });
        } else {
            contactServer.setVisibility(8);
        }
    }
}

