/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.turntable.v2.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.memoryrecycle.views.YYTextView;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.PopupComponent;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.gift.GiftConfigItemBase;
import com.yymobile.core.gift.GiftConfigParser;

public class LuckyLotteryDialog
extends PopupComponent {
    public static boolean LuckyLotteryDialogIsShow = false;
    public static String GiftTypeKey = "GiftTypeKey";
    public static String GiftNumberKey = "GiftNumberKey";
    private int dialogW = (int)ResolutionUtils.convertDpToPixel((float)250.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int dialogH = (int)ResolutionUtils.convertDpToPixel((float)274.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int giftType = 0;
    private int giftNum = 0;
    private RecycleImageView giftIcon;
    private YYTextView giftInfo;
    private View mRootView;

    public static LuckyLotteryDialog newInstance(int giftType, int giftNum) {
        LuckyLotteryDialog luckyLotteryDialog = new LuckyLotteryDialog();
        Bundle bundle = new Bundle();
        bundle.putInt(GiftTypeKey, giftType);
        bundle.putInt(GiftNumberKey, giftNum);
        luckyLotteryDialog.setArguments(bundle);
        return luckyLotteryDialog;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(0, 16973834);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.giftType = bundle.getInt(GiftTypeKey);
            this.giftNum = bundle.getInt(GiftNumberKey);
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.setCanceledOnTouchOutside(true);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setWindowAnimations(R.style.slide_dialog_animation);
        dialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        dialog.getWindow().setGravity(17);
        dialog.getWindow().setFlags(1024, 1024);
        dialog.getWindow().setLayout(this.dialogW, this.dialogH);
        dialog.getWindow().clearFlags(2);
        return dialog;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        try {
            this.mRootView = inflater.inflate(R.layout.layout_luckylottery_dialog, container);
            this.initView();
        }
        catch (Throwable throwable) {
            MLog.error((Object)"LuckyLotteryDialog", (String)throwable.getMessage(), (Object[])new Object[0]);
            return null;
        }
        return this.mRootView;
    }

    private void initView() {
        this.giftInfo = (YYTextView)this.mRootView.findViewById(R.id.gift_name);
        if (this.giftType != 0) {
            GiftConfigItemBase base = GiftConfigParser.getInstance().getGiftConfigItemByType(this.giftType);
            String giftName = base == null ? "" : base.name;
            this.giftInfo.setText((CharSequence)String.format("%sx%d", giftName, this.giftNum));
        }
        this.giftIcon = (RecycleImageView)this.mRootView.findViewById(R.id.gift_icon);
        String url = GiftConfigParser.getInstance().getGiftIconPath(this.giftType);
        ImageLoader.loadImage((RecycleImageView)this.giftIcon, (String)url, (int)0);
        this.mRootView.findViewById(R.id.btn_ok).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LuckyLotteryDialog.this.dismissAllowingStateLoss();
            }
        });
    }

    public void onDestroy() {
        MLog.info((Object)"LuckyLotteryDialog", (String)"LuckyLotteryDialog is onDestroy", (Object[])new Object[0]);
        LuckyLotteryDialogIsShow = false;
        super.onDestroy();
    }

    public void onDismiss(DialogInterface dialog) {
        MLog.info((Object)"LuckyLotteryDialog", (String)"LuckyLotteryDialog is onDismiss", (Object[])new Object[0]);
        LuckyLotteryDialogIsShow = false;
        super.onDismiss(dialog);
    }
}

