/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.turntable.v2.bigwinner.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGADrawable;
import com.opensource.svgaplayer.SVGADynamicEntity;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.publicchat.top.TextUtils;
import com.yy.mobile.ui.turntable.TurnTableUtils;
import com.yy.mobile.ui.turntable.bigwinner.BigWinnerResult;
import com.yy.mobile.ui.turntable.bigwinner.BigWinnerResults;
import com.yy.mobile.ui.turntable.bigwinner.IBigWinnerCore;
import com.yy.mobile.ui.turntable.core.TurnTableManager;
import com.yy.mobile.ui.turntable.v2.bigwinner.widget.SVGACallbackAdapter;
import com.yy.mobile.ui.utils.SvgaUtil;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.gift.GiftConfigParser;
import com.yyproto.utils.FP;
import io.reactivex.Maybe;
import io.reactivex.MaybeEmitter;
import io.reactivex.MaybeOnSubscribe;
import io.reactivex.MaybeSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Function8;
import io.reactivex.functions.Predicate;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WinnerResultAnimComponent
extends Component {
    private static final int RoundConerRadius = (int)ResolutionUtils.convertDpToPixel((float)4.0f, (Context)BasicConfig.getInstance().getAppContext());
    public static final String[] TEXT_LIWUSHULIANG_LIST = new String[]{"liwu_shuliang_01", "liwu_shuliang_02", "liwu_shuliang_03", "liwu_shuliang_04"};
    public static final String[] ICON_LIWU_LIST = new String[]{"liwu_icon_01", "liwu_icon_02", "liwu_icon_03", "liwu_icon_04"};
    private boolean mIsCreated;
    private boolean mIsWatchMode;
    public SVGAImageView mSvgaImageView;
    private CompositeDisposable mCompositeDisposable = new CompositeDisposable();

    public static WinnerResultAnimComponent newInstance() {
        return new WinnerResultAnimComponent();
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return new FrameLayout((Context)this.getActivity());
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mSvgaImageView = this.createSvgaImageView((Context)this.getActivity(), (ViewGroup)view);
        this.mIsCreated = true;
    }

    private SVGAImageView createSvgaImageView(@NonNull Context context, @NonNull ViewGroup parent) {
        SVGAImageView svgaImageView = new SVGAImageView(context);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        svgaImageView.setId(R.id.bigwinner_result_svga);
        parent.addView((View)svgaImageView, layoutParams);
        svgaImageView.bringToFront();
        svgaImageView.setLoops(1);
        svgaImageView.setClearsAfterStop(true);
        return svgaImageView;
    }

    public void startSvgaAnim(@NonNull SVGAImageView svgaImageView, @NotNull SVGAVideoEntity svgaVideoEntity, @Nullable SVGADynamicEntity dynamicEntity, @Nullable SVGACallback callback2) {
        svgaImageView.stopAnimation();
        svgaImageView.setCallback(callback2);
        SVGADrawable svgaDrawable = null == dynamicEntity ? new SVGADrawable(svgaVideoEntity) : new SVGADrawable(svgaVideoEntity, dynamicEntity);
        svgaImageView.setImageDrawable((Drawable)svgaDrawable);
        svgaImageView.startAnimation();
    }

    private void stopSvgaAnim() {
        if (null != this.mSvgaImageView) {
            this.mSvgaImageView.stopAnimation();
        }
    }

    public void watchMode(boolean isWatchMode) {
        this.mIsWatchMode = isWatchMode;
    }

    public Maybe<Boolean> parseAndStartSvgaAnim(@Nullable Context context, @NonNull String svgaFile, final @NonNull SVGAImageView sVGAImageView, final @Nullable SVGADynamicEntity dynamicEntity, final @Nullable SVGACallback callback2) {
        MLog.info((Object)"WinnerResultAnimComponent", (String)("play svgaFile :" + svgaFile), (Object[])new Object[0]);
        if (null == context || !new File(svgaFile).exists()) {
            return Maybe.just((Object)false);
        }
        return SvgaUtil.parserSvgaFile((Context)context, (String)svgaFile).observeOn(AndroidSchedulers.mainThread()).firstOrError().map((Function)new Function<SVGAVideoEntity, Boolean>(){

            public Boolean apply(SVGAVideoEntity svgaVideoEntity) throws Exception {
                if (null != svgaVideoEntity) {
                    WinnerResultAnimComponent.this.startSvgaAnim(sVGAImageView, svgaVideoEntity, dynamicEntity, callback2);
                }
                return null != svgaVideoEntity;
            }
        }).toMaybe();
    }

    public void callRunnable(@Nullable Runnable runnable) {
        if (null != runnable) {
            runnable.run();
        }
    }

    public void playResultAnim(final @Nullable Runnable onStartedRunnable, final @Nullable Runnable onFinishedRunnable) {
        if (this.mIsCreated && this.checkActivityValid()) {
            boolean isSvgaValid = this.checkWinnerSvgaValid();
            MLog.info((Object)"WinnerResultAnimComponent", (String)("svga valid :" + isSvgaValid), (Object[])new Object[0]);
            if (!isSvgaValid) {
                this.callRunnable(onFinishedRunnable);
                return;
            }
            this.mCompositeDisposable.clear();
            this.mCompositeDisposable.add(this.loadResultAndCreateSVGADynamicEntity().observeOn(AndroidSchedulers.mainThread()).filter((Predicate)new Predicate<SVGADynamicEntity>(){

                public boolean test(SVGADynamicEntity svgaDynamicEntity) throws Exception {
                    return WinnerResultAnimComponent.this.checkActivityValid();
                }
            }).flatMap((Function)new Function<SVGADynamicEntity, MaybeSource<Boolean>>(){

                public MaybeSource<Boolean> apply(SVGADynamicEntity svgaDynamicEntity) throws Exception {
                    String svgaFilePath = WinnerResultAnimComponent.this.getWinnerSvgaFilePath();
                    return WinnerResultAnimComponent.this.parseAndStartSvgaAnim((Context)WinnerResultAnimComponent.this.getActivity(), svgaFilePath, WinnerResultAnimComponent.this.mSvgaImageView, svgaDynamicEntity, new SVGACallbackAdapter(){
                        private boolean isStarted = false;

                        @Override
                        public void onStep(int frame, double percentage) {
                            if (percentage == 1.0) {
                                WinnerResultAnimComponent.this.mSvgaImageView.pauseAnimation();
                                WinnerResultAnimComponent.this.callRunnable(onFinishedRunnable);
                            } else if (percentage >= 0.0 && !this.isStarted) {
                                this.isStarted = true;
                                WinnerResultAnimComponent.this.callRunnable(onStartedRunnable);
                            }
                        }
                    });
                }
            }).subscribe((Consumer)new Consumer<Boolean>(){

                public void accept(Boolean aBoolean) throws Exception {
                    MLog.debug((Object)"WinnerResultAnimComponent", (String)("palyResultAnim success :" + aBoolean), (Object[])new Object[0]);
                    if (!aBoolean.booleanValue()) {
                        WinnerResultAnimComponent.this.callRunnable(onFinishedRunnable);
                    }
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) throws Exception {
                    MLog.info((Object)"WinnerResultAnimComponent", (String)("playResultAnim error:" + throwable), (Object[])new Object[0]);
                    WinnerResultAnimComponent.this.callRunnable(onFinishedRunnable);
                }
            }));
        }
    }

    private Maybe<SVGADynamicEntity> loadResultAndCreateSVGADynamicEntity() {
        return Maybe.zip(this.winnerAvatar(), this.winnerNickname(), this.winnerTotalScore(), this.winnerGiftScore(), this.winnerGiftIcon(0), this.winnerGiftIcon(1), this.winnerGiftIcon(2), this.winnerGiftIcon(3), (Function8)new Function8<SVGADynamicEntity, SVGADynamicEntity, SVGADynamicEntity, SVGADynamicEntity, SVGADynamicEntity, SVGADynamicEntity, SVGADynamicEntity, SVGADynamicEntity, SVGADynamicEntity>(){

            public SVGADynamicEntity apply(SVGADynamicEntity svgaDynamicEntity1, SVGADynamicEntity svgaDynamicEntity2, SVGADynamicEntity svgaDynamicEntity3, SVGADynamicEntity svgaDynamicEntity4, SVGADynamicEntity svgaDynamicEntity5, SVGADynamicEntity svgaDynamicEntity6, SVGADynamicEntity svgaDynamicEntity7, SVGADynamicEntity svgaDynamicEntity8) throws Exception {
                SVGADynamicEntity newEntity = new SVGADynamicEntity();
                WinnerResultAnimComponent.this.handleNewSGVADynamicEntity(newEntity, svgaDynamicEntity1);
                WinnerResultAnimComponent.this.handleNewSGVADynamicEntity(newEntity, svgaDynamicEntity2);
                WinnerResultAnimComponent.this.handleNewSGVADynamicEntity(newEntity, svgaDynamicEntity3);
                WinnerResultAnimComponent.this.handleNewSGVADynamicEntity(newEntity, svgaDynamicEntity4);
                WinnerResultAnimComponent.this.handleNewSGVADynamicEntity(newEntity, svgaDynamicEntity5);
                WinnerResultAnimComponent.this.handleNewSGVADynamicEntity(newEntity, svgaDynamicEntity6);
                WinnerResultAnimComponent.this.handleNewSGVADynamicEntity(newEntity, svgaDynamicEntity7);
                WinnerResultAnimComponent.this.handleNewSGVADynamicEntity(newEntity, svgaDynamicEntity8);
                return newEntity;
            }
        });
    }

    public void handleNewSGVADynamicEntity(SVGADynamicEntity newEntity, SVGADynamicEntity oldEntity) {
        HashMap text = oldEntity.getDynamicText();
        HashMap textPaint = oldEntity.getDynamicTextPaint();
        HashMap bitmapMap = oldEntity.getDynamicImage();
        if (!FP.empty((CharSequence)((CharSequence)text.get("nicheng")))) {
            newEntity.setDynamicText(TextUtils.INSTANCE.handleMaxText((String)text.get("nicheng"), 11), (TextPaint)textPaint.get("nicheng"), "nicheng");
        }
        if (!FP.empty((CharSequence)((CharSequence)text.get("liwujifen")))) {
            newEntity.setDynamicText((String)text.get("liwujifen"), (TextPaint)textPaint.get("liwujifen"), "liwujifen");
        }
        if (null != bitmapMap.get("win")) {
            Bitmap roundBitmap = TurnTableUtils.getRoundedCornerBitmap((Bitmap)((Bitmap)bitmapMap.get("win")), (int)RoundConerRadius);
            newEntity.setDynamicImage(roundBitmap, "win");
        }
        if (!FP.empty((CharSequence)((CharSequence)text.get("liwu_shuliang_01")))) {
            newEntity.setDynamicText((String)text.get("liwu_shuliang_01"), (TextPaint)textPaint.get("liwu_shuliang_01"), "liwu_shuliang_01");
        }
        if (!FP.empty((CharSequence)((CharSequence)text.get("liwu_shuliang_02")))) {
            newEntity.setDynamicText((String)text.get("liwu_shuliang_02"), (TextPaint)textPaint.get("liwu_shuliang_02"), "liwu_shuliang_02");
        }
        if (!FP.empty((CharSequence)((CharSequence)text.get("liwu_shuliang_03")))) {
            newEntity.setDynamicText((String)text.get("liwu_shuliang_03"), (TextPaint)textPaint.get("liwu_shuliang_03"), "liwu_shuliang_03");
        }
        if (!FP.empty((CharSequence)((CharSequence)text.get("liwu_shuliang_04")))) {
            newEntity.setDynamicText((String)text.get("liwu_shuliang_04"), (TextPaint)textPaint.get("liwu_shuliang_04"), "liwu_shuliang_04");
        }
        if (null != bitmapMap.get("liwu_icon_01")) {
            newEntity.setDynamicImage((Bitmap)bitmapMap.get("liwu_icon_01"), "liwu_icon_01");
        }
        if (null != bitmapMap.get("liwu_icon_02")) {
            newEntity.setDynamicImage((Bitmap)bitmapMap.get("liwu_icon_02"), "liwu_icon_02");
        }
        if (null != bitmapMap.get("liwu_icon_03")) {
            newEntity.setDynamicImage((Bitmap)bitmapMap.get("liwu_icon_03"), "liwu_icon_03");
        }
        if (null != bitmapMap.get("liwu_icon_04")) {
            newEntity.setDynamicImage((Bitmap)bitmapMap.get("liwu_icon_04"), "liwu_icon_04");
        }
    }

    private Maybe<SVGADynamicEntity> winnerGiftScore() {
        return Maybe.just((Object)new SVGADynamicEntity()).doOnSuccess((Consumer)new Consumer<SVGADynamicEntity>(){

            public void accept(SVGADynamicEntity svgaDynamicEntity) throws Exception {
                List giftList;
                BigWinnerResults results = WinnerResultAnimComponent.this.getResults();
                if (null != results && !FP.empty((Collection)(giftList = results.getTotalGiftVector()))) {
                    for (int i = 0; i < 4; ++i) {
                        Pair item2 = (Pair)giftList.get(i);
                        if (null == item2) continue;
                        TextPaint scoreTextPaint = new TextPaint();
                        scoreTextPaint.setColor(Color.parseColor((String)"#bbbbbb"));
                        scoreTextPaint.setTextSize(TypedValue.applyDimension((int)0, (float)26.0f, (DisplayMetrics)ScreenUtil.getInstance().getDisplayMetrics()));
                        scoreTextPaint.setTextAlign(Paint.Align.LEFT);
                        scoreTextPaint.setAntiAlias(true);
                        svgaDynamicEntity.setDynamicText("x " + TurnTableUtils.alignGiftNum((String)((String)item2.second), (int)8), scoreTextPaint, TEXT_LIWUSHULIANG_LIST[i]);
                    }
                }
            }
        });
    }

    private Maybe<SVGADynamicEntity> winnerTotalScore() {
        return Maybe.just((Object)new SVGADynamicEntity()).doOnSuccess((Consumer)new Consumer<SVGADynamicEntity>(){

            public void accept(SVGADynamicEntity svgaDynamicEntity) throws Exception {
                BigWinnerResults results = WinnerResultAnimComponent.this.getResults();
                if (null != results) {
                    int totalScore = results.getTotalScore();
                    TextPaint scoreTextPaint = new TextPaint();
                    scoreTextPaint.setColor(Color.parseColor((String)"#ffdd00"));
                    scoreTextPaint.setTextSize(TypedValue.applyDimension((int)0, (float)26.0f, (DisplayMetrics)ScreenUtil.getInstance().getDisplayMetrics()));
                    scoreTextPaint.setAntiAlias(true);
                    svgaDynamicEntity.setDynamicText("\u793c\u7269\u603b\u79ef\u5206\uff1a" + totalScore, scoreTextPaint, "liwujifen");
                }
            }
        });
    }

    private Maybe<SVGADynamicEntity> winnerNickname() {
        return Maybe.just((Object)new SVGADynamicEntity()).doOnSuccess((Consumer)new Consumer<SVGADynamicEntity>(){

            public void accept(SVGADynamicEntity svgaDynamicEntity) throws Exception {
                List resultList;
                BigWinnerResult curWinnerResult;
                BigWinnerResults results = WinnerResultAnimComponent.this.getResults();
                if (null != results && !FP.empty((Collection)results.getBigWinnerResults()) && null != (curWinnerResult = (BigWinnerResult)(resultList = results.getBigWinnerResults()).get(results.getBigWinnerSeat() - 1))) {
                    String winnerName = curWinnerResult.getNick();
                    TextPaint nameTextPaint = new TextPaint();
                    nameTextPaint.setColor(Color.parseColor((String)"#ffffff"));
                    nameTextPaint.setTextSize(TypedValue.applyDimension((int)0, (float)28.0f, (DisplayMetrics)ScreenUtil.getInstance().getDisplayMetrics()));
                    nameTextPaint.setAntiAlias(true);
                    svgaDynamicEntity.setDynamicText(winnerName, nameTextPaint, "nicheng");
                }
            }
        });
    }

    public BigWinnerResults getResults() {
        BigWinnerResults results = ((IBigWinnerCore)ICoreManagerBase.getCore(IBigWinnerCore.class)).getWinnerResults();
        if (this.mIsWatchMode) {
            results = ((IBigWinnerCore)ICoreManagerBase.getCore(IBigWinnerCore.class)).getWatchResults();
        }
        return results;
    }

    private Maybe<SVGADynamicEntity> winnerAvatar() {
        List resultList;
        BigWinnerResult curWinnerResult;
        final SVGADynamicEntity entity = new SVGADynamicEntity();
        BigWinnerResults results = this.getResults();
        if (null != results && !FP.empty((Collection)results.getBigWinnerResults()) && null != (curWinnerResult = (BigWinnerResult)(resultList = results.getBigWinnerResults()).get(results.getBigWinnerSeat() - 1))) {
            String winnerAvatarUrl = curWinnerResult.getLogoUrl();
            if (!FP.empty((CharSequence)winnerAvatarUrl)) {
                return this.loadBitmap(winnerAvatarUrl).observeOn(AndroidSchedulers.mainThread()).map((Function)new Function<Bitmap, SVGADynamicEntity>(){

                    public SVGADynamicEntity apply(Bitmap bitmap) throws Exception {
                        entity.setDynamicImage(bitmap, "win");
                        return entity;
                    }
                });
            }
            return Maybe.just((Object)entity).doOnSuccess((Consumer)new Consumer<SVGADynamicEntity>(){

                public void accept(SVGADynamicEntity svgaDynamicEntity) throws Exception {
                    Bitmap defaultIconBitmap = BitmapFactory.decodeResource((Resources)WinnerResultAnimComponent.this.getResources(), (int)R.drawable.default_portrait);
                    entity.setDynamicImage(defaultIconBitmap, "win");
                }
            });
        }
        return Maybe.just((Object)entity);
    }

    private Maybe<SVGADynamicEntity> winnerGiftIcon(final @IntRange(from=0L, to=3L) int index) {
        Pair curGiftItem;
        List giftList;
        final SVGADynamicEntity entity = new SVGADynamicEntity();
        BigWinnerResults results = this.getResults();
        if (null != results && index >= 0 && index < 4 && !FP.empty((Collection)(giftList = results.getTotalGiftVector())) && null != (curGiftItem = (Pair)giftList.get(index))) {
            String giftUrl = GiftConfigParser.getInstance().getGiftIconPath(StringUtils.safeParseInt((String)((String)curGiftItem.first)));
            if (!FP.empty((CharSequence)giftUrl)) {
                return this.loadBitmap(giftUrl).observeOn(AndroidSchedulers.mainThread()).map((Function)new Function<Bitmap, SVGADynamicEntity>(){

                    public SVGADynamicEntity apply(Bitmap bitmap) throws Exception {
                        entity.setDynamicImage(bitmap, ICON_LIWU_LIST[index]);
                        return entity;
                    }
                });
            }
            return Maybe.just((Object)entity).doOnSuccess((Consumer)new Consumer<SVGADynamicEntity>(){

                public void accept(SVGADynamicEntity svgaDynamicEntity) throws Exception {
                    Bitmap defaultIconBitmap = BitmapFactory.decodeResource((Resources)WinnerResultAnimComponent.this.getResources(), (int)R.drawable.lr_ic_default_gift);
                    entity.setDynamicImage(defaultIconBitmap, ICON_LIWU_LIST[index]);
                }
            });
        }
        return Maybe.just((Object)entity);
    }

    private Maybe<Bitmap> loadBitmap(final @NonNull String url) {
        MLog.info((Object)"WinnerResultAnimComponent", (String)("loadBitmap url: " + url), (Object[])new Object[0]);
        return Maybe.create((MaybeOnSubscribe)new MaybeOnSubscribe<Bitmap>(){

            public void subscribe(final MaybeEmitter<Bitmap> emitter) throws Exception {
                Glide.with((FragmentActivity)WinnerResultAnimComponent.this.getActivity()).asBitmap().load(url).into((Target)new SimpleTarget<Bitmap>(){

                    public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                        if (!emitter.isDisposed()) {
                            emitter.onSuccess((Object)resource);
                            emitter.onComplete();
                        }
                    }

                    public void onLoadFailed(@Nullable Drawable errorDrawable) {
                        if (!emitter.isDisposed()) {
                            emitter.onError(new Throwable("onLoadFailed :" + url));
                        }
                    }
                });
            }
        });
    }

    public void setPlayPostion(int width, int height, int x, int y) {
        if (this.mIsCreated && null != this.mSvgaImageView) {
            MLog.info((Object)"WinnerResultAnimComponent", (String)("setViewPosition-> width:" + width + " height:" + height + " x:" + x + " y:" + y), (Object[])new Object[0]);
            ViewGroup.LayoutParams layoutParams = this.mSvgaImageView.getLayoutParams();
            if (null == layoutParams) {
                layoutParams = new ViewGroup.LayoutParams(width, height);
            } else {
                layoutParams.width = width;
                layoutParams.height = height;
            }
            this.mSvgaImageView.setLayoutParams(layoutParams);
            this.mSvgaImageView.setX((float)x);
            this.mSvgaImageView.setY((float)y);
        }
    }

    public String getWinnerSvgaFilePath() {
        if (null == TurnTableManager.turnTableEntryInfo) {
            return "";
        }
        MLog.debug((Object)"WinnerResultAnimComponent", (String)("svga file path :" + TurnTableManager.turnTableEntryInfo.filePath), (Object[])new Object[0]);
        return new File(TurnTableManager.turnTableEntryInfo.filePath, "bigWinnerGold.svga").getAbsolutePath();
    }

    private boolean checkWinnerSvgaValid() {
        File svgaFile = new File(this.getWinnerSvgaFilePath());
        return svgaFile.isFile() && svgaFile.exists();
    }

    public void stopResultAnim() {
        this.mCompositeDisposable.clear();
        if (this.mIsCreated) {
            this.stopSvgaAnim();
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mCompositeDisposable.clear();
        this.stopSvgaAnim();
        this.mIsCreated = false;
        this.mIsWatchMode = false;
    }
}

