/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.turntable.v2.bigwinner;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.RxBus;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.publicchat.top.TextUtils;
import com.yy.mobile.ui.turntable.TurnTableUtils;
import com.yy.mobile.ui.turntable.bigwinner.BigWinnerResult;
import com.yy.mobile.ui.turntable.bigwinner.BigWinnerResults;
import com.yy.mobile.ui.turntable.bigwinner.IBigWinnerCore;
import com.yy.mobile.ui.turntable.bigwinner.event.BigWinner_OnGameActionResult_EventArgs;
import com.yy.mobile.ui.turntable.bigwinner.event.BigWinner_OnGameStatusChanged_EventArgs;
import com.yy.mobile.ui.turntable.bigwinner.event.BigWinner_OnUpdateSeatInfo_EventArgs;
import com.yy.mobile.ui.turntable.bigwinner.event.BigWinner_OnWatchRecordRsp_EventArgs;
import com.yy.mobile.ui.turntable.bigwinner.event.BigWinner_OnWinnerResultNotify_EventArgs;
import com.yy.mobile.ui.turntable.v2.RuleFragment;
import com.yy.mobile.ui.turntable.v2.bigwinner.BigWinnerComponent$$EventBinder;
import com.yy.mobile.ui.turntable.v2.bigwinner.GamePlayDelegate;
import com.yy.mobile.ui.turntable.v2.bigwinner.GameWatchDelegate;
import com.yy.mobile.ui.turntable.v2.bigwinner.WinnerSeatZoneDelegate;
import com.yy.mobile.ui.turntable.v2.bigwinner.widget.WinnerHistoryComponent;
import com.yy.mobile.ui.turntable.v2.bigwinner.widget.WinnerResultAnimComponent;
import com.yy.mobile.ui.turntable.v2.bigwinner.widget.WinnerSeat;
import com.yy.mobile.ui.turntable.v2.bigwinner.widget.WinnerSeatZone;
import com.yy.mobile.ui.turntable.v2.event.BigWinner_OnSeatLotteryAnim_EventArgs;
import com.yy.mobile.ui.turntable.v2.event.TurnTableCommonEvent;
import com.yy.mobile.ui.utils.ViewUtils;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yyproto.utils.FP;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import java.util.Collection;

public class BigWinnerComponent
extends Component {
    protected View mHistoryBtn;
    protected View mHelpBtn;
    protected View mSvagLayout;
    protected TextView mBroadcastTxv;
    protected TextView mStartBtn;
    protected TextView mCancelBtn;
    protected TextView mStartWatchBtn;
    protected TextView mCancelWatchBtn;
    private WinnerResultAnimComponent mWinnerResultAnimComponent;
    private CompositeDisposable mCompositeDisposable = new CompositeDisposable();
    public boolean mIsWatchMode = false;
    private Fragment mRuleFragment;
    private Fragment mHistoryFragment;
    public WinnerSeatZoneDelegate mWinnerSeatZoneDelegate;
    public GameWatchDelegate mGameWatchDelegate;
    private GamePlayDelegate mGamePlayDelegate;
    private Runnable btnEnableRunnable = new Runnable(){

        @Override
        public void run() {
            BigWinnerComponent.this.mStartBtn.setEnabled(true);
            BigWinnerComponent.this.mStartWatchBtn.setEnabled(true);
        }
    };
    private EventBinder mBigWinnerComponentSniperEventBinder;

    public static BigWinnerComponent newInstance() {
        return new BigWinnerComponent();
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_bigwinner, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        if (this.mBigWinnerComponentSniperEventBinder == null) {
            this.mBigWinnerComponentSniperEventBinder = new BigWinnerComponent$$EventBinder();
        }
        this.mBigWinnerComponentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, savedInstanceState);
        this.mHistoryBtn = view.findViewById(R.id.record_btn);
        this.mHelpBtn = view.findViewById(R.id.help_btn);
        this.mBroadcastTxv = (TextView)view.findViewById(R.id.broadcast);
        this.mStartBtn = (TextView)view.findViewById(R.id.start_btn);
        this.mCancelBtn = (TextView)view.findViewById(R.id.cancel_btn);
        this.mStartWatchBtn = (TextView)view.findViewById(R.id.watch_btn);
        this.mCancelWatchBtn = (TextView)view.findViewById(R.id.cancel_watch_btn);
        this.mSvagLayout = view.findViewById(R.id.svga_layout);
        this.mCompositeDisposable.add(ViewUtils.clicks((View)this.mHistoryBtn, (long)500L).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                BigWinnerComponent.this.showHistoryComponent();
            }
        }, RxUtils.errorConsumer((String)"BigWinnerComponent")));
        this.mCompositeDisposable.add(ViewUtils.clicks((View)this.mHelpBtn, (long)500L).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                BigWinnerComponent.this.showRuleComponent();
            }
        }, RxUtils.errorConsumer((String)"BigWinnerComponent")));
        this.mWinnerSeatZoneDelegate = new WinnerSeatZoneDelegate((WinnerSeatZone)view.findViewById(R.id.seat_zone));
        this.mWinnerSeatZoneDelegate.onInit();
        this.mGameWatchDelegate = new GameWatchDelegate(this);
        this.mGameWatchDelegate.onInit();
        this.mGamePlayDelegate = new GamePlayDelegate(this);
        this.mGamePlayDelegate.onInit();
        this.initSvgaComponent();
        this.initGameStatus();
    }

    private void initGameStatus() {
        this.watchMode(false);
        this.resetGameStatus();
        this.mGamePlayDelegate.updateBoradcast();
        this.mGamePlayDelegate.updateBtn();
        this.queryGameStatus();
        this.startAndWatchBtnEnable(false);
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        if (null != this.mRuleFragment && this.mRuleFragment.isVisible()) {
            this.mRuleFragment.setUserVisibleHint(isVisibleToUser);
        }
        if (null != this.mHistoryFragment && this.mHistoryFragment.isVisible()) {
            this.mHistoryFragment.setUserVisibleHint(isVisibleToUser);
        }
    }

    private void queryGameStatus() {
        ((IBigWinnerCore)ICoreManagerBase.getCore(IBigWinnerCore.class)).queryGameStatus();
    }

    private void initSvgaComponent() {
        if (null == this.mWinnerResultAnimComponent) {
            this.mWinnerResultAnimComponent = WinnerResultAnimComponent.newInstance();
            this.getChildFragmentManager().beginTransaction().replace(R.id.svga_layout, (Fragment)this.mWinnerResultAnimComponent, "tag_svga_component").commitAllowingStateLoss();
        }
    }

    protected void resetGameStatus() {
        MLog.info((Object)"BigWinnerComponent", (String)"restGameStatus", (Object[])new Object[0]);
        ((IBigWinnerCore)ICoreManagerBase.getCore(IBigWinnerCore.class)).resetGameStatus();
    }

    protected void resetGameView() {
        MLog.info((Object)"BigWinnerComponent", (String)"resetGameView", (Object[])new Object[0]);
        this.mGamePlayDelegate.reset();
        this.mGameWatchDelegate.reset();
        this.hideResultSvgaAnim();
        this.mWinnerSeatZoneDelegate.stopLotteryAnim();
        this.mWinnerSeatZoneDelegate.showSeatZone();
        this.mWinnerSeatZoneDelegate.restFrontSildeImmediate();
        this.mWinnerSeatZoneDelegate.hideAllWinnerScore();
        this.mWinnerSeatZoneDelegate.clearAllSeatInfo();
        this.mWinnerSeatZoneDelegate.clearTopLabelInfo();
        this.mWinnerSeatZoneDelegate.disableAllSeatFlip();
    }

    protected void startAndWatchBtnEnable(boolean isEnable) {
        this.mStartBtn.setEnabled(isEnable);
        this.mStartWatchBtn.setEnabled(isEnable);
        this.getHandler().removeCallbacks(this.btnEnableRunnable);
        if (!isEnable) {
            this.getHandler().postDelayed(this.btnEnableRunnable, 3000L);
        }
    }

    public void showHistoryComponent() {
        MLog.debug((Object)"BigWinnerComponent", (String)"showHistoryComponent", (Object[])new Object[0]);
        try {
            Object historyComponent = this.getChildFragmentManager().findFragmentByTag("history_component");
            if (null == historyComponent) {
                historyComponent = WinnerHistoryComponent.newInstance();
            }
            this.mHistoryFragment = historyComponent;
            FragmentTransaction ft = this.getChildFragmentManager().beginTransaction();
            if (!historyComponent.isAdded()) {
                ft.setCustomAnimations(R.anim.turntable_slide_in_left, R.anim.turntable_slide_out_left, R.anim.turntable_slide_in_left, R.anim.turntable_slide_out_left);
                ft.addToBackStack(null);
                ft.add(R.id.extend_layout, historyComponent, "history_component");
            } else {
                ft.show(historyComponent);
            }
            ft.commitAllowingStateLoss();
        }
        catch (Exception e) {
            e.printStackTrace();
            MLog.info((Object)"BigWinnerComponent", (String)("showHistoryComponent error :" + e), (Object[])new Object[0]);
        }
    }

    public void showRuleComponent() {
        MLog.debug((Object)"BigWinnerComponent", (String)"showRuleComponent", (Object[])new Object[0]);
        try {
            Object fragment = this.getChildFragmentManager().findFragmentByTag("RuleFragment");
            if (null == fragment) {
                fragment = RuleFragment.newInstance(TurnTableUtils.creatRuleWebUrl((TurnTableUtils.RuleWebViewType)TurnTableUtils.RuleWebViewType.BigWinner));
            }
            this.mRuleFragment = fragment;
            FragmentTransaction ft = this.getChildFragmentManager().beginTransaction();
            if (!fragment.isAdded()) {
                ft.setCustomAnimations(R.anim.turntable_slide_in_right, R.anim.turntable_slide_out_right, R.anim.turntable_slide_in_right, R.anim.turntable_slide_out_right);
                ft.addToBackStack(null);
                ft.add(R.id.extend_layout, fragment, "RuleFragment");
            } else {
                ft.show(fragment);
            }
            ft.commitAllowingStateLoss();
        }
        catch (Exception e) {
            e.printStackTrace();
            MLog.info((Object)"BigWinnerComponent", (String)("showRuleComponent error :" + e), (Object[])new Object[0]);
        }
    }

    public void showResultSvgaAnim() {
        MLog.info((Object)"BigWinnerComponent", (String)"showResultSvgaAnim", (Object[])new Object[0]);
        this.mSvagLayout.setVisibility(0);
        if (null != this.mWinnerResultAnimComponent && this.mWinnerResultAnimComponent.isVisible() && !this.mWinnerResultAnimComponent.isDetached()) {
            int seatZoneWidth = this.mWinnerSeatZoneDelegate.getSeatZone().getWidth();
            int seatZoneHeight = this.mWinnerSeatZoneDelegate.getSeatZone().getHeight();
            MLog.info((Object)"BigWinnerComponent", (String)("seatZoneWidth :" + seatZoneWidth + " seatZoneHeight:" + seatZoneHeight), (Object[])new Object[0]);
            if (seatZoneWidth > 0 && seatZoneHeight > 0) {
                int offset = DimenConverter.dip2px((Context)this.getActivity(), (float)60.0f);
                int left = this.mWinnerSeatZoneDelegate.getSeatZone().getLeft();
                int top = this.mWinnerSeatZoneDelegate.getSeatZone().getTop();
                this.mWinnerResultAnimComponent.setPlayPostion(seatZoneWidth + offset, seatZoneWidth + offset, (int)((float)left - (float)offset * 0.5f), (int)((float)top - (float)offset * 0.5f));
                this.mWinnerResultAnimComponent.playResultAnim(new Runnable(){

                    @Override
                    public void run() {
                        if (null != BigWinnerComponent.this.mWinnerSeatZoneDelegate && BigWinnerComponent.this.checkActivityValid()) {
                            MLog.info((Object)"BigWinnerComponent", (String)"play winnerResult anim started", (Object[])new Object[0]);
                            BigWinnerComponent.this.mWinnerSeatZoneDelegate.hideSeatZone();
                        }
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        MLog.info((Object)"BigWinnerComponent", (String)"pay winnerResult anim finished", (Object[])new Object[0]);
                        if (!BigWinnerComponent.this.mIsWatchMode) {
                            ((IBigWinnerCore)ICoreManagerBase.getCore(IBigWinnerCore.class)).setGameFinishedFlag();
                        } else {
                            BigWinnerComponent.this.mGameWatchDelegate.showCancelWatchBtn();
                        }
                    }
                });
            }
        }
    }

    private void hideResultSvgaAnim() {
        MLog.info((Object)"BigWinnerComponent", (String)"hideResultSvgaAnim", (Object[])new Object[0]);
        this.mSvagLayout.setVisibility(4);
        if (null != this.mWinnerResultAnimComponent && this.mWinnerResultAnimComponent.isVisible() && !this.mWinnerResultAnimComponent.isDetached()) {
            this.mWinnerResultAnimComponent.stopResultAnim();
        }
    }

    @BusEvent(busName="plugin_pluginunionlive", busType=1, scheduler=2)
    public void onSeatLotteryAnim(BigWinner_OnSeatLotteryAnim_EventArgs eventArgs) {
        WinnerSeat seat = this.mWinnerSeatZoneDelegate.getSeatZone().getSeatByIndex(eventArgs.getIndex());
        if (eventArgs.getStep() == 3) {
            seat.setEnableFlip(true);
            if (eventArgs.getIndex() == 8) {
                this.updateBroadcast("\u6bd4\u8d5b\u7ed3\u675f \u8d62\u5bb6\u901a\u5403\u5168\u90e8\u793c\u7269");
                this.getHandler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BigWinnerComponent.this.showResultSvgaAnim();
                    }
                }, 1000L);
            }
        } else if (eventArgs.getStep() == 0) {
            if (null != this.mWinnerSeatZoneDelegate) {
                this.updateLotteryBroadcast(eventArgs.getIndex());
            }
        } else if (eventArgs.getStep() == 2 && null != this.mWinnerSeatZoneDelegate) {
            this.mWinnerSeatZoneDelegate.updateWinnerTopLabel(eventArgs.getIndex());
            this.mWinnerSeatZoneDelegate.showWinnerScore(eventArgs.getIndex());
        }
    }

    private void updateLotteryBroadcast(int index) {
        BigWinnerResult result;
        BigWinnerResults results = ((IBigWinnerCore)ICoreManagerBase.getCore(IBigWinnerCore.class)).getWinnerResults();
        if (this.mIsWatchMode) {
            results = ((IBigWinnerCore)ICoreManagerBase.getCore(IBigWinnerCore.class)).getWatchResults();
        }
        if (null != results && !FP.empty((Collection)results.getBigWinnerResults()) && null != (result = (BigWinnerResult)results.getBigWinnerResults().get(index))) {
            this.updateBroadcast(String.format("%s \u62bd\u4e2d\u79ef\u5206%s\u7684\u793c\u7269", TextUtils.INSTANCE.handleMaxText(result.getNick(), 8), result.getScore()));
        }
    }

    @BusEvent(scheduler=2)
    public void onGameStatusChanged(BigWinner_OnGameStatusChanged_EventArgs eventArgs) {
        if (this.mIsWatchMode) {
            return;
        }
        this.mGamePlayDelegate.updateBtn();
        this.mGamePlayDelegate.updateBoradcast();
        if (eventArgs.getGameStatus() == 2) {
            this.mGamePlayDelegate.startCountdown();
        } else if (eventArgs.getGameStatus() == 1) {
            this.startAndWatchBtnEnable(true);
        } else if (eventArgs.getGameStatus() == 0) {
            this.resetGameView();
        } else if (eventArgs.getGameStatus() == 3) {
            this.watchMode(false);
        } else if (eventArgs.getGameStatus() == 4) {
            this.updateGiftReward();
        }
    }

    private void updateGiftReward() {
        RxBus.getDefault().post((Object)new TurnTableCommonEvent(2, null));
    }

    protected void updateBroadcast(@NonNull CharSequence broadcast) {
        this.mBroadcastTxv.setTextColor(Color.parseColor((String)"#ffffff"));
        StringBuilder sb = new StringBuilder("\u202d" + broadcast + "\u202c");
        this.mBroadcastTxv.setText((CharSequence)sb.toString());
    }

    @BusEvent(scheduler=2)
    public void onUpdateSeatInfo(BigWinner_OnUpdateSeatInfo_EventArgs eventArgs) {
        if (this.mIsWatchMode) {
            return;
        }
        MLog.info((Object)"BigWinnerComponent", (String)("onUpdateSeatInfo :" + eventArgs.toString()), (Object[])new Object[0]);
        if (null != this.mWinnerSeatZoneDelegate) {
            this.mWinnerSeatZoneDelegate.updateAllSeatInfo();
        }
    }

    @BusEvent(scheduler=2)
    public void onGameActionResult(BigWinner_OnGameActionResult_EventArgs eventArgs) {
        MLog.debug((Object)"BigWinnerComponent", (String)("onGameActionResult :" + eventArgs), (Object[])new Object[0]);
        this.startAndWatchBtnEnable(true);
        if (eventArgs.getResult() != 0) {
            if (eventArgs.getResult() == 1) {
                if (eventArgs.getAction() == 1) {
                    this.toast("\u8bf7\u6c42\u5339\u914d\u5931\u8d25");
                }
            } else if (eventArgs.getResult() == 2) {
                this.toast("\u6ca1\u6709\u8db3\u591f\u62bd\u5956\u5238");
            } else if (eventArgs.getResult() == 3) {
                this.queryGameStatus();
            } else if (eventArgs.getResult() == 4) {
                this.toast("\u6b63\u5728\u6e38\u620f\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
    }

    @BusEvent(scheduler=2)
    public void onWinnerResultNotify(BigWinner_OnWinnerResultNotify_EventArgs eventArgs) {
        if (this.mIsWatchMode) {
            return;
        }
        MLog.debug((Object)"BigWinnerComponent", (String)("onWinnerResultNotify :" + eventArgs), (Object[])new Object[0]);
        if (eventArgs.isValidResult()) {
            this.mGamePlayDelegate.startBigWinnerGame();
        } else {
            this.resetGameStatus();
            this.toast("\u62bd\u5956\u5931\u8d25\uff0c\u8bf7\u9000\u51fa\u91cd\u8bd5");
        }
        this.mGamePlayDelegate.stopQueryWinnerResultTask();
    }

    @BusEvent(scheduler=2)
    public void onWatchRecordRsp(BigWinner_OnWatchRecordRsp_EventArgs eventArgs) {
        this.startAndWatchBtnEnable(true);
        if (eventArgs.isSucc()) {
            this.watchMode(true);
            this.mGamePlayDelegate.hideAllBtn();
            this.mGameWatchDelegate.onStartWatchGame();
        } else {
            this.watchMode(false);
            this.toast("\u5f53\u524d\u6ca1\u6709\u573a\u6b21\u53ef\u4ee5\u89c2\u770b\u54e6");
        }
    }

    protected void watchMode(boolean isWatchMode) {
        MLog.info((Object)"BigWinnerComponent", (String)("watchMode :" + isWatchMode), (Object[])new Object[0]);
        this.mIsWatchMode = isWatchMode;
        this.mWinnerSeatZoneDelegate.watchMode(isWatchMode);
        if (null != this.mWinnerResultAnimComponent) {
            this.mWinnerResultAnimComponent.watchMode(isWatchMode);
        }
    }

    protected void fillDataIntoAllBackSideScoreList() {
        this.mWinnerSeatZoneDelegate.fillDataIntoAllBackSideScoreList();
    }

    protected void updateWatchSeatInfo() {
        this.mWinnerSeatZoneDelegate.updateWatchSeatInfo();
    }

    protected void startWinnerLottery() {
        this.mWinnerSeatZoneDelegate.startLotteryAnim();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mWinnerSeatZoneDelegate.onDispose();
        this.mGameWatchDelegate.onDispose();
        this.mGamePlayDelegate.onDispose();
        this.mCompositeDisposable.clear();
        this.mRuleFragment = null;
        this.mHistoryFragment = null;
        Object var2_1 = null;
        if (this.mBigWinnerComponentSniperEventBinder != null) {
            this.mBigWinnerComponentSniperEventBinder.unBindEvent();
        }
    }
}

