/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.turntable.v2;

import com.yy.mobile.ui.turntable.TurnTableUtils;
import com.yy.mobile.ui.turntable.TurntablePointer;
import com.yy.mobile.util.log.MLog;

public class TurntablePointRenderThread
extends Thread {
    public volatile boolean isRun;
    private TurntablePointer pointer;
    private final int defaultDelayTime = 30;
    private final int maxDelayTime = 68;
    private int frameRate = 30;

    public TurntablePointRenderThread(TurntablePointer turntablePointer) {
        this.pointer = turntablePointer;
        this.frameRate = TurnTableUtils.getNumberCores() == 1 ? 68 : 30;
    }

    @Override
    public void run() {
        try {
            while (this.isRun) {
                long endTime;
                int diffTime;
                long startTime = System.currentTimeMillis();
                if (this.pointer != null) {
                    this.pointer.render();
                }
                if ((diffTime = (int)((endTime = System.currentTimeMillis()) - startTime)) < 0 || diffTime >= this.frameRate) continue;
                Thread.sleep(this.frameRate - diffTime);
            }
        }
        catch (Throwable e) {
            MLog.info((Object)"TurntablePointRenderThread", (String)("TurntablePointRenderThread run error " + e.toString()), (Object[])new Object[0]);
        }
    }
}

