/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.turntable.v2;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import com.duowan.mobile.entlive.events.IChannelTurntableClient_onLottery_EventArgs;
import com.duowan.mobile.entlive.events.WebOpenGiftComponentEventArgs;
import com.trello.rxlifecycle2.android.FragmentEvent;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.RxBus;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.events.IChannelTurntableClient_onFastTimes_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelTurntableClient_onQueryTurnTableWinBroadcast_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelTurntableClient_onUpdateLottery_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.turntable.PrizePanel;
import com.yy.mobile.ui.turntable.TurnTableUtils;
import com.yy.mobile.ui.turntable.TurntablePointer;
import com.yy.mobile.ui.turntable.bigwinner.IBigWinnerCore;
import com.yy.mobile.ui.turntable.bigwinner.event.TurnTable_LuckyLotteryData_EventArgs;
import com.yy.mobile.ui.turntable.core.IChannelTurntableCore;
import com.yy.mobile.ui.turntable.core.TurnTableManager;
import com.yy.mobile.ui.turntable.info.TurnTableEntryInfo;
import com.yy.mobile.ui.turntable.info.TurnTableLotteryResult;
import com.yy.mobile.ui.turntable.listener.TurnListener;
import com.yy.mobile.ui.turntable.v2.RuleFragment;
import com.yy.mobile.ui.turntable.v2.StateCode;
import com.yy.mobile.ui.turntable.v2.TurnTableComponentV2;
import com.yy.mobile.ui.turntable.v2.TurnTableFragment$$EventBinder;
import com.yy.mobile.ui.turntable.v2.TurntablePointRenderThread;
import com.yy.mobile.ui.turntable.v2.bean.LuckyLotteryBean;
import com.yy.mobile.ui.turntable.v2.dialog.LuckyLotteryDialog;
import com.yy.mobile.ui.turntable.v2.event.TurnTableCommonEvent;
import com.yy.mobile.ui.turntable.v2.widget.TurntableBroadCastTextView;
import com.yy.mobile.ui.turntable.v2.widget.TurntableToastView;
import com.yy.mobile.ui.turntable.v2.widget.YYCricleProgressView;
import com.yy.mobile.ui.utils.ViewUtils;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.ui.widget.BaseFragment;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.gift.GiftConfigItemBase;
import com.yymobile.core.gift.GiftConfigParser;
import com.yyproto.utils.FP;
import io.reactivex.ObservableTransformer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;

public class TurnTableFragment
extends BaseFragment
implements EventCompat {
    private final int onTurnPointAnimatorEnd = 1;
    private View mRootView;
    private RecycleImageView stageBgIv;
    private RecycleImageView ruleBtn;
    private RecycleImageView turntableBg;
    public RecycleImageView turntableLight;
    public YYCricleProgressView mYYCricleProgressView;
    public String defaultTipsTextFormat = "\u7b2c%d\u6b21\u53c2\u4e0e\u7528\u6237\u5fc5\u5f97%s*%d";
    private int broadCastViewMarginRight = (int)ResolutionUtils.convertDpToPixel((float)50.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int broadCastViewMarginTop = (int)ResolutionUtils.convertDpToPixel((float)6.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int broadCastViewMarginLeft = (int)ResolutionUtils.convertDpToPixel((float)35.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int progressContainerSize = (int)ResolutionUtils.convertDpToPixel((float)280.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int turntableBroadCastTextViewH = (int)ResolutionUtils.convertDpToPixel((float)16.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int lotteryButtonSize = (int)ResolutionUtils.convertDpToPixel((float)55.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int prizePanelMarginTop = (int)ResolutionUtils.convertDpToPixel((float)33.0f, (Context)BasicConfig.getInstance().getAppContext());
    public SafeDispatchHandler safeDispatchHandler = new SafeDispatchHandler(Looper.getMainLooper()){

        public void dispatchMessage(Message msg) {
            super.dispatchMessage(msg);
            if (msg.what == 1) {
                if (TurnTableFragment.this.mTurnTablePointer != null && TurnTableFragment.this.lotteryBtn != null) {
                    boolean isTurn = (Boolean)msg.obj;
                    MLog.info((Object)"TurnTableFragment", (String)("onTurnState is " + isTurn), (Object[])new Object[0]);
                    if (isTurn) {
                        TurnTableFragment.this.lockLotteryRadioBtn(true);
                        TurnTableFragment.this.lotteryBtn.setEnabled(false);
                        TurnTableFragment.this.mTurnTablePointer.setLayerType(2, null);
                    } else {
                        TurnTableFragment.this.lockLotteryRadioBtn(false);
                        TurnTableFragment.this.lotteryBtn.setEnabled(true);
                        TurnTableFragment.this.mTurnTablePointer.setLayerType(0, null);
                        if (!StringUtils.isEmpty((String)TurnTableFragment.this.banner).booleanValue()) {
                            MLog.info((Object)"TurnTableFragment", (String)("turntable lotteryEnd banner :" + TurnTableFragment.this.banner), (Object[])new Object[0]);
                            if (null != TurnTableFragment.this.toastView && !TurnTableFragment.this.isPause) {
                                TurnTableFragment.this.toastView.show(TurnTableFragment.this.banner);
                                TurnTableFragment.this.intervalToast = 0;
                            }
                        }
                        TurnTableFragment.this.startTurn = false;
                        TurnTableCommonEvent updatePropsEvent = new TurnTableCommonEvent(2, null);
                        RxBus.getDefault().post((Object)updatePropsEvent);
                    }
                }
                TurnTableFragment.this.needQueryBroadCastOutSizeInterval = true;
            }
        }
    };
    public boolean islihgt = false;
    public int lightDelayTime = 800;
    public int broadCastQueryTime = 40000;
    public int intervalBroadCastCount = 1;
    public boolean needQueryBroadCastOutSizeInterval = false;
    private int defaultIntervalValue = 3200;
    public int intervalValue = 0;
    public int intervalCount = 1;
    public int intervalToast = 0;
    private RadioGroup radioGroup;
    public RadioButton lotteryBtn1;
    public RadioButton lotteryBtn2;
    public RadioButton lotteryBtn3;
    private final int lotteryButtonType1 = 0;
    private final int lotteryButtonType2 = 1;
    private final int lotteryButtonType3 = 2;
    private boolean islandscape = false;
    public boolean isPause = false;
    public int cost = 1;
    public int currentLotteryButtonType = 0;
    public TurntablePointer mTurnTablePointer;
    public PrizePanel mPrizePanel;
    private ViewGroup turntableViewContainer;
    private ViewGroup lotteryResultContainer;
    private TurntableBroadCastTextView looperTextView;
    public List<LuckyLotteryBean> luckyLotteryBeans = new ArrayList<LuckyLotteryBean>();
    public View lotteryBtn;
    private TurntablePointRenderThread turntablePointRenderThread;
    public TurntableToastView toastView;
    private String lastProgressLotteryCfg = "";
    public RuleFragment mRuleFragment;
    private boolean isOnViewCreated = false;
    public boolean startTurn;
    public String banner = "";
    private DialogLinkManager dialogLinkManager;
    private TurnListener turnListener = new TurnListener(){

        public void onTurnState(boolean isTurn) {
            Message message = new Message();
            message.what = 1;
            message.obj = isTurn;
            TurnTableFragment.this.safeDispatchHandler.sendMessage(message);
        }
    };
    public int nodeTipShowTime = 3000;
    public Runnable nodeTipShowRunnable = new Runnable(){

        @Override
        public void run() {
            if (TurnTableFragment.this.mYYCricleProgressView != null && TurnTableFragment.this.mYYCricleProgressView.isNodeTipsIsShow()) {
                TurnTableFragment.this.mYYCricleProgressView.hideNodeTips();
            }
        }
    };
    private Runnable timeDelayRunnable = new Runnable(){

        @Override
        public void run() {
            if (TurnTableFragment.this.turntableLight != null) {
                if (TurnTableFragment.this.islihgt) {
                    TurnTableFragment.this.turntableLight.setImageDrawable(TurnTableFragment.this.getContext().getResources().getDrawable(R.drawable.turntabl_light_1_v2));
                } else {
                    TurnTableFragment.this.turntableLight.setImageDrawable(TurnTableFragment.this.getContext().getResources().getDrawable(R.drawable.turntabl_light_2_v2));
                }
                TurnTableFragment.this.islihgt = !TurnTableFragment.this.islihgt;
                if (TurnTableFragment.this.intervalValue > 0) {
                    if (TurnTableFragment.this.intervalCount % TurnTableFragment.this.intervalValue == 0) {
                        TurnTableFragment.this.queryLuckyLotteryDataTime();
                    }
                    int n = TurnTableFragment.this.intervalCount++;
                }
                if (TurnTableFragment.this.intervalBroadCastCount * TurnTableFragment.this.lightDelayTime == TurnTableFragment.this.broadCastQueryTime || TurnTableFragment.this.needQueryBroadCastOutSizeInterval) {
                    TurnTableFragment.this.needQueryBroadCastOutSizeInterval = false;
                    TurnTableFragment.this.intervalBroadCastCount = 0;
                    TurnTableFragment.this.queryWinBroadCase();
                }
                int n = TurnTableFragment.this.intervalBroadCastCount++;
                if (TurnTableFragment.this.toastView != null && TurnTableFragment.this.toastView.isShow()) {
                    if (TurnTableFragment.this.intervalToast * TurnTableFragment.this.lightDelayTime > TurnTableFragment.this.toastView.getDefaultStayTime()) {
                        TurnTableFragment.this.intervalToast = 0;
                        TurnTableFragment.this.toastView.hide();
                    } else {
                        int n2 = TurnTableFragment.this.intervalToast++;
                    }
                }
                TurnTableFragment.this.safeDispatchHandler.postDelayed((Runnable)this, (long)TurnTableFragment.this.lightDelayTime);
            }
        }
    };
    private EventBinder mTurnTableFragmentSniperEventBinder;

    public void onEventBind() {
        if (this.mTurnTableFragmentSniperEventBinder == null) {
            this.mTurnTableFragmentSniperEventBinder = new TurnTableFragment$$EventBinder();
        }
        this.mTurnTableFragmentSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mTurnTableFragmentSniperEventBinder != null) {
            this.mTurnTableFragmentSniperEventBinder.unBindEvent();
        }
    }

    public static TurnTableFragment newInstance(String filePath) {
        TurnTableFragment fragment = new TurnTableFragment();
        Bundle bundle = new Bundle();
        bundle.putString("filePath", filePath);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.onEventBind();
        this.dialogLinkManager = new DialogLinkManager(this.getContext());
        this.queryData();
        this.startRender();
        this.isOnViewCreated = true;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        try {
            this.mRootView = inflater.inflate(R.layout.turntable_layout_v2, null);
            this.initView();
        }
        catch (Exception e) {
            MLog.info((Object)"TurnTableFragment", (String)"Load TurntableComponent layout is failure!", (Object[])new Object[0]);
        }
        return this.mRootView;
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        try {
            if (null != this.mRuleFragment && this.mRuleFragment.isVisible()) {
                this.mRuleFragment.setUserVisibleHint(isVisibleToUser);
            }
            if (this.isOnViewCreated) {
                if (this.getUserVisibleHint()) {
                    MLog.info((Object)"TurnTableFragment", (String)"getUserVisibleHint is True", (Object[])new Object[0]);
                    this.startCountDownDelay();
                } else {
                    MLog.info((Object)"TurnTableFragment", (String)"getUserVisibleHint is false", (Object[])new Object[0]);
                    this.safeDispatchHandler.removeCallbacks(this.timeDelayRunnable);
                    if (this.toastView != null && this.toastView.isShow()) {
                        this.toastView.hide();
                    }
                }
            }
        }
        catch (Exception e) {
            MLog.info((Object)"TurnTableFragment", (String)("setUserVisibleHint ERROR: " + e.toString()), (Object[])new Object[0]);
        }
    }

    public void onResume() {
        super.onResume();
        MLog.info((Object)"TurnTableFragment", (String)"TurntableFragment onResume", (Object[])new Object[0]);
        if (this.isPause) {
            this.isPause = false;
            this.startCountDownDelay();
        }
    }

    public void onPause() {
        super.onPause();
        MLog.info((Object)"TurnTableFragment", (String)"TurntableFragment onPause", (Object[])new Object[0]);
        this.isPause = true;
        this.safeDispatchHandler.removeCallbacks(this.timeDelayRunnable);
        if (this.toastView != null && this.toastView.isShow()) {
            this.toastView.hide();
        }
    }

    public void onDestroy() {
        this.stopRender();
        this.safeDispatchHandler.removeCallbacksAndMessages(null);
        if (this.mTurnTablePointer != null) {
            this.mTurnTablePointer.onDestroy();
            this.mTurnTablePointer = null;
        }
        if (this.mYYCricleProgressView != null) {
            this.mYYCricleProgressView.setGiftNodeClickListener(null);
        }
        if (this.mPrizePanel != null) {
            this.mPrizePanel.onDestroy();
            this.mPrizePanel = null;
        }
        if (this.dialogLinkManager != null) {
            this.dialogLinkManager.dismissDialog();
        }
        if (this.looperTextView != null) {
            this.looperTextView.onDestroy();
        }
        this.mRuleFragment = null;
        this.onEventUnBind();
        super.onDestroy();
    }

    private void initView() {
        if (TurnTableManager.turnTableEntryInfo.lotteryCfgs.size() == 0) {
            return;
        }
        this.stageBgIv = (RecycleImageView)this.mRootView.findViewById(R.id.stage_bg_v2);
        String backupgroundUrl = ((TurnTableEntryInfo.PageCfg)TurnTableManager.turnTableEntryInfo.lotteryCfgs.get((int)0)).backupground;
        if (!FP.empty((CharSequence)backupgroundUrl)) {
            String stageUrl = TurnTableManager.turnTableEntryInfo.filePath + backupgroundUrl;
            ImageLoader.loadImage((RecycleImageView)this.stageBgIv, (String)stageUrl, (int)0);
        }
        this.looperTextView = new TurntableBroadCastTextView(this.getContext());
        RelativeLayout.LayoutParams looperTvLp = new RelativeLayout.LayoutParams(-1, this.turntableBroadCastTextViewH);
        this.looperTextView.setAreaHeight(this.turntableBroadCastTextViewH);
        looperTvLp.rightMargin = this.broadCastViewMarginRight;
        looperTvLp.topMargin = this.broadCastViewMarginTop;
        looperTvLp.leftMargin = this.broadCastViewMarginLeft;
        ViewGroup broadCastContainer = (ViewGroup)this.mRootView.findViewById(R.id.top_broadcast_container);
        broadCastContainer.addView((View)this.looperTextView, (ViewGroup.LayoutParams)looperTvLp);
        this.turntableBg = (RecycleImageView)this.mRootView.findViewById(R.id.turntable_bg_v2);
        String turntableBgUrl = TurnTableManager.turnTableEntryInfo.filePath + ((TurnTableEntryInfo.PageCfg)TurnTableManager.turnTableEntryInfo.lotteryCfgs.get((int)0)).turntable;
        if (!StringUtils.isEmpty((String)turntableBgUrl).booleanValue()) {
            ImageLoader.loadImage((RecycleImageView)this.turntableBg, (String)turntableBgUrl, (int)0);
        }
        this.turntableLight = (RecycleImageView)this.mRootView.findViewById(R.id.turntable_light);
        this.safeDispatchHandler.postDelayed(this.timeDelayRunnable, (long)this.lightDelayTime);
        this.ruleBtn = (RecycleImageView)this.mRootView.findViewById(R.id.turntabl_rule_btn);
        ViewUtils.clicks((View)this.ruleBtn, (long)500L).observeOn(AndroidSchedulers.mainThread()).compose((ObservableTransformer)this.bindUntilEvent(FragmentEvent.DESTROY)).subscribe((Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                if (TurnTableFragment.this.mPrizePanel != null) {
                    TurnTableFragment.this.mPrizePanel.hideTips();
                }
                try {
                    FragmentTransaction ft = TurnTableFragment.this.getChildFragmentManager().beginTransaction();
                    RuleFragment ruleFragment = (RuleFragment)TurnTableFragment.this.getChildFragmentManager().findFragmentByTag("RuleFragment");
                    if (ruleFragment == null) {
                        ruleFragment = RuleFragment.newInstance(TurnTableUtils.creatRuleWebUrl((TurnTableUtils.RuleWebViewType)TurnTableUtils.RuleWebViewType.TurnTable));
                    }
                    TurnTableFragment.this.mRuleFragment = ruleFragment;
                    if (!ruleFragment.isAdded()) {
                        ft.setCustomAnimations(R.anim.turntable_slide_in_right, R.anim.turntable_slide_out_right, R.anim.turntable_slide_in_right, R.anim.turntable_slide_out_right);
                        ft.addToBackStack(null);
                        ft.add(R.id.turntable_extend_container, (Fragment)ruleFragment, "RuleFragment");
                    } else {
                        ft.show((Fragment)ruleFragment);
                    }
                    ft.commitAllowingStateLoss();
                }
                catch (Exception e) {
                    MLog.info((Object)"TurnTableFragment", (String)("RuleFragment add error :" + e.toString()), (Object[])new Object[0]);
                }
            }
        }, RxUtils.errorConsumer((String)"TurnTableFragment"));
        this.islandscape = this.getContext().getResources().getConfiguration().orientation == 2;
        this.turntableViewContainer = (ViewGroup)this.mRootView.findViewById(R.id.turntable_view_container);
        this.lotteryResultContainer = (ViewGroup)this.mRootView.findViewById(R.id.lottery_result_view);
        this.createLotteryTypeSelectButton();
        this.createLotteryResultToast();
        this.createPrizePannel();
        this.createTurnTablePointer();
        this.createLotteryButton();
        this.createProgressView();
    }

    private void createLotteryResultToast() {
        this.toastView = new TurntableToastView(this.getContext());
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-2, -2);
        lp.addRule(14);
        this.toastView.setLayoutParams(lp);
        if (this.toastView.getToastView() != null) {
            this.lotteryResultContainer.addView((View)this.toastView.getToastView());
        }
    }

    private void createPrizePannel() {
        this.mPrizePanel = new PrizePanel(this.getContext());
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, this.progressContainerSize);
        lp.topMargin = this.prizePanelMarginTop;
        this.mPrizePanel.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.mPrizePanel.setCfgs(TurnTableManager.turnTableEntryInfo.lotteryCfgs);
        this.mPrizePanel.setParentView(this.turntableViewContainer);
        this.turntableViewContainer.addView((View)this.mPrizePanel);
        this.mPrizePanel.setPageIndex(this.currentLotteryButtonType);
    }

    private void createTurnTablePointer() {
        this.mTurnTablePointer = new TurntablePointer(this.getContext());
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, this.progressContainerSize);
        this.mTurnTablePointer.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.mTurnTablePointer.init(this.islandscape ? TurnTableComponentV2.landscapeWidth : 0, 0);
        this.mTurnTablePointer.setTurnListener(this.turnListener);
        this.turntableViewContainer.addView((View)this.mTurnTablePointer);
        if (this.currentLotteryButtonType < TurnTableManager.turnTableEntryInfo.lotteryCfgs.size()) {
            this.mTurnTablePointer.setPageCfg((TurnTableEntryInfo.PageCfg)TurnTableManager.turnTableEntryInfo.lotteryCfgs.get(this.currentLotteryButtonType));
        }
    }

    public void refreshTurntableUiData() {
        int size = TurnTableManager.turnTableEntryInfo.lotteryCfgs.size();
        if (this.currentLotteryButtonType >= size) {
            return;
        }
        if (this.mTurnTablePointer != null) {
            this.mTurnTablePointer.setPageCfg((TurnTableEntryInfo.PageCfg)TurnTableManager.turnTableEntryInfo.lotteryCfgs.get(this.currentLotteryButtonType));
        }
        if (this.mPrizePanel != null) {
            this.mPrizePanel.setPageIndex(this.currentLotteryButtonType);
        }
    }

    private void createProgressView() {
        this.mYYCricleProgressView = new YYCricleProgressView(this.getContext());
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, (int)ResolutionUtils.convertDpToPixel((float)342.0f, (Context)BasicConfig.getInstance().getAppContext()));
        this.mYYCricleProgressView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.mYYCricleProgressView.setContainerSize(this.islandscape ? TurnTableComponentV2.landscapeWidth : ResolutionUtils.getScreenWidth((Context)BasicConfig.getInstance().getAppContext()), this.progressContainerSize, 0, TurnTableUtils.progressCommonCenterY);
        this.mYYCricleProgressView.setGiftNodeClickListener(new YYCricleProgressView.OnGiftNodeContainerClickListener(){

            @Override
            public void onClick(int index) {
                if (TurnTableFragment.this.mPrizePanel != null) {
                    TurnTableFragment.this.mPrizePanel.hideTips();
                }
                if (index > -1 && index < TurnTableFragment.this.luckyLotteryBeans.size()) {
                    LuckyLotteryBean bean = TurnTableFragment.this.luckyLotteryBeans.get(index);
                    if (bean != null) {
                        GiftConfigItemBase base = GiftConfigParser.getInstance().getGiftConfigItemByType(bean.giftId);
                        String giftName = base == null ? "" : base.name;
                        TurnTableFragment.this.mYYCricleProgressView.setNodeTipInfo(String.format(TurnTableFragment.this.defaultTipsTextFormat, bean.val, giftName, bean.rewardNum));
                    }
                    TurnTableFragment.this.safeDispatchHandler.removeCallbacks(TurnTableFragment.this.nodeTipShowRunnable);
                    TurnTableFragment.this.safeDispatchHandler.postDelayed(TurnTableFragment.this.nodeTipShowRunnable, (long)TurnTableFragment.this.nodeTipShowTime);
                }
            }

            @Override
            public void showFinishEnd(boolean end) {
                if (end) {
                    TurnTableFragment.this.safeDispatchHandler.removeCallbacks(TurnTableFragment.this.nodeTipShowRunnable);
                }
            }
        });
        this.turntableViewContainer.addView((View)this.mYYCricleProgressView);
    }

    private void createLotteryButton() {
        this.lotteryBtn = new View(this.getContext());
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(this.lotteryButtonSize, this.lotteryButtonSize);
        this.lotteryBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MLog.info((Object)"TurnTableFragment", (String)"lotteryBtn is click!", (Object[])new Object[0]);
                if (!NetworkUtils.isNetworkStrictlyAvailable((Context)TurnTableFragment.this.getContext())) {
                    Toast.makeText((Context)TurnTableFragment.this.getContext(), (int)R.string.str_network_not_capable, (int)0).show();
                } else if (!TurnTableFragment.this.startTurn) {
                    TurnTableFragment.this.startTurn = true;
                    if (ICoreManagerBase.getCore(IChannelTurntableCore.class) != null && TurnTableManager.turnTableEntryInfo.lotteryCfgs.get(TurnTableFragment.this.currentLotteryButtonType) != null) {
                        ((IChannelTurntableCore)ICoreManagerBase.getCore(IChannelTurntableCore.class)).setFastTimes(((TurnTableEntryInfo.PageCfg)TurnTableManager.turnTableEntryInfo.lotteryCfgs.get((int)TurnTableFragment.this.currentLotteryButtonType)).times, (long)TurnTableFragment.this.cost, 10);
                    }
                } else {
                    MLog.info((Object)"TurnTableFragment", (String)"turntable lock! startTurn is true", (Object[])new Object[0]);
                }
            }
        });
        lp.addRule(14);
        lp.topMargin = (int)ResolutionUtils.convertDpToPixel((float)105.0f, (Context)BasicConfig.getInstance().getAppContext());
        this.turntableViewContainer.addView(this.lotteryBtn, (ViewGroup.LayoutParams)lp);
    }

    private void createLotteryTypeSelectButton() {
        this.radioGroup = (RadioGroup)this.mRootView.findViewById(R.id.lottery_radioGroup);
        this.lotteryBtn1 = (RadioButton)this.mRootView.findViewById(R.id.lottery_btn_1);
        this.lotteryBtn2 = (RadioButton)this.mRootView.findViewById(R.id.lottery_btn_2);
        this.lotteryBtn3 = (RadioButton)this.mRootView.findViewById(R.id.lottery_btn_3);
        this.radioGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup radioGroup, int i) {
                boolean isButtonClick = false;
                if (radioGroup.getCheckedRadioButtonId() == TurnTableFragment.this.lotteryBtn1.getId()) {
                    if (TurnTableFragment.this.currentLotteryButtonType != 0) {
                        TurnTableFragment.this.currentLotteryButtonType = 0;
                        TurnTableFragment.this.lotteryBtn1.setChecked(true);
                        isButtonClick = true;
                    }
                } else if (radioGroup.getCheckedRadioButtonId() == TurnTableFragment.this.lotteryBtn2.getId()) {
                    if (TurnTableFragment.this.currentLotteryButtonType != 1) {
                        TurnTableFragment.this.currentLotteryButtonType = 1;
                        TurnTableFragment.this.lotteryBtn2.setChecked(true);
                        isButtonClick = true;
                    }
                } else if (radioGroup.getCheckedRadioButtonId() == TurnTableFragment.this.lotteryBtn3.getId() && TurnTableFragment.this.currentLotteryButtonType != 2) {
                    TurnTableFragment.this.currentLotteryButtonType = 2;
                    TurnTableFragment.this.lotteryBtn3.setChecked(true);
                    isButtonClick = true;
                }
                if (isButtonClick) {
                    TurnTableFragment.this.refreshTurntableUiData();
                }
                if (TurnTableFragment.this.mPrizePanel != null) {
                    TurnTableFragment.this.mPrizePanel.hideTips();
                }
            }
        });
        if (TurnTableManager.turnTableEntryInfo != null && TurnTableManager.turnTableEntryInfo.coupon_qty >= 10 && this.currentLotteryButtonType != 1) {
            this.currentLotteryButtonType = 1;
            this.lotteryBtn2.setChecked(true);
        }
        if (TurnTableManager.turnTableEntryInfo.lotteryCfgs.size() >= 3) {
            for (int idx = 0; idx < 3; ++idx) {
                TurnTableEntryInfo.PageCfg pageCfg = (TurnTableEntryInfo.PageCfg)TurnTableManager.turnTableEntryInfo.lotteryCfgs.get(idx);
                String buttonInfo = TurnTableUtils.getLotteryButtonInfoByTimes((int)pageCfg.times);
                if (idx == 0) {
                    this.lotteryBtn1.setText((CharSequence)buttonInfo);
                    continue;
                }
                if (idx == 1) {
                    this.lotteryBtn2.setText((CharSequence)buttonInfo);
                    continue;
                }
                if (idx != 2) continue;
                this.lotteryBtn3.setText((CharSequence)buttonInfo);
            }
        }
    }

    public void lockLotteryRadioBtn(boolean lock) {
        if (this.lotteryBtn1 != null) {
            this.lotteryBtn1.setClickable(!lock);
        }
        if (this.lotteryBtn2 != null) {
            this.lotteryBtn2.setClickable(!lock);
        }
        if (this.lotteryBtn3 != null) {
            this.lotteryBtn3.setClickable(!lock);
        }
    }

    private void startCountDownDelay() {
        this.intervalCount = 1;
        this.intervalToast = 0;
        this.intervalBroadCastCount = 0;
        this.queryLuckyLotteryDataTime();
        this.queryWinBroadCase();
        this.safeDispatchHandler.removeCallbacks(this.timeDelayRunnable);
        this.safeDispatchHandler.postDelayed(this.timeDelayRunnable, (long)this.lightDelayTime);
    }

    public void startRender() {
        if (this.turntablePointRenderThread == null) {
            this.turntablePointRenderThread = new TurntablePointRenderThread(this.mTurnTablePointer);
            this.turntablePointRenderThread.isRun = true;
            this.turntablePointRenderThread.start();
        } else if (!this.turntablePointRenderThread.isRun) {
            this.turntablePointRenderThread.isRun = true;
            this.turntablePointRenderThread.start();
        }
    }

    public void stopRender() {
        if (this.turntablePointRenderThread != null) {
            this.turntablePointRenderThread.isRun = false;
        }
    }

    private void queryData() {
        this.queryLuckyLotteryDataTime();
        this.queryWinBroadCase();
    }

    public void queryWinBroadCase() {
        MLog.info((Object)"TurnTableFragment", (String)"{ queryWinBroadCase }", (Object[])new Object[0]);
        if (ICoreManagerBase.getCore(IChannelTurntableCore.class) != null) {
            ((IChannelTurntableCore)ICoreManagerBase.getCore(IChannelTurntableCore.class)).queryWinBroadCase();
        }
    }

    public void queryLuckyLotteryDataTime() {
        if (ICoreManagerBase.getCore(IBigWinnerCore.class) != null) {
            ((IBigWinnerCore)ICoreManagerBase.getCore(IBigWinnerCore.class)).queryLuckyLotteryRealTimeData();
        }
    }

    @BusEvent(sync=true)
    public void onQueryTurnTableWinBroadcastReceiver(IChannelTurntableClient_onQueryTurnTableWinBroadcast_EventArgs busEventArgs) {
        long result = busEventArgs.getResult();
        Map extendInfo = busEventArgs.getExtendInfo();
        List otherList = busEventArgs.getOtherList();
        this.onQueryTurnTableWinBroadcast(result, extendInfo, otherList);
    }

    private void onQueryTurnTableWinBroadcast(long result, Map<String, String> extendInfo, List<Map<String, String>> otherList) {
        if (result == 0L && otherList.size() != 0) {
            if (TurnTableManager.turnTableEntryInfo.first_lottery == 1 || this.looperTextView == null) {
                return;
            }
            MLog.info((Object)"TurnTableFragment", (String)"onQueryTurnTableWinBroadcast size = %d, %s", (Object[])new Object[]{otherList.size(), otherList.toString()});
            for (int idx = 0; idx < otherList.size(); ++idx) {
                this.looperTextView.addMessage(otherList.get(idx));
            }
        }
    }

    @BusEvent
    public void onTurnTableReceiverEvent(TurnTableCommonEvent event) {
        boolean isclick;
        if (event == null || event != null && event.getObject() == null) {
            return;
        }
        if (event.getType() == 1 && event.getObject() instanceof Boolean && (isclick = ((Boolean)event.getObject()).booleanValue()) && this.mPrizePanel != null) {
            this.mPrizePanel.hideTips();
        }
    }

    @BusEvent
    public void onLuckyLotteryRealTimeData(TurnTable_LuckyLotteryData_EventArgs eventArgs) {
        if (eventArgs == null || this.mYYCricleProgressView == null) {
            return;
        }
        int interval = eventArgs.getInterval().intValue() * 1000;
        this.intervalValue = Math.round((float)interval / ((float)this.lightDelayTime * 1.0f));
        if (this.intervalValue <= this.lightDelayTime) {
            this.intervalValue = Math.round((float)this.defaultIntervalValue / ((float)this.lightDelayTime * 1.0f));
        }
        int currentLuckyLotteryProgress = 0;
        if (eventArgs.getIParam() != null && eventArgs.getIParam().get(StateCode.KEY_CURRENT_LUCKY_NUM) != null) {
            currentLuckyLotteryProgress = ((Uint32)eventArgs.getIParam().get(StateCode.KEY_CURRENT_LUCKY_NUM)).intValue();
        }
        String lotteryCfg = "";
        if (eventArgs.getSParam() != null && eventArgs.getSParam().get(StateCode.KEY_LUCKY_PROGRESS_BAR_CFG) != null) {
            lotteryCfg = (String)eventArgs.getSParam().get(StateCode.KEY_LUCKY_PROGRESS_BAR_CFG);
            if (StringUtils.isEmpty((String)lotteryCfg).booleanValue()) {
                return;
            }
            if (this.luckyLotteryBeans.size() == 0 || this.luckyLotteryBeans.size() > 0 && !lotteryCfg.equals(this.lastProgressLotteryCfg)) {
                if (this.luckyLotteryBeans.size() > 0) {
                    this.luckyLotteryBeans.clear();
                }
                this.lastProgressLotteryCfg = lotteryCfg;
                int maxProgress = 0;
                try {
                    JSONArray jsonArray = new JSONArray(lotteryCfg);
                    int len = jsonArray.length();
                    for (int idx = 0; idx < len; ++idx) {
                        JSONArray array = jsonArray.getJSONArray(idx);
                        if (array == null) continue;
                        int lenj = array.length();
                        int[] values = new int[lenj];
                        LuckyLotteryBean bean = new LuckyLotteryBean();
                        for (int index = 0; index < lenj; ++index) {
                            values[index] = array.optInt(index);
                            if (idx == len - 1 && index == 0) {
                                maxProgress = values[index];
                            }
                            if (index == 0) {
                                bean.val = values[0];
                                continue;
                            }
                            if (index == 1) {
                                bean.giftId = values[1];
                                continue;
                            }
                            if (index != 2) continue;
                            bean.rewardNum = values[2];
                        }
                        this.luckyLotteryBeans.add(bean);
                    }
                }
                catch (JSONException e) {
                    MLog.info((Object)"TurnTableFragment", (String)"lotteryCfg parserError!", (Object[])new Object[0]);
                }
                this.mYYCricleProgressView.setMax(maxProgress);
                this.mYYCricleProgressView.setLuckyLotteryBeans(this.luckyLotteryBeans);
            }
        }
        this.mYYCricleProgressView.setProgress(currentLuckyLotteryProgress);
    }

    @BusEvent(sync=true)
    public void onFastTimesReceiver(IChannelTurntableClient_onFastTimes_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        int fastTimes = busEventArgs.getFastTimes();
        int moneyNum = busEventArgs.getMoneyNum();
        int costType = busEventArgs.getCostType();
        this.onFastTimes(result, fastTimes, moneyNum, costType);
    }

    private void onFastTimes(int result, int fastTimes, int moneyNum, int costType) {
        if (result == 0) {
            if (ICoreManagerBase.getCore(IChannelTurntableCore.class) != null) {
                ((IChannelTurntableCore)ICoreManagerBase.getCore(IChannelTurntableCore.class)).queryLottery();
            }
        } else {
            this.startTurn = false;
            if (null != this.toastView) {
                this.toastView.show(StateCode.codeMessageStrings[0]);
                this.intervalToast = 0;
            }
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void onLotteryReceiver(IChannelTurntableClient_onLottery_EventArgs busEventArgs) {
        TurnTableLotteryResult lotteryResult = busEventArgs.mResult;
        this.onLottery(lotteryResult);
    }

    private void onLottery(TurnTableLotteryResult lotteryResult) {
        if (lotteryResult != null && lotteryResult.costType == 10) {
            MLog.info((Object)"TurnTableFragment", (String)("onLottery result = " + lotteryResult.result), (Object[])new Object[0]);
            if (lotteryResult.result == 0) {
                int times = ((TurnTableEntryInfo.PageCfg)TurnTableManager.turnTableEntryInfo.lotteryCfgs.get((int)this.currentLotteryButtonType)).times;
                if (TurnTableManager.turnTableEntryInfo.coupon_qty < times) {
                    MLog.info((Object)"TurnTableFragment", (String)"current coupon_qty is low in times!", (Object[])new Object[0]);
                    this.startTurn = false;
                    return;
                }
                if (lotteryResult.luckyGift > 0 && lotteryResult.luckyGiftNum > 0 && !LuckyLotteryDialog.LuckyLotteryDialogIsShow) {
                    LuckyLotteryDialog.LuckyLotteryDialogIsShow = true;
                    LuckyLotteryDialog luckyLotteryDialog = LuckyLotteryDialog.newInstance(lotteryResult.luckyGift, lotteryResult.luckyGiftNum);
                    luckyLotteryDialog.show(this.getChildFragmentManager(), "LuckyLotteryDialog");
                }
                if (this.currentLotteryButtonType < TurnTableManager.turnTableEntryInfo.lotteryCfgs.size()) {
                    TurnTableManager.turnTableEntryInfo.coupon_qty -= times;
                    IChannelTurntableClient_onUpdateLottery_EventArgs eventArgs = new IChannelTurntableClient_onUpdateLottery_EventArgs();
                    RxBus.getDefault().post((Object)eventArgs);
                }
                if (this.mTurnTablePointer != null) {
                    int area;
                    if (this.startTurn) {
                        this.startTurn = false;
                        this.mTurnTablePointer.turnOn();
                    }
                    if ((area = lotteryResult.showId - 1) >= 0) {
                        this.mTurnTablePointer.setStopRotate(area);
                    }
                    this.mTurnTablePointer.setRewardCount(lotteryResult.rewardMap);
                }
                this.banner = lotteryResult.banner;
            } else if (lotteryResult.result != 0) {
                this.startTurn = false;
                if (lotteryResult.result == StateCode.CodeMessage.lotteryResult_12.code()) {
                    this.dialogLinkManager.showContentOkDialog((CharSequence)StateCode.CodeMessage.lotteryResult_12.getMessage(), (CharSequence)"\u83b7\u53d6\u62bd\u5956\u5238", true, true, new DialogLinkManager.OkDialogListener(){

                        public void onOk() {
                            WebOpenGiftComponentEventArgs eventArgs = new WebOpenGiftComponentEventArgs(1513);
                            eventArgs.setSourceType(WebOpenGiftComponentEventArgs.SourceType.Turntabel);
                            RxBus.getDefault().post((Object)eventArgs);
                            ((DialogFragment)TurnTableFragment.this.getParentFragment()).dismissAllowingStateLoss();
                        }
                    });
                } else {
                    Toast toast = Toast.makeText((Context)this.getContext(), (CharSequence)StateCode.codeMessageStrings[lotteryResult.result], (int)0);
                    toast.show();
                }
            }
        }
    }
}

