/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.turntable.v2;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.memoryrecycle.views.YYTextView;
import com.yy.mobile.plugin.main.events.IAuthClient_onKickOff_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelTurntableClient_onLeaveTurnTable_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelTurntableClient_onQueryTurnTablePropsList_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelTurntableClient_onUpdateLottery_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.BasePopupComponent;
import com.yy.mobile.ui.turntable.TurnTableAttachedActivity;
import com.yy.mobile.ui.turntable.bigwinner.IBigWinnerCore;
import com.yy.mobile.ui.turntable.core.IChannelTurntableCore;
import com.yy.mobile.ui.turntable.core.TurnTableManager;
import com.yy.mobile.ui.turntable.guide.TurnTableGuideControl;
import com.yy.mobile.ui.turntable.guide.TurnTableGuideDialogFragment;
import com.yy.mobile.ui.turntable.info.TurnTableEntryInfo;
import com.yy.mobile.ui.turntable.v2.PropsAdapter;
import com.yy.mobile.ui.turntable.v2.TurnTableComponentV2$$EventBinder;
import com.yy.mobile.ui.turntable.v2.TurnTableFragment;
import com.yy.mobile.ui.turntable.v2.TurnTablePagerAdapter;
import com.yy.mobile.ui.turntable.v2.WinnerFragment;
import com.yy.mobile.ui.turntable.v2.dialog.TurntablePropsDetailDialog;
import com.yy.mobile.ui.turntable.v2.event.TurnTableCommonEvent;
import com.yy.mobile.ui.turntable.v2.event.TurnTable_ShowWinnerCancelDialog_EventArgs;
import com.yy.mobile.ui.turntable.v2.event.TurnTable_TabChanged_EventArgs;
import com.yy.mobile.ui.utils.ViewUtils;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.ui.widget.ControlTouchViewPager;
import com.yy.mobile.ui.widget.horizontallist.AdapterView;
import com.yy.mobile.ui.widget.horizontallist.HListView;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelState;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TurnTableComponentV2
extends BasePopupComponent {
    private DialogLinkManager mDialogLinkManager;
    private YYTextView lotteryNumber;
    private LinearLayout propsContainer;
    public View rootView;
    public ControlTouchViewPager centerContainer;
    private View bottomContainer;
    private RadioGroup typeSelectTab;
    public PropsAdapter mPropsAdapter;
    private HListView mPropsListView;
    private boolean isFirstData = true;
    public static boolean isShown = false;
    public List<Fragment> fragments = new ArrayList<Fragment>(2);
    public TurnTablePagerAdapter mAdpater;
    public String filePath;
    private final int propsMargin = (int)ResolutionUtils.convertDpToPixel((float)12.0f, (Context)BasicConfig.getInstance().getAppContext());
    public static final int landscapeWidth = (int)ResolutionUtils.convertDpToPixel((float)375.0f, (Context)BasicConfig.getInstance().getAppContext());
    private final int portaintHeight = (int)ResolutionUtils.convertDpToPixel((float)456.0f, (Context)BasicConfig.getInstance().getAppContext());
    public RadioButton happyPannel;
    public RadioButton winerPannel;
    public int currentPannelType = 0;
    private boolean isInit = false;
    private SafeDispatchHandler safeDispatchHandler = new SafeDispatchHandler(Looper.getMainLooper());
    TurntablePropsDetailDialog turntablePropsDetailDialog;
    private Runnable lazyLoad = new Runnable(){

        @Override
        public void run() {
            TurnTableComponentV2.this.fragments.add((Fragment)TurnTableFragment.newInstance(TurnTableComponentV2.this.filePath));
            TurnTableComponentV2.this.fragments.add((Fragment)WinnerFragment.newInstance(TurnTableComponentV2.this.filePath));
            TurnTableComponentV2.this.mAdpater = new TurnTablePagerAdapter(TurnTableComponentV2.this.getChildFragmentManager(), TurnTableComponentV2.this.fragments);
            TurnTableComponentV2.this.centerContainer.setAdapter((PagerAdapter)TurnTableComponentV2.this.mAdpater);
            TurnTableComponentV2.this.centerContainer.setCurrentItem(0);
            TurnTableComponentV2.this.setLotteryNumber(TurnTableManager.turnTableEntryInfo.coupon_qty, false);
            TurnTableComponentV2.this.createPropsList();
            TurnTableComponentV2.this.initListener();
            TurnTableComponentV2.this.queryTools();
            TurnTableComponentV2.this.rootView.setVisibility(0);
        }
    };
    private EventBinder mTurnTableComponentV2SniperEventBinder;

    public static void popuComponent(FragmentActivity activity, String filePath) {
        Bundle bundle = new Bundle();
        bundle.putString("filePath", filePath);
        ViewUtils.showPopupComponent((Activity)activity, (FragmentManager)activity.getSupportFragmentManager(), (Bundle)bundle, TurnTableComponentV2.class, (String)"turntablecomponentV2");
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        isShown = false;
        this.cancleBigWinnerGame();
        if (this.getActivity() instanceof TurnTableAttachedActivity) {
            this.getActivity().finish();
        }
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        isShown = true;
        this.isInit = true;
    }

    private void cancleBigWinnerGame() {
        if (((IBigWinnerCore)ICoreManagerBase.getCore(IBigWinnerCore.class)).getCurGameStatus() == 1 && LoginUtil.isLogined() && ICoreManagerBase.getChannelLinkCore().getChannelState() == ChannelState.In_Channel) {
            ((IBigWinnerCore)ICoreManagerBase.getCore(IBigWinnerCore.class)).cancelGameMatching().subscribe((Consumer)new Consumer<Boolean>(){

                public void accept(Boolean aBoolean) throws Exception {
                    RxBus.getDefault().post((Object)new TurnTable_ShowWinnerCancelDialog_EventArgs(aBoolean));
                }
            }, RxUtils.errorConsumer((String)"TurnTableComponentV2", (String)"cancelGameMatching error"));
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.setCanceledOnTouchOutside(true);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setWindowAnimations(R.style.left_bottom_popup_scale_menu_animation);
        dialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        dialog.getWindow().setFlags(1024, 1024);
        if (this.getContext().getResources().getConfiguration().orientation == 2) {
            dialog.getWindow().setGravity(85);
            dialog.getWindow().setLayout(landscapeWidth, -1);
        } else {
            dialog.getWindow().setGravity(80);
            dialog.getWindow().setLayout(-1, this.portaintHeight);
        }
        dialog.getWindow().clearFlags(2);
        return dialog;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(0, 16973834);
        this.mDialogLinkManager = new DialogLinkManager(this.getContext());
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        try {
            this.rootView = inflater.inflate(R.layout.turntable_fragment_v2, container);
            this.initView(this.rootView);
            this.rootView.setVisibility(4);
        }
        catch (Exception e) {
            MLog.info((Object)"TurnTableComponentV2", (String)"Load TurntableComponent layout is failure!", (Object[])new Object[0]);
        }
        return this.rootView;
    }

    private void initView(View rootView) {
        Bundle bundle = this.getArguments();
        if (null != bundle) {
            this.filePath = bundle.getString("filePath", "");
            MLog.info((Object)"TurnTableComponentV2", (String)("filePath = " + this.filePath), (Object[])new Object[0]);
        }
        this.typeSelectTab = (RadioGroup)rootView.findViewById(R.id.type_select_tab);
        this.happyPannel = (RadioButton)rootView.findViewById(R.id.happy_turntable);
        this.winerPannel = (RadioButton)rootView.findViewById(R.id.winer_turntable);
        this.bottomContainer = rootView.findViewById(R.id.bottom_container);
        this.centerContainer = (ControlTouchViewPager)rootView.findViewById(R.id.center_container);
        this.lotteryNumber = (YYTextView)rootView.findViewById(R.id.turntable_lottery_number);
        this.propsContainer = (LinearLayout)rootView.findViewById(R.id.props_container);
        this.safeDispatchHandler.postDelayed(this.lazyLoad, 500L);
    }

    public void createPropsList() {
        this.mPropsAdapter = new PropsAdapter(this.mContext);
        this.mPropsListView = new HListView(this.mContext);
        this.mPropsListView.setDividerWidth(this.propsMargin);
        this.mPropsListView.setStackFromRight(false);
        this.mPropsListView.setOverScrollMode(2);
        this.mPropsListView.setSelector(R.color.transparent);
        this.mPropsListView.setAdapter((ListAdapter)this.mPropsAdapter);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -1);
        layoutParams.gravity = 17;
        this.propsContainer.addView((View)this.mPropsListView, (ViewGroup.LayoutParams)layoutParams);
        this.mPropsAdapter.setData(TurnTableManager.turnTableEntryInfo.gifts);
    }

    public void initListener() {
        if (this.bottomContainer == null || this.centerContainer == null || this.typeSelectTab == null && this.mPropsListView == null) {
            return;
        }
        this.bottomContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TurnTableCommonEvent event = new TurnTableCommonEvent(1, true);
                RxBus.getDefault().post((Object)event);
            }
        });
        this.centerContainer.setCanScroll(false);
        this.centerContainer.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                if (position == 0) {
                    TurnTableComponentV2.this.happyPannel.setChecked(true);
                } else if (position == 1) {
                    TurnTableComponentV2.this.winerPannel.setChecked(true);
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.typeSelectTab.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup radioGroup, int checkId) {
                if (radioGroup.getCheckedRadioButtonId() == TurnTableComponentV2.this.happyPannel.getId()) {
                    if (TurnTableComponentV2.this.currentPannelType != 0) {
                        TurnTableComponentV2.this.currentPannelType = 0;
                        TurnTableComponentV2.this.centerContainer.setCurrentItem(0);
                    }
                } else if (radioGroup.getCheckedRadioButtonId() == TurnTableComponentV2.this.winerPannel.getId() && TurnTableComponentV2.this.currentPannelType != 1) {
                    TurnTableComponentV2.this.currentPannelType = 1;
                    TurnTableComponentV2.this.centerContainer.setCurrentItem(1);
                }
                TurnTableCommonEvent event = new TurnTableCommonEvent(1, true);
                RxBus.getDefault().post((Object)event);
            }
        });
        this.mPropsListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                TurnTableEntryInfo.GiftCfg itemInfo = TurnTableComponentV2.this.mPropsAdapter.getItem(position);
                TurnTableComponentV2.this.turntablePropsDetailDialog = TurntablePropsDetailDialog.newInstance();
                if (!TurntablePropsDetailDialog.TurntablePropsDetailDialogUIShow) {
                    TurntablePropsDetailDialog.TurntablePropsDetailDialogUIShow = true;
                    TurnTableComponentV2.this.turntablePropsDetailDialog.updateView(itemInfo);
                    TurnTableComponentV2.this.turntablePropsDetailDialog.show(((FragmentActivity)TurnTableComponentV2.this.mContext).getSupportFragmentManager(), "TurntablePropsDetailDialog");
                }
                TurnTableCommonEvent event = new TurnTableCommonEvent(1, true);
                RxBus.getDefault().post((Object)event);
            }
        });
    }

    public void onDestroy() {
        this.mDialogLinkManager.dismissDialog();
        this.safeDispatchHandler.removeCallbacksAndMessages(null);
        super.onDestroy();
    }

    public void setLotteryNumber(int number, boolean needTurnTableGuide) {
        if (this.lotteryNumber != null) {
            this.lotteryNumber.setText((CharSequence)String.format("%d", number));
        }
        if (number == 0 && LoginUtil.isLogined() && needTurnTableGuide && TurnTableGuideControl.needPlayGuideWebView(LoginUtil.getUid()) && this.getContext().getResources().getConfiguration().orientation == 1 && this.isInit) {
            TurnTableGuideDialogFragment.popTurnTableGuideDialogFragment(this.getActivity(), TurnTableGuideControl.TurnTableGuideWebUrl);
        }
        if (needTurnTableGuide) {
            this.isInit = false;
        }
    }

    public void queryTools() {
        if (ICoreManagerBase.getCore(IChannelTurntableCore.class) != null) {
            ((IChannelTurntableCore)ICoreManagerBase.getCore(IChannelTurntableCore.class)).queryTools();
        }
    }

    @BusEvent
    public void onTurnTableCommonEventReceiver(TurnTableCommonEvent event) {
        if (event == null) {
            return;
        }
        if (event.getType() == 0) {
            if (event.getObject() != null && event.getObject() instanceof Boolean && this.bottomContainer != null) {
                boolean state = (Boolean)event.getObject();
                if (state) {
                    this.bottomContainer.setVisibility(0);
                } else {
                    this.bottomContainer.setVisibility(8);
                }
            }
        } else if (event.getType() == 2) {
            this.queryTools();
        }
    }

    @BusEvent
    public void onTurnTableTabChanged(TurnTable_TabChanged_EventArgs eventArgs) {
        MLog.info((Object)"TurnTableComponentV2", (String)("onTurnTableTabChanged :" + eventArgs), (Object[])new Object[0]);
        if (this.currentPannelType != eventArgs.getTab()) {
            this.currentPannelType = eventArgs.getTab();
            this.centerContainer.setCurrentItem(eventArgs.getTab());
        }
    }

    @BusEvent
    public void onQueryTurnTablePropsList(IChannelTurntableClient_onQueryTurnTablePropsList_EventArgs busEventArgs) {
        int result = (int)busEventArgs.getResult();
        Map extendInfo = busEventArgs.getExtendInfo();
        List otherList = busEventArgs.getOtherList();
        if (result != 0) {
            return;
        }
        if (extendInfo != null) {
            String itemInfo = (String)extendInfo.get("item_info_v1");
            if (!StringUtils.isEmpty((String)itemInfo).booleanValue()) {
                String[] info = itemInfo.split(",");
                for (int k = 0; k < TurnTableManager.turnTableEntryInfo.gifts.size(); ++k) {
                    ((TurnTableEntryInfo.GiftCfg)TurnTableManager.turnTableEntryInfo.gifts.get((int)k)).playAnim = false;
                }
                for (int i = 0; i < info.length; ++i) {
                    String[] arr = info[i].split("=");
                    int giftId = StringUtils.safeParseInt((String)arr[0]);
                    int giftNum = StringUtils.safeParseInt((String)arr[1]);
                    for (int j = 0; j < TurnTableManager.turnTableEntryInfo.gifts.size(); ++j) {
                        if (((TurnTableEntryInfo.GiftCfg)TurnTableManager.turnTableEntryInfo.gifts.get((int)j)).id != giftId) continue;
                        if (((TurnTableEntryInfo.GiftCfg)TurnTableManager.turnTableEntryInfo.gifts.get((int)j)).num != giftNum && !this.isFirstData) {
                            ((TurnTableEntryInfo.GiftCfg)TurnTableManager.turnTableEntryInfo.gifts.get((int)j)).playAnim = true;
                        }
                        ((TurnTableEntryInfo.GiftCfg)TurnTableManager.turnTableEntryInfo.gifts.get((int)j)).num = giftNum;
                    }
                }
                if (this.mPropsAdapter != null) {
                    this.mPropsAdapter.setData(TurnTableManager.turnTableEntryInfo.gifts);
                }
                this.isFirstData = false;
            }
            TurnTableManager.turnTableEntryInfo.coupon_qty = StringUtils.safeParseInt((String)((String)extendInfo.get("coupon_qty")));
            this.setLotteryNumber(TurnTableManager.turnTableEntryInfo.coupon_qty, true);
        }
    }

    @BusEvent(sync=true)
    public void onLeaveTurnTable(IChannelTurntableClient_onLeaveTurnTable_EventArgs busEventArgs) {
        if (this.checkActivityValid()) {
            this.dismissAllowingStateLoss();
        }
    }

    @BusEvent
    public void onKickOff(IAuthClient_onKickOff_EventArgs busEventArgs) {
        if (this.checkActivityValid()) {
            this.dismissAllowingStateLoss();
            if (this.turntablePropsDetailDialog != null && TurntablePropsDetailDialog.TurntablePropsDetailDialogUIShow) {
                this.turntablePropsDetailDialog.dismissAllowingStateLoss();
            }
        }
    }

    @BusEvent
    public void onUpdateLottery(IChannelTurntableClient_onUpdateLottery_EventArgs busEventArgs) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (null != TurnTableManager.turnTableEntryInfo) {
            this.setLotteryNumber(TurnTableManager.turnTableEntryInfo.coupon_qty, false);
        }
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mTurnTableComponentV2SniperEventBinder == null) {
            this.mTurnTableComponentV2SniperEventBinder = new TurnTableComponentV2$$EventBinder();
        }
        this.mTurnTableComponentV2SniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mTurnTableComponentV2SniperEventBinder != null) {
            this.mTurnTableComponentV2SniperEventBinder.unBindEvent();
        }
    }
}

