/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.turntable.v2;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import com.yy.mobile.RxBus;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.liveapi.help.WebViewEventListener;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.turntable.v2.event.TurnTableCommonEvent;
import com.yy.mobile.ui.widget.BaseFragment;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewEventListener;
import com.yy.mobile.ylink.bridge.coreapi.WebViewFragmentApi;

public class RuleFragment
extends BaseFragment
implements View.OnTouchListener {
    public View mRootView;
    private RecycleImageView ruleBackBtn;
    private String webUrl = "";

    public static RuleFragment newInstance(String url) {
        RuleFragment ruleFragment = new RuleFragment();
        Bundle bundle = new Bundle();
        bundle.putString("WebUrlKey", url);
        ruleFragment.setArguments(bundle);
        return ruleFragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.webUrl = bundle.getString("WebUrlKey", "");
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        try {
            this.mRootView = inflater.inflate(R.layout.turntable_rule_layout, null);
            this.ruleBackBtn = (RecycleImageView)this.mRootView.findViewById(R.id.turntabl_rule_back_btn);
            this.ruleBackBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    RuleFragment.this.closeRuleFragment();
                }
            });
        }
        catch (Exception e) {
            MLog.info((Object)"RuleFragment", (String)"Load RuleFragment layout is failure!", (Object[])new Object[0]);
        }
        return this.mRootView;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        BaseLinkFragment baseLinkFragment = this.createFragemByUrl();
        if (baseLinkFragment != null) {
            if (!this.isDetached() && this.mRootView != null) {
                FragmentTransaction ft = this.getChildFragmentManager().beginTransaction();
                if (baseLinkFragment.isDetached()) {
                    ft.attach((Fragment)baseLinkFragment);
                } else if (!baseLinkFragment.isAdded()) {
                    ft.add(R.id.rule_web_container, (Fragment)baseLinkFragment, "webFragmentTag");
                }
                ft.commitAllowingStateLoss();
            } else {
                MLog.info((Object)"RuleFragment", (String)"[initView],Can't not show mWVFragment", (Object[])new Object[0]);
            }
        }
        TurnTableCommonEvent event = new TurnTableCommonEvent(0, false);
        RxBus.getDefault().post((Object)event);
    }

    private BaseLinkFragment createFragemByUrl() {
        BaseLinkFragment wvFragment = null;
        WebViewEventListener listener2 = new WebViewEventListener(){

            public void changeHeight(int height) {
                if (RuleFragment.this.mRootView == null) {
                    return;
                }
                ViewGroup.LayoutParams lp = RuleFragment.this.mRootView.getLayoutParams();
                lp.height = height;
                RuleFragment.this.mRootView.setLayoutParams(lp);
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                MLog.info((Object)"RuleFragment", (String)("RuleFragment rewardDialogFragment erroCode=" + errorCode + " description=" + description), (Object[])new Object[0]);
            }

            public void onPageFinished(WebView view, String finishUrl) {
                super.onPageFinished(view, finishUrl);
            }
        };
        if (!StringUtils.isEmpty((String)this.webUrl).booleanValue() && CoreApiManager.getInstance().getApi(WebViewFragmentApi.class) != null) {
            wvFragment = ((WebViewFragmentApi)CoreApiManager.getInstance().getApi(WebViewFragmentApi.class)).createWebViewFragment(this.webUrl, true, (IWebViewEventListener)listener2, false);
        }
        return wvFragment;
    }

    public void closeRuleFragment() {
        RuleFragment ruleFragment;
        if (this.getFragmentManager() != null && (ruleFragment = (RuleFragment)this.getFragmentManager().findFragmentByTag("RuleFragment")) != null) {
            this.getFragmentManager().popBackStack();
        }
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        TurnTableCommonEvent event = new TurnTableCommonEvent(0, !isVisibleToUser);
        RxBus.getDefault().post((Object)event);
    }

    public void onDestroyView() {
        super.onDestroyView();
        TurnTableCommonEvent event = new TurnTableCommonEvent(0, true);
        RxBus.getDefault().post((Object)event);
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        return true;
    }
}

