/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.turntable.popuptips;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.RxBus;
import com.yy.mobile.plugin.main.events.IChannelTurntableClient_requestOpenTurnTable_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.BasePopupComponent;
import com.yy.mobile.ui.turntable.popuptips.LuckyListInfo;
import com.yy.mobile.ui.turntable.popuptips.LuckyListItemInfo;
import com.yy.mobile.ui.turntable.popuptips.LuckyListItemView;
import com.yy.mobile.util.ResolutionUtils;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import java.util.Map;

public class LuckyListPopupComponent
extends BasePopupComponent {
    private LinearLayout mLuckyListLayout;
    private LuckyListInfo mLuckyListInfo = new LuckyListInfo();
    private String uid = "";
    private TextView tvSenderName;
    private TextView tvPersonNum;
    private TextView tvClose;
    private LuckyListItemInfo mLuckListItemInfo = new LuckyListItemInfo();
    private RelativeLayout btnGotoTurntable;
    private RelativeLayout mLuckyListPop;
    private ObjectAnimator alphaRootView;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(0, 16973834);
        this.mLuckyListInfo = (LuckyListInfo)this.getArguments().getSerializable("info");
        this.uid = this.getArguments().getString("uid");
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.setCanceledOnTouchOutside(true);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        dialog.getWindow().setFlags(1024, 1024);
        dialog.getWindow().setGravity(17);
        dialog.getWindow().setLayout((int)ResolutionUtils.convertDpToPixel((float)250.0f, (Context)this.getActivity()), -2);
        return dialog;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.layout_luckylist_popup, null);
        this.initView(view);
        return view;
    }

    private void setSenderName() {
        String sb = this.mLuckyListInfo.sender;
        if (sb != null && sb.length() > 7) {
            this.mLuckyListInfo.sender = sb = sb.substring(0, 7);
        }
        if (this.mLuckyListInfo.sender != null) {
            SpannableString ss = new SpannableString((CharSequence)("\u611f\u8c22" + this.mLuckyListInfo.sender + "\u9001\u9177\u70ab\u5927\u793c"));
            int start2 = 2;
            int end = start2 + this.mLuckyListInfo.sender.length();
            ss.setSpan((Object)new ForegroundColorSpan(this.getResources().getColor(R.color.lucky_list_sender_name)), start2, end, 33);
            ss.setSpan((Object)new StyleSpan(1), start2, end, 33);
            this.tvSenderName.setText((CharSequence)ss);
        }
    }

    private void setPersonNum() {
        SpannableString ss = new SpannableString((CharSequence)("\u5171\u88ab" + this.mLuckyListInfo.personNum + "\u4f4d\u5e78\u8fd0\u513f\u62a2\u5230!"));
        int start2 = 2;
        int end = start2 + this.mLuckyListInfo.personNum.length();
        ss.setSpan((Object)new ForegroundColorSpan(this.getResources().getColor(R.color.lucky_list_person_num)), start2, end, 33);
        ss.setSpan((Object)new StyleSpan(1), start2, end, 33);
        this.tvPersonNum.setText((CharSequence)ss);
    }

    private void initView(View view) {
        this.mLuckyListLayout = (LinearLayout)view.findViewById(R.id.lucky_list_ll);
        this.tvSenderName = (TextView)view.findViewById(R.id.tv_sender_name);
        this.tvPersonNum = (TextView)view.findViewById(R.id.tv_person_num);
        this.tvClose = (TextView)view.findViewById(R.id.tv_close);
        this.mLuckyListPop = (RelativeLayout)view.findViewById(R.id.lucky_list_pop_root);
        this.tvClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LuckyListPopupComponent.this.hide();
            }
        });
        this.btnGotoTurntable = (RelativeLayout)view.findViewById(R.id.goto_turntable_btn);
        this.btnGotoTurntable.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RxBus.getDefault().post((Object)new IChannelTurntableClient_requestOpenTurnTable_EventArgs());
                LuckyListPopupComponent.this.hide();
            }
        });
        if (((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).isLoginUserMobileLive()) {
            this.btnGotoTurntable.setVisibility(8);
        }
        this.setSenderName();
        this.setPersonNum();
        for (int i = 0; i < this.mLuckyListInfo.luckylistItemInfo.size(); ++i) {
            this.mLuckListItemInfo.rank = this.mLuckyListInfo.luckylistItemInfo.size() > 3 ? i : i + 1;
            this.mLuckListItemInfo.name = (String)((Map)this.mLuckyListInfo.luckylistItemInfo.get(i)).get("nick_name");
            String sb = this.mLuckListItemInfo.name;
            if (sb != null && sb.length() > 7) {
                this.mLuckListItemInfo.name = sb = sb.substring(0, 7);
            }
            this.mLuckListItemInfo.num = (String)((Map)this.mLuckyListInfo.luckylistItemInfo.get(i)).get("grab_val");
            this.mLuckListItemInfo.id = this.mLuckyListInfo.giftId;
            this.mLuckListItemInfo.giftType = this.mLuckyListInfo.giftType;
            LuckyListItemView mLuckyListItemView = new LuckyListItemView(this.getContext(), this.mLuckListItemInfo);
            if (((String)((Map)this.mLuckyListInfo.luckylistItemInfo.get(i)).get("uid")).equals(this.uid)) {
                mLuckyListItemView.setBackgroundColor(Color.parseColor((String)"#fff4db"));
            }
            this.mLuckyListLayout.addView((View)mLuckyListItemView);
        }
    }

    public void alphaDismiss() {
        if (this.mLuckyListPop != null) {
            this.alphaRootView = ObjectAnimator.ofFloat((Object)this.mLuckyListPop, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
            this.alphaRootView.setDuration(3000L);
            this.alphaRootView.start();
            this.alphaRootView.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    LuckyListPopupComponent.this.hide();
                }
            });
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.alphaRootView != null) {
            this.alphaRootView.cancel();
            this.alphaRootView.removeAllListeners();
        }
    }
}

