/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.turntable.guide;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebView;
import android.widget.LinearLayout;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.httpsparser.HttpsParser;
import com.yy.mobile.liveapi.help.WebViewEventListener;
import com.yy.mobile.plugin.main.events.IWebViewClient_closeActWindow_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.basicchanneltemplate.component.BasePopupComponent;
import com.yy.mobile.ui.turntable.guide.TurnTableGuideDialogFragment$$EventBinder;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.utils.ViewUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewEventListener;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewFragmentInterface;
import com.yy.mobile.ylink.bridge.coreapi.WebViewFragmentApi;
import com.yymobile.core.ICoreManagerBase;

public class TurnTableGuideDialogFragment
extends BasePopupComponent {
    private String url;
    private boolean hasDimBehind = false;
    private int width = 300;
    private int height = 460;
    public View rootView;
    private IWebViewFragmentInterface mWVFragment;
    private EventBinder mTurnTableGuideDialogFragmentSniperEventBinder;

    public static void popTurnTableGuideDialogFragment(FragmentActivity activity, String url) {
        if (null == activity || null == url) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("url", url);
        ViewUtils.showPopupComponent((Activity)activity, (FragmentManager)activity.getSupportFragmentManager(), (Bundle)bundle, TurnTableGuideDialogFragment.class, (String)"TurnTableGuideDialogFragment");
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ICoreManagerBase.addClient((Object)((Object)this));
        this.url = this.getArguments().getString("url");
        this.url = HttpsParser.convertToHttps((String)this.url);
        if (this.getArguments() != null) {
            int height;
            this.hasDimBehind = this.getArguments().getBoolean("hasDimBehind");
            int width = this.getArguments().getInt("width", 0);
            if (width > 0) {
                this.width = width;
            }
            if ((height = this.getArguments().getInt("height", 0)) > 0) {
                this.height = height;
            }
        }
        this.setStyle(0, 16973834);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.setCanceledOnTouchOutside(true);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        dialog.getWindow().clearFlags(2);
        dialog.getWindow().setGravity(17);
        int width = DensityUtil.dip2px((Context)BasicConfig.getInstance().getAppContext(), (float)this.width);
        int height = DensityUtil.dip2px((Context)BasicConfig.getInstance().getAppContext(), (float)this.height);
        dialog.getWindow().setLayout(width, height);
        if (this.hasDimBehind) {
            WindowManager.LayoutParams lp = dialog.getWindow().getAttributes();
            lp.dimAmount = 0.55f;
            dialog.getWindow().setAttributes(lp);
            dialog.getWindow().addFlags(2);
        } else {
            dialog.getWindow().clearFlags(2);
        }
        return dialog;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.rootView = inflater.inflate(R.layout.turntable_guide_webview, container, false);
        int heightPx = DensityUtil.dip2px((Context)this.getContext(), (float)this.height);
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, heightPx);
        this.rootView.setLayoutParams(lp);
        LinearLayout.LayoutParams lpWeb = new LinearLayout.LayoutParams(-1, heightPx);
        this.rootView.findViewById(R.id.web).setLayoutParams((ViewGroup.LayoutParams)lpWeb);
        this.initView();
        return this.rootView;
    }

    private void initView() {
        BaseLinkFragment baseLinkFragment = this.createWebViewFragment(this.url);
        if (baseLinkFragment != null) {
            this.mWVFragment = (IWebViewFragmentInterface)baseLinkFragment;
            if (!this.isDetached() && this.rootView != null) {
                FragmentTransaction ft = this.getChildFragmentManager().beginTransaction();
                if (baseLinkFragment.isDetached()) {
                    ft.attach((Fragment)baseLinkFragment);
                } else if (!baseLinkFragment.isAdded()) {
                    ft.add(R.id.web, (Fragment)baseLinkFragment, "TurnTableGuideDialogFragment");
                }
                ft.commitAllowingStateLoss();
            } else {
                MLog.warn((Object)"TurnTableGuideDialogFragment", (String)"[initView],Can't not show mWVFragment", (Object[])new Object[0]);
            }
        }
    }

    private BaseLinkFragment createWebViewFragment(String url) {
        BaseLinkFragment wvFragment = null;
        WebViewEventListener listener2 = new WebViewEventListener(){

            public void changeHeight(int height) {
                if (TurnTableGuideDialogFragment.this.rootView == null) {
                    return;
                }
                ViewGroup.LayoutParams lp = TurnTableGuideDialogFragment.this.rootView.getLayoutParams();
                lp.height = height;
                TurnTableGuideDialogFragment.this.rootView.setLayoutParams(lp);
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                MLog.info((Object)"TurnTableGuideDialogFragment", (String)("wwd TaskSystem rewardDialogFragment erroCode=" + errorCode + " description=" + description), (Object[])new Object[0]);
            }

            public void onPageFinished(WebView view, String finishUrl) {
                super.onPageFinished(view, finishUrl);
            }
        };
        if (CoreApiManager.getInstance().getApi(WebViewFragmentApi.class) != null) {
            wvFragment = ((WebViewFragmentApi)CoreApiManager.getInstance().getApi(WebViewFragmentApi.class)).createWebViewFragment(url, true, (IWebViewEventListener)listener2, false);
        }
        return wvFragment;
    }

    @BusEvent
    public void closeActWindow(IWebViewClient_closeActWindow_EventArgs busEventArgs) {
        String params = busEventArgs.getParams();
        if (TextUtils.isEmpty((CharSequence)params)) {
            return;
        }
        this.dismissAllowingStateLoss();
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mTurnTableGuideDialogFragmentSniperEventBinder == null) {
            this.mTurnTableGuideDialogFragmentSniperEventBinder = new TurnTableGuideDialogFragment$$EventBinder();
        }
        this.mTurnTableGuideDialogFragmentSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mTurnTableGuideDialogFragmentSniperEventBinder != null) {
            this.mTurnTableGuideDialogFragmentSniperEventBinder.unBindEvent();
        }
    }
}

