/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.turntable;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.turntable.BroadcastController;
import com.yy.mobile.ui.turntable.ITurnTableCommon;
import com.yy.mobile.ui.turntable.TrunTableWebView;
import com.yy.mobile.ui.turntable.TurnTableComponent;
import com.yy.mobile.ui.turntable.TurnTableFreeView;
import com.yy.mobile.ui.turntable.TurntableItemBar;
import com.yy.mobile.ui.turntable.core.IChannelTurntableCore;
import com.yy.mobile.ui.turntable.core.TurnTableManager;
import com.yy.mobile.ui.turntable.info.TurnTableEntryInfo;
import com.yy.mobile.ui.turntable.info.TurnTableLotteryResult;
import com.yy.mobile.ui.turntable.listener.ComposeListener;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.widget.MarqueeLayout;
import com.yy.mobile.util.StringUtils;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.gift.GiftConfigParser;
import com.yyproto.utils.FP;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TurnTableCommonUi
implements ITurnTableCommon {
    public View.OnClickListener clickCallback;
    public TurnTableComponent component;
    private View closeBtn;
    private ViewGroup headerTips;
    private MarqueeLayout marqueeLayout;
    private TextView headerTipsTxt;
    private RecycleImageView outBtn;
    public TurnTableFreeView freeView;
    private TurntableItemBar turntableItemBar;
    private TrunTableWebView turnTableWebView;
    private BroadcastController broadcastController;
    private TextView toastView;
    private int curCfgIndex;
    private int constType;
    private ArrayList<TurnTableEntryInfo.PageCfg> pageCfgs;
    private Runnable hideRunnable = new Runnable(){

        @Override
        public void run() {
            TurnTableCommonUi.this.hideToast();
        }
    };
    private View.OnClickListener onCloseListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (TurnTableCommonUi.this.component != null && TurnTableCommonUi.this.component.checkActivityEnable()) {
                TurnTableCommonUi.this.component.dismissAllowingStateLoss();
            }
        }
    };
    private Runnable broadcastRunnable = new Runnable(){

        @Override
        public void run() {
            ((IChannelTurntableCore)ICoreManagerBase.getCore(IChannelTurntableCore.class)).queryWinBroadCase();
            if (null != TurnTableCommonUi.this.component) {
                TurnTableCommonUi.this.component.getHandler().postDelayed((Runnable)this, 40000L);
            }
        }
    };
    private ComposeListener composeListener = new ComposeListener(){

        public void onCompose(int fragmentNum, int composeNum, int fragmentTarget) {
            String giftName = "";
            if (GiftConfigParser.getInstance().getGiftConfigItemByType(fragmentTarget) != null) {
                giftName = GiftConfigParser.getInstance().getGiftConfigItemByType((int)fragmentTarget).name;
            }
            if (giftName == null || "".equals(giftName)) {
                giftName = "\u5927\u793c\u7269";
            }
            String msg = "\u62bd\u4e2d" + fragmentNum + "\u4e2a\u788e\u7247\n\u81ea\u52a8\u5408\u6210" + giftName + "*" + composeNum;
            TurnTableCommonUi.this.freeView.showDialogMsg(msg);
        }
    };

    public void init(TurnTableComponent context, ViewGroup rootView, final View.OnClickListener clickCallback) {
        this.component = context;
        this.clickCallback = clickCallback;
        String backupgroundUrl = "";
        if (TurnTableManager.turnTableEntryInfo.lotteryCfgs.size() > 0) {
            backupgroundUrl = ((TurnTableEntryInfo.PageCfg)TurnTableManager.turnTableEntryInfo.lotteryCfgs.get((int)0)).backupground;
        }
        if (TurnTableManager.turnTableEntryInfo.pageCfgs.size() > 0 && FP.empty((CharSequence)backupgroundUrl)) {
            backupgroundUrl = ((TurnTableEntryInfo.PageCfg)TurnTableManager.turnTableEntryInfo.pageCfgs.get((int)0)).backupground;
        }
        if (!FP.empty((CharSequence)backupgroundUrl)) {
            RecycleImageView stageBg = (RecycleImageView)rootView.findViewById(R.id.stage_bg);
            String stageUrl = TurnTableManager.turnTableEntryInfo.filePath + backupgroundUrl;
            ImageLoader.loadImage((RecycleImageView)stageBg, (String)stageUrl, (int)0);
        }
        this.closeBtn = rootView.findViewById(R.id.close_btn);
        this.closeBtn.setOnClickListener(this.onCloseListener);
        this.headerTips = (ViewGroup)rootView.findViewById(R.id.header_tips_layout);
        this.marqueeLayout = (MarqueeLayout)rootView.findViewById(R.id.layout_marquee);
        this.headerTipsTxt = (TextView)rootView.findViewById(R.id.header_tips_txt);
        this.outBtn = (RecycleImageView)rootView.findViewById(R.id.out_btn);
        TextView outNameTxt = (TextView)rootView.findViewById(R.id.out_name_txt);
        if (!StringUtils.isEmpty((String)TurnTableManager.turnTableEntryInfo.out_icon).booleanValue()) {
            ImageLoader.loadImage((String)TurnTableManager.turnTableEntryInfo.out_icon, (RecycleImageView)this.outBtn, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.rule_btn_normal);
        }
        if (!StringUtils.isEmpty((String)TurnTableManager.turnTableEntryInfo.out_name).booleanValue()) {
            outNameTxt.setText((CharSequence)TurnTableManager.turnTableEntryInfo.out_name);
        }
        this.outBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (null != clickCallback) {
                    clickCallback.onClick(v);
                }
                if (!StringUtils.isEmpty((String)TurnTableManager.turnTableEntryInfo.out_url).booleanValue()) {
                    TurnTableCommonUi.this.showURl(TurnTableManager.turnTableEntryInfo.out_url);
                }
            }
        });
        this.broadcastController = new BroadcastController((Activity)this.component.getActivity());
        View broadcastView = this.broadcastController.getView();
        broadcastView.setVisibility(4);
        this.addHeaderTips(broadcastView);
        if (TurnTableManager.turnTableEntryInfo.first_lottery != 1) {
            this.component.getHandler().postDelayed(this.broadcastRunnable, 200L);
        } else {
            this.showFirstHeaderTips();
        }
        this.freeView = new TurnTableFreeView(this.component.getContext());
        this.freeView.setClickCallBack(clickCallback);
        RelativeLayout.LayoutParams freelp = new RelativeLayout.LayoutParams(-2, -2);
        freelp.topMargin = DensityUtil.dip2px((Context)this.component.getContext(), (float)30.0f);
        freelp.leftMargin = DensityUtil.dip2px((Context)this.component.getContext(), (float)16.0f);
        this.freeView.setId(R.id.truntable_freecout_layout);
        rootView.addView((View)this.freeView, (ViewGroup.LayoutParams)freelp);
        this.turntableItemBar = new TurntableItemBar(this.component.getContext(), rootView);
        this.turntableItemBar.setClickCallBack(clickCallback);
        RelativeLayout.LayoutParams itemLp = new RelativeLayout.LayoutParams(-1, DensityUtil.dip2px((Context)this.component.getContext(), (float)35.0f));
        itemLp.addRule(12);
        itemLp.bottomMargin = DensityUtil.dip2px((Context)this.component.getContext(), (float)10.0f);
        this.turntableItemBar.setComposeListener(this.composeListener);
        this.turntableItemBar.setRechargeClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (null != clickCallback) {
                    clickCallback.onClick(v);
                }
                TurnTableCommonUi.this.showRechargeWeb();
            }
        });
        this.turntableItemBar.setFromPage(this.component.fromPage);
        rootView.addView((View)this.turntableItemBar, (ViewGroup.LayoutParams)itemLp);
        this.toastView = new TextView(this.component.getContext());
        this.toastView.setBackgroundColor(Color.parseColor((String)"#dfdde1"));
        this.toastView.setTextColor(Color.parseColor((String)"#291130"));
        this.toastView.setTextSize(11.0f);
        this.toastView.setPadding(DensityUtil.dip2px((Context)BasicConfig.getInstance().getAppContext(), (float)20.0f), DensityUtil.dip2px((Context)BasicConfig.getInstance().getAppContext(), (float)5.0f), DensityUtil.dip2px((Context)BasicConfig.getInstance().getAppContext(), (float)20.0f), DensityUtil.dip2px((Context)BasicConfig.getInstance().getAppContext(), (float)5.0f));
        this.toastView.setGravity(17);
        this.toastView.setId(R.id.turntable_toast_tv);
        this.toastView.setVisibility(4);
        RelativeLayout.LayoutParams toastParams = new RelativeLayout.LayoutParams(-2, -2);
        toastParams.addRule(14, -1);
        toastParams.addRule(3, R.id.truntable_freecout_layout);
        toastParams.leftMargin = DensityUtil.dip2px((Context)BasicConfig.getInstance().getAppContext(), (float)20.0f);
        toastParams.rightMargin = DensityUtil.dip2px((Context)BasicConfig.getInstance().getAppContext(), (float)20.0f);
        rootView.addView((View)this.toastView, (ViewGroup.LayoutParams)toastParams);
        RelativeLayout webviewLayout = new RelativeLayout(this.component.getContext());
        webviewLayout.setVisibility(8);
        webviewLayout.setId(R.id.turntable_webview_group);
        RelativeLayout.LayoutParams wblp = new RelativeLayout.LayoutParams(-1, -1);
        rootView.addView((View)webviewLayout, (ViewGroup.LayoutParams)wblp);
        this.turnTableWebView = new TrunTableWebView(this.component.getContext(), (ViewGroup)webviewLayout);
        this.turnTableWebView.setFragmentManager(this.component.getChildFragmentManager());
    }

    public void onDestroy() {
        if (null != this.turnTableWebView) {
            this.turnTableWebView.onDestory();
            this.turnTableWebView = null;
        }
        if (this.marqueeLayout != null) {
            this.marqueeLayout.reserverAnimation();
        }
        if (this.broadcastController != null) {
            this.broadcastController.finish();
            this.broadcastController = null;
        }
        if (null != this.component) {
            this.component.getHandler().removeCallbacks(this.broadcastRunnable);
            this.component.getHandler().removeCallbacks(this.hideRunnable);
        }
        if (this.turntableItemBar != null && this.turntableItemBar.mGiftItemTipsController != null) {
            this.turntableItemBar.mGiftItemTipsController.dismiss();
        }
        if (this.freeView != null) {
            this.freeView.onDestory();
            this.freeView = null;
        }
        if (this.turntableItemBar != null) {
            this.turntableItemBar.onDestroy();
        }
        this.toastView = null;
        this.component = null;
        this.clickCallback = null;
    }

    private void showToast(String text) {
        this.hideToast();
        if (null != this.toastView) {
            this.toastView.setText((CharSequence)text);
            this.toastView.setVisibility(0);
        }
        if (null != this.component) {
            this.component.getHandler().postDelayed(this.hideRunnable, 2000L);
        }
    }

    public void hideToast() {
        if (null != this.component) {
            this.component.getHandler().removeCallbacks(this.hideRunnable);
        }
        if (null != this.toastView) {
            this.toastView.setVisibility(4);
        }
    }

    public void showFirstHeaderTips() {
        if (this.headerTipsTxt != null) {
            this.headerTipsTxt.setText((CharSequence)"\u5c11\u4fa0\u8bf7\u7559\u6b65\uff01\u4eca\u65e5\u9996\u62bd\u767e\u5206\u767e\u4e0d\u4e8f\uff01\u673a\u667a\u5982\u4f60\uff0c\u4e00\u5b9a\u4e0d\u4f1a\u9519\u8fc7\u7684\uff01    \u5c11\u4fa0\u8bf7\u7559\u6b65\uff01\u4eca\u65e5\u9996\u62bd\u767e\u5206\u767e\u4e0d\u4e8f\uff01\u673a\u667a\u5982\u4f60\uff0c\u4e00\u5b9a\u4e0d\u4f1a\u9519\u8fc7\u7684\uff01    \u5c11\u4fa0\u8bf7\u7559\u6b65\uff01\u4eca\u65e5\u9996\u62bd\u767e\u5206\u767e\u4e0d\u4e8f\uff01\u673a\u667a\u5982\u4f60\uff0c\u4e00\u5b9a\u4e0d\u4f1a\u9519\u8fc7\u7684\uff01");
        }
    }

    public void hideFirstHeaderTips() {
        if (this.headerTipsTxt != null) {
            this.headerTipsTxt.setText((CharSequence)"");
        }
    }

    public void addHeaderTips(View broadcastView) {
        if (this.headerTips != null) {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
            this.headerTips.addView(broadcastView, (ViewGroup.LayoutParams)params);
        }
    }

    public void onJsCallCloseWeb() {
        if (null != this.turnTableWebView) {
            this.turnTableWebView.onJsCallCloseWeb();
        }
        if (null != this.turntableItemBar) {
            this.turntableItemBar.updateDiamodNum();
        }
    }

    public void onQueryTurnTableWinBroadcast(long result, Map<String, String> extendInfo, List<Map<String, String>> otherList) {
        if (result == 0L && otherList.size() != 0) {
            if (this.broadcastController == null || TurnTableManager.turnTableEntryInfo.first_lottery == 1) {
                return;
            }
            for (int i = 0; i < otherList.size(); ++i) {
                this.broadcastController.addMessage(otherList.get(i));
            }
        }
    }

    public void refreshWebByShortCutPay() {
        if (null != this.turnTableWebView) {
            this.turnTableWebView.refreshWeb();
        }
    }

    public void showRechargeWeb() {
        IChannelLinkCore channelLinkCore = ICoreManagerBase.getChannelLinkCore();
        String url = TurnTableManager.getDiamondUrl((String)(channelLinkCore.getCurrentTopMicId() + ""), (String)(channelLinkCore.getCurrentChannelInfo().topSid + ""));
        this.showURl(url);
    }

    public void onLottery(TurnTableLotteryResult lotteryResult) {
        if (null != this.freeView && lotteryResult.costType == 20) {
            this.freeView.onLottery(lotteryResult);
        }
        if (null != this.turntableItemBar) {
            this.turntableItemBar.onLottery(lotteryResult);
        }
    }

    public void onQueryRedDiamondAmount(boolean result, long amount) {
        if (null != this.turntableItemBar) {
            this.turntableItemBar.onQueryRedDiamondAmount(result, amount);
        }
    }

    public void onQueryTurnTablePropsList(long result, Map<String, String> extendInfo, List<Map<String, String>> otherList) {
        if (null != this.turntableItemBar) {
            this.turntableItemBar.onQueryTurnTablePropsList(result, extendInfo, otherList);
        }
    }

    public void showURl(String url) {
        if (null != this.turnTableWebView) {
            this.turnTableWebView.showUrl(url);
        }
    }

    public void onTurnState(boolean isTurn) {
        if (this.constType == 10 && TurnTableManager.turnTableEntryInfo.first_lottery == 1) {
            return;
        }
        if (isTurn && null != this.component) {
            this.component.getHandler().removeCallbacks(this.broadcastRunnable);
            this.component.getHandler().postDelayed(this.broadcastRunnable, 200L);
            this.hideFirstHeaderTips();
        }
    }

    public void onLotteryEnd(int constType) {
        if (null != this.turntableItemBar) {
            this.turntableItemBar.onLotteryEnd();
        }
        if (null != this.freeView && constType == 20) {
            this.freeView.onLottery();
        }
    }

    public void showCommonToast(String text) {
        this.showToast(text);
    }

    public void hideCommonToast() {
        this.hideToast();
    }

    public void hideAllTips() {
        if (null != this.freeView) {
            this.freeView.hideDialogMsg();
        }
        if (this.turntableItemBar != null && this.turntableItemBar.mGiftItemTipsController != null) {
            this.turntableItemBar.mGiftItemTipsController.dismiss();
        }
    }

    public void onCfgsSelected(int cfgIndex) {
        this.curCfgIndex = cfgIndex;
        if (null != this.pageCfgs && cfgIndex < this.pageCfgs.size() && null != this.freeView) {
            this.freeView.setCurrentCfg(this.curCfgIndex, this.pageCfgs.get(this.curCfgIndex));
        }
    }

    public void onPageSelected(int consType, int pageIndex, ArrayList<TurnTableEntryInfo.PageCfg> cfgs) {
        this.constType = consType;
        this.pageCfgs = cfgs;
        if (null != this.turntableItemBar) {
            this.turntableItemBar.setConsType(consType);
        }
    }

    public void delDiamodNum(long diamodNum) {
        if (null != this.turntableItemBar && this.turntableItemBar.diamodNum - diamodNum >= 0L) {
            this.turntableItemBar.diamodNum -= diamodNum;
            this.turntableItemBar.setDiamodNum(this.turntableItemBar.diamodNum);
        }
    }

    public void delLotteryCount(int count) {
        if (null != this.turntableItemBar && this.turntableItemBar.lotteryCount - count >= 0) {
            this.turntableItemBar.setLotteryNum(this.turntableItemBar.lotteryCount - count);
        }
    }

    public boolean checkActivityValid() {
        return false;
    }

    public void setLotteryCout(int count) {
        if (null != this.turntableItemBar) {
            this.turntableItemBar.setLotteryNum(count);
        }
    }
}

