/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.treasurechest;

import com.duowan.mobile.entlive.events.IFlowerClient_onFlowerSendResult_EventArgs;
import com.duowan.mobile.entlive.events.IGiftClient_onSendFreeGiftWithError_EventArgs;
import com.duowan.mobile.entlive.events.IGiftClient_onSendPaidGift_EventArgs;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.http.DefaultRetryPolicy;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.RequestParam;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.http.RetryPolicy;
import com.yy.mobile.http.StringQueryRequest;
import com.yy.mobile.plugin.main.events.IAuthClient_onLoginSucceed_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onChatInputSwitch_EventArgs;
import com.yy.mobile.plugin.main.events.ISubscribeClient_onSubscribeResult_EventArgs;
import com.yy.mobile.sdkwrapper.yylive.sdkadapt.SdkAdapter;
import com.yy.mobile.ui.treasurechest.TreasureChestModule$$EventBinder;
import com.yy.mobile.ui.treasurechest.TreasureChestPresenter;
import com.yy.mobile.ui.treasurechest.spdt.SpdtSvcGroup;
import com.yy.mobile.ui.treasurechest.spdt.SpdtTerminateProtocol;
import com.yy.mobile.ui.treasurechest.spdt.SpdtTreasureChestUrl;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yy.udbauth.AuthSDK;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.UriProvider;
import com.yymobile.core.ent.protos.IEntProtocol;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.utils.CommonParamUtil;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.Calendar;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TreasureChestModule
implements EventCompat {
    public TreasureChestPresenter mPresenter;
    private CommonPref commonPref;
    private String TREASURE_CHEST_INIT;
    private String TREASURE_CHEST_PRE_INIT;
    private Disposable dialogDisposable;
    private Disposable terminateDisposable;
    private EventBinder mTreasureChestModuleSniperEventBinder;

    TreasureChestModule(TreasureChestPresenter presenter2) {
        this.mPresenter = presenter2;
        this.onEventBind();
        this.TREASURE_CHEST_INIT = ((SpdtTreasureChestUrl)Spdt.of(SpdtTreasureChestUrl.class)).getTreasureChestInitUrl();
        this.TREASURE_CHEST_PRE_INIT = ((SpdtTreasureChestUrl)Spdt.of(SpdtTreasureChestUrl.class)).getTreasureChestPreInitUrl();
    }

    public void onDestroy() {
        this.onEventUnBind();
        if (this.dialogDisposable != null) {
            this.dialogDisposable.dispose();
        }
    }

    void sendInitRequest() {
        this.sendRequest(this.getUrl(this.TREASURE_CHEST_INIT), 2, new ResponseListener<String>(){

            public void onResponse(String response) {
                try {
                    JSONObject object = new JSONObject(response);
                    MLog.info((Object)"TreasureChestModule", (String)("sendInitRequest response = " + object.toString()), (Object[])new Object[0]);
                    if (object.optInt("code") != 0) {
                        return;
                    }
                    JSONObject data = object.optJSONObject("data");
                    TreasureChestModule.this.mPresenter.onInitResponse(data.optBoolean("actValid"), data.optInt("leftNum"), data.optInt("countDown"));
                }
                catch (JSONException throwable) {
                    MLog.error((Object)"TreasureChestModule", (String)"sendInitRequest: exception = %s", (Object[])new Object[]{throwable.toString()});
                }
            }
        }, new ResponseErrorListener(){

            public void onErrorResponse(RequestError error) {
                MLog.error((Object)"TreasureChestModule", (String)"sendInitRequest: error = %s", (Object[])new Object[]{error.toString()});
            }
        });
    }

    void sendPreInitRequest() {
        this.sendRequest(this.TREASURE_CHEST_PRE_INIT, 2, new ResponseListener<String>(){

            public void onResponse(String response) {
                try {
                    JSONObject object = new JSONObject(response);
                    MLog.info((Object)"TreasureChestModule", (String)("sendPreInitRequest response = " + object.toString()), (Object[])new Object[0]);
                    if (object.optInt("code") != 0) {
                        return;
                    }
                    JSONArray datas = object.optJSONArray("data");
                    JSONObject data = datas.getJSONObject(0);
                    TreasureChestModule.this.mPresenter.onPreInitResponse(data.optString("image"), data.optString("svga"), data.optInt("actionType"), data.optString("action"), data.optInt("onlyPic"), data.optString("title"));
                }
                catch (JSONException throwable) {
                    MLog.error((Object)"TreasureChestModule", (String)"sendPreInitRequest: exception = %s", (Object[])new Object[]{throwable.toString()});
                    TreasureChestModule.this.mPresenter.doOnPreInitError();
                }
            }
        }, new ResponseErrorListener(){

            public void onErrorResponse(RequestError error) {
                MLog.error((Object)"TreasureChestModule", (String)"sendPreInitRequest: error = %s", (Object[])new Object[]{error.getLocalizedMessage()});
                TreasureChestModule.this.mPresenter.doOnPreInitError();
            }
        });
    }

    void sendTicketStatusRequest() {
        if (this.getCommonPref().getBoolean(this.getPrefKey("has_show_obtain_ticket_dialog_"), false)) {
            return;
        }
        this.sendRequest(UriProvider.TICKET_STATUS + "ticket=" + AuthSDK.getToken((String)SdkAdapter.YY_APP_ID), 2, new ResponseListener<String>(){

            public void onResponse(String response) {
                try {
                    JSONObject object = new JSONObject(response);
                    MLog.info((Object)"TreasureChestModule", (String)("sendTicketStatusRequest response = " + object.toString()), (Object[])new Object[0]);
                    if (object.optInt("code") != 0) {
                        return;
                    }
                    TreasureChestModule.this.mPresenter.onTicketStatusResponse();
                    TreasureChestModule.this.getCommonPref().putBoolean(TreasureChestModule.this.getPrefKey("has_show_obtain_ticket_dialog_"), true);
                }
                catch (JSONException throwable) {
                    MLog.error((Object)"TreasureChestModule", (String)"sendTicketStatusRequest: exception = %s", (Object[])new Object[]{throwable.toString()});
                    TreasureChestModule.this.mPresenter.doOnPreInitError();
                }
            }
        }, new ResponseErrorListener(){

            public void onErrorResponse(RequestError error) {
                MLog.error((Object)"TreasureChestModule", (String)"sendTicketStatusRequest: error = %s", (Object[])new Object[]{error.getLocalizedMessage()});
            }
        });
    }

    private String getUrl(String rootUrl) {
        return String.format(Locale.CHINA, "%suid=%d&&hdid=%s&&ticket=%s", rootUrl, LoginUtil.getUid(), ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).getHdid(), AuthSDK.getToken((String)SdkAdapter.YY_APP_ID));
    }

    public String getPrefKey(String key) {
        return key + LoginUtil.getUid();
    }

    public CommonPref getCommonPref() {
        if (this.commonPref == null) {
            this.commonPref = CommonPref.instance();
        }
        if (this.commonPref.getInt(this.getPrefKey("treasure_chest_date_"), -1) != Calendar.getInstance().get(5)) {
            this.commonPref.putInt(this.getPrefKey("treasure_chest_date_"), Calendar.getInstance().get(5));
            this.commonPref.putInt(this.getPrefKey("treasure_chest_subscribe_time_"), 0);
            this.commonPref.putInt(this.getPrefKey("treasure_chest_send_gift_time_"), 0);
            this.commonPref.putBoolean(this.getPrefKey("has_show_obtain_ticket_dialog_"), false);
        }
        return this.commonPref;
    }

    public void onEventBind() {
        if (this.mTreasureChestModuleSniperEventBinder == null) {
            this.mTreasureChestModuleSniperEventBinder = new TreasureChestModule$$EventBinder();
        }
        this.mTreasureChestModuleSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mTreasureChestModuleSniperEventBinder != null) {
            this.mTreasureChestModuleSniperEventBinder.unBindEvent();
        }
    }

    @BusEvent(sync=true)
    public void onLoginSucceed(IAuthClient_onLoginSucceed_EventArgs busEventArgs) {
        MLog.info((Object)"TreasureChestModule", (String)"onLoginSucceed sendInitRequest", (Object[])new Object[0]);
        this.mPresenter.sendPreInitRequest();
    }

    @BusEvent(sync=true)
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        MLog.info((Object)"TreasureChestModule", (String)"onJoinChannelSuccess sendPreInitRequest", (Object[])new Object[0]);
        this.mPresenter.sendPreInitRequest();
        this.mPresenter.setHasSubscribe(false);
        this.mPresenter.setHasSendGift(false);
    }

    @BusEvent(sync=true)
    public void onSubscribeResult(ISubscribeClient_onSubscribeResult_EventArgs busEventArgs) {
        if (busEventArgs.getSuccess()) {
            MLog.info((Object)"TreasureChestModule", (String)("onSubscribeResult: hasSubscribe = " + this.mPresenter.hasSubscribe()), (Object[])new Object[0]);
            if (this.mPresenter.hasSubscribe()) {
                return;
            }
            int subscribeTime = this.getCommonPref().getInt(this.getPrefKey("treasure_chest_subscribe_time_"), 0);
            if (subscribeTime < 10) {
                this.mPresenter.reduceCountDown(30L);
                this.getCommonPref().putInt(this.getPrefKey("treasure_chest_subscribe_time_"), subscribeTime + 1);
                this.mPresenter.setHasSubscribe(true);
            }
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void onSendPaidGift(IGiftClient_onSendPaidGift_EventArgs busEventArgs) {
        if (busEventArgs.mResultCode == 0) {
            MLog.info((Object)"TreasureChestModule", (String)"onSendPaidGift() invoke", (Object[])new Object[0]);
            this.onSendGiftResponse();
            if (this.mPresenter.isJumpH5Dialog()) {
                if (this.dialogDisposable != null) {
                    this.dialogDisposable.dispose();
                }
                this.dialogDisposable = Observable.timer((long)5L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                    public void accept(Long aLong) {
                        TreasureChestModule.this.mPresenter.sendTicketStatusRequest();
                    }
                });
            }
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void onSendFreeGiftWithError(IGiftClient_onSendFreeGiftWithError_EventArgs busEventArgs) {
        MLog.info((Object)"TreasureChestModule", (String)("onSendFreeGiftWithError()" + busEventArgs.mResultCode), (Object[])new Object[0]);
        if (busEventArgs.mResultCode == 0) {
            MLog.info((Object)"TreasureChestModule", (String)"onSendFreeGiftWithError() invoke", (Object[])new Object[0]);
            this.onSendGiftResponse();
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void onFlowerSendResult(IFlowerClient_onFlowerSendResult_EventArgs busEventArgs) {
        if (busEventArgs.mResult == 0) {
            MLog.info((Object)"TreasureChestModule", (String)"onFlowerSendResult() invoke", (Object[])new Object[0]);
            this.onSendGiftResponse();
        }
    }

    private void onSendGiftResponse() {
        MLog.info((Object)"TreasureChestModule", (String)("onSendGiftResponse: hasSendGift = " + this.mPresenter.hasSendGift()), (Object[])new Object[0]);
        if (this.mPresenter.hasSendGift()) {
            return;
        }
        int sendGiftTime = this.getCommonPref().getInt(this.getPrefKey("treasure_chest_send_gift_time_"), 0);
        if (sendGiftTime < 10) {
            this.mPresenter.reduceCountDown(30L);
            this.getCommonPref().putInt(this.getPrefKey("treasure_chest_send_gift_time_"), sendGiftTime + 1);
            this.mPresenter.setHasSendGift(true);
        }
    }

    @BusEvent
    public void onChatInputSwitch(IChatEmotionClient_onChatInputSwitch_EventArgs busEventArgs) {
        this.mPresenter.onChatInputSwitch(busEventArgs.getChatInputSwitch());
    }

    private void sendRequest(String url, int maxNumRetry, ResponseListener<String> successListener, ResponseErrorListener errorListener) {
        MLog.info((Object)"TreasureChestModule", (String)"sendRequest: url = %s", (Object[])new Object[]{url});
        url = RequestManager.getUrlWithQueryString((String)url, (RequestParam)CommonParamUtil.fillCommonParam());
        StringQueryRequest req = new StringQueryRequest(RequestManager.instance().getCache(), url, successListener, errorListener);
        req.setRunOnUIThread(true);
        req.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(7500, maxNumRetry, 1.0f));
        RequestManager.instance().submitRequest((Request)req);
    }

    void registerTerminateBroadcastReceiver(final Consumer<IEntProtocol> receiver) {
        ((SpdtSvcGroup)Spdt.of(SpdtSvcGroup.class)).joinSvcGroup();
        this.terminateDisposable = ICoreManagerBase.getEntCore().registerBroadcast(((SpdtTerminateProtocol)Spdt.of(SpdtTerminateProtocol.class)).getProtocolClass()).firstOrError().observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<IEntProtocol>(){

            public void accept(IEntProtocol treasureTerminateProtocol) throws Exception {
                MLog.info((Object)"TreasureChestModule", (String)("receive terminate broadcast: " + treasureTerminateProtocol), (Object[])new Object[0]);
                receiver.accept((Object)treasureTerminateProtocol);
            }
        }, RxUtils.errorConsumer((String)"TreasureChestModule"));
    }

    void unRegisterTerminateBroadcastReceiver() {
        ((SpdtSvcGroup)Spdt.of(SpdtSvcGroup.class)).leaveSvcGroup();
        if (this.terminateDisposable != null) {
            this.terminateDisposable.dispose();
        }
    }
}

