/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.touch.surface;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.view.SurfaceHolder;
import com.yy.mobile.base.utils.DensityUtils;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.activity.GlobalActivityManager;
import com.yy.mobile.ui.touch.surface.CoverPosInfo;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;
import io.reactivex.schedulers.Schedulers;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.util.common.ScreenUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 H2\u00020\u0001:\u0001HB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\bJ(\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020+H\u0002J \u00103\u001a\u00020(2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\bH\u0002J\u0018\u00104\u001a\u00020(2\u0006\u0010.\u001a\u00020/2\b\u0010)\u001a\u0004\u0018\u00010\u001dJ\"\u00104\u001a\u00020(2\u0006\u0010.\u001a\u00020/2\u0006\u00101\u001a\u00020\b2\b\u00105\u001a\u0004\u0018\u00010\u0018H\u0002J(\u00106\u001a\u00020(2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020+H\u0002J\u0006\u00107\u001a\u00020\fJ\b\u00108\u001a\u0004\u0018\u00010\u001dJ\u000e\u00109\u001a\u00020(2\u0006\u0010.\u001a\u00020/J\b\u0010:\u001a\u00020(H\u0002J\b\u0010;\u001a\u00020(H\u0002J\b\u0010<\u001a\u00020(H\u0002J\u0010\u0010=\u001a\u00020(2\b\u00105\u001a\u0004\u0018\u00010\u0018J\u0010\u0010>\u001a\u00020(2\b\u00105\u001a\u0004\u0018\u00010\u0018J \u0010?\u001a\u00020\u00182\u0006\u00105\u001a\u00020\u00182\u0006\u0010@\u001a\u00020\f2\u0006\u0010A\u001a\u00020\fH\u0002J\u0016\u0010B\u001a\u00020(2\u0006\u0010@\u001a\u00020\f2\u0006\u0010A\u001a\u00020\fJ\u0018\u0010C\u001a\u00020(2\u0006\u0010@\u001a\u00020\f2\u0006\u0010A\u001a\u00020\fH\u0002J\u000e\u0010D\u001a\u00020\u00182\u0006\u00105\u001a\u00020\u0018J\u0016\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\f2\u0006\u0010G\u001a\u00020\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/yy/mobile/ui/touch/surface/SwipeCoverDrawer;", "", "context", "Landroid/content/Context;", "holder", "Landroid/view/SurfaceHolder;", "(Landroid/content/Context;Landroid/view/SurfaceHolder;)V", "arrowMargin", "", "bottomArrowPath", "Landroid/graphics/Path;", "bottomTitleWidth", "", "circleMargin", "getContext", "()Landroid/content/Context;", "coverMatrix", "Landroid/graphics/Matrix;", "getHolder", "()Landroid/view/SurfaceHolder;", "mArrowPaint", "Landroid/graphics/Paint;", "mCirclePaint", "mCoverBitmap", "Landroid/graphics/Bitmap;", "mCoverHeight", "mCoverPaint", "mCoverWidth", "mCurrentPos", "Lcom/yy/mobile/ui/touch/surface/CoverPosInfo;", "mNextBitmap", "mPrevBitmap", "mTextPaint", "statusHeight", "titleMargin", "topArrowPath", "topTitleWidth", "windowHeight", "windowWidth", "autoSlide", "", "posInfo", "isReset", "", "velocity", "drawArrow", "canvas", "Landroid/graphics/Canvas;", "dx", "dy", "isTop", "drawCircle", "drawCover", "bitmap", "drawText", "getCoverHeight", "getCurrentPos", "hideCover", "initPaint", "initTextWidth", "initWH", "nextBitmap", "prevBitmap", "resizeImage", "width", "height", "setWidthHeight", "setupBitmap", "test", "Landroid/graphics/Rect;", "bitmapWidth", "bitmapHeight", "Companion", "pluginunionlive_release"})
public final class SwipeCoverDrawer {
    private CoverPosInfo mCurrentPos;
    private int mCoverWidth;
    private int mCoverHeight;
    private Paint mCoverPaint;
    private final Matrix coverMatrix;
    public Bitmap mCoverBitmap;
    private Bitmap mNextBitmap;
    private Bitmap mPrevBitmap;
    private int windowWidth;
    private int windowHeight;
    private int statusHeight;
    private Paint mTextPaint;
    private int topTitleWidth;
    private int bottomTitleWidth;
    private final float titleMargin;
    private Paint mArrowPaint;
    private final Path topArrowPath;
    private final Path bottomArrowPath;
    private final float arrowMargin;
    private Paint mCirclePaint;
    private final float circleMargin;
    @NotNull
    private final Context context;
    @NotNull
    private final SurfaceHolder holder;
    public static final Companion Companion = new Companion(null);

    private final void initPaint() {
        block11: {
            Paint paint = this.mCoverPaint = new Paint();
            if (paint != null) {
                paint.setAntiAlias(true);
            }
            Paint paint2 = this.mTextPaint = new Paint();
            if (paint2 != null) {
                paint2.setDither(true);
            }
            Paint paint3 = this.mTextPaint;
            if (paint3 != null) {
                paint3.setAntiAlias(true);
            }
            Paint paint4 = this.mTextPaint;
            if (paint4 != null) {
                paint4.setColor(-1);
            }
            Paint paint5 = this.mTextPaint;
            if (paint5 != null) {
                paint5.setTextSize((float)DensityUtils.dp2px((float)12.0f));
            }
            Paint paint6 = this.mArrowPaint = new Paint();
            if (paint6 != null) {
                paint6.setStrokeWidth(2.0f);
            }
            Paint paint7 = this.mArrowPaint;
            if (paint7 != null) {
                paint7.setColor(Color.parseColor((String)"#FFD800"));
            }
            Paint paint8 = this.mArrowPaint;
            if (paint8 != null) {
                paint8.setStyle(Paint.Style.STROKE);
            }
            Paint paint9 = this.mArrowPaint;
            if (paint9 != null) {
                paint9.setStrokeCap(Paint.Cap.ROUND);
            }
            Paint paint10 = this.mCirclePaint = new Paint();
            if (paint10 != null) {
                paint10.setStrokeWidth(5.0f);
            }
            Paint paint11 = this.mCirclePaint;
            if (paint11 != null) {
                paint11.setColor(Color.parseColor((String)"#FFD800"));
            }
            Paint paint12 = this.mCirclePaint;
            if (paint12 == null) break block11;
            paint12.setStrokeCap(Paint.Cap.ROUND);
        }
    }

    public final void nextBitmap(@Nullable Bitmap bitmap) {
        MLog.info((Object)"SwipeCoverDrawer", (String)("nextBitmap -> " + bitmap), (Object[])new Object[0]);
        this.initWH();
        Bitmap bitmap2 = bitmap;
        if (bitmap2 != null) {
            Bitmap bitmap3 = bitmap2;
            boolean bl = false;
            boolean bl2 = false;
            Bitmap it = bitmap3;
            boolean bl3 = false;
            try {
                this.mNextBitmap = this.test(bitmap);
                return;
            }
            catch (OutOfMemoryError outError) {
                MLog.error((Object)"SwipeCoverDrawer", (Throwable)outError);
            }
            catch (Exception e) {
                MLog.error((Object)"SwipeCoverDrawer", (Throwable)e);
            }
        }
        this.mNextBitmap = null;
    }

    public final void prevBitmap(@Nullable Bitmap bitmap) {
        MLog.info((Object)"SwipeCoverDrawer", (String)("prevBitmap -> " + bitmap), (Object[])new Object[0]);
        this.initWH();
        Bitmap bitmap2 = bitmap;
        if (bitmap2 != null) {
            Bitmap bitmap3 = bitmap2;
            boolean bl = false;
            boolean bl2 = false;
            Bitmap it = bitmap3;
            boolean bl3 = false;
            try {
                this.mPrevBitmap = this.test(bitmap);
                return;
            }
            catch (OutOfMemoryError outError) {
                MLog.error((Object)"SwipeCoverDrawer", (Throwable)outError);
            }
            catch (Exception e) {
                MLog.error((Object)"SwipeCoverDrawer", (Throwable)e);
            }
        }
        this.mPrevBitmap = null;
    }

    private final void initWH() {
        if (this.windowHeight == 0 || this.windowWidth == 0) {
            Activity act = GlobalActivityManager.INSTANCE.getCurrentActivity();
            this.windowHeight = ScreenUtils.getScreenHeight();
            this.windowWidth = ScreenUtils.getScreenWidth();
            this.statusHeight = ScreenUtil.getStatusBarHeight() * 2;
            MLog.info((Object)"SwipeCoverDrawer", (String)("width = " + this.windowWidth + ", height = " + this.windowHeight + ", statusHeight = " + this.statusHeight), (Object[])new Object[0]);
        }
    }

    private final void initTextWidth() {
        Rect rect;
        if (this.topTitleWidth == 0) {
            rect = new Rect();
            Paint paint = this.mTextPaint;
            if (paint != null) {
                paint.getTextBounds("\u4e0a\u62c9\u6362\u4e2a\u76f4\u64ad\u770b\u770b\uff5e", 0, "\u4e0a\u62c9\u6362\u4e2a\u76f4\u64ad\u770b\u770b\uff5e".length(), rect);
            }
            this.topTitleWidth = rect.width();
        }
        if (this.bottomTitleWidth == 0) {
            rect = new Rect();
            Paint paint = this.mTextPaint;
            if (paint != null) {
                paint.getTextBounds("\u4e0b\u62c9\u6362\u4e2a\u76f4\u64ad\u770b\u770b\uff5e", 0, "\u4e0b\u62c9\u6362\u4e2a\u76f4\u64ad\u770b\u770b\uff5e".length(), rect);
            }
            this.bottomTitleWidth = rect.width();
        }
    }

    public final int getCoverHeight() {
        return this.mCoverHeight > 0 ? this.mCoverHeight : ResolutionUtils.getScreenHeight((Context)this.context);
    }

    @Nullable
    public final CoverPosInfo getCurrentPos() {
        return this.mCurrentPos;
    }

    public final void hideCover(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.mCurrentPos = null;
        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
    }

    public final void autoSlide(@NotNull CoverPosInfo posInfo, boolean isReset, float velocity) {
        Intrinsics.checkParameterIsNotNull((Object)posInfo, (String)"posInfo");
        MLog.info((Object)"SwipeCoverDrawer", (String)("autoSlide -> startScroll\uff1a posInfo = " + posInfo + ", isReset = " + isReset + ", "), (Object[])new Object[0]);
        float currentPosition = posInfo.getPositionY();
        while (true) {
            Canvas it;
            boolean bl;
            boolean bl2;
            Canvas canvas;
            Canvas canvas2;
            CoverPosInfo newPos;
            if ((newPos = new CoverPosInfo(currentPosition, posInfo.getDirection())).getDirection() == 1) {
                if (isReset) {
                    if (newPos.getPositionY() >= (float)this.mCoverHeight) {
                        Canvas canvas3 = canvas2 = this.holder.lockCanvas();
                        if (canvas3 != null) {
                            canvas = canvas3;
                            bl2 = false;
                            bl = false;
                            it = canvas;
                            boolean bl3 = false;
                            this.hideCover(it);
                            this.holder.unlockCanvasAndPost(it);
                        }
                        break;
                    }
                    CoverPosInfo coverPosInfo = newPos;
                    coverPosInfo.setPositionY(coverPosInfo.getPositionY() + velocity);
                    currentPosition += velocity;
                    if (newPos.getPositionY() > (float)this.mCoverHeight) {
                        newPos.setPositionY(this.mCoverHeight);
                        currentPosition = this.mCoverHeight;
                    }
                } else {
                    if (newPos.getPositionY() <= (float)(-this.statusHeight)) {
                        newPos.setPositionY(-((float)this.statusHeight));
                        Canvas canvas4 = canvas2 = this.holder.lockCanvas();
                        if (canvas4 != null) {
                            canvas = canvas4;
                            bl2 = false;
                            bl = false;
                            it = canvas;
                            boolean bl4 = false;
                            this.hideCover(it);
                            this.holder.unlockCanvasAndPost(it);
                        }
                        break;
                    }
                    CoverPosInfo coverPosInfo = newPos;
                    coverPosInfo.setPositionY(coverPosInfo.getPositionY() - velocity);
                    currentPosition -= velocity;
                    if (newPos.getPositionY() <= (float)(-this.statusHeight)) {
                        newPos.setPositionY(-((float)this.statusHeight));
                        currentPosition = -((float)this.statusHeight);
                    }
                }
            } else if (isReset) {
                if (newPos.getPositionY() <= 0.0f) {
                    Canvas canvas5 = canvas2 = this.holder.lockCanvas();
                    if (canvas5 != null) {
                        canvas = canvas5;
                        bl2 = false;
                        bl = false;
                        it = canvas;
                        boolean bl5 = false;
                        this.hideCover(it);
                        this.holder.unlockCanvasAndPost(it);
                    }
                    break;
                }
                CoverPosInfo coverPosInfo = newPos;
                coverPosInfo.setPositionY(coverPosInfo.getPositionY() - velocity);
                currentPosition -= velocity;
                if (newPos.getPositionY() <= 0.0f) {
                    newPos.setPositionY(0.0f);
                    currentPosition = 0.0f;
                }
            } else {
                if (newPos.getPositionY() >= (float)(this.mCoverHeight + this.statusHeight)) {
                    newPos.setPositionY(this.mCoverHeight);
                    Canvas canvas6 = canvas2 = this.holder.lockCanvas();
                    if (canvas6 != null) {
                        canvas = canvas6;
                        bl2 = false;
                        bl = false;
                        it = canvas;
                        boolean bl6 = false;
                        this.hideCover(it);
                        this.holder.unlockCanvasAndPost(it);
                    }
                    break;
                }
                CoverPosInfo coverPosInfo = newPos;
                coverPosInfo.setPositionY(coverPosInfo.getPositionY() + velocity);
                currentPosition += velocity;
                if (newPos.getPositionY() >= (float)(this.mCoverHeight + this.statusHeight)) {
                    newPos.setPositionY((float)this.mCoverHeight + (float)this.statusHeight);
                    currentPosition = (float)this.mCoverHeight + (float)this.statusHeight;
                }
            }
            if ((canvas2 = this.holder.lockCanvas()) == null) continue;
            bl2 = false;
            bl = false;
            it = canvas;
            boolean bl7 = false;
            this.hideCover(it);
            this.drawCover(it, newPos);
            this.holder.unlockCanvasAndPost(it);
        }
    }

    public final void drawCover(@NotNull Canvas canvas, @Nullable CoverPosInfo posInfo) {
        float f;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (posInfo == null) {
            return;
        }
        if (posInfo.getDirection() == 1) {
            posInfo.setPositionY(RangesKt.coerceAtLeast((float)posInfo.getPositionY(), (float)0.0f));
            f = RangesKt.coerceAtLeast((float)posInfo.getPositionY(), (float)0.0f);
        } else {
            posInfo.setPositionY(RangesKt.coerceAtMost((float)posInfo.getPositionY(), (float)this.mCoverHeight));
            f = RangesKt.coerceAtMost((float)((float)(-this.mCoverHeight) + posInfo.getPositionY()), (float)0.0f);
        }
        float dy = f;
        canvas.concat(this.coverMatrix);
        this.mCurrentPos = posInfo;
        if (posInfo.getDirection() == 1) {
            float center = (float)this.mCoverWidth / 2.0f;
            float titleDy = posInfo.getPositionY() + this.titleMargin;
            float titleDx = (float)(this.mCoverWidth - this.topTitleWidth) / 2.0f;
            float arrowDy = posInfo.getPositionY() + this.arrowMargin;
            float circleDy = posInfo.getPositionY() + this.circleMargin;
            this.drawCover(canvas, dy, this.mPrevBitmap);
            this.drawText(canvas, titleDx, titleDy, true);
            this.drawArrow(canvas, center, arrowDy, true);
            this.drawCircle(canvas, center, circleDy);
        } else if (posInfo.getDirection() == 2) {
            float center = (float)this.mCoverWidth / 2.0f;
            float titleDy = posInfo.getPositionY() - this.titleMargin;
            float titleDx = (float)(this.mCoverWidth - this.bottomTitleWidth) / 2.0f;
            float arrowDy = posInfo.getPositionY() - this.arrowMargin;
            float circleDy = posInfo.getPositionY() - this.circleMargin + (float)5;
            this.drawCover(canvas, dy, this.mNextBitmap);
            this.drawText(canvas, titleDx, titleDy, false);
            this.drawArrow(canvas, center, arrowDy, false);
            this.drawCircle(canvas, center, circleDy);
        }
        this.coverMatrix.reset();
    }

    private final void drawCover(Canvas canvas, float dy, Bitmap bitmap) {
        block1: {
            this.coverMatrix.postTranslate(0.0f, dy);
            Rect dstRect = new Rect(0, (int)dy, this.windowWidth, this.windowHeight + (int)dy);
            Bitmap bitmap2 = bitmap;
            if (bitmap2 != null) {
                Bitmap bitmap3 = bitmap2;
                boolean bl = false;
                boolean bl2 = false;
                Bitmap it = bitmap3;
                boolean bl3 = false;
                canvas.drawBitmap(it, this.coverMatrix, this.mCoverPaint);
                return;
            }
            Bitmap bitmap4 = this.mCoverBitmap;
            if (bitmap4 == null) break block1;
            Bitmap bitmap5 = bitmap4;
            boolean bl = false;
            boolean bl4 = false;
            Bitmap it = bitmap5;
            boolean bl5 = false;
            canvas.drawBitmap(it, null, dstRect, this.mCoverPaint);
        }
    }

    @NotNull
    public final Rect test(int bitmapWidth, int bitmapHeight) {
        if ((float)bitmapHeight * (float)this.windowWidth / (float)bitmapWidth > (float)this.windowHeight) {
            float h3 = (float)this.windowHeight * (float)bitmapWidth / (float)this.windowWidth;
            return new Rect(0, (int)(((float)bitmapHeight - h3) / (float)2), bitmapWidth, (int)(((float)bitmapHeight + h3) / (float)2));
        }
        float w3 = (float)this.windowWidth * (float)bitmapHeight / (float)this.windowHeight;
        return new Rect((int)(((float)bitmapWidth - w3) / (float)2), 0, (int)(((float)bitmapWidth + w3) / (float)2), bitmapHeight);
    }

    @NotNull
    public final Bitmap test(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Rect rect = this.test(bitmap.getWidth(), bitmap.getHeight());
        Bitmap clipBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)rect.left, (int)rect.top, (int)rect.width(), (int)rect.height());
        Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)clipBitmap, (int)this.windowWidth, (int)this.windowHeight, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createScaledBitma\u2026idth, windowHeight, true)");
        return bitmap2;
    }

    private final void drawText(Canvas canvas, float dx, float dy, boolean isTop) {
        block2: {
            Paint paint = this.mTextPaint;
            if (paint == null) break block2;
            Paint paint2 = paint;
            boolean bl = false;
            boolean bl2 = false;
            Paint it = paint2;
            boolean bl3 = false;
            if (isTop) {
                canvas.drawText("\u4e0a\u62c9\u6362\u4e2a\u76f4\u64ad\u770b\u770b\uff5e", dx, dy, it);
            } else {
                canvas.drawText("\u4e0b\u62c9\u6362\u4e2a\u76f4\u64ad\u770b\u770b\uff5e", dx, dy, it);
            }
        }
    }

    private final void drawArrow(Canvas canvas, float dx, float dy, boolean isTop) {
        block2: {
            Paint paint = this.mArrowPaint;
            if (paint == null) break block2;
            Paint paint2 = paint;
            boolean bl = false;
            boolean bl2 = false;
            Paint it = paint2;
            boolean bl3 = false;
            if (isTop) {
                this.topArrowPath.reset();
                this.topArrowPath.moveTo(dx, dy);
                this.topArrowPath.rLineTo(-11.0f, 11.0f);
                this.topArrowPath.moveTo(dx, dy);
                this.topArrowPath.rLineTo(11.0f, 11.0f);
                canvas.drawPath(this.topArrowPath, it);
            } else {
                this.bottomArrowPath.reset();
                this.bottomArrowPath.moveTo(dx, dy);
                this.bottomArrowPath.rLineTo(-11.0f, -11.0f);
                this.bottomArrowPath.moveTo(dx, dy);
                this.bottomArrowPath.rLineTo(11.0f, -11.0f);
                canvas.drawPath(this.bottomArrowPath, it);
            }
        }
    }

    public final void setWidthHeight(int width, int height) {
        MLog.info((Object)"SwipeCoverDrawer", (String)("setWidthHeight -> width = " + width + ", height = " + height), (Object[])new Object[0]);
        this.mCoverHeight = height;
        this.mCoverWidth = width;
        this.setupBitmap(width, height);
    }

    private final void drawCircle(Canvas canvas, float dx, float dy) {
        if (this.mCirclePaint == null) {
            return;
        }
        int alpha = (int)229.5;
        Paint paint = this.mCirclePaint;
        if (paint != null) {
            paint.setAlpha(alpha);
        }
        float f = dy - (float)30;
        Paint paint2 = this.mCirclePaint;
        if (paint2 == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawCircle(dx, f, 2.0f, paint2);
        Paint paint3 = this.mCirclePaint;
        if (paint3 != null) {
            paint3.setAlpha(alpha);
        }
        float f2 = dy - (float)15;
        Paint paint4 = this.mCirclePaint;
        if (paint4 == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawCircle(dx, f2, 2.0f, paint4);
        Paint paint5 = this.mCirclePaint;
        if (paint5 != null) {
            paint5.setAlpha(alpha);
        }
        Paint paint6 = this.mCirclePaint;
        if (paint6 == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawCircle(dx, dy, 2.0f, paint6);
    }

    private final void setupBitmap(int width, int height) {
        if (this.mCoverBitmap != null) {
            MLog.info((Object)"SwipeCoverDrawer", (String)"setupBitmap: already setup", (Object[])new Object[0]);
            return;
        }
        if (width <= 0 || height <= 0) {
            MLog.info((Object)"SwipeCoverDrawer", (String)"setupBitmap: invalid width or height", (Object[])new Object[0]);
            return;
        }
        Schedulers.io().scheduleDirect(new Runnable(this, width, height){
            final /* synthetic */ SwipeCoverDrawer this$0;
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;

            public final void run() {
                if (this.this$0.mCoverBitmap == null) {
                    try {
                        Bitmap bitmap = this.this$0.mCoverBitmap = BitmapFactory.decodeResource((Resources)this.this$0.getContext().getResources(), (int)R.drawable.live_room_loading_bg);
                        if (bitmap == null) {
                            Intrinsics.throwNpe();
                        }
                        this.this$0.mCoverBitmap = this.this$0.resizeImage(bitmap, this.$width, this.$height);
                        MLog.info((Object)"SwipeCoverDrawer", (String)"setupBitmap: bitmap setup finish", (Object[])new Object[0]);
                    }
                    catch (Throwable throwable) {
                        MLog.error((Object)"SwipeCoverDrawer", (String)"setupBitmap decode or create bitmap fail ", (Throwable)throwable, (Object[])new Object[0]);
                    }
                }
            }
            {
                this.this$0 = swipeCoverDrawer;
                this.$width = n;
                this.$height = n2;
            }
        });
    }

    public final Bitmap resizeImage(Bitmap bitmap, int width, int height) {
        int bmpWidth = bitmap.getWidth();
        int bmpHeight = bitmap.getHeight();
        float scaleWidth = (float)width / (float)bmpWidth;
        float scaleHeight = (float)height / (float)bmpHeight;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bmpWidth, (int)bmpHeight, (Matrix)matrix, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(bitm\u2026 bmpHeight, matrix, true)");
        return bitmap2;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final SurfaceHolder getHolder() {
        return this.holder;
    }

    public SwipeCoverDrawer(@NotNull Context context, @NotNull SurfaceHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        this.context = context;
        this.holder = holder;
        this.initPaint();
        this.initTextWidth();
        this.coverMatrix = new Matrix();
        this.titleMargin = DensityUtils.dp2px((float)85.0f);
        this.topArrowPath = new Path();
        this.bottomArrowPath = new Path();
        this.arrowMargin = DensityUtils.dp2px((float)45.0f);
        this.circleMargin = DensityUtils.dp2px((float)30.0f);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/yy/mobile/ui/touch/surface/SwipeCoverDrawer$Companion;", "", "()V", "DIRECTION_TO_BOTTOM", "", "DIRECTION_TO_TOP", "TAG", "", "bottomTitle", "topTitle", "pluginunionlive_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

