/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.touch.surface;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.support.annotation.MainThread;
import com.yy.mobile.ui.touch.surface.CoverPosInfo;
import com.yy.mobile.ui.touch.surface.ICoverDrawer;
import com.yy.mobile.ui.touch.surface.SwipeCoverDrawer;
import com.yy.mobile.util.log.MLog;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000 42\u00020\u0001:\u0003456B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0003H\u0007J(\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0006\u0010%\u001a\u00020\u0014J\u001a\u0010&\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\b\u0010'\u001a\u00020\u001dH\u0007J\b\u0010(\u001a\u00020\u001dH\u0002J\"\u0010)\u001a\u00020\u00062\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\b\u0010*\u001a\u00020\u001dH\u0014J\b\u0010+\u001a\u00020\u001dH\u0007J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u0017H\u0007J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u0014H\u0002J\u0010\u00100\u001a\u00020\u001d2\b\u00101\u001a\u0004\u0018\u00010\u001bJ\u0014\u00102\u001a\u00020\u000b2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u001bH\u0002J\u0012\u00103\u001a\u00020\u001d2\b\u0010-\u001a\u0004\u0018\u00010\u0017H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/yy/mobile/ui/touch/surface/CoverDrawThread;", "Landroid/os/HandlerThread;", "name", "", "(Ljava/lang/String;)V", "autoSlideDirection", "", "autoSlideVelocity", "", "currentFuncScene", "isReset", "", "listener", "Lcom/yy/mobile/ui/touch/surface/CoverDrawThread$StateCallback;", "getListener", "()Lcom/yy/mobile/ui/touch/surface/CoverDrawThread$StateCallback;", "setListener", "(Lcom/yy/mobile/ui/touch/surface/CoverDrawThread$StateCallback;)V", "mActionState", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/yy/mobile/ui/touch/surface/CoverDrawThread$CoverActionState;", "kotlin.jvm.PlatformType", "mCurScrollPosInfo", "Lcom/yy/mobile/ui/touch/surface/CoverPosInfo;", "mDrawThreadHandler", "Landroid/os/Handler;", "mICoverDrawer", "Lcom/yy/mobile/ui/touch/surface/ICoverDrawer;", "autoSlide", "", "velocity", "direction", "currentFunc", "autoSlideDraw", "reset", "drawer", "Lcom/yy/mobile/ui/touch/surface/SwipeCoverDrawer;", "currentState", "getResetVelocity", "hideCover", "initHandler", "modifyVelocity", "onLooperPrepared", "resetCover", "scrollSlide", "posInfo", "setCoverState", "state", "setDrawer", "coverDrawer", "surfaceValid", "updateSwipePos", "Companion", "CoverActionState", "StateCallback", "pluginunionlive_release"})
public final class CoverDrawThread
extends HandlerThread {
    private Handler mDrawThreadHandler;
    public float autoSlideVelocity;
    private int autoSlideDirection;
    public volatile String currentFuncScene;
    public boolean isReset;
    private CoverPosInfo mCurScrollPosInfo;
    private final AtomicReference<CoverActionState> mActionState;
    @Nullable
    private StateCallback listener;
    public volatile ICoverDrawer mICoverDrawer;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final StateCallback getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable StateCallback stateCallback) {
        this.listener = stateCallback;
    }

    @NotNull
    public final CoverActionState currentState() {
        CoverActionState coverActionState = this.mActionState.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)coverActionState), (String)"mActionState.get()");
        return coverActionState;
    }

    public final void setDrawer(@Nullable ICoverDrawer coverDrawer) {
        block1: {
            this.mICoverDrawer = coverDrawer;
            if (coverDrawer != null || this.mDrawThreadHandler == null) break block1;
            this.setCoverState(CoverActionState.HIDE);
            Message msg = Message.obtain();
            msg.what = 8;
            Handler handler2 = this.mDrawThreadHandler;
            if (handler2 != null) {
                handler2.sendMessage(msg);
            }
        }
    }

    public final void setCoverState(CoverActionState state) {
        if (this.mActionState.get() != state) {
            MLog.info((Object)"CoverDrawThread", (String)("setCoverState: " + (Object)((Object)this.mActionState.get()) + " to " + (Object)((Object)state)), (Object[])new Object[0]);
            StateCallback stateCallback = this.listener;
            if (stateCallback != null) {
                CoverActionState coverActionState = this.mActionState.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)coverActionState), (String)"mActionState.get()");
                stateCallback.stateChange(coverActionState, state);
            }
        }
        this.mActionState.getAndSet(state);
    }

    public final boolean surfaceValid(ICoverDrawer drawer) {
        ICoverDrawer drawer2;
        ICoverDrawer iCoverDrawer = drawer;
        if (iCoverDrawer == null) {
            iCoverDrawer = this.mICoverDrawer;
        }
        ICoverDrawer iCoverDrawer2 = drawer2 = iCoverDrawer;
        return iCoverDrawer2 != null ? iCoverDrawer2.isSurfaceValid() : false;
    }

    static /* synthetic */ boolean surfaceValid$default(CoverDrawThread coverDrawThread, ICoverDrawer iCoverDrawer, int n, Object object) {
        if ((n & 1) != 0) {
            iCoverDrawer = null;
        }
        return coverDrawThread.surfaceValid(iCoverDrawer);
    }

    private final void updateSwipePos(CoverPosInfo posInfo) {
        block3: {
            if (posInfo == null) {
                return;
            }
            if (CoverActionState.HIDE == this.mActionState.get()) {
                MLog.info((Object)"CoverDrawThread", (String)"updateSwipePos: do nothing on hide state", (Object[])new Object[0]);
                return;
            }
            if (this.mDrawThreadHandler == null) break block3;
            Message msg = Message.obtain();
            msg.what = 4;
            msg.obj = posInfo;
            Handler handler2 = this.mDrawThreadHandler;
            if (handler2 != null) {
                handler2.sendMessage(msg);
            }
        }
    }

    @MainThread
    public final void scrollSlide(@NotNull CoverPosInfo posInfo) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)posInfo, (String)"posInfo");
            if (this.mDrawThreadHandler == null) break block1;
            Message msg = Message.obtain();
            msg.what = 3;
            msg.obj = posInfo;
            Handler handler2 = this.mDrawThreadHandler;
            if (handler2 != null) {
                handler2.sendMessage(msg);
            }
        }
    }

    @MainThread
    public final void hideCover() {
        block2: {
            if (CoverActionState.HIDE == this.mActionState.get()) {
                return;
            }
            if (this.mDrawThreadHandler == null) break block2;
            this.setCoverState(CoverActionState.HIDE);
            Message msg = Message.obtain();
            msg.what = 6;
            Handler handler2 = this.mDrawThreadHandler;
            if (handler2 != null) {
                handler2.sendMessage(msg);
            }
        }
    }

    @MainThread
    public final void autoSlide(int velocity, int direction, @NotNull String currentFunc) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)currentFunc, (String)"currentFunc");
            if (this.mDrawThreadHandler == null) break block1;
            this.mCurScrollPosInfo = null;
            Message msg = Message.obtain();
            this.currentFuncScene = currentFunc;
            msg.what = 5;
            msg.arg1 = velocity;
            msg.arg2 = direction;
            Handler handler2 = this.mDrawThreadHandler;
            if (handler2 != null) {
                handler2.sendMessage(msg);
            }
        }
    }

    @MainThread
    public final void resetCover() {
        block3: {
            if (CoverActionState.HIDE == this.mActionState.get()) {
                MLog.info((Object)"CoverDrawThread", (String)"resetCover: already hide", (Object[])new Object[0]);
                return;
            }
            if (CoverActionState.RESET == this.mActionState.get()) {
                MLog.info((Object)"CoverDrawThread", (String)"resetCover: already reset", (Object[])new Object[0]);
                return;
            }
            if (this.mDrawThreadHandler == null) break block3;
            this.mCurScrollPosInfo = null;
            Message msg = Message.obtain();
            msg.what = 7;
            Handler handler2 = this.mDrawThreadHandler;
            if (handler2 != null) {
                handler2.sendMessage(msg);
            }
        }
    }

    public final void autoSlideDraw(boolean reset, SwipeCoverDrawer drawer, int velocity, int direction) {
        this.autoSlideDirection = direction;
        this.isReset = reset;
        this.autoSlideVelocity = reset ? this.getResetVelocity(drawer, direction) : (float)this.modifyVelocity(drawer, velocity, direction);
        MLog.debug((Object)"CoverDrawThread", (String)"autoSlideDraw: reset:%b, velocity:%d, modifiedVelocity:%f, direction:%d", (Object[])new Object[]{reset, velocity, Float.valueOf(this.autoSlideVelocity), direction});
    }

    private final float getResetVelocity(SwipeCoverDrawer drawer, int direction) {
        float f;
        if (drawer == null) {
            MLog.info((Object)"CoverDrawThread", (String)"getResetVelocity: null drawer", (Object[])new Object[0]);
            return 0.0f;
        }
        CoverPosInfo pos = drawer.getCurrentPos();
        float slideDistance = 0.0f;
        if (direction == 1) {
            f = pos != null ? (float)drawer.getCoverHeight() - pos.getPositionY() : (float)drawer.getCoverHeight() / 3.0f;
        } else {
            CoverPosInfo coverPosInfo = pos;
            f = coverPosInfo != null ? coverPosInfo.getPositionY() : (float)drawer.getCoverHeight() / 3.0f;
        }
        slideDistance = f;
        float disRatio = slideDistance / (float)drawer.getCoverHeight();
        int duration = (int)((disRatio + 1.0f) * (float)100);
        return slideDistance / (float)duration;
    }

    private final int modifyVelocity(SwipeCoverDrawer drawer, int velocity, int direction) {
        float f;
        if (drawer == null) {
            MLog.info((Object)"CoverDrawThread", (String)"modifyVelocity: null drawer", (Object[])new Object[0]);
            return 0;
        }
        CoverPosInfo pos = drawer.getCurrentPos();
        float slideDistance = 0.0f;
        if (direction == 1) {
            CoverPosInfo coverPosInfo = pos;
            f = coverPosInfo != null ? coverPosInfo.getPositionY() : (float)drawer.getCoverHeight();
        } else {
            f = pos != null ? (float)drawer.getCoverHeight() - pos.getPositionY() : (float)drawer.getCoverHeight();
        }
        slideDistance = f;
        float minVelocity = slideDistance / (float)100;
        boolean bl = false;
        float fingerVelocity = (float)Math.abs(velocity) / 1000.0f;
        bl = false;
        return (int)Math.max(minVelocity, fingerVelocity);
    }

    protected void onLooperPrepared() {
        super.onLooperPrepared();
        this.initHandler();
    }

    private final void initHandler() {
        MLog.info((Object)"CoverDrawThread", (String)"initHandler: ", (Object[])new Object[0]);
        this.mDrawThreadHandler = new Handler(this, this.getLooper()){
            final /* synthetic */ CoverDrawThread this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void handleMessage(@NotNull Message msg) {
                Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                super.handleMessage(msg);
                if (msg.what == 8) {
                    MLog.info((Object)"CoverDrawThread", (String)"handleMessage: cancel mUpdateAnimator", (Object[])new Object[0]);
                    this.this$0.setCoverState(CoverActionState.HIDE);
                }
                if (!this.this$0.surfaceValid(iCoverDrawer = this.this$0.mICoverDrawer)) {
                    return;
                }
                v0 = iCoverDrawer;
                if (v0 == null) {
                    Intrinsics.throwNpe();
                }
                var3_3 = v0.getCanvasLock();
                var4_4 = false;
                var5_5 = false;
                synchronized (var3_3) {
                    block33: {
                        $i$a$-synchronized-CoverDrawThread$initHandler$1$handleMessage$1 = false;
                        if (this.this$0.surfaceValid(iCoverDrawer)) {
                            canvas = null;
                            try {
                                canvas = iCoverDrawer.getSurfaceHolder().lockCanvas();
                                drawer = iCoverDrawer.getDrawer();
                                if (canvas == null) break block33;
                                pos = null;
                                switch (msg.what) {
                                    case 3: {
                                        this.this$0.setCoverState(CoverActionState.SCROLL);
                                        drawer.hideCover(canvas);
                                        v1 = msg.obj;
                                        if (v1 == null) {
                                            throw new TypeCastException("null cannot be cast to non-null type com.yy.mobile.ui.touch.surface.CoverPosInfo");
                                        }
                                        drawer.drawCover(canvas, (CoverPosInfo)v1);
                                        ** break;
lbl35:
                                        // 1 sources

                                        break;
                                    }
                                    case 4: {
                                        v2 = msg.obj;
                                        if (v2 == null) {
                                            throw new TypeCastException("null cannot be cast to non-null type com.yy.mobile.ui.touch.surface.CoverPosInfo");
                                        }
                                        posInfo = (CoverPosInfo)v2;
                                        drawer.drawCover(canvas, posInfo);
                                        ** break;
lbl43:
                                        // 1 sources

                                        break;
                                    }
                                    case 5: {
                                        this.this$0.setCoverState(CoverActionState.FLING);
                                        pos = drawer.getCurrentPos();
                                        if (pos == null) {
                                            positionY = msg.arg2 == 1 ? drawer.getCoverHeight() : 0;
                                            pos = new CoverPosInfo(positionY, msg.arg2);
                                        }
                                        drawer.drawCover(canvas, pos);
                                        iCoverDrawer.getSurfaceHolder().unlockCanvasAndPost(canvas);
                                        this.this$0.autoSlideDraw(false, drawer, msg.arg1, msg.arg2);
                                        if (this.this$0.autoSlideVelocity == 0.0f) {
                                            this.this$0.autoSlideVelocity = 1.0f;
                                        }
                                        if (Intrinsics.areEqual((Object)this.this$0.currentFuncScene, (Object)"MeiPaiLiveOver")) {
                                            MLog.info((Object)"CoverDrawThread", (String)"super speed Scroll", (Object[])new Object[0]);
                                            this.this$0.autoSlideVelocity = 125.0f;
                                        }
                                        drawer.autoSlide(pos, this.this$0.isReset, this.this$0.autoSlideVelocity * 6.0f);
                                        this.this$0.setCoverState(CoverActionState.HIDE);
                                        MLog.info((Object)"CoverDrawThread", (String)"hideCover Finish Scroll", (Object[])new Object[0]);
                                        ** break;
lbl62:
                                        // 1 sources

                                        break;
                                    }
                                    case 6: {
                                        this.this$0.setCoverState(CoverActionState.HIDE);
                                        drawer.hideCover(canvas);
                                        ** break;
lbl67:
                                        // 1 sources

                                        break;
                                    }
                                    case 7: {
                                        this.this$0.setCoverState(CoverActionState.RESET);
                                        pos = drawer.getCurrentPos();
                                        drawer.drawCover(canvas, pos);
                                        if (pos != null) {
                                            this.this$0.autoSlideDraw(true, drawer, 0, pos.getDirection());
                                            iCoverDrawer.getSurfaceHolder().unlockCanvasAndPost(canvas);
                                            if (this.this$0.autoSlideVelocity == 0.0f) {
                                                this.this$0.autoSlideVelocity = 1.0f;
                                            }
                                            drawer.autoSlide(pos, true, this.this$0.autoSlideVelocity * 6.0f);
                                        }
                                        this.this$0.setCoverState(CoverActionState.HIDE);
                                        break;
                                    }
                                    ** default:
lbl81:
                                    // 1 sources

                                    break;
                                }
                            }
                            catch (Exception ex) {
                                MLog.error((Object)"CoverDrawThread", (String)"error when slide = ", (Throwable)ex, (Object[])new Object[0]);
                            }
                            finally {
                                try {
                                    if (canvas != null) {
                                        iCoverDrawer.getSurfaceHolder().unlockCanvasAndPost(canvas);
                                    }
                                }
                                catch (Exception ex) {
                                    MLog.error((Object)"CoverDrawThread", (String)"unlockCanvasAndPost failed", (Throwable)ex, (Object[])new Object[0]);
                                }
                            }
                        }
                    }
                    var5_6 = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
    }

    public CoverDrawThread(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        super(name, 19);
        this.currentFuncScene = "";
        this.mActionState = new AtomicReference<CoverActionState>(CoverActionState.HIDE);
        this.setCoverState(CoverActionState.HIDE);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/yy/mobile/ui/touch/surface/CoverDrawThread$CoverActionState;", "", "(Ljava/lang/String;I)V", "SCROLL", "FLING", "RESET", "HIDE", "pluginunionlive_release"})
    public static final class CoverActionState
    extends Enum<CoverActionState> {
        public static final /* enum */ CoverActionState SCROLL;
        public static final /* enum */ CoverActionState FLING;
        public static final /* enum */ CoverActionState RESET;
        public static final /* enum */ CoverActionState HIDE;
        private static final /* synthetic */ CoverActionState[] $VALUES;

        static {
            CoverActionState[] coverActionStateArray = new CoverActionState[4];
            CoverActionState[] coverActionStateArray2 = coverActionStateArray;
            coverActionStateArray[0] = SCROLL = new CoverActionState();
            coverActionStateArray[1] = FLING = new CoverActionState();
            coverActionStateArray[2] = RESET = new CoverActionState();
            coverActionStateArray[3] = HIDE = new CoverActionState();
            $VALUES = coverActionStateArray;
        }

        public static CoverActionState[] values() {
            return (CoverActionState[])$VALUES.clone();
        }

        public static CoverActionState valueOf(String string2) {
            return Enum.valueOf(CoverActionState.class, string2);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/yy/mobile/ui/touch/surface/CoverDrawThread$StateCallback;", "", "stateChange", "", "oldState", "Lcom/yy/mobile/ui/touch/surface/CoverDrawThread$CoverActionState;", "newState", "pluginunionlive_release"})
    public static interface StateCallback {
        public void stateChange(@NotNull CoverActionState var1, @NotNull CoverActionState var2);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/yy/mobile/ui/touch/surface/CoverDrawThread$Companion;", "", "()V", "MAX_AUTO_SLIDE_MILLIS", "", "MSG_AUTO_SLIDE", "MSG_HIDE_COVER", "MSG_RESET_COVER", "MSG_SCROLL_COVER", "MSG_SURFACE_DESTROY", "MSG_UPDATE_SWIPE_POS", "TAG", "", "pluginunionlive_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

