/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.touch;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.duowan.mobile.basemedia.swipe.SwipeDirection;
import com.duowan.mobile.basemedia.swipe.SwipeViewDelegate;
import com.duowan.mobile.basemedia.watchlive.activity.ViewingRoomProcessor;
import com.duowan.mobile.entlive.events.ITouchClearScreen_EventArgs;
import com.unionyy.mobile.spdt.Spdt;
import com.unionyy.mobile.spdt.annotation.MEIPAI;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.game.ui.videobusiness.VolumeBrightnessView;
import com.yy.mobile.RxBus;
import com.yy.mobile.mvp.MvpView;
import com.yy.mobile.plugin.main.events.IBasicFunctionClient_onHideScreenElementsView_EventArgs;
import com.yy.mobile.plugin.main.events.IBasicFunctionClient_onShowScreenElementsView_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.activity.GlobalActivityManager;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.basicfunction.behavior.IBasicFunctionBehavior;
import com.yy.mobile.ui.meidabasicvideoview.compat.component.AudienceVideoViewFragment;
import com.yy.mobile.ui.recommend.ShowSlideMenuEvent;
import com.yy.mobile.ui.touch.TouchComponent$$EventBinder;
import com.yy.mobile.ui.touch.surface.CoverPosInfo;
import com.yy.mobile.ui.touch.surface.SwipeSurfaceView;
import com.yy.mobile.ui.widget.swipeloadingview.SwipeContentView;
import com.yy.mobile.ui.ylink.SpdtComponent;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.uicore.ITouchCore;
import jp.wasabeef.glide.transformations.BlurTransformation;
import tv.athena.util.common.ScreenUtils;

public class TouchComponent
extends Component
implements SwipeViewDelegate,
MvpView {
    private View mRootView = null;
    protected View view;
    protected View content;
    protected SwipeContentView swipeView;
    private boolean enable;
    private VolumeBrightnessView mBrightnessView;
    protected SwipeViewDelegate mSwipeListener;
    protected SwipeSurfaceView mSwipeSurfaceView;
    private volatile boolean autoSlide = false;
    protected Drawable nextRoomDrawable = null;
    protected Drawable prevRoomDrawable = null;
    protected Drawable defaultDrawable = null;
    private int windowHeight = 0;
    private int windowWidth = 0;
    private EventBinder mTouchComponentSniperEventBinder;

    protected Drawable getDefaultDrawable() {
        if (this.defaultDrawable == null) {
            Context context = null;
            if (this.getContext() != null) {
                context = this.getContext();
            } else if (GlobalActivityManager.INSTANCE.getCurrentActivity() != null) {
                context = GlobalActivityManager.INSTANCE.getCurrentActivity();
            }
            if (context != null) {
                this.defaultDrawable = context.getResources().getDrawable(R.drawable.live_room_loading_bg);
            }
        }
        return this.defaultDrawable;
    }

    public static TouchComponent newInstance() {
        TouchComponent fragment = new TouchComponent();
        Bundle bundle = new Bundle();
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        MLog.info((Object)"TouchComponent", (String)"onCreatesetSwipeEnable true", (Object[])new Object[0]);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (container != null) {
            this.mRootView = inflater.inflate(R.layout.fragment_basic_touch, container, false);
        }
        this.swipeView = (SwipeContentView)this.mRootView.findViewById(R.id.swipe_loading);
        this.swipeView.setSwipeViewDelegate(this);
        this.mBrightnessView = (VolumeBrightnessView)this.mRootView.findViewById(R.id.volumeBrightness);
        this.mBrightnessView.setEnable(this.isLandScapeMode());
        this.mSwipeSurfaceView = (SwipeSurfaceView)this.mRootView.findViewById(R.id.swipe_surface_view);
        this.initSwipeTipLayout();
        ((ITouchCore)ICoreManagerBase.getCore(ITouchCore.class)).setClearScreenSate(false);
        return this.mRootView;
    }

    private View getContentView() {
        if (!this.checkActivityValid()) {
            return null;
        }
        if (this.getActivity() == null) {
            return null;
        }
        this.content = this.getActivity().findViewById(R.id.channel_content);
        return this.content;
    }

    public void disableSwipeToRight() {
        if (this.swipeView != null) {
            this.swipeView.disableDirection(SwipeDirection.LEFT);
        }
    }

    public void disableSwipeToLeftAndRight() {
        if (this.swipeView != null) {
            this.swipeView.disableDirection(SwipeDirection.LEFT);
            this.swipeView.disableDirection(SwipeDirection.RIGHT);
            this.swipeView.disableDirection(SwipeDirection.CENTER);
        }
    }

    public void enableSwipeToLeftAndRight() {
        if (this.swipeView != null) {
            this.swipeView.enableDirection(SwipeDirection.LEFT);
            this.swipeView.enableDirection(SwipeDirection.RIGHT);
            this.swipeView.enableDirection(SwipeDirection.CENTER);
        }
    }

    public void disableSwipeAll() {
        if (this.swipeView != null) {
            this.swipeView.disableDirection(SwipeDirection.RIGHT);
            this.swipeView.disableDirection(SwipeDirection.LEFT);
            this.swipeView.disableDirection(SwipeDirection.TOP);
            this.swipeView.disableDirection(SwipeDirection.BOTTOM);
        }
    }

    public void onleSwipeToRight() {
        if (this.swipeView != null) {
            this.swipeView.disableDirection(SwipeDirection.LEFT);
            this.swipeView.disableDirection(SwipeDirection.TOP);
            this.swipeView.disableDirection(SwipeDirection.BOTTOM);
        }
    }

    public View getDragView(SwipeDirection direction) {
        switch (direction) {
            case CENTER: 
            case RIGHT: 
            case LEFT: {
                return this.getContentView();
            }
            case BOTTOM: 
            case TOP: {
                if (Spdt.currentFlavor() instanceof MEIPAI) {
                    return this.getSlideChannelMask();
                }
                return this.getSlideChannelMask(direction);
            }
        }
        if (this.mSwipeListener != null) {
            this.mSwipeListener.getDragView(direction);
        }
        return null;
    }

    protected void showLiveMenu() {
        RxBus.getDefault().post((Object)new ShowSlideMenuEvent(true, false));
    }

    public void onFling(SwipeDirection fromDirection, SwipeDirection toDirection, int velocity) {
        MLog.info((Object)"TouchComponent", (String)("liveTemplateActivity.onFling  fromDirection:" + fromDirection + " toDirection\uff1a" + toDirection), (Object[])new Object[0]);
        if (fromDirection != toDirection && toDirection == SwipeDirection.RIGHT) {
            this.showLiveMenu();
        }
        if (toDirection == SwipeDirection.BOTTOM || toDirection == SwipeDirection.TOP) {
            if (!this.getAutoSlide()) {
                int direction = toDirection == SwipeDirection.BOTTOM ? 1 : 2;
                this.mSwipeSurfaceView.autoSlide(velocity, direction, ViewingRoomProcessor.getInstance().getCurrentFunctionName());
                this.setAutoSlide(true);
            }
            if (toDirection == SwipeDirection.BOTTOM && this.prevRoomDrawable != null) {
                this.setLoadingDrawable(this.prevRoomDrawable);
            } else if (toDirection == SwipeDirection.TOP && this.nextRoomDrawable != null) {
                this.setLoadingDrawable(this.nextRoomDrawable);
            }
        }
        if (fromDirection == SwipeDirection.CENTER && toDirection == SwipeDirection.CENTER && !this.getAutoSlide()) {
            this.mSwipeSurfaceView.resetCover();
            this.setAutoSlide(true);
        }
        if (this.mSwipeListener != null) {
            this.mSwipeListener.onFling(fromDirection, toDirection, velocity);
        }
    }

    public void onScroll(SwipeDirection fromPosition, SwipeDirection toPosition, int x, int y, float percent, boolean isVerticalScroll) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (fromPosition == SwipeDirection.LEFT || toPosition == SwipeDirection.LEFT) {
            IBasicFunctionBehavior basicFunctionBehavior;
            View view = this.getDragView(SwipeDirection.CENTER);
            if (view != null) {
                view.setTranslationX((float)(-x));
            }
            if (this.getRoot() != null && (basicFunctionBehavior = this.getBasicFunctionBehavior()) != null) {
                basicFunctionBehavior.transformSwipeAlpha(percent);
            }
        } else if (fromPosition == SwipeDirection.TOP || toPosition == SwipeDirection.TOP) {
            if (!this.getAutoSlide()) {
                this.mSwipeSurfaceView.scrollSlide(new CoverPosInfo(Math.abs(y), 2));
            }
        } else if (fromPosition == SwipeDirection.BOTTOM || toPosition == SwipeDirection.BOTTOM) {
            if (!this.getAutoSlide()) {
                this.mSwipeSurfaceView.scrollSlide(new CoverPosInfo(this.mSwipeSurfaceView.getMeasuredHeight() - y, 1));
            }
        } else if (toPosition != SwipeDirection.CENTER || fromPosition != SwipeDirection.RIGHT) {
            if (toPosition == SwipeDirection.RIGHT) {
                IBasicFunctionBehavior basicFunctionBehavior;
                View view = this.getDragView(SwipeDirection.CENTER);
                if (view != null) {
                    view.setTranslationX(0.0f);
                }
                if (this.getRoot() != null && (basicFunctionBehavior = this.getBasicFunctionBehavior()) != null) {
                    basicFunctionBehavior.transformSwipeAlpha(0.0f);
                }
            } else if (fromPosition == SwipeDirection.CENTER && toPosition == SwipeDirection.CENTER) {
                if (isVerticalScroll) {
                    View view = this.getDragView(SwipeDirection.BOTTOM);
                    if (view != null) {
                        int delta = y > 0 ? view.getMeasuredHeight() - y : -view.getMeasuredHeight() - y;
                        view.setTranslationY((float)delta);
                    }
                } else {
                    IBasicFunctionBehavior basicFunctionBehavior;
                    View view = this.getDragView(SwipeDirection.CENTER);
                    if (view != null) {
                        view.setTranslationX((float)(-x));
                    }
                    if (this.getRoot() != null && (basicFunctionBehavior = this.getBasicFunctionBehavior()) != null) {
                        basicFunctionBehavior.transformSwipeAlpha(percent);
                    }
                }
            }
        }
        if (this.mSwipeListener != null) {
            this.mSwipeListener.onScroll(fromPosition, toPosition, x, y, percent, isVerticalScroll);
        }
    }

    public void onScrollFinish(SwipeDirection fromDirection, SwipeDirection toDirection) {
        MLog.info((Object)"TouchComponent", (String)("liveTemplateActivity.onScrollFinish  fromDirection:" + fromDirection + " toDirection\uff1a" + toDirection), (Object[])new Object[0]);
        if (fromDirection == null) {
            return;
        }
        if (fromDirection != toDirection) {
            if (toDirection == SwipeDirection.TOP || toDirection == SwipeDirection.BOTTOM) {
                if (this.swipeView != null) {
                    this.swipeView.flingToDirection(toDirection, SwipeDirection.CENTER, 0, false);
                }
                MLog.info((Object)"TouchComponent", (String)"onScrollFinish: hide loading view", (Object[])new Object[0]);
                if (this.view != null) {
                    this.view.setVisibility(4);
                }
                this.setAutoSlide(false);
            } else if (toDirection == SwipeDirection.RIGHT) {
                if (this.swipeView != null) {
                    this.swipeView.flingToDirection(toDirection, SwipeDirection.CENTER, 0, false);
                }
            } else if (toDirection == SwipeDirection.LEFT) {
                ((ITouchCore)ICoreManagerBase.getCore(ITouchCore.class)).setClearScreenSate(true);
                RxBus.getDefault().post((Object)new ITouchClearScreen_EventArgs(true));
            } else if (fromDirection == SwipeDirection.LEFT && toDirection == SwipeDirection.CENTER) {
                ((ITouchCore)ICoreManagerBase.getCore(ITouchCore.class)).setClearScreenSate(false);
                RxBus.getDefault().post((Object)new ITouchClearScreen_EventArgs(false));
            }
        } else if (fromDirection == SwipeDirection.CENTER) {
            this.setAutoSlide(false);
        }
        if (this.mSwipeListener != null) {
            this.mSwipeListener.onScrollFinish(fromDirection, toDirection);
        } else {
            MLog.error((Object)"TouchComponent", (String)"mSwipeListener = null", (Object[])new Object[0]);
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.view != null) {
            this.view.setVisibility(4);
        }
        ((ITouchCore)ICoreManagerBase.getCore(ITouchCore.class)).setClearScreenSate(false);
        Object var2_1 = null;
        if (this.mTouchComponentSniperEventBinder != null) {
            this.mTouchComponentSniperEventBinder.unBindEvent();
        }
    }

    protected View getSlideChannelMask() {
        if (!this.checkActivityValid()) {
            return null;
        }
        ViewStub stub = (ViewStub)this.getActivity().findViewById(R.id.viewstud_loading);
        if (stub != null) {
            stub.inflate();
        }
        if (this.view == null) {
            this.view = this.getActivity().findViewById(R.id.view_change_channel_mask);
        }
        return this.view;
    }

    protected View getSlideChannelMask(SwipeDirection direction) {
        this.getSlideChannelMask();
        if (this.view == null) {
            return null;
        }
        ImageView background = (ImageView)this.view.findViewById(R.id.channel_mask_background);
        Drawable drawable2 = null;
        if (direction == SwipeDirection.BOTTOM && this.prevRoomDrawable != null) {
            background.setImageDrawable(this.prevRoomDrawable);
            drawable2 = this.prevRoomDrawable;
            MLog.debug((Object)"pengyangfan", (String)"getSlideChannelMask  BOTTOM", (Object[])new Object[0]);
        } else if (direction == SwipeDirection.TOP && this.nextRoomDrawable != null) {
            background.setImageDrawable(this.nextRoomDrawable);
            drawable2 = this.nextRoomDrawable;
            MLog.debug((Object)"pengyangfan", (String)"getSlideChannelMask  TOP", (Object[])new Object[0]);
        } else {
            background.setImageDrawable(this.getDefaultDrawable());
            drawable2 = this.getDefaultDrawable();
        }
        MLog.debug((Object)"pengyangfan", (String)("drawable = " + drawable2), (Object[])new Object[0]);
        return this.view;
    }

    protected void setLoadingDrawable(Drawable drawable2) {
        AudienceVideoViewFragment audienceVideoViewFragment = (AudienceVideoViewFragment)this.getRoot().findComponent(((SpdtComponent)Spdt.of(SpdtComponent.class)).getAudienceVideoViewFragmentClass());
        if (audienceVideoViewFragment != null) {
            audienceVideoViewFragment.setLoadingDrawable(drawable2);
        }
    }

    private void initSwipeTipLayout() {
        ViewStub viewStub = (ViewStub)this.getActivity().findViewById(R.id.swipe_control_tip);
        if (viewStub != null) {
            viewStub.inflate();
        }
        if (this.mBrightnessView != null) {
            this.mBrightnessView.setTipContainer(this.getActivity().findViewById(R.id.swipe_control_tip_container));
        }
    }

    private void switchMask(SwipeDirection viewDirection, View maskView) {
        if (maskView == null) {
            return;
        }
        View bottomHint = maskView.findViewById(R.id.iv_hint_bottom);
        View topHint = maskView.findViewById(R.id.iv_hint_top);
        if (bottomHint == null || topHint == null) {
            return;
        }
        if (maskView.getVisibility() != 0) {
            maskView.setVisibility(0);
        }
        if (viewDirection == SwipeDirection.TOP && bottomHint.getVisibility() != 0) {
            ImageView imageView = (ImageView)maskView.findViewById(R.id.iv_hint_bottom);
            imageView.setVisibility(0);
            this.startHintAnimation(imageView);
            maskView.findViewById(R.id.iv_hint_bottom_text).setVisibility(0);
            maskView.findViewById(R.id.iv_hint_top).setVisibility(4);
            maskView.findViewById(R.id.iv_hint_top_text).setVisibility(4);
        } else if (viewDirection == SwipeDirection.BOTTOM && topHint.getVisibility() != 0) {
            ImageView imageView = (ImageView)maskView.findViewById(R.id.iv_hint_top);
            imageView.setVisibility(0);
            this.startHintAnimation(imageView);
            maskView.findViewById(R.id.iv_hint_top_text).setVisibility(0);
            maskView.findViewById(R.id.iv_hint_bottom).setVisibility(4);
            maskView.findViewById(R.id.iv_hint_bottom_text).setVisibility(4);
        }
    }

    private void startHintAnimation(ImageView imageView) {
        imageView.setImageResource(R.drawable.anim_ylink_swipe);
        AnimationDrawable animationDrawable = (AnimationDrawable)imageView.getDrawable();
        if (animationDrawable != null && !animationDrawable.isRunning()) {
            animationDrawable.start();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        MLog.info((Object)"TouchComponent", (String)"onConfigurationChanged", (Object[])new Object[0]);
        if (this.swipeView != null) {
            if (newConfig.orientation == 2) {
                this.swipeView.disableDirection(SwipeDirection.BOTTOM);
                this.swipeView.disableDirection(SwipeDirection.TOP);
            } else {
                this.swipeView.enableDirection(SwipeDirection.BOTTOM);
                this.swipeView.enableDirection(SwipeDirection.TOP);
            }
        }
        if (this.view != null) {
            this.view.setVisibility(4);
        }
    }

    public void onOrientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        if (this.mBrightnessView != null) {
            this.mBrightnessView.setEnable(isLandscape);
        }
    }

    public void smoothScrollTo(SwipeDirection fromDirection, SwipeDirection toDirection) {
        if (toDirection != null && fromDirection != null && this.swipeView != null) {
            this.swipeView.flingToDirection(fromDirection, toDirection, 0, true);
        }
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setSwipeListener(SwipeViewDelegate mSwipeListener) {
        this.mSwipeListener = mSwipeListener;
    }

    @BusEvent
    public void onShowScreenElementsView(IBasicFunctionClient_onShowScreenElementsView_EventArgs busEventArgs) {
        this.smoothScrollTo(SwipeDirection.LEFT, SwipeDirection.CENTER);
    }

    @BusEvent
    public void onHideScreenElementsView(IBasicFunctionClient_onHideScreenElementsView_EventArgs busEventArgs) {
        this.smoothScrollTo(SwipeDirection.CENTER, SwipeDirection.LEFT);
    }

    public IBasicFunctionBehavior getBasicFunctionBehavior() {
        if (this.getRoot() == null) {
            return null;
        }
        return (IBasicFunctionBehavior)this.getRoot().findComponent(((SpdtComponent)Spdt.of(SpdtComponent.class)).getBasicFunctionComponentClass());
    }

    public void setSwipeDrawables(String nextUrl, String prevUrl) {
        MLog.info((Object)"TouchComponent", (String)("setSwipeDrawables: nextUrl = " + nextUrl + ", prevUrl = " + prevUrl), (Object[])new Object[0]);
        if (!this.checkActivityValid()) {
            MLog.error((Object)"TouchComponent", (String)"setSwipeDrawables activity not valid", (Object[])new Object[0]);
            return;
        }
        if (nextUrl.isEmpty()) {
            this.nextRoomDrawable = null;
            this.mSwipeSurfaceView.nextBackground(null);
        } else {
            this.initWH();
            ((RequestBuilder)Glide.with((Fragment)this).load(nextUrl).override(this.windowWidth / 5, this.windowHeight / 5)).apply(((RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().dontAnimate()).placeholder(R.drawable.live_room_loading_bg)).format(DecodeFormat.PREFER_RGB_565)).transform((Transformation)new BlurTransformation(10))).into((Target)new SimpleTarget<Drawable>(){

                public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                    TouchComponent.this.nextRoomDrawable = resource;
                    TouchComponent.this.mSwipeSurfaceView.nextBackground(((BitmapDrawable)TouchComponent.this.nextRoomDrawable).getBitmap());
                }
            });
        }
        if (prevUrl.isEmpty()) {
            this.prevRoomDrawable = null;
            this.mSwipeSurfaceView.prevBackground(null);
            return;
        }
        this.initWH();
        ((RequestBuilder)Glide.with((Fragment)this).load(prevUrl).override(this.windowWidth / 5, this.windowHeight / 5)).apply(((RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().dontAnimate()).placeholder(R.drawable.live_room_loading_bg)).format(DecodeFormat.PREFER_RGB_565)).transform((Transformation)new BlurTransformation(10))).into((Target)new SimpleTarget<Drawable>(){

            public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                TouchComponent.this.prevRoomDrawable = resource;
                TouchComponent.this.mSwipeSurfaceView.prevBackground(((BitmapDrawable)TouchComponent.this.prevRoomDrawable).getBitmap());
            }
        });
        MLog.debug((Object)"pengyangfan", (String)("prevD = " + this.prevRoomDrawable + ", nextD =" + this.nextRoomDrawable), (Object[])new Object[0]);
    }

    private void initWH() {
        if (this.windowHeight == 0 || this.windowWidth == 0) {
            this.windowHeight = ScreenUtils.getScreenHeight();
            this.windowWidth = ScreenUtils.getScreenWidth();
            MLog.info((Object)"TouchComponent", (String)("width = " + this.windowWidth + "height = " + this.windowHeight), (Object[])new Object[0]);
        }
    }

    public SwipeViewDelegate getSwipeListener() {
        return this.mSwipeListener;
    }

    protected void setAutoSlide(boolean autoSlide) {
        this.autoSlide = autoSlide;
    }

    protected boolean getAutoSlide() {
        return this.autoSlide;
    }

    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mTouchComponentSniperEventBinder == null) {
            this.mTouchComponentSniperEventBinder = new TouchComponent$$EventBinder();
        }
        this.mTouchComponentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }
}

