/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.touch;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.media.AudioManager;
import android.provider.Settings;
import android.view.WindowManager;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.events.IBasicFunctionClient_onSetScreenBrightness_EventArgs;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.statistic.IHiidoStatisticCore;

public class BrightnessAndVolumnSetter {

    public static class BrightnessSetter {
        private Activity mActivity;
        private float mCurrent = -1.0f;
        private float mStart = -1.0f;
        private float mStartCoordinate = -1.0f;

        public BrightnessSetter(Activity activity) {
            this.mActivity = activity;
            WindowManager.LayoutParams window = this.mActivity.getWindow().getAttributes();
            if (window.screenBrightness == -1.0f) {
                int currLight = Settings.System.getInt((ContentResolver)this.mActivity.getContentResolver(), (String)"screen_brightness", (int)255);
                window.screenBrightness = (float)currLight / 255.0f;
            }
        }

        private static float getScreenBrightness(Activity activity) {
            WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
            return lp.screenBrightness;
        }

        private static void setBrightness(Activity activity, int brightness) {
            BrightnessSetter.setBrightness(activity, (float)brightness * 0.003921569f);
        }

        private static void setBrightness(Activity activity, float brightness) {
            WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
            lp.screenBrightness = brightness;
            activity.getWindow().setAttributes(lp);
        }

        public float changeBrightness(float startPos, float value) {
            if (this.mStartCoordinate != startPos) {
                this.mStart = this.mCurrent = BrightnessSetter.getScreenBrightness(this.mActivity);
                this.mStartCoordinate = startPos;
                this.sendStatistic();
            }
            if (this.mCurrent == 1.0f && value >= 0.0f || this.mCurrent == 0.0f && value <= 0.0f) {
                return this.mCurrent;
            }
            this.mCurrent = this.mStart + value;
            if (this.mCurrent < 0.0f) {
                this.mCurrent = 0.0f;
            }
            if (this.mCurrent > 1.0f) {
                this.mCurrent = 1.0f;
            }
            BrightnessSetter.setBrightness(this.mActivity, this.mCurrent);
            RxBus.getDefault().post((Object)new IBasicFunctionClient_onSetScreenBrightness_EventArgs((int)(this.mCurrent * 255.0f)));
            return this.mCurrent;
        }

        private void sendStatistic() {
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51001", "0066");
        }
    }

    public static class VolumeSetter {
        private final int fMax;
        private Context mContext;
        private AudioManager mAudioManager = null;
        private float mCurrent = -1.0f;
        private float mStart = -1.0f;
        private float mStartCoordinate = -1.0f;

        public VolumeSetter(Context context) {
            this.mContext = context;
            this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
            this.fMax = this.mAudioManager.getStreamMaxVolume(3);
        }

        public float changeVolume(float startPos, float value) {
            if (this.mStartCoordinate != startPos) {
                this.mStart = this.mCurrent = (float)this.mAudioManager.getStreamVolume(3) / (float)this.fMax;
                this.mStartCoordinate = startPos;
                this.sendStatistic();
            }
            if (this.mCurrent == 1.0f && value >= 0.0f || this.mCurrent == 0.0f && value <= 0.0f) {
                return this.mCurrent;
            }
            this.mCurrent = this.mStart + value;
            if (this.mCurrent < 0.0f) {
                this.mCurrent = 0.0f;
            }
            if (this.mCurrent > 1.0f) {
                this.mCurrent = 1.0f;
            }
            this.mAudioManager.setStreamVolume(3, (int)(this.mCurrent * (float)this.fMax), 0);
            return this.mCurrent;
        }

        private void sendStatistic() {
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51001", "0067");
        }
    }
}

