/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.swivelChair;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;

public class SCLoadingView
extends View {
    private int width;
    private int height;
    private int widthRect;
    private int heigheRect;
    private Paint rectPaint;
    private int pos = 0;
    private Rect rect;
    private String[] color = new String[]{"#bbbbbb", "#aaaaaa", "#999999", "#888888", "#777777", "#666666"};

    public SCLoadingView(Context context) {
        this(context, null);
    }

    public SCLoadingView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SCLoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.rectPaint = new Paint(1);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (widthMode == Integer.MIN_VALUE || heightMode == Integer.MIN_VALUE) {
            this.width = 100;
        } else {
            this.width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            this.height = View.MeasureSpec.getSize((int)heightMeasureSpec);
            this.width = Math.min(this.width, this.height);
        }
        this.widthRect = this.width / 12;
        this.heigheRect = 4 * this.widthRect;
        this.setMeasuredDimension(this.width, this.width);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.rect == null) {
            this.rect = new Rect((this.width - this.widthRect) / 2, 0, (this.width + this.widthRect) / 2, this.heigheRect);
        }
        for (int i = 0; i < 12; ++i) {
            if (i - this.pos >= 5) {
                this.rectPaint.setColor(Color.parseColor((String)this.color[5]));
            } else if (i - this.pos >= 0 && i - this.pos < 5) {
                this.rectPaint.setColor(Color.parseColor((String)this.color[i - this.pos]));
            } else if (i - this.pos >= -7 && i - this.pos < 0) {
                this.rectPaint.setColor(Color.parseColor((String)this.color[5]));
            } else if (i - this.pos >= -11 && i - this.pos < -7) {
                this.rectPaint.setColor(Color.parseColor((String)this.color[12 + i - this.pos]));
            }
            canvas.drawRect(this.rect, this.rectPaint);
            canvas.rotate(30.0f, (float)(this.width / 2), (float)(this.width / 2));
        }
        ++this.pos;
        if (this.pos > 11) {
            this.pos = 0;
        }
        this.postInvalidateDelayed(100L);
    }
}

