/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.startask;

import android.content.Context;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.startask.TaskStrongEffectView;
import com.yy.mobile.ui.startask.TaskWeakEffectView;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;

public class TaskEffectController {
    private TaskWeakEffectView taskWeakEffectView;
    private TaskStrongEffectView taskStrongEffectView;
    private Context context;
    private RelativeLayout layout;
    private boolean inChannel = false;
    private int strongEffectPosY;
    private int strongEffectPosX;
    public boolean isPlaying = false;
    private ITaskViewClickedListener taskViewClickedListener;
    private ITaskAnimationListener taskAnimationListener;
    private ITaskStrongEffectListener taskStrongEffectListener = new ITaskStrongEffectListener(){

        @Override
        public void animtionOnStop() {
            TaskEffectController.this.playWeakEffect(false);
        }
    };
    private ITaskControllerPlayState taskControllerPlayStateListener = new ITaskControllerPlayState(){

        @Override
        public void playState(boolean state) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"TaskEffectController", (String)("wwd Task effect playing state = " + state), (Object[])new Object[0]);
            }
            TaskEffectController.this.isPlaying = state;
        }
    };

    public TaskEffectController(Context context, RelativeLayout layout2, boolean inChannel, ITaskViewClickedListener listener2) {
        this.context = context;
        this.layout = layout2;
        this.inChannel = inChannel;
        if (listener2 != null) {
            this.taskViewClickedListener = listener2;
        }
    }

    public void initUseByInChannel() {
        this.setStrongEffect(-1, -1);
    }

    private void setStrongEffect(int posX, int posY) {
        if (this.strongEffectPosX != posX || this.strongEffectPosY != posY) {
            this.strongEffectPosX = posX;
            this.strongEffectPosY = posY;
            if (this.taskStrongEffectView == null) {
                this.taskStrongEffectView = new TaskStrongEffectView(this.context);
                this.taskStrongEffectView.setEffectListenerWeakRef(this.taskStrongEffectListener);
                if (this.taskViewClickedListener != null) {
                    this.taskStrongEffectView.setTaskViewClickedWeakRef(this.taskViewClickedListener);
                }
                this.taskStrongEffectView.setPlayStateWeakReference(this.taskControllerPlayStateListener);
                this.taskStrongEffectView.setInChannel(this.inChannel);
            }
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams((int)ResolutionUtils.convertDpToPixel((float)320.0f, (Context)BasicConfig.getInstance().getAppContext()), -2);
            layoutParams.addRule(12);
            if (!this.inChannel) {
                layoutParams.addRule(14);
            } else {
                layoutParams.addRule(9);
            }
            layoutParams.bottomMargin = (int)ResolutionUtils.convertDpToPixel((float)posY, (Context)BasicConfig.getInstance().getAppContext());
            layoutParams.leftMargin = (int)ResolutionUtils.convertDpToPixel((float)posX, (Context)BasicConfig.getInstance().getAppContext());
            if (this.layout.indexOfChild(this.taskStrongEffectView.getTaskLayoutView()) != -1) {
                this.taskStrongEffectView.getTaskLayoutView().setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            } else if (this.inChannel && null != this.layout.findViewById(R.id.trl_gift_panel)) {
                this.layout.addView(this.taskStrongEffectView.getTaskLayoutView(), this.layout.indexOfChild(this.layout.findViewById(R.id.trl_gift_panel)), (ViewGroup.LayoutParams)layoutParams);
            } else {
                this.layout.addView(this.taskStrongEffectView.getTaskLayoutView(), (ViewGroup.LayoutParams)layoutParams);
            }
        }
    }

    private void setWeakEffect(int posX, int posY, ITaskAnimationListener taskAnimationListener) {
        if (this.taskWeakEffectView == null) {
            this.taskWeakEffectView = !this.inChannel ? new TaskWeakEffectView(this.context, 11, posX, posY) : new TaskWeakEffectView(this.context, posX, posY);
            this.taskWeakEffectView.setPlayStateWeakReference(this.taskControllerPlayStateListener);
        } else if (this.taskWeakEffectView.getPosX() != posX || this.taskWeakEffectView.getPosY() != posY) {
            this.taskWeakEffectView.setPos(posX, posY);
        } else {
            return;
        }
        if (taskAnimationListener != null && this.taskWeakEffectView.isNullAnimationListenerWeakRef()) {
            this.taskWeakEffectView.setAnimationListenerWeakRef(taskAnimationListener);
        }
        RelativeLayout.LayoutParams weakLayoutParams = this.taskWeakEffectView.getWeakEffectLayoutParmas();
        if (this.layout.indexOfChild(this.taskWeakEffectView.getWeakEffectView()) != -1) {
            this.taskWeakEffectView.getWeakEffectView().setLayoutParams((ViewGroup.LayoutParams)weakLayoutParams);
        } else if (this.inChannel && null != this.layout.findViewById(R.id.trl_gift_panel)) {
            this.layout.addView(this.taskWeakEffectView.getWeakEffectView(), this.layout.indexOfChild(this.layout.findViewById(R.id.trl_gift_panel)), (ViewGroup.LayoutParams)weakLayoutParams);
        } else {
            this.layout.addView(this.taskWeakEffectView.getWeakEffectView(), (ViewGroup.LayoutParams)weakLayoutParams);
        }
    }

    private void playStrongEffect(int offsetX, int offsetY) {
        if (this.taskStrongEffectView != null) {
            this.taskStrongEffectView.setTaskLayoutInfo(this.strongEffectPosY, this.strongEffectPosX);
            this.taskStrongEffectView.startTaskAnimation(offsetX, offsetY);
        }
    }

    public void playWeakEffect(boolean isWeak) {
        if (this.taskWeakEffectView != null) {
            this.taskWeakEffectView.startTaskAnimation(isWeak);
        }
    }

    public void setInfoMessage(String title, String message, String reward) {
        if (this.taskStrongEffectView != null) {
            this.taskStrongEffectView.setLayoutTxtInfo(title, message, reward);
        }
    }

    public void playAnimation(int left, int bottom, int targetX, int targetY, int posX, int posY, ITaskAnimationListener taskAnimationListener) {
        MLog.info((Object)"TaskEffectController", (String)"wwd taskEffectController playAnimation Strong", (Object[])new Object[0]);
        this.setStrongEffect(left, bottom);
        this.isPlaying = true;
        this.playStrongEffect(targetX, targetY);
        this.taskAnimationListener = taskAnimationListener;
        this.setWeakEffect(posX, posY, this.taskAnimationListener);
    }

    public void playWeakAnimation(int posX, int posY, ITaskAnimationListener taskAnimationListener) {
        MLog.info((Object)"TaskEffectController", (String)"wwd taskEffectController playAnimation Weak", (Object[])new Object[0]);
        this.taskAnimationListener = taskAnimationListener;
        this.setWeakEffect(posX, posY, this.taskAnimationListener);
        this.isPlaying = true;
        this.playWeakEffect(true);
    }

    public void removeAllListener() {
        if (this.taskAnimationListener != null) {
            this.taskAnimationListener = null;
        }
        if (this.taskStrongEffectListener != null) {
            this.taskStrongEffectListener = null;
        }
        if (this.taskViewClickedListener != null) {
            this.taskViewClickedListener = null;
        }
        if (this.taskControllerPlayStateListener != null) {
            this.taskControllerPlayStateListener = null;
        }
    }

    public void stopAnimation() {
        this.isPlaying = false;
        if (this.taskStrongEffectView != null && this.taskStrongEffectView.isPlaying()) {
            this.taskStrongEffectView.stopTaskAnimation();
        }
        if (this.taskWeakEffectView != null && this.taskWeakEffectView.isPlaying()) {
            this.taskWeakEffectView.stopTaskAnimation();
        }
    }

    public void clickMoreButtonPlayAnimation() {
        if (this.taskStrongEffectView != null && this.taskStrongEffectView.isPlaying()) {
            this.taskStrongEffectView.clickMoreButtonPlayAnimation();
        }
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public static interface ITaskControllerPlayState {
        public void playState(boolean var1);
    }

    public static interface ITaskViewClickedListener {
        public void clicked();
    }

    public static interface ITaskAnimationListener {
        public void animationEnd();
    }

    public static interface ITaskStrongEffectListener {
        public void animtionOnStop();
    }
}

