/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.richtop.ui;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.richtop.core.RichTopLiveGiftInfo;
import com.yy.mobile.ui.richtop.ui.RichTopGiftRecordComponent;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.widget.ViewHolderAdapterCompatV2;
import com.yy.mobile.util.CommonUtils;
import com.yymobile.core.gift.GiftConfigItemBase;
import com.yymobile.core.gift.GiftConfigParser;
import java.util.Date;
import java.util.List;

public class RichTopGiftRecordAdapter
extends ViewHolderAdapterCompatV2<Object> {
    private Context mContext;
    private int iconSize = 20;

    public RichTopGiftRecordAdapter(List<Object> list2) {
        super(list2);
    }

    public RichTopGiftRecordAdapter(List<Object> list2, Context context) {
        this(list2);
        this.mContext = context;
        this.iconSize = DensityUtil.dip2px((Context)this.mContext, (float)20.0f);
    }

    public int getItemViewType(int position) {
        if (this.getItem(position) instanceof RichTopLiveGiftInfo) {
            return 0;
        }
        if (this.getItem(position) instanceof RichTopGiftRecordComponent.DividerEntity) {
            return 2;
        }
        return 1;
    }

    public int getViewTypeCount() {
        return 3;
    }

    public View onCreateView(ViewGroup viewGroup, int position) {
        if (this.getItemViewType(position) == 0) {
            return LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_richtop_gift_record_item, viewGroup, false);
        }
        return LayoutInflater.from((Context)this.mContext).inflate(R.layout.divider, viewGroup, false);
    }

    public void onBindView(ViewHolderAdapterCompatV2.ViewHolder viewHolder, int position) {
        if (viewHolder.getViewType() == 0) {
            RichTopLiveGiftInfo giftInfo = (RichTopLiveGiftInfo)this.getItem(position);
            TextView nickname = (TextView)viewHolder.get(R.id.tv_nickname);
            RecycleImageView giftIcon = (RecycleImageView)viewHolder.get(R.id.iv_gift_icon);
            TextView giftNumber = (TextView)viewHolder.get(R.id.tv_gift_number);
            TextView time = (TextView)viewHolder.get(R.id.tv_time);
            if (giftInfo != null) {
                time.setText((CharSequence)this.timeToFormat(giftInfo.timeSpan * 1000L));
                nickname.setText((CharSequence)(giftInfo.nick != null ? giftInfo.nick : ""));
                GiftConfigItemBase configItemBase = GiftConfigParser.getInstance().getGiftConfigItemByType(giftInfo.giftId);
                if (configItemBase != null) {
                    ImageLoader.loadImage((String)configItemBase.iconPath, (RecycleImageView)giftIcon, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.lr_ic_default_gift);
                }
                giftNumber.setText((CharSequence)this.mContext.getString(R.string.channel_contribution_send_gift_number, new Object[]{giftInfo.giftNumber}));
            }
        }
    }

    private String timeToFormat(long time) {
        if (time > 0L) {
            return CommonUtils.getSimpleDateFormat((String)"HH:mm:ss").format(new Date(time));
        }
        return "";
    }
}

