/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.publicchat.model.medal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.ui.publicchat.model.medal.BasePublicChatMedalModel;
import com.yy.mobile.ui.publicchat.model.medal.utils.MedalMarginUtils;
import com.yy.mobile.ui.truelove.TreasureMedal;
import com.yy.mobile.ui.utils.CheckIndexUtils;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.medal.MedalBaseEntry;
import com.yymobile.core.medal.MedalTrueLoveEntry;

public class TrueLoveSpannableModel
extends BasePublicChatMedalModel {
    @SuppressLint(value={"ImageLoader"})
    public SpannableStringBuilder getSpannable(final ChannelMessage message, Spannable spannable, MedalBaseEntry entity) {
        this.checkIconVisible(message);
        MedalTrueLoveEntry mEntity = (MedalTrueLoveEntry)entity;
        SpannableStringBuilder stringBuilder = (SpannableStringBuilder)spannable;
        String text = stringBuilder.toString();
        int startIdx = stringBuilder.toString().indexOf(mEntity.getNote());
        int endIdx = startIdx + mEntity.getNote().length();
        if (startIdx > -1) {
            if (this.isIcnShow) {
                Drawable medalDrawable;
                int trueloveLv = 0;
                int fansLv = 0;
                final String trueloveBgUrl = mEntity.treasureBgUrlV2MO;
                if (mEntity.isCBA) {
                    trueloveLv = mEntity.trueLoveLevel;
                    medalDrawable = TreasureMedal.instance().getSpecialMedalDrawable(trueloveLv, mEntity.treasureGroupMedalName, this.mContext);
                } else {
                    if (!StringUtils.isEmpty((String)mEntity.treasureGroupLevelV2).booleanValue()) {
                        trueloveLv = Integer.valueOf(mEntity.treasureGroupLevelV2);
                    }
                    if (!StringUtils.isEmpty((String)mEntity.treasureFansLevelV2).booleanValue()) {
                        fansLv = Integer.valueOf(mEntity.treasureFansLevelV2);
                    }
                    ImageConfig config = new ImageConfig((int)ResolutionUtils.convertDpToPixel((float)47.0f, (Context)this.mContext), (int)ResolutionUtils.convertDpToPixel((float)15.0f, (Context)this.mContext));
                    BitmapDrawable cacheMedalDrawable = ImageLoader.getBitmapFromCache((String)(trueloveBgUrl + "fans"), (ImageConfig)config);
                    if (cacheMedalDrawable == null) {
                        if (this.tureLoveModelIsCurrentUser(message.uid)) {
                            MLog.info((Object)"TrueLoveSpannableModel", (String)"cacheMedalDrawable = null need load from net!", (Object[])new Object[0]);
                        }
                        Drawable background = TreasureMedal.instance().getTrueloveLvBg(trueloveLv, this.mContext);
                        Drawable foreground = TreasureMedal.instance().getTrueloveFanslvImg(fansLv, this.mContext);
                        medalDrawable = TreasureMedal.instance().getTrueloveBg(background, foreground, mEntity.treasureGroupMedalName, this.mContext);
                        ImageLoader.loadBitmap((Context)BasicConfig.getInstance().getAppContext(), (String)trueloveBgUrl, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                            public void onLoadFailed(Exception e) {
                            }

                            public void onResourceReady(Bitmap bitmap) {
                                if (bitmap != null) {
                                    ImageConfig config = new ImageConfig((int)ResolutionUtils.convertDpToPixel((float)47.0f, (Context)TrueLoveSpannableModel.this.mContext), (int)ResolutionUtils.convertDpToPixel((float)15.0f, (Context)TrueLoveSpannableModel.this.mContext));
                                    BitmapDrawable bitmapDrawable = new BitmapDrawable(BasicConfig.getInstance().getAppContext().getResources(), TreasureMedal.instance().getResizedBitmap(bitmap, (int)ResolutionUtils.convertDpToPixel((float)47.0f, (Context)TrueLoveSpannableModel.this.mContext), (int)ResolutionUtils.convertDpToPixel((float)15.0f, (Context)TrueLoveSpannableModel.this.mContext)));
                                    ImageLoader.addBitmapToCache((String)(trueloveBgUrl + "fans"), (BitmapDrawable)bitmapDrawable, (ImageConfig)config);
                                    if (TrueLoveSpannableModel.this.tureLoveModelIsCurrentUser(message.uid)) {
                                        MLog.info((Object)"TrueLoveSpannableModel", (String)"user trueloveMedal load from net is onResourceReady!", (Object[])new Object[0]);
                                    }
                                }
                            }
                        });
                    } else {
                        Drawable foreground = TreasureMedal.instance().getTrueloveFanslvImg(fansLv, this.mContext);
                        medalDrawable = TreasureMedal.instance().getTrueloveBg((Drawable)cacheMedalDrawable, foreground, mEntity.treasureGroupMedalName, this.mContext);
                    }
                }
                if (medalDrawable != null && CheckIndexUtils.isSafeRange(startIdx, endIdx, stringBuilder.length())) {
                    int marginLeft = MedalMarginUtils.getMedalMarginLeft(text, startIdx);
                    int marginRight = MedalMarginUtils.getMedalMarginRight(text, endIdx);
                    medalDrawable.setBounds(0, 0, medalDrawable.getIntrinsicWidth(), medalDrawable.getIntrinsicHeight());
                    stringBuilder.setSpan((Object)new CustomImageSpan(medalDrawable, 2, ResolutionUtils.convertDpToPixel((float)marginLeft, (Context)this.mContext), ResolutionUtils.convertDpToPixel((float)marginRight, (Context)this.mContext)), startIdx, endIdx, 33);
                    if (this.tureLoveModelIsCurrentUser(message.uid)) {
                        MLog.info((Object)"TrueLoveSpannableModel", (String)"user trueloveMedal Spannable is Created!", (Object[])new Object[0]);
                    }
                } else {
                    if (this.tureLoveModelIsCurrentUser(message.uid)) {
                        MLog.info((Object)"TrueLoveSpannableModel", (String)"user trueloveMedal is Replace because of medalDrawable = null or CheckIndexUtils.isSafeRange is false", (Object[])new Object[0]);
                    }
                    if (endIdx <= stringBuilder.length()) {
                        stringBuilder.replace(startIdx, endIdx, (CharSequence)"");
                        message.medals.replace(startIdx, endIdx, "");
                    }
                    message.text = message.text.replace(mEntity.getNote(), "");
                }
            }
        } else if (this.tureLoveModelIsCurrentUser(message.uid)) {
            MLog.info((Object)"TrueLoveSpannableModel", (String)"user trueloveMedal is Replace because of not found truelove medal Tag", (Object[])new Object[0]);
        }
        return stringBuilder;
    }

    public boolean tureLoveModelIsCurrentUser(long uid) {
        boolean isRet = false;
        if (LoginUtil.isLogined() && LoginUtil.getUid() == uid) {
            isRet = true;
        }
        return isRet;
    }
}

