/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.publicchat.model.medal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.actmedal.core.IActMedalCore;
import com.yy.mobile.ui.publicchat.model.medal.BasePublicChatMedalModel;
import com.yy.mobile.ui.publicchat.model.medal.listener.IChatCacheUpdateListener;
import com.yy.mobile.ui.utils.CheckIndexUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.cavalier.ITaskCore;
import com.yymobile.core.cavalier.TaskCoreProxy;
import com.yymobile.core.cavalier.TaskProtocol;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.medal.MedalBaseEntry;
import com.yymobile.core.medal.MedalTailEntry;

public class TailLightSpannableModel
extends BasePublicChatMedalModel {
    public IChatCacheUpdateListener mIChatCacheUpdateListener;
    public int height = ((IActMedalCore)ICoreManagerBase.getCore(IActMedalCore.class)).getMedalHeight(BasicConfig.getInstance().getAppContext());
    public int width = ((IActMedalCore)ICoreManagerBase.getCore(IActMedalCore.class)).getMedalWidth(BasicConfig.getInstance().getAppContext());

    @Override
    public void setIChatCacheUpdateListener(IChatCacheUpdateListener listener2) {
        this.mIChatCacheUpdateListener = listener2;
    }

    public SpannableStringBuilder getSpannable(ChannelMessage message, Spannable spannable, MedalBaseEntry entity) {
        this.checkIconVisible(message);
        MedalTailEntry mEntity = (MedalTailEntry)entity;
        SpannableStringBuilder stringBuilder = (SpannableStringBuilder)spannable;
        int startIdx = stringBuilder.toString().indexOf(mEntity.getNote());
        int endIdx = startIdx + mEntity.getNote().length();
        if (startIdx > -1) {
            if (this.isIcnShow && CheckIndexUtils.isSafeRange(startIdx, endIdx, spannable.length())) {
                int medalWallMedalId = mEntity.getUserMedalWallMaxPriorityId();
                String url = ((ITaskCore)ICoreManagerBase.getCore(ITaskCore.class)).getTailLightIdUrl(medalWallMedalId, TaskProtocol.MEDAL_TYPE.MOB_TAILLIGHT);
                if (!TextUtils.isEmpty((CharSequence)url)) {
                    stringBuilder = this.parseMedalWallMedal(this.mContext, message, stringBuilder, url);
                } else {
                    stringBuilder.replace(startIdx, endIdx, (CharSequence)"");
                }
            } else {
                stringBuilder.replace(startIdx, endIdx, (CharSequence)"");
            }
        }
        return stringBuilder;
    }

    @SuppressLint(value={"ImageLoader"})
    private SpannableStringBuilder parseMedalWallMedal(final Context context, final ChannelMessage message, final SpannableStringBuilder spannable, final String url) {
        if (!FP.empty((CharSequence)url)) {
            SpannableStringBuilder sp;
            BitmapDrawable drawable2 = ImageLoader.getBitmapFromCache((String)url, (ImageConfig)ImageConfig.smallImageConfig());
            if (drawable2 == null) {
                sp = TaskCoreProxy.newInstance().getMedalMessage(context, message, spannable, R.drawable.xunzhang_default_bitmap, 1, 1, url);
                ImageLoader.loadBitmap((Context)BasicConfig.getInstance().getAppContext(), (String)url, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                    public void onLoadFailed(Exception e) {
                    }

                    public void onResourceReady(Bitmap bitmap) {
                        if (bitmap != null) {
                            BitmapDrawable bitmapDrawable = new BitmapDrawable(BasicConfig.getInstance().getAppContext().getResources(), bitmap);
                            ImageLoader.addBitmapToCache((String)url, (BitmapDrawable)bitmapDrawable, (ImageConfig)ImageConfig.smallImageConfig());
                            if (context != null) {
                                try {
                                    message.spannable = TaskCoreProxy.newInstance().getMedalMessage(context, message, spannable, R.drawable.xunzhang_default_bitmap, TailLightSpannableModel.this.width, TailLightSpannableModel.this.height, url);
                                    if (TailLightSpannableModel.this.mIChatCacheUpdateListener != null) {
                                        TailLightSpannableModel.this.mIChatCacheUpdateListener.onUpdateCallback();
                                    }
                                }
                                catch (Throwable throwable) {
                                    MLog.error((Object)"TailLightSpannableModel", (Throwable)throwable);
                                    MLog.error((Object)"TailLightSpannableModel", (String)spannable.toString(), (Object[])new Object[0]);
                                }
                            }
                        }
                    }
                });
            } else {
                sp = TaskCoreProxy.newInstance().getMedalMessage(context, message, spannable, R.drawable.xunzhang_default_bitmap, this.width, this.height, url);
            }
            return sp;
        }
        return spannable;
    }
}

