/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.publicchat.model.medal;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Looper;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public enum LiveRoomLoadDrawableWrapper {
    INSTANCE;

    private boolean mNeedWrapper = Build.BRAND.contains("vivo") && Build.VERSION.SDK_INT == 25;
    public Map<Integer, Drawable> mCachedDrawableMap = new ConcurrentHashMap<Integer, Drawable>();
    public WeakReference<Drawable> mCachedFixSizeDrawable = null;
    private String mTag = "";

    public void init(@NotNull String tag) {
        this.mTag = tag;
    }

    public void uninit(@NotNull String tag) {
        if (tag.equalsIgnoreCase(this.mTag)) {
            MLog.info((Object)"LiveRoomLoadDrawableWrapper", (String)"clear map", (Object[])new Object[0]);
            this.mCachedDrawableMap.clear();
        }
    }

    public boolean isMustChangeToUiThread() {
        return this.mNeedWrapper && Looper.myLooper() != Looper.getMainLooper();
    }

    public Drawable getDrawableWithCache(Context context, final int res) {
        if (null == context || res == 0) {
            return null;
        }
        if (this.isMustChangeToUiThread()) {
            if (this.mCachedDrawableMap.containsKey(res)) {
                MLog.debug((Object)"LiveRoomLoadDrawableWrapper", (String)"get res from cache map", (Object[])new Object[0]);
                return this.mCachedDrawableMap.get(res);
            }
            this.getDrawableInMainThread(context, res).blockingSubscribe((Consumer)new Consumer<Drawable>(){

                public void accept(Drawable drawable2) {
                    MLog.info((Object)"LiveRoomLoadDrawableWrapper", (String)"get drawable from uiThread", (Object[])new Object[0]);
                    LiveRoomLoadDrawableWrapper.this.mCachedDrawableMap.put(res, drawable2);
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) {
                    MLog.warn((Object)"LiveRoomLoadDrawableWrapper", (String)"get null drawable from uiThread ", (Object[])new Object[0]);
                }
            });
            return this.mCachedDrawableMap.get(res);
        }
        return context.getResources().getDrawable(res);
    }

    public Flowable<Drawable> getDrawableInMainThread(final Context context, final int res) {
        return Single.create((SingleOnSubscribe)new SingleOnSubscribe<Drawable>(){

            public void subscribe(SingleEmitter<Drawable> emitter) {
                Drawable drawable2 = context.getResources().getDrawable(res);
                MLog.info((Object)"LiveRoomLoadDrawableWrapper", (String)"get resource change to main thread res = %d", (Object[])new Object[]{res});
                if (drawable2 != null) {
                    emitter.onSuccess((Object)drawable2);
                } else {
                    emitter.onError((Throwable)new Exception("get drawable return null"));
                }
            }
        }).toFlowable().subscribeOn(AndroidSchedulers.mainThread());
    }

    public Drawable getFixedSizeNobleImageSafely(final int reSource, final int w, final int h, final Context context) {
        if (INSTANCE.isMustChangeToUiThread()) {
            Single.create((SingleOnSubscribe)new SingleOnSubscribe<Drawable>(){

                public void subscribe(SingleEmitter<Drawable> emitter) {
                    MLog.info((Object)"LiveRoomLoadDrawableWrapper", (String)"get resource change to main thread res = %d", (Object[])new Object[]{reSource});
                    Drawable drawable2 = LiveRoomLoadDrawableWrapper.this.getFixedSizedNobleImage(reSource, w, h, context);
                    if (drawable2 != null) {
                        emitter.onSuccess((Object)drawable2);
                    } else {
                        emitter.onError((Throwable)new Exception("get drawable return null"));
                    }
                }
            }).toFlowable().subscribeOn(AndroidSchedulers.mainThread()).blockingSubscribe((Consumer)new Consumer<Drawable>(){

                public void accept(Drawable drawable2) {
                    if (LiveRoomLoadDrawableWrapper.this.mCachedFixSizeDrawable != null) {
                        LiveRoomLoadDrawableWrapper.this.mCachedFixSizeDrawable.clear();
                    }
                    LiveRoomLoadDrawableWrapper.this.mCachedFixSizeDrawable = new WeakReference<Drawable>(drawable2);
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) {
                    if (LiveRoomLoadDrawableWrapper.this.mCachedFixSizeDrawable != null) {
                        LiveRoomLoadDrawableWrapper.this.mCachedFixSizeDrawable.clear();
                        LiveRoomLoadDrawableWrapper.this.mCachedFixSizeDrawable = null;
                    }
                    MLog.warn((Object)"LiveRoomLoadDrawableWrapper", (String)"get null drawable from uiThread ", (Object[])new Object[0]);
                }
            });
            if (this.mCachedFixSizeDrawable != null) {
                MLog.info((Object)"LiveRoomLoadDrawableWrapper", (String)"return drawable", (Object[])new Object[0]);
                return (Drawable)this.mCachedFixSizeDrawable.get();
            }
            MLog.info((Object)"LiveRoomLoadDrawableWrapper", (String)"return null", (Object[])new Object[0]);
            return null;
        }
        return this.getFixedSizedNobleImage(reSource, w, h, context);
    }

    public Drawable getFixedSizedNobleImage(int reSource, int w, int h, Context context) {
        BitmapDrawable baseImage = ImageLoader.getBitmapDrawableFromResource((int)reSource, (ImageConfig)ImageConfig.fullImageConfig());
        BitmapDrawable reSize = null;
        int tw = (int)ResolutionUtils.convertDpToPixel((float)w, (Context)context);
        int th = (int)ResolutionUtils.convertDpToPixel((float)h, (Context)context);
        if (baseImage != null && baseImage.getBitmap() != null) {
            reSize = ImageLoader.getBitmapFromCache((String)(reSource + "" + tw + th));
            if (reSize == null) {
                Bitmap bitmap = baseImage.getBitmap();
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)tw, (int)th, (boolean)true);
                reSize = new BitmapDrawable(context.getResources(), bitmap);
                ImageLoader.addBitmapToCache((String)(reSource + "" + tw + th), (BitmapDrawable)reSize);
            }
            reSize.setBounds(0, 0, reSize.getIntrinsicWidth(), reSize.getIntrinsicHeight());
        }
        return reSize != null ? reSize : baseImage;
    }
}

