/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.publicchat;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.ent.mobile.memeda.domain.mobile.pb.nano.PersonalInfoCardPro;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onAppendChannelMsg_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_updateCurrentChannelMessage_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.publicchat.NickClickableSpan;
import com.yy.mobile.ui.publicchat.PublicChatEventReceiver$$EventBinder;
import com.yy.mobile.ui.publicchat.handler.ParserUtil;
import com.yy.mobile.ui.publicchat.model.event.AppendChannelMessageEvent;
import com.yy.mobile.ui.utils.DimensUtils;
import com.yy.mobile.ui.utils.StringUtil;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCoreEx;
import com.yymobile.core.basechannel.SessOnText;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.NoticeMessage;
import com.yymobile.core.channel.PublicChatMessage;
import com.yymobile.core.mobilelive.IMobileLiveCore;

public final class PublicChatEventReceiver
implements EventCompat {
    public int mChatFilterType = 1;
    public int mHistoryType = 0;
    private static volatile PublicChatEventReceiver sInstance;
    private Context mContext = BasicConfig.getInstance().getAppContext();
    private String hostActivityName;
    private EventBinder mPublicChatEventReceiverSniperEventBinder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PublicChatEventReceiver instance() {
        if (sInstance != null) return sInstance;
        Class<PublicChatEventReceiver> clazz = PublicChatEventReceiver.class;
        synchronized (PublicChatEventReceiver.class) {
            if (sInstance != null) return sInstance;
            sInstance = new PublicChatEventReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void onCreate(String host) {
        MLog.debug((Object)"PublicChatEventReceiver", (String)"PublicChatEventReceiver onCreate", (Object[])new Object[0]);
        this.onEventBind();
        this.hostActivityName = host;
    }

    public void onDestroy(String host) {
        if (!TextUtils.equals((CharSequence)host, (CharSequence)this.hostActivityName)) {
            return;
        }
        MLog.debug((Object)"PublicChatEventReceiver", (String)"PublicChatEventReceiver onDestroy", (Object[])new Object[0]);
        this.onEventUnBind();
    }

    @BusEvent
    public void updateCurrentChannelMessage(IChannelLinkClient_updateCurrentChannelMessage_EventArgs busEventArgs) {
        if (this.isNull()) {
            return;
        }
        SessOnText sessOnText = busEventArgs.getEtSessOnText();
        if (LoginUtil.isLogined() && sessOnText.uid == LoginUtil.getUid()) {
            return;
        }
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"PublicChatEventReceiver", (String)("updateCurrentChannelMessage:" + sessOnText.text), (Object[])new Object[0]);
        }
        PublicChatMessage message = new PublicChatMessage();
        message.uid = sessOnText.uid;
        message.sid = sessOnText.subSid;
        message.nickname = sessOnText.nickname;
        message.text = sessOnText.text;
        RxBus.getDefault().post((Object)new AppendChannelMessageEvent((ChannelMessage)message));
    }

    @BusEvent
    public void onAppendChannelMsg(IChannelLinkClient_onAppendChannelMsg_EventArgs busEventArgs) {
        if (this.isNull()) {
            MLog.error((Object)"PublicChatEventReceiver", (String)"mContext == null", (Object[])new Object[0]);
            return;
        }
        ChannelMessage message = busEventArgs.getMessage();
        if (BasicConfig.getInstance().isDebuggable() && MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"PublicChatEventReceiver", (String)(" message = " + message), (Object[])new Object[0]);
        }
        RxBus.getDefault().post((Object)new AppendChannelMessageEvent(message));
    }

    @BusEvent
    public void onReceiveChannelMsg(PersonalInfoCardPro.ChannelPubMsgBroadcast channelPubMsg) {
        if (this.isNull()) {
            return;
        }
        if (null == channelPubMsg) {
            return;
        }
        NoticeMessage noticeMessage = new NoticeMessage();
        String type = channelPubMsg.type;
        if (TextUtils.equals((CharSequence)type, (CharSequence)"memeda")) {
            noticeMessage.spannable = this.getMemedaMsg(channelPubMsg);
        } else if (TextUtils.equals((CharSequence)type, (CharSequence)"chok")) {
            noticeMessage.spannable = this.getChokMsg(channelPubMsg);
        } else if (TextUtils.equals((CharSequence)type, (CharSequence)"micUp")) {
            noticeMessage.spannable = this.getMicUpMsg(channelPubMsg);
        }
        noticeMessage.channelMessageType = ChannelMessage.ChannelMsgType.CUSTOMS_MESSAGE_TYPE;
        noticeMessage.uid = channelPubMsg.uid;
        noticeMessage.sid = channelPubMsg.sid;
        noticeMessage.nickname = channelPubMsg.nick;
        noticeMessage.text = channelPubMsg.type;
        noticeMessage.priority = 3;
        RxBus.getDefault().post((Object)new AppendChannelMessageEvent((ChannelMessage)noticeMessage));
    }

    private SpannableStringBuilder getMicUpMsg(@NonNull PersonalInfoCardPro.ChannelPubMsgBroadcast channelPubMsg) {
        String nick = StringUtil.cutOffString((String)channelPubMsg.nick, (int)10);
        String text = nick + " \u88ab\u62b1\u4e0a\u4e86\u9ea6\u5e8f";
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)text);
        int lastIndexOf = text.lastIndexOf(nick);
        if (lastIndexOf >= 0 && lastIndexOf + nick.length() < spannable.length()) {
            spannable.setSpan((Object)new NickClickableSpan(true, channelPubMsg.uid, null, this.isOtherChannelMessage(channelPubMsg.sid)), lastIndexOf, lastIndexOf + nick.length(), 33);
        }
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#bae05d")), 0, spannable.length(), 33);
        return spannable;
    }

    private SpannableStringBuilder getChokMsg(@NonNull PersonalInfoCardPro.ChannelPubMsgBroadcast channelPubMsg) {
        String nick = StringUtil.cutOffString((String)channelPubMsg.nick, (int)10);
        String chokDesc = "[chok]";
        String text = ((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).isLoginUserMobileLive() ? "\u4f60\u6233\u4e86" + chokDesc + nick + "\u4e00\u4e0b" : "\u4e3b\u64ad\u6233\u4e86" + chokDesc + nick + "\u4e00\u4e0b";
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)text);
        int lastIndexOf = text.lastIndexOf(nick);
        if (lastIndexOf >= 0 && lastIndexOf + nick.length() < spannable.length()) {
            spannable.setSpan((Object)new NickClickableSpan(true, channelPubMsg.uid, null, this.isOtherChannelMessage(channelPubMsg.sid)), lastIndexOf, lastIndexOf + nick.length(), 33);
        }
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#6DEAFF")), 0, spannable.length(), 33);
        Drawable drawable2 = ParserUtil.createBusinessIconDrawable(R.drawable.icon_liveroom_finger, 16, 16);
        if (null == drawable2) {
            return spannable;
        }
        int indexOf = text.indexOf(chokDesc);
        int dp2 = DimensUtils.dip2pixel((Context)this.mContext, (float)2.0f);
        spannable.setSpan((Object)new CustomImageSpan(drawable2, 2, (float)dp2, (float)dp2), indexOf, indexOf + chokDesc.length(), 33);
        return spannable;
    }

    private SpannableStringBuilder getMemedaMsg(@NonNull PersonalInfoCardPro.ChannelPubMsgBroadcast channelPubMsg) {
        String nick = StringUtil.cutOffString((String)channelPubMsg.nick, (int)10);
        String memeDesc = "[memeda]";
        String text = ((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).isLoginUserMobileLive() ? "\u4f60\u7ed9 " + nick + " \u4e00\u4e2a\u4e48\u4e48\u54d2" + memeDesc : "\u4e3b\u64ad\u7ed9 " + nick + " \u4e00\u4e2a\u4e48\u4e48\u54d2" + memeDesc;
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)text);
        int indexOf = text.lastIndexOf(nick);
        if (indexOf >= 0 && indexOf + nick.length() < spannable.length()) {
            spannable.setSpan((Object)new NickClickableSpan(true, channelPubMsg.uid, null, this.isOtherChannelMessage(channelPubMsg.sid)), indexOf, indexOf + nick.length(), 33);
        }
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#6DEAFF")), 0, spannable.length(), 33);
        Drawable drawable2 = ParserUtil.createBusinessIconDrawable(R.drawable.icon_liveroom_lips, 16, 16);
        if (null == drawable2) {
            return spannable;
        }
        indexOf = text.indexOf(memeDesc);
        int dp2 = DimensUtils.dip2pixel((Context)this.mContext, (float)2.0f);
        spannable.setSpan((Object)new CustomImageSpan(drawable2, 2, (float)dp2, (float)dp2), indexOf, indexOf + memeDesc.length(), 33);
        return spannable;
    }

    private boolean isOtherChannelMessage(long sid) {
        return ((IChannelLinkCoreEx)ICoreManagerBase.getChannelLinkCore()).getSubscribedMutiChannelSSidList().contains(sid);
    }

    private boolean isNull() {
        return this.mContext == null;
    }

    public void onEventBind() {
        if (this.mPublicChatEventReceiverSniperEventBinder == null) {
            this.mPublicChatEventReceiverSniperEventBinder = new PublicChatEventReceiver$$EventBinder();
        }
        this.mPublicChatEventReceiverSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mPublicChatEventReceiverSniperEventBinder != null) {
            this.mPublicChatEventReceiverSniperEventBinder.unBindEvent();
        }
    }
}

