/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.publicchat;

import android.content.Context;
import android.widget.RelativeLayout;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.liveapi.chatemotion.uicore.IChatEmotionCore;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onChatInputSwitch_EventArgs;
import com.yy.mobile.plugin.main.events.IMediaVideoBasicClient_onMediaVideoBasicStopFlagSwitch_EventArgs;
import com.yy.mobile.plugin.main.events.IPublicChatBroadcastClient_onUpdateChatLayoutParams_EventArgs;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoPlayInfo;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.playstatus.AudienceVideoPlayStatusEvent;
import com.yy.mobile.ui.basicchanneltemplate.Temp;
import com.yy.mobile.ui.publicchat.MergeChannelMessage;
import com.yy.mobile.ui.publicchat.PublicChatController$$EventBinder;
import com.yy.mobile.ui.publicchat.model.IPublicChatFlushDataListener;
import com.yy.mobile.ui.publicchat.model.IPublicChatViewListener;
import com.yy.mobile.ui.publicchat.model.PublicChatBaseModel;
import com.yy.mobile.ui.publicchat.model.event.AirTicketClickEvent;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.ui.utils.dialog.OkCancelDialog;
import com.yy.mobile.ui.utils.dialog.OkCancelDialogListener;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.gift.GiftChannelMessage;
import com.yymobile.core.live.LiveCore.JoinChannelIntent;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.mobilelive.MobileLiveType;
import java.util.ArrayList;
import java.util.Collection;

public class PublicChatController
implements EventCompat {
    private Context mContext;
    private PublicChatBaseModel publicChatModel;
    private DialogLinkManager dialogFactory;
    public IPublicChatViewListener publicChatViewListener;
    private boolean isInit = false;
    private boolean canClick = true;
    private IPublicChatFlushDataListener publicChatFlushDataListener = new IPublicChatFlushDataListener(){

        @Override
        public void setChatData(Collection<? extends ChannelMessage> data) {
            if (PublicChatController.this.publicChatViewListener != null) {
                PublicChatController.this.publicChatViewListener.onSetChatData(new ArrayList<ChannelMessage>(data));
            }
        }

        @Override
        public void updateGiftDrawable(GiftChannelMessage msg) {
            if (PublicChatController.this.publicChatViewListener != null) {
                PublicChatController.this.publicChatViewListener.onUpdateGiftDrawable(msg);
            }
        }

        @Override
        public void updateMergeMessage(MergeChannelMessage msg) {
            if (PublicChatController.this.publicChatViewListener != null) {
                PublicChatController.this.publicChatViewListener.onUpdateMergeMessage(msg);
            }
        }
    };
    private EventBinder mPublicChatControllerSniperEventBinder;

    public void onEventBind() {
        if (this.mPublicChatControllerSniperEventBinder == null) {
            this.mPublicChatControllerSniperEventBinder = new PublicChatController$$EventBinder();
        }
        this.mPublicChatControllerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mPublicChatControllerSniperEventBinder != null) {
            this.mPublicChatControllerSniperEventBinder.unBindEvent();
        }
    }

    public PublicChatController(PublicChatBaseModel model) {
        this.publicChatModel = model;
    }

    public void init(Context context) {
        this.mContext = context;
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        this.onEventBind();
        this.publicChatModel.initModel(this.mContext);
        this.publicChatModel.setFlushDataListener(this.publicChatFlushDataListener);
        this.dialogFactory = new DialogLinkManager(context);
    }

    public void setPublicChatViewListener(IPublicChatViewListener listener2) {
        this.publicChatViewListener = listener2;
    }

    public void resetMessage() {
    }

    @BusEvent
    public void onVideoPlayStatusChanged(AudienceVideoPlayStatusEvent event) {
        MLog.info((Object)"PublicChatController", (String)("onVideoPlayStatusChanged called with: event = [" + event + "]"), (Object[])new Object[0]);
        switch (event.playStatus) {
            case PLAYING: {
                this.onVideoPlaying(event.videoPlayInfo);
                break;
            }
        }
    }

    private void onVideoPlaying(VideoPlayInfo videoPlayInfo) {
        if (this.publicChatViewListener == null) {
            return;
        }
        if (this.publicChatModel != null && !this.canClick) {
            return;
        }
        if (ICoreManagerBase.getMediaCore().getStreamListSize() >= 2 || Temp.getCurrentBussinessId() == null && ((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).getMobileLiveType() != null && ((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).getMobileLiveType() != MobileLiveType.NOT_LIVING && ICoreManagerBase.getMediaCore().getStreamListSize() >= 1) {
            this.publicChatViewListener.onMeasureUILocation(false);
        } else {
            this.publicChatViewListener.onSetChatListLayoutParams(false);
        }
    }

    @BusEvent
    public void onChatInputSwitch(IChatEmotionClient_onChatInputSwitch_EventArgs busEventArgs) {
        boolean chatInputSwitch = busEventArgs.getChatInputSwitch();
        if (this.publicChatModel == null || this.publicChatViewListener == null) {
            return;
        }
        if (chatInputSwitch) {
            this.publicChatViewListener.onSetChatListLayoutParams(true);
            this.canClick = false;
        } else {
            this.publicChatViewListener.onSetChatListLayoutParams(false);
            this.canClick = true;
        }
    }

    @BusEvent
    public void onMediaVideoBasicStopFlagSwitch(IMediaVideoBasicClient_onMediaVideoBasicStopFlagSwitch_EventArgs busEventArgs) {
        boolean stopFlag = busEventArgs.getStopFlag();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"PublicChatController", (String)("[onMediaVideoBasicStopFlagSwitch] stopFlag = " + stopFlag), (Object[])new Object[0]);
        }
        if (this.publicChatViewListener == null) {
            return;
        }
        if (stopFlag) {
            boolean inputState = ((IChatEmotionCore)ICoreManagerBase.getCore(IChatEmotionCore.class)).getChatInputState();
            this.publicChatViewListener.onSetSmallChatListLayoutParams(inputState, this.publicChatViewListener.onGetLayoutWidth(inputState));
            ICoreManagerBase.getChannelLinkCore().setPublicCommonShowByAudioAndVideo(true);
        } else {
            ICoreManagerBase.getChannelLinkCore().setPublicCommonShowByAudioAndVideo(false);
        }
    }

    @BusEvent
    public void onShowAirTicketClickedTip(final AirTicketClickEvent event) {
        if (!this.canClick) {
            return;
        }
        if (this.dialogFactory == null) {
            this.dialogFactory = new DialogLinkManager(this.mContext);
        }
        this.dialogFactory.dismissDialog();
        if (ICoreManagerBase.getCore(IMobileLiveCore.class) != null && ((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).isLoginUserMobileLive()) {
            this.toChannel(event);
        } else {
            this.dialogFactory.showDialog((BaseDialog)new OkCancelDialog((CharSequence)"\u60a8\u786e\u5b9a\u8981\u79bb\u5f00\u6b64\u76f4\u64ad\u95f4\u5417\uff1f", (CharSequence)"\u786e\u5b9a", (CharSequence)"\u53d6\u6d88", true, true, new OkCancelDialogListener(){

                public void onCancel() {
                }

                public void onOk() {
                    PublicChatController.this.toChannel(event);
                }
            }));
        }
    }

    public void toChannel(AirTicketClickEvent event) {
        if (this.mContext == null || this.publicChatModel == null) {
            return;
        }
        if (event != null && event.getTopSid() > 0L) {
            JoinChannelIntent.instance((long)event.getTopSid(), (long)event.getSubSid()).src("90001").build().joinChannel(this.mContext);
        }
    }

    public void onDispose() {
        this.onEventUnBind();
        this.dialogFactory.dismissDialog();
        this.publicChatModel.deInitModel();
        this.isInit = false;
        this.publicChatViewListener = null;
        this.mContext = null;
    }

    @BusEvent(sync=true)
    public void onUpdateChatLayoutParams(IPublicChatBroadcastClient_onUpdateChatLayoutParams_EventArgs busEventArgs) {
        RelativeLayout.LayoutParams params = busEventArgs.getParams();
        MLog.info((Object)"PublicChatController", (String)("onUpdateChatLayoutParams params height = :" + (params != null ? Integer.valueOf(params.height) : null)), (Object[])new Object[0]);
        if (this.publicChatViewListener != null) {
            this.publicChatViewListener.onUpdateLayoutParams(params);
        }
    }
}

