/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.programinfo;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.duowan.mobile.entlive.events.ISecondVideoInfoClient_onSetSecondVideoMeasureUILocation_EventArgs;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.channel.core.AbsChannelControllerCore;
import com.yy.mobile.liveapi.user.personalinfocard.PersonalInfoCardBuilder;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.metadata.AudienceMetadataManager;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.playstatus.VideoPlayStatusListener;
import com.yy.mobile.ui.basicchanneltemplate.Temp;
import com.yy.mobile.ui.basicfunction.ScreenSizeUtils;
import com.yy.mobile.ui.channeltemplate.template.mobilelive.touchhandler.handler.SecondVideoInfoClickHandler;
import com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.layoutparser.VideoLayoutConstants;
import com.yy.mobile.ui.programinfo.BaseSecondVideoInfoComponent;
import com.yy.mobile.ui.programinfo.SecondVideoInfoComponent$$EventBinder;
import com.yy.mobile.ui.programinfo.uicore.ISecondVideoInfoCore;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.util.ActivityUtilKt;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.statistic.IDataReportCore;
import com.yymobile.core.uicore.ITouchCore;
import mobile.yy.com.toucheventbus.TouchEventBus;
import org.jetbrains.annotations.NotNull;

public class SecondVideoInfoComponent
extends BaseSecondVideoInfoComponent
implements View.OnClickListener,
VideoPlayStatusListener {
    private boolean isEntNewTemplate = false;
    protected View rootView;
    protected ImageView mImageViewBg;
    protected TextView mTextView;
    private EventBinder mSecondVideoInfoComponentSniperEventBinder;

    public static SecondVideoInfoComponent newInstance(boolean isEntNewTemplate) {
        SecondVideoInfoComponent f = new SecondVideoInfoComponent();
        Bundle bundle = new Bundle();
        bundle.putBoolean("PARAM_KEY_NEW_TEMPLATE", isEntNewTemplate);
        f.setArguments(bundle);
        return f;
    }

    public static SecondVideoInfoComponent newInstance() {
        SecondVideoInfoComponent f = new SecondVideoInfoComponent();
        return f;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.isEntNewTemplate = this.getArguments().getBoolean("PARAM_KEY_NEW_TEMPLATE", false);
        }
    }

    @Override
    public View onCreateView(@NotNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.rootView = inflater.inflate(this.getLayoutResId(), container, false);
        this.mImageViewBg = (ImageView)this.rootView.findViewById(R.id.mic_pic_bg);
        this.mImageViewBg.setImageResource(this.getFollowBtnResId());
        this.mTextView = (TextView)this.rootView.findViewById(R.id.right_mic_txt);
        this.mTextView.setOnClickListener((View.OnClickListener)this);
        this.mTextView.setVisibility(8);
        this.mImageViewBg.setOnClickListener((View.OnClickListener)this);
        if (this.isEntNewTemplate) {
            TouchEventBus.of(SecondVideoInfoClickHandler.class).attach((Object)this.rootView);
        }
        return this.rootView;
    }

    protected int getLayoutResId() {
        return R.layout.fragment_basic_second_video_info_layout;
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        if (this.mSecondVideoInfoComponentSniperEventBinder == null) {
            this.mSecondVideoInfoComponentSniperEventBinder = new SecondVideoInfoComponent$$EventBinder();
        }
        this.mSecondVideoInfoComponentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, savedInstanceState);
        this.showComponentLayout();
        MLog.info((Object)"SecondVideoInfoComponent", (String)"onViewCreated: isEntNewTemplate=%s, mSecondMicUid=%s", (Object[])new Object[]{this.isEntNewTemplate, this.mSecondMicUid});
    }

    @Override
    public void showComponentLayout() {
        MLog.info((Object)"SecondVideoInfoComponent", (String)"showComponentLayout:", (Object[])new Object[0]);
        if (!this.isSecondStreamInfoValid()) {
            this.hideRootView();
            return;
        }
        if (((ISecondVideoInfoCore)ICoreManagerBase.getCore(ISecondVideoInfoCore.class)).getLayoutParams() != null) {
            this.onExternalParamsUpdateLocation(((ISecondVideoInfoCore)ICoreManagerBase.getCore(ISecondVideoInfoCore.class)).getLayoutParams());
        } else {
            this.layoutSecondVideoInfoPosition(this.isLandscape);
        }
        if (!((ITouchCore)ICoreManagerBase.getCore(ITouchCore.class)).getClearScreenSate() && !this.multiWindowStatus) {
            this.showRootView();
        } else {
            this.hideRootView();
        }
    }

    @Override
    public void hideComponentLayout() {
        MLog.info((Object)"SecondVideoInfoComponent", (String)"hideComponentLayout:", (Object[])new Object[0]);
        this.setNickName("");
        this.setFollowState(true);
        this.hideRootView();
    }

    @Override
    protected void setNickName(String nickName) {
        if (this.mTextView != null) {
            if (!StringUtils.isEmpty((String)nickName).booleanValue()) {
                this.mTextView.setVisibility(0);
            }
            this.mTextView.setText((CharSequence)nickName);
        }
    }

    @Override
    protected void setFollowState(boolean isFollowed) {
        if (isFollowed) {
            this.mImageViewBg.setImageResource(this.getFollowBtnResId());
            this.mImageViewBg.setVisibility(4);
            this.mImageViewBg.setOnClickListener(null);
            this.mTextView.setPadding(DensityUtil.dip2px((Context)this.getActivity(), (float)8.0f), 0, DensityUtil.dip2px((Context)this.getActivity(), (float)8.0f), 0);
        } else {
            this.mImageViewBg.setImageResource(this.getFollowBtnResId());
            this.mImageViewBg.setVisibility(0);
            this.mImageViewBg.setOnClickListener((View.OnClickListener)this);
            this.mTextView.setPadding(DensityUtil.dip2px((Context)this.getActivity(), (float)8.0f), 0, DensityUtil.dip2px((Context)this.getActivity(), (float)24.0f), 0);
        }
    }

    private void onExternalParamsUpdateLocation(RelativeLayout.LayoutParams layoutParams) {
        if (layoutParams == null || this.rootView == null) {
            return;
        }
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onSetSecondVideoMeasureUILocation(ISecondVideoInfoClient_onSetSecondVideoMeasureUILocation_EventArgs busEventArgs) {
        RelativeLayout.LayoutParams layoutParams = busEventArgs.mLayoutParams;
        this.onExternalParamsUpdateLocation(layoutParams);
    }

    private void layoutSecondVideoInfoPosition(boolean isLandscape) {
        MLog.debug((Object)"SecondVideoInfoComponent", (String)"layoutSecondVideoInfoPosition: isEntNewTemplate=%s, isLandscape=%s", (Object[])new Object[]{this.isEntNewTemplate, isLandscape});
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        int gravity = 3;
        if (isLandscape) {
            if (this.isEntNewTemplate) {
                left = DensityUtil.dip2px((Context)this.getActivity(), (float)15.0f);
                top = DensityUtil.dip2px((Context)this.getActivity(), (float)12.0f);
            } else {
                left = this.calculateCommonVideoX() + DensityUtil.dip2px((Context)this.getActivity(), (float)10.0f);
                top = this.calculateCommonVideoY() + DensityUtil.dip2px((Context)this.getActivity(), (float)50.0f);
            }
        } else if (this.isEntNewTemplate) {
            top = DensityUtil.dip2px((Context)this.getActivity(), (float)36.0f);
            right = DensityUtil.dip2px((Context)this.getActivity(), (float)10.0f);
            gravity = 5;
        } else {
            left = this.calculateCommonVideoX() + DensityUtil.dip2px((Context)this.getActivity(), (float)4.0f);
            top = this.calculateCommonVideoY() + DensityUtil.dip2px((Context)this.getActivity(), (float)4.0f);
        }
        MLog.info((Object)"SecondVideoInfoComponent", (String)"layoutSecondVideoInfoPosition: left=%s, top=%s, right=%s, bottom=%s, gravity=%s", (Object[])new Object[]{left, top, right, bottom, gravity});
        layoutParams.setMargins(left, top, right, bottom);
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        ((RelativeLayout)this.rootView).setHorizontalGravity(gravity);
        this.rootView.bringToFront();
        this.showRootView();
    }

    protected int calculateCommonVideoX() {
        return ScreenSizeUtils.getWindowHeightIncludeBars((Activity)this.getActivity()) / 2;
    }

    protected int calculateCommonVideoY() {
        if (ActivityUtilKt.isLandScape((Activity)this.getActivity())) {
            return 0;
        }
        return (int)ResolutionUtils.convertDpToPixel((float)VideoLayoutConstants.DEFAULT_VIDEO_TOP, (Context)this.getContext());
    }

    public void onClick(View v) {
        if (v.getId() == R.id.mic_pic_bg) {
            if (!this.isNetworkAvailable()) {
                this.checkNetToast();
            } else if (this.isLogined()) {
                if (this.mSecondMicUid > 0L) {
                    this.clickProfileAnchor();
                    IDataReportCore core = (IDataReportCore)Spdt.ofOrNull(IDataReportCore.class);
                    if (core != null) {
                        core.reportOnSecondLiveSubscribe();
                    }
                }
            } else {
                this.showLoginDialog();
            }
        } else if (v.getId() == R.id.right_mic_txt) {
            boolean showRevenue = !"social".equals(Temp.getCurrentBussinessId());
            AbsChannelControllerCore channelControllerCore = (AbsChannelControllerCore)ICoreManagerBase.getCore(AbsChannelControllerCore.class);
            if (channelControllerCore == null || !channelControllerCore.isInterceptShowPersonalCard(this.mSecondMicUid, true, 3, this.getChildFragmentManager(), false)) {
                new PersonalInfoCardBuilder(this.mSecondMicUid).setCanCheckAnchorMicOrder(false).setHasDimBehind(true).setHasNoble(showRevenue).setShowContribution(showRevenue).setShowTrasureLove(showRevenue).withFragmentManager(this.getChildFragmentManager()).show();
            }
        }
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.hideRootView();
        this.showComponentLayout();
    }

    public void showRootView() {
        if (AudienceMetadataManager.getInstance().isArenaLive()) {
            return;
        }
        if (this.rootView != null && this.rootView.getVisibility() != 0) {
            this.requestData();
            this.rootView.setVisibility(0);
            MLog.info((Object)"SecondVideoInfoComponent", (String)"showRootView:", (Object[])new Object[0]);
        }
    }

    public void hideRootView() {
        if (this.rootView != null && this.rootView.getVisibility() != 8) {
            this.rootView.setVisibility(8);
            MLog.info((Object)"SecondVideoInfoComponent", (String)"hideRootView:", (Object[])new Object[0]);
        }
    }

    protected int getFollowBtnResId() {
        return R.drawable.second_video_info_unmic_selector;
    }

    @Override
    public void onDestroy() {
        if (this.isEntNewTemplate) {
            TouchEventBus.of(SecondVideoInfoClickHandler.class).dettach((Object)this.rootView);
        }
        super.onDestroy();
    }

    @Override
    protected void onDestroyView() {
        super.onDestroyView();
        if (this.mSecondVideoInfoComponentSniperEventBinder != null) {
            this.mSecondVideoInfoComponentSniperEventBinder.unBindEvent();
        }
    }
}

