/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.programinfo;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.duowan.mobile.entlive.events.ITouchClearScreen_EventArgs;
import com.unionyy.mobile.spdt.Spdt;
import com.unionyy.mobile.spdt.annotation.HEYTAP;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.channel.core.AbsChannelControllerCore;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.plugin.main.events.IMediaVideoBasicClient_onMediaVideoBasicStopSwitch_EventArgs;
import com.yy.mobile.plugin.main.events.ISubscribeClient_onSubscribeResult_EventArgs;
import com.yy.mobile.plugin.main.events.ISubscribeClient_onUnSubscribeResult_EventArgs;
import com.yy.mobile.plugin.main.events.IUserClient_onRequestDetailUserInfo_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.playstatus.VideoPlayStatusEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.streamcompat.VideoStreamCompat;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.playstatus.VideoPlayStatus;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.playstatus.VideoPlayStatusListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoPlayInfo;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.streamcompat.VideoStreamListSizeChangeEvent;
import com.yy.mobile.ui.activity.MultiWindowViewModel;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.pop.IGuidePop;
import com.yy.mobile.ui.programinfo.BaseSecondVideoInfoComponent$$EventBinder;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.utils.StringUtil;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.ActivityUtilKt;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.BaseFragmentApi;
import com.yymobile.core.CoreError;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.profile.EntUserInfo;
import com.yymobile.core.profile.IProfileCore;
import com.yymobile.core.subscribe.ISubscribeCore;
import com.yymobile.core.subscribe.SubscribedNotifyOpenPushPermissionManager;
import com.yymobile.core.user.IUserCore;
import com.yymobile.core.user.UserInfo;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;

public abstract class BaseSecondVideoInfoComponent
extends Component
implements VideoPlayStatusListener {
    protected VideoPlayStatus mVideoPlayStatus = VideoPlayStatus.STOP;
    protected boolean isLandscape = false;
    protected long mSecondMicUid;
    protected long mCurrentFousUid = -1L;
    protected UserInfo mUserInfo;
    protected Disposable registerDisposable;
    protected boolean multiWindowStatus = false;
    private Disposable subscribeDisposable = null;
    private EventBinder mBaseSecondVideoInfoComponentSniperEventBinder;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        VideoPlayStatusEventHandler.getInstance().addVideoPlayStatusListener((VideoPlayStatusListener)this);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.isLandscape = ActivityUtilKt.isLandScape((Activity)this.getActivity());
        if (((AbsChannelControllerCore)ICoreManagerBase.getCore(AbsChannelControllerCore.class)).ignoreHorizontalScreenImp()) {
            this.isLandscape = false;
        }
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        if (this.mBaseSecondVideoInfoComponentSniperEventBinder == null) {
            this.mBaseSecondVideoInfoComponentSniperEventBinder = new BaseSecondVideoInfoComponent$$EventBinder();
        }
        this.mBaseSecondVideoInfoComponentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, savedInstanceState);
        if (!this.isSecondStreamInfoValid()) {
            MLog.error((Object)"BaseSecondVideoInfoComponent", (String)"onViewCreated: second stream info is not valid ! not lianmai mode !", (Object[])new Object[0]);
            this.hideComponentLayout();
        } else {
            this.mSecondMicUid = VideoStreamCompat.getInstance().getSecondVideoStreamUid();
            this.mVideoPlayStatus = VideoPlayStatusEventHandler.getInstance().getVideoPlayStatus(this.mSecondMicUid);
            this.requestData();
        }
        if (this.registerDisposable != null && !this.registerDisposable.isDisposed()) {
            this.registerDisposable.dispose();
            this.registerDisposable = null;
        }
        if (this.getActivity() != null) {
            MultiWindowViewModel multiWindowViewModel = MultiWindowViewModel.get((FragmentActivity)this.getActivity());
            this.registerDisposable = multiWindowViewModel.registerV2().subscribe((Consumer)new Consumer<MultiWindowViewModel.MultiWindowChangeInfo>(){

                public void accept(MultiWindowViewModel.MultiWindowChangeInfo multiWindowChangeInfo) throws Exception {
                    BaseSecondVideoInfoComponent.this.multiWindowStatus = multiWindowChangeInfo.getMultiWindowStatus();
                }
            });
        }
    }

    public void onResume() {
        super.onResume();
        if (this.isSecondStreamInfoValid()) {
            this.queryShowFollowInfo();
        }
    }

    protected boolean isSecondStreamInfoValid() {
        long secUid = VideoStreamCompat.getInstance().getSecondVideoStreamUid();
        int streamSize = VideoStreamCompat.getInstance().getVideoStreamListSize();
        MLog.debug((Object)"BaseSecondVideoInfoComponent", (String)"isSecondStreamInfoValid: streamSize=%s, secUid=%s", (Object[])new Object[]{streamSize, secUid});
        return secUid > 0L && streamSize >= 2;
    }

    protected void requestData() {
        this.mSecondMicUid = VideoStreamCompat.getInstance().getSecondVideoStreamUid();
        this.queryShowUserInfo();
        this.queryShowFollowInfo();
    }

    protected void queryShowUserInfo() {
        UserInfo userInfo = ((IUserCore)ICoreManagerBase.getCore(IUserCore.class)).getCacheUserInfoByUid(this.mSecondMicUid);
        EntUserInfo entUserInfo = ((IProfileCore)ICoreManagerBase.getCore(IProfileCore.class)).getCachedProfileInfo(this.mSecondMicUid);
        if (null == entUserInfo) {
            ((IProfileCore)ICoreManagerBase.getCore(IProfileCore.class)).requestProfile(this.mSecondMicUid);
        }
        if (userInfo == null) {
            ((IUserCore)ICoreManagerBase.getCore(IUserCore.class)).requestDetailUserInfo(this.mSecondMicUid, false);
        } else {
            this.setNickName(this.parseName(userInfo));
        }
    }

    protected abstract void setNickName(String var1);

    @BusEvent
    public void onRequestDetailUserInfo(IUserClient_onRequestDetailUserInfo_EventArgs busEventArgs) {
        long userId = busEventArgs.getUserId();
        UserInfo info = busEventArgs.getInfo();
        boolean isLocalData = busEventArgs.getIsLocalData();
        CoreError error = busEventArgs.getError();
        long secUid = VideoStreamCompat.getInstance().getSecondVideoStreamUid();
        MLog.debug((Object)"BaseSecondVideoInfoComponent", (String)("onRequestDetailUserInfo  secUid =  " + secUid + " info =" + (info == null ? " is null" : info.userId + " : " + info.nickName) + " isLocalData=" + isLocalData + " error = " + error), (Object[])new Object[0]);
        if (error == null && info != null && info.userId > 0L && info.userId == secUid) {
            this.mUserInfo = info;
            this.setNickName(this.parseName(info));
        }
    }

    protected String parseName(UserInfo info) {
        if (info == null) {
            return "";
        }
        if (!FP.empty((CharSequence)info.reserve1)) {
            return StringUtil.shortString((String)info.reserve1, (int)6);
        }
        if (!FP.empty((CharSequence)info.nickName)) {
            return StringUtil.shortString((String)info.nickName, (int)6);
        }
        return "";
    }

    protected void queryShowFollowInfo() {
        if (!LoginUtil.isLogined() || this.mSecondMicUid <= 0L) {
            this.setFollowState(false);
            return;
        }
        if (this.subscribeDisposable != null) {
            this.subscribeDisposable.dispose();
        }
        this.subscribeDisposable = ((ISubscribeCore)ICoreManagerBase.getCore(ISubscribeCore.class)).querySubscribeObservable(this.mSecondMicUid).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Boolean>(){

            public void accept(Boolean aBoolean) throws Exception {
                if (BaseSecondVideoInfoComponent.this.isSecondStreamInfoValid()) {
                    MLog.debug((Object)"BaseSecondVideoInfoComponent", (String)("onQueryBookAnchorBatchResult uid:" + LoginUtil.getUid() + ",aBoolean=" + aBoolean + " secUid = " + BaseSecondVideoInfoComponent.this.mSecondMicUid), (Object[])new Object[0]);
                    BaseSecondVideoInfoComponent.this.setFollowState(aBoolean);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)"BaseSecondVideoInfoComponent", (String)"queryShowFollowInfo", (Object[])new Object[]{throwable.getMessage()});
                if (Spdt.currentFlavor() instanceof HEYTAP) {
                    BaseSecondVideoInfoComponent.this.setFollowState(false);
                }
            }
        });
    }

    protected abstract void setFollowState(boolean var1);

    protected void clickProfileAnchor() {
        this.mCurrentFousUid = this.mSecondMicUid;
        AbsChannelControllerCore iMicAudienceNobleControllerCore = (AbsChannelControllerCore)ICoreManagerBase.getCore(AbsChannelControllerCore.class);
        if (iMicAudienceNobleControllerCore == null || !iMicAudienceNobleControllerCore.isInterceptSubscribe(this.mSecondMicUid)) {
            ((ISubscribeCore)ICoreManagerBase.getCore(ISubscribeCore.class)).subscribe(this.mSecondMicUid);
        }
    }

    @BusEvent
    public void onSubscribeResult(ISubscribeClient_onSubscribeResult_EventArgs busEventArgs) {
        if (!this.checkActivityValid() || !this.isSecondStreamInfoValid()) {
            return;
        }
        long anchorUid = busEventArgs.getAnchorUid();
        boolean success = busEventArgs.getSuccess();
        String errorMsg = busEventArgs.getErrorMsg();
        MLog.debug((Object)"BaseSecondVideoInfoComponent", (String)"onSubscribeResult: anchorUid=%s, secUid=%s, mCurrentFousUid=%s", (Object[])new Object[]{anchorUid, this.mSecondMicUid, this.mCurrentFousUid});
        if (anchorUid == this.mSecondMicUid && this.mSecondMicUid > 0L && anchorUid > 0L) {
            if (success) {
                if (this.getUserVisibleHint()) {
                    if (this.mCurrentFousUid == this.mSecondMicUid) {
                        this.mCurrentFousUid = -1L;
                        this.toast("\u5173\u6ce8\u6210\u529f\uff01");
                        SubscribedNotifyOpenPushPermissionManager.showSubscribedNotifyDialog((Fragment)this, (long)this.mSecondMicUid, (String)this.parseName(this.mUserInfo), (int)IGuidePop.Companion.getFROM_FOLLOW());
                    }
                    this.setFollowState(true);
                }
            } else if (this.getUserVisibleHint()) {
                if (this.mCurrentFousUid == this.mSecondMicUid) {
                    this.mCurrentFousUid = -1L;
                    if (!StringUtils.isEmpty((String)errorMsg).booleanValue()) {
                        SingleToastUtil.showToast((Context)this.getContext(), (String)errorMsg);
                    } else {
                        SingleToastUtil.showToast((Context)this.getContext(), (int)R.string.str_subscribe_failed);
                    }
                }
                this.setFollowState(false);
            }
        }
    }

    @BusEvent
    public void onUnSubscribeResult(ISubscribeClient_onUnSubscribeResult_EventArgs busEventArgs) {
        if (!this.checkActivityValid() || !this.isSecondStreamInfoValid()) {
            return;
        }
        long anchorUid = busEventArgs.getAnchorUid();
        boolean success = busEventArgs.getSuccess();
        long secUid = VideoStreamCompat.getInstance().getSecondVideoStreamUid();
        MLog.debug((Object)"BaseSecondVideoInfoComponent", (String)"onUnSubscribeResult: anchorUid=%s, secUid=%s, mCurrentFousUid=%s", (Object[])new Object[]{anchorUid, this.mSecondMicUid, this.mCurrentFousUid});
        if (this.isSecondStreamInfoValid() && anchorUid == secUid && secUid > 0L && anchorUid > 0L) {
            if (success) {
                if (this.getUserVisibleHint()) {
                    if (this.mCurrentFousUid == secUid) {
                        this.mCurrentFousUid = -1L;
                        this.toast("\u53d6\u6d88\u5173\u6ce8\u6210\u529f\uff01");
                        SubscribedNotifyOpenPushPermissionManager.unSubscribeAnchor((long)anchorUid);
                    }
                    this.setFollowState(false);
                }
            } else if (this.getUserVisibleHint()) {
                if (this.mCurrentFousUid == secUid) {
                    this.mCurrentFousUid = -1L;
                    this.toast("\u53d6\u6d88\u5173\u6ce8\u5931\u8d25\uff01");
                }
                this.setFollowState(true);
            }
        }
    }

    public void onPlayStatusChanged(VideoPlayInfo playInfo, VideoPlayStatus videoPlayStatus) {
        if (videoPlayStatus == null) {
            return;
        }
        MLog.info((Object)"BaseSecondVideoInfoComponent", (String)("onPlayStatusChanged:" + videoPlayStatus), (Object[])new Object[0]);
        this.mVideoPlayStatus = videoPlayStatus;
        if (videoPlayStatus == VideoPlayStatus.PLAYING && playInfo.micPos == 1 && playInfo.isMixLayout) {
            this.showComponentLayout();
        }
    }

    @BusEvent
    public void onVideoStreamSizeChanged(VideoStreamListSizeChangeEvent event) {
        MLog.info((Object)"BaseSecondVideoInfoComponent", (String)("onVideoStreamSizeChange called with: event = [" + event + "]"), (Object[])new Object[0]);
        if (this.isSecondStreamInfoValid()) {
            this.showComponentLayout();
            this.requestData();
        } else {
            this.hideComponentLayout();
        }
    }

    @BusEvent
    public void onVideoAudioModeSwitch(IMediaVideoBasicClient_onMediaVideoBasicStopSwitch_EventArgs eventArgs) {
        MLog.info((Object)"BaseSecondVideoInfoComponent", (String)("onVideoAudioModeSwitch: eventArgs=" + eventArgs), (Object[])new Object[0]);
        if (!this.isSecondStreamInfoValid()) {
            return;
        }
        if (eventArgs.isVideoEnable) {
            this.showComponentLayout();
            this.requestData();
        } else {
            this.hideComponentLayout();
        }
    }

    @BusEvent(sync=true)
    public void onSwipeLandScape(ITouchClearScreen_EventArgs busEventArgs) {
        MLog.info((Object)"BaseSecondVideoInfoComponent", (String)("onSwipeLandScape: busEventArgs=" + busEventArgs), (Object[])new Object[0]);
        if (!busEventArgs.getCleanSceen() && !this.multiWindowStatus) {
            this.mSecondMicUid = VideoStreamCompat.getInstance().getSecondVideoStreamUid();
            if (this.isSecondStreamInfoValid()) {
                this.showComponentLayout();
                this.requestData();
            } else {
                this.hideComponentLayout();
            }
        } else {
            this.hideComponentLayout();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.isLandscape = ActivityUtilKt.isLandScape((Activity)this.getActivity());
        if (((AbsChannelControllerCore)ICoreManagerBase.getCore(AbsChannelControllerCore.class)).ignoreHorizontalScreenImp()) {
            this.isLandscape = false;
        }
    }

    public void showLoginDialog() {
        if (this.checkActivityValid()) {
            try {
                ((BaseFragmentApi)CoreApiManager.getInstance().getApi(BaseFragmentApi.class)).showLoginDialog((Activity)this.getActivity());
            }
            catch (Throwable e) {
                Toast.makeText((Context)this.getActivity(), (CharSequence)"\u767b\u5f55\u540e\u624d\u80fd\u4f7f\u7528\u8be5\u529f\u80fd", (int)0).show();
            }
        }
    }

    @BusEvent
    public void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs busEventArgs) {
        MLog.debug((Object)"BaseSecondVideoInfoComponent", (String)"leaveCurrentChannel:", (Object[])new Object[0]);
        this.setNickName("");
        this.setFollowState(false);
        this.hideComponentLayout();
    }

    @BusEvent
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        MLog.debug((Object)"BaseSecondVideoInfoComponent", (String)"onJoinChannelSuccess:", (Object[])new Object[0]);
        this.requestData();
        this.showComponentLayout();
    }

    protected abstract void showComponentLayout();

    protected abstract void hideComponentLayout();

    public void onDestroy() {
        super.onDestroy();
        this.mSecondMicUid = 0L;
        this.mCurrentFousUid = -1L;
        this.mVideoPlayStatus = null;
        VideoPlayStatusEventHandler.getInstance().removeVideoPlayStatusListener((VideoPlayStatusListener)this);
        if (this.subscribeDisposable != null) {
            this.subscribeDisposable.dispose();
            this.subscribeDisposable = null;
        }
        if (this.registerDisposable != null) {
            this.registerDisposable.dispose();
            this.registerDisposable = null;
        }
    }

    protected void onDestroyView() {
        super.onDestroyView();
        if (this.mBaseSecondVideoInfoComponentSniperEventBinder != null) {
            this.mBaseSecondVideoInfoComponentSniperEventBinder.unBindEvent();
        }
    }
}

