/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.plugincenter.presenter;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.plugincenter.IPluginCenterCore;
import com.yymobile.liveapi.plugincenter.ExSinglePluginInfo;
import com.yymobile.liveapi.plugincenter.SinglePluginInfo;
import com.yyproto.utils.FP;
import java.util.List;

public class PluginCenterAdapter
extends RecyclerView.Adapter<ViewHolder> {
    public List<SinglePluginInfo> mPluginList;
    public OnItemSelectListener mItemSelectListener;
    private boolean mIsLandscape;
    public long mCurrentActivePluginId;

    public PluginCenterAdapter(boolean isLandscape) {
        this.mIsLandscape = isLandscape;
    }

    public void setItemSelectListener(OnItemSelectListener listener2) {
        this.mItemSelectListener = listener2;
    }

    public void setPluginList(List<SinglePluginInfo> pluginInfos) {
        this.mPluginList = pluginInfos;
        IPluginCenterCore pluginCenterCore = (IPluginCenterCore)CoreFactory.getCore(IPluginCenterCore.class);
        this.mCurrentActivePluginId = null != pluginCenterCore && null != pluginCenterCore.getCurrentActivatedPlugin() ? pluginCenterCore.getCurrentActivatedPlugin().pluginId : -1L;
        this.notifyDataSetChanged();
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (this.mIsLandscape) {
            return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.entlive_plugincenter_item_land, parent, false));
        }
        return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.entlive_plugincenter_item, parent, false));
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, final int position) {
        if (FP.size(this.mPluginList) <= position) {
            return;
        }
        holder.updatePluginInfo(this.mPluginList.get(position));
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (null != PluginCenterAdapter.this.mItemSelectListener && FP.size(PluginCenterAdapter.this.mPluginList) > position) {
                    PluginCenterAdapter.this.mItemSelectListener.onPluginItemSelect(PluginCenterAdapter.this.mPluginList.get(position), v, position);
                }
            }
        });
    }

    public int getItemCount() {
        return FP.size(this.mPluginList);
    }

    static interface OnItemSelectListener {
        public void onPluginItemSelect(SinglePluginInfo var1, View var2, int var3);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView mPluginIcon;
        private View mRedDot;
        private TextView mPluginName;
        private TextView mPluginPlayingView;

        ViewHolder(View itemView) {
            super(itemView);
            this.mPluginIcon = (ImageView)itemView.findViewById(R.id.entlive_plugincenteritem_icon);
            this.mRedDot = itemView.findViewById(R.id.entlive_plugincenteritem_reddot);
            this.mPluginName = (TextView)itemView.findViewById(R.id.entlive_plugincenteritem_name);
            this.mPluginPlayingView = (TextView)itemView.findViewById(R.id.entlive_plugincenteritem_playing);
        }

        void updatePluginInfo(SinglePluginInfo pluginInfo) {
            if (pluginInfo instanceof ExSinglePluginInfo && ((ExSinglePluginInfo)pluginInfo).iconResId > 0) {
                this.mPluginIcon.setImageResource(((ExSinglePluginInfo)pluginInfo).iconResId);
            } else {
                Glide.with((View)this.mPluginIcon).load(pluginInfo.icon).into(this.mPluginIcon);
            }
            this.mPluginName.setText((CharSequence)pluginInfo.pluginName);
            if (pluginInfo.isNewPlugin) {
                this.mRedDot.setVisibility(0);
            } else {
                this.mRedDot.setVisibility(8);
            }
            if (PluginCenterAdapter.this.mCurrentActivePluginId == pluginInfo.pluginId) {
                this.mPluginPlayingView.setVisibility(0);
                this.mPluginName.setTextColor(Color.parseColor((String)"#ffdd00"));
            } else {
                this.mPluginPlayingView.setVisibility(8);
                this.mPluginName.setTextColor(Color.parseColor((String)"#8d8d8d"));
            }
        }
    }
}

