/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.plugincenter;

import android.content.Context;
import android.os.Build;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.duowan.mobile.entlive.events.IPluginCenterClient_addPluginView_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.RxBus;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.plugin.main.events.IPluginCenterClient_pluginCenterViewShow_EventArgs;
import com.yy.mobile.plugin.main.events.IPluginCenterClient_removePluginView_EventArgs;
import com.yy.mobile.ui.plugincenter.PluginCenterContainer$$EventBinder;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.liveapi.plugincenter.PluginViewParams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class PluginCenterContainer
implements EventCompat {
    private FragmentActivity context;
    private RelativeLayout viewGroup;
    private boolean isLandscape;
    private HashMap<String, PluginViewParams> paramsHashMap = new HashMap();
    private ArrayList<ViewStateInfo> viewStateInfos = new ArrayList();
    private EventBinder mPluginCenterContainerSniperEventBinder;

    public void onEventBind() {
        if (this.mPluginCenterContainerSniperEventBinder == null) {
            this.mPluginCenterContainerSniperEventBinder = new PluginCenterContainer$$EventBinder();
        }
        this.mPluginCenterContainerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mPluginCenterContainerSniperEventBinder != null) {
            this.mPluginCenterContainerSniperEventBinder.unBindEvent();
        }
    }

    public void init(FragmentActivity context, RelativeLayout viewGroup) {
        this.context = context;
        this.viewGroup = new RelativeLayout((Context)context);
        viewGroup.addView((View)this.viewGroup, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.isLandscape = this.context.getResources().getConfiguration().orientation == 2;
        ICoreManagerBase.addClient((Object)this);
    }

    public void onResume() {
    }

    public void onPause() {
    }

    public void onOrientationChange(boolean isLandscape) {
        this.isLandscape = isLandscape;
        if (!this.checkActivityValid()) {
            MLog.info((Object)"PluginCenterContainer", (String)"activity unvalid", (Object[])new Object[0]);
        }
        if (null == this.viewGroup) {
            return;
        }
        try {
            int childCount = this.viewGroup.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View view = this.viewGroup.getChildAt(i);
                if (null == view || !(view.getTag() instanceof String) || !(view.getLayoutParams() instanceof RelativeLayout.LayoutParams) || null == this.paramsHashMap.get(view.getTag())) continue;
                PluginViewParams params = this.paramsHashMap.get(view.getTag());
                if (params.lanscape.equals(params.porrait)) continue;
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)view.getLayoutParams();
                if (isLandscape) {
                    if (null != params.lanscape) {
                        this.setLayoutParams(layoutParams, params.lanscape);
                    }
                } else if (null != params.porrait) {
                    this.setLayoutParams(layoutParams, params.porrait);
                }
                view.requestLayout();
            }
        }
        catch (Exception e) {
            MLog.info((Object)"PluginCenterContainer", (String)("onOrientationChange error=" + e.toString()), (Object[])new Object[0]);
        }
    }

    public void destory() {
        ICoreManagerBase.removeClient((Object)this);
        this.removeAllView(true);
        this.viewGroup = null;
        this.context = null;
    }

    @BusEvent(sync=true)
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        ChannelInfo channelInfo = busEventArgs.getInfo();
        this.removeAllView(false);
    }

    @BusEvent(sync=true)
    public void addPluginView(IPluginCenterClient_addPluginView_EventArgs busEventArgs) {
        String tag = busEventArgs.getTag();
        int priority = busEventArgs.getPriority();
        View view = busEventArgs.getView();
        PluginViewParams params = busEventArgs.getParams();
        MLog.info((Object)"PluginCenterContainer", (String)"addPluginView tag = %s priority = %d ", (Object[])new Object[]{tag, priority});
        if (!this.checkActivityValid()) {
            MLog.info((Object)"PluginCenterContainer", (String)"activity unvalid", (Object[])new Object[0]);
            return;
        }
        this.addView(tag, priority, view, params);
    }

    @BusEvent(sync=true)
    public void removePluginView(IPluginCenterClient_removePluginView_EventArgs busEventArgs) {
        String tag = busEventArgs.getTag();
        MLog.info((Object)"PluginCenterContainer", (String)"addPluginView tag = %s ", (Object[])new Object[]{tag});
        if (!this.checkActivityValid()) {
            MLog.info((Object)"PluginCenterContainer", (String)"activity unvalid", (Object[])new Object[0]);
            return;
        }
        this.removeView(tag);
    }

    public void addView(String tag, int priority, View view, PluginViewParams params) {
        if (null == this.viewGroup || null == view || null == tag || null == params || view.getParent() != null) {
            MLog.info((Object)"PluginCenterContainer", (String)"viewGroup or context or view or tag or params is null or view.Parent is not null", (Object[])new Object[0]);
            return;
        }
        try {
            ViewStateInfo first;
            MLog.info((Object)"PluginCenterContainer", (String)("addView tag=" + tag), (Object[])new Object[0]);
            ViewStateInfo stateInfo = new ViewStateInfo();
            stateInfo.priority = priority;
            stateInfo.tag = tag;
            stateInfo.showing = true;
            if (!this.viewStateInfos.isEmpty() && null != (first = this.viewStateInfos.get(0))) {
                if (first.priority <= priority) {
                    stateInfo.showing = false;
                } else {
                    View firstChild = this.viewGroup.findViewWithTag((Object)first.tag);
                    if (null != firstChild) {
                        firstChild.setVisibility(4);
                        first.showing = false;
                    }
                }
            }
            view.setTag((Object)tag);
            if (!stateInfo.showing) {
                view.setVisibility(4);
            }
            RelativeLayout.LayoutParams layoutParams = null;
            if (this.isLandscape) {
                if (null != params.lanscape) {
                    layoutParams = new RelativeLayout.LayoutParams(params.lanscape.width == 0 ? -2 : params.lanscape.width, params.lanscape.height == 0 ? -2 : params.lanscape.height);
                    this.setLayoutParams(layoutParams, params.lanscape);
                }
            } else if (null != params.porrait) {
                layoutParams = new RelativeLayout.LayoutParams(params.porrait.width == 0 ? -2 : params.porrait.width, params.porrait.height == 0 ? -2 : params.porrait.height);
                this.setLayoutParams(layoutParams, params.porrait);
            }
            if (null != layoutParams) {
                this.viewGroup.addView(view, layoutParams);
            } else {
                this.viewGroup.addView(view);
            }
            this.paramsHashMap.put(tag, params);
            this.viewStateInfos.add(stateInfo);
            Collections.sort(this.viewStateInfos, new SortComparator());
            if (this.viewStateInfos.size() == 1) {
                RxBus.getDefault().post((Object)new IPluginCenterClient_pluginCenterViewShow_EventArgs(true));
            }
        }
        catch (Exception e) {
            MLog.info((Object)"PluginCenterContainer", (String)("addView error=" + e.toString()), (Object[])new Object[0]);
        }
    }

    public void removeView(String tag) {
        if (null == tag || null == this.viewGroup) {
            MLog.info((Object)"PluginCenterContainer", (String)"removeView tag or viewGroup is null", (Object[])new Object[0]);
            return;
        }
        try {
            MLog.info((Object)"PluginCenterContainer", (String)("removeView tag=" + tag), (Object[])new Object[0]);
            View delView = this.viewGroup.findViewWithTag((Object)tag);
            if (null != delView) {
                this.viewGroup.removeView(delView);
            }
            for (ViewStateInfo stateInfo : this.viewStateInfos) {
                if (null == stateInfo || !tag.equals(stateInfo.tag)) continue;
                this.viewStateInfos.remove(stateInfo);
                break;
            }
            if (!this.viewStateInfos.isEmpty()) {
                View seeView;
                ViewStateInfo info = this.viewStateInfos.get(0);
                if (null != info && null != info.tag && !info.showing && null != (seeView = this.viewGroup.findViewWithTag((Object)info.tag))) {
                    info.showing = true;
                    seeView.setVisibility(0);
                }
            } else {
                RxBus.getDefault().post((Object)new IPluginCenterClient_pluginCenterViewShow_EventArgs(false));
            }
            this.paramsHashMap.remove(tag);
        }
        catch (Exception e) {
            MLog.info((Object)"PluginCenterContainer", (String)("removeView error=" + e.toString()), (Object[])new Object[0]);
        }
    }

    public void removeAllView(boolean isDestory) {
        try {
            this.viewGroup.removeAllViews();
            this.paramsHashMap.clear();
            this.viewStateInfos.clear();
            if (!isDestory) {
                RxBus.getDefault().post((Object)new IPluginCenterClient_pluginCenterViewShow_EventArgs(false));
            }
        }
        catch (Exception e) {
            MLog.info((Object)"PluginCenterContainer", (String)("removeView error=" + e.toString()), (Object[])new Object[0]);
        }
    }

    private void setLayoutParams(RelativeLayout.LayoutParams params, PluginViewParams.ViewParamsconfig viewParamsconfig) {
        params.leftMargin = viewParamsconfig.leftMargin;
        params.rightMargin = viewParamsconfig.rightMargin;
        params.topMargin = viewParamsconfig.topMargin;
        params.bottomMargin = viewParamsconfig.bottomMargin;
        params.addRule(9, viewParamsconfig.alginParentLeft ? -1 : 0);
        params.addRule(10, viewParamsconfig.alginParentTop ? -1 : 0);
        params.addRule(12, viewParamsconfig.alginParentBottom ? -1 : 0);
        params.addRule(11, viewParamsconfig.alginParentRight ? -1 : 0);
    }

    protected boolean checkActivityValid() {
        return null != this.context && !this.context.isFinishing() && (Build.VERSION.SDK_INT < 17 || !this.context.isDestroyed());
    }

    private static class SortComparator
    implements Comparator<ViewStateInfo> {
        private SortComparator() {
        }

        @Override
        public int compare(ViewStateInfo lhs, ViewStateInfo rhs) {
            if (null != lhs && null != rhs) {
                return lhs.priority - rhs.priority;
            }
            return 0;
        }
    }

    public static class ViewStateInfo {
        public String tag;
        public int priority;
        public boolean showing;
    }
}

