/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.onlinebusiness.adapter;

import android.content.Context;
import android.graphics.Color;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.onlinebusiness.ISubscribeButtonClickListener;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.ClipboardUtil;
import com.yymobile.core.business.BusinessGoodsInfo;
import java.lang.ref.WeakReference;

public class ShelvesHolder {
    public TextView mTxItemIndex;
    public RecycleImageView mImgShopsIcon;
    public TextView mTxShopName;
    public TextView mTxPrice;
    private RecycleImageView mImgShopTag;
    private TextView mBtnBook;
    private TextView mTxBrokerage;
    public Button mBtnCopy;
    public WeakReference<ISubscribeButtonClickListener> clickListenerWeakReference;

    public ShelvesHolder(View rootView, ISubscribeButtonClickListener clickListener, boolean isLandspace) {
        this.clickListenerWeakReference = new WeakReference<ISubscribeButtonClickListener>(clickListener);
        if (isLandspace) {
            this.mTxItemIndex = (TextView)rootView.findViewById(R.id.tx_item_index_landspace);
            this.mImgShopsIcon = (RecycleImageView)rootView.findViewById(R.id.img_shops_icon_landspace);
            this.mTxShopName = (TextView)rootView.findViewById(R.id.tx_shop_name_landspace);
            this.mTxPrice = (TextView)rootView.findViewById(R.id.tx_price_landspace);
            this.mImgShopTag = (RecycleImageView)rootView.findViewById(R.id.img_shop_tag_landspace);
            this.mBtnBook = (TextView)rootView.findViewById(R.id.btn_book_landspace);
            this.mTxBrokerage = (TextView)rootView.findViewById(R.id.tx_brokerage_landspace);
            this.mBtnCopy = (Button)rootView.findViewById(R.id.btn_copy_landspace);
        } else {
            this.mTxItemIndex = (TextView)rootView.findViewById(R.id.tx_item_index_portrait);
            this.mImgShopsIcon = (RecycleImageView)rootView.findViewById(R.id.img_shops_icon_portrait);
            this.mTxShopName = (TextView)rootView.findViewById(R.id.tx_shop_name_portrait);
            this.mTxPrice = (TextView)rootView.findViewById(R.id.tx_price_portrait);
            this.mImgShopTag = (RecycleImageView)rootView.findViewById(R.id.img_shop_tag_portrait);
            this.mBtnBook = (TextView)rootView.findViewById(R.id.btn_book_portrait);
            this.mTxBrokerage = (TextView)rootView.findViewById(R.id.tx_brokerage_portrait);
            this.mBtnCopy = (Button)rootView.findViewById(R.id.btn_copy_portrait);
        }
        this.mBtnBook.setText((CharSequence)"\u63a8\u8350");
    }

    public void setShopInfo(int index, final BusinessGoodsInfo info) {
        if (info == null) {
            return;
        }
        this.mTxItemIndex.setText((CharSequence)String.format("%d", index));
        final int pos = index - 1;
        ImageLoader.loadImage((String)info.picUrl, (RecycleImageView)this.mImgShopsIcon, (ImageConfig)ImageConfig.smallImageConfig(), (int)R.drawable.default_portrait_140_140);
        if (info.isHot == 1) {
            this.mImgShopTag.setVisibility(0);
        } else if (info.isHot == 0) {
            this.mImgShopTag.setVisibility(8);
        }
        this.mTxShopName.setText((CharSequence)info.title);
        this.mTxPrice.setText((CharSequence)String.format("\uffe5%s", info.price));
        this.mTxBrokerage.setText((CharSequence)("\uffe5" + info.realCommission));
        this.mBtnBook.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ISubscribeButtonClickListener listener2;
                ISubscribeButtonClickListener iSubscribeButtonClickListener = listener2 = ShelvesHolder.this.clickListenerWeakReference != null ? (ISubscribeButtonClickListener)ShelvesHolder.this.clickListenerWeakReference.get() : null;
                if (listener2 != null) {
                    listener2.bookButtonClick(view, pos);
                }
            }
        });
        this.mBtnCopy.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ClipboardUtil.setText((Context)v.getContext(), (String)info.shareLink);
                Toast.makeText((Context)v.getContext(), (int)R.string.business_copy_tip, (int)0).show();
            }
        });
        this.mBtnCopy.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0) {
                    ShelvesHolder.this.mBtnCopy.setAlpha(0.4f);
                } else if (event.getAction() == 1) {
                    ShelvesHolder.this.mBtnCopy.setAlpha(1.0f);
                }
                return false;
            }
        });
        if (info.status == 1) {
            this.mBtnCopy.setVisibility(0);
        } else {
            this.mBtnBook.setText((CharSequence)"\u5df2\u4e0b\u67b6");
            this.mBtnBook.setBackgroundColor(Color.parseColor((String)"#e8e8e8"));
            this.mBtnBook.setTextColor(Color.parseColor((String)"#C5C5C5"));
            this.mBtnCopy.setVisibility(4);
        }
        if (info.status == 1) {
            this.mBtnBook.setBackgroundColor(Color.parseColor((String)"#FFDD00"));
            this.mBtnBook.setTextColor(Color.parseColor((String)"#000000"));
            if (info.isRecommending) {
                this.mBtnBook.setText((CharSequence)"\u64a4\u9500\u63a8\u8350");
            } else {
                this.mBtnBook.setText((CharSequence)"\u63a8\u8350");
            }
        }
    }
}

