/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.onlinebusiness;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import com.duowan.mobile.entlive.events.IBusinessClient_onReceiveAnchorSubscribeResult_EventArgs;
import com.duowan.mobile.entlive.events.IBusinessClient_onReceiveShelvesList_EventArgs;
import com.duowan.mobile.entlive.events.IBusinessClient_onTimerEnd_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.BasePopupComponent;
import com.yy.mobile.ui.onlinebusiness.ISubscribeButtonClickListener;
import com.yy.mobile.ui.onlinebusiness.ShopsComponent$$EventBinder;
import com.yy.mobile.ui.onlinebusiness.adapter.ShelvesAdapter;
import com.yy.mobile.ui.widget.horizontallist.HListView;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.business.BusinessGoodsInfo;
import com.yymobile.core.business.IBusinessCore;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ShopsComponent
extends BasePopupComponent
implements EventCompat {
    public static boolean ShopsComponentUIShow = false;
    private ListView shopsList;
    private HListView shopsListLandspace;
    private ShelvesAdapter shelvesAdapter;
    public List<BusinessGoodsInfo> mDatas;
    private boolean isLandspace = false;
    private View rootView;
    public IChannelLinkCore channelLinkCore;
    private ISubscribeButtonClickListener bookButtonClickListener = new ISubscribeButtonClickListener(){

        public void bookButtonClick(View view, int pos) {
            if (ShopsComponent.this.mDatas != null) {
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51707", "0012");
                BusinessGoodsInfo info = ShopsComponent.this.mDatas.get(pos);
                if (info.status != 1) {
                    return;
                }
                if (ShopsComponent.this.channelLinkCore != null && ICoreManagerBase.getCore(IBusinessCore.class) != null) {
                    ChannelInfo channelInfo = ShopsComponent.this.channelLinkCore.getCurrentChannelInfo();
                    if (info.isRecommending()) {
                        ((IBusinessCore)ICoreManagerBase.getCore(IBusinessCore.class)).sendSubscribeGoodsInfo(LoginUtil.getUid(), channelInfo.topSid, channelInfo.subSid, info.mallType, info.itemId, 0);
                    } else {
                        ((IBusinessCore)ICoreManagerBase.getCore(IBusinessCore.class)).sendSubscribeGoodsInfo(LoginUtil.getUid(), channelInfo.topSid, channelInfo.subSid, info.mallType, info.itemId, 1);
                    }
                }
            }
        }
    };
    private EventBinder mShopsComponentSniperEventBinder;

    public static ShopsComponent newInstanceByPortrait() {
        ShopsComponent shopsComponent = new ShopsComponent();
        Bundle bundle = new Bundle();
        bundle.putBoolean("isLandspace", false);
        shopsComponent.setArguments(bundle);
        return shopsComponent;
    }

    public static ShopsComponent newInstanceByLandspace() {
        ShopsComponent shopsComponent = new ShopsComponent();
        Bundle bundle = new Bundle();
        bundle.putBoolean("isLandspace", true);
        shopsComponent.setArguments(bundle);
        return shopsComponent;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.isLandspace = savedInstanceState.getBoolean("isLandspace");
        } else {
            Bundle bundle = this.getArguments();
            this.isLandspace = bundle.getBoolean("isLandspace");
        }
        this.setStyle(0, 16973834);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.setCanceledOnTouchOutside(true);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setWindowAnimations(R.style.slide_dialog_animation);
        dialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        dialog.getWindow().setGravity(80);
        dialog.getWindow().setFlags(1024, 1024);
        if (this.isLandspace) {
            dialog.getWindow().setLayout(-1, -2);
        } else {
            dialog.getWindow().setLayout(-1, (int)ResolutionUtils.convertDpToPixel((float)324.0f, (Context)BasicConfig.getInstance().getAppContext()));
        }
        dialog.getWindow().clearFlags(2);
        return dialog;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        try {
            this.rootView = inflater.inflate(R.layout.dialog_liveroom_shops, container);
        }
        catch (Throwable throwable) {
            MLog.error((Object)"ShopsComponent", (String)throwable.getMessage(), (Object[])new Object[0]);
            return null;
        }
        this.mDatas = new ArrayList<BusinessGoodsInfo>();
        if (ICoreManagerBase.getCore(IBusinessCore.class) != null) {
            if (((IBusinessCore)ICoreManagerBase.getCore(IBusinessCore.class)).getGoodsCacheInfosCount() > 0) {
                HashMap maps = ((IBusinessCore)ICoreManagerBase.getCore(IBusinessCore.class)).getGoodsCacheInfos();
                for (String key : maps.keySet()) {
                    this.mDatas.add((BusinessGoodsInfo)maps.get(key));
                }
                this.setListView();
            } else {
                ((IBusinessCore)ICoreManagerBase.getCore(IBusinessCore.class)).requestShelvesList(LoginUtil.getUid(), 2);
            }
        }
        this.channelLinkCore = (IChannelLinkCore)ICoreManagerBase.getCore(IChannelLinkCore.class);
        return this.rootView;
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.bookButtonClickListener != null) {
            this.bookButtonClickListener = null;
        }
        ShopsComponentUIShow = false;
    }

    private void setListView() {
        this.shelvesAdapter = new ShelvesAdapter(this.getContext(), this.mDatas, this.isLandspace);
        this.shelvesAdapter.setClickListenerWeakReference(this.bookButtonClickListener);
        this.shopsList = (ListView)this.rootView.findViewById(R.id.shops_list);
        if (this.isLandspace) {
            this.shopsList.setVisibility(8);
            this.shopsListLandspace = new HListView(this.getContext());
            this.shopsListLandspace.setOverScrollMode(2);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
            layoutParams.height = (int)ResolutionUtils.convertDpToPixel((float)126.0f, (Context)BasicConfig.getInstance().getAppContext());
            ((ViewGroup)this.rootView).addView((View)this.shopsListLandspace, (ViewGroup.LayoutParams)layoutParams);
            this.shopsListLandspace.setAdapter((ListAdapter)this.shelvesAdapter);
        } else {
            this.shopsList.setAdapter((ListAdapter)this.shelvesAdapter);
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onReceiveShelvesList(IBusinessClient_onReceiveShelvesList_EventArgs busEventArgs) {
        List list2 = busEventArgs.mList;
        long total = busEventArgs.mTotal;
        if (list2.size() > 0) {
            this.mDatas = list2;
            this.setListView();
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onReceiveAnchorSubscribeResult(IBusinessClient_onReceiveAnchorSubscribeResult_EventArgs busEventArgs) {
        int code = busEventArgs.mCode;
        int operate = busEventArgs.mOperate;
        int mallType = busEventArgs.mMallType;
        String itemId = busEventArgs.mItemId;
        long leftTime = busEventArgs.mLeftTime;
        this.dismissAllowingStateLoss();
        if (code == 1) {
            BusinessGoodsInfo info = ((IBusinessCore)ICoreManagerBase.getCore(IBusinessCore.class)).queryLiveRoomGoodsByCache(mallType, itemId);
            if (operate == 1) {
                if (info != null) {
                    info.isRecommending = true;
                }
                ((IBusinessCore)ICoreManagerBase.getCore(IBusinessCore.class)).updateTimer(mallType, itemId, leftTime);
                Toast.makeText((Context)this.getContext(), (CharSequence)"\u63a8\u8350\u6210\u529f", (int)0).show();
            } else if (operate == 0) {
                if (info != null) {
                    info.isRecommending = false;
                }
                Toast.makeText((Context)this.getContext(), (CharSequence)"\u64a4\u9500\u63a8\u8350\u6210\u529f", (int)0).show();
            }
            if (this.shelvesAdapter != null) {
                this.shelvesAdapter.notifyDataSetChanged();
            }
        } else {
            Toast.makeText((Context)this.getContext(), (CharSequence)"\u8bf7\u4e0d\u8981\u9891\u7e41\u64cd\u4f5c", (int)0).show();
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void onTimerEnd(IBusinessClient_onTimerEnd_EventArgs busEventArgs) {
        if (this.shelvesAdapter != null) {
            this.shelvesAdapter.notifyDataSetChanged();
            if (this.isLandspace) {
                this.shopsListLandspace.invalidate();
            } else {
                this.shopsList.invalidate();
            }
        }
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mShopsComponentSniperEventBinder == null) {
            this.mShopsComponentSniperEventBinder = new ShopsComponent$$EventBinder();
        }
        this.mShopsComponentSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mShopsComponentSniperEventBinder != null) {
            this.mShopsComponentSniperEventBinder.unBindEvent();
        }
    }
}

