/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mobilelive.smallvideo.player;

import android.app.Activity;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.request.target.SizeReadyCallback;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.target.ViewTarget;
import com.bumptech.glide.request.transition.Transition;
import com.yy.mobile.sdkwrapper.player.vod.PlayerCallback;
import com.yy.mobile.sdkwrapper.player.vod.PlayerPlayInfo;
import com.yy.mobile.sdkwrapper.player.vod.SimplePlayerCallback;
import com.yy.mobile.ui.mobilelive.smallvideo.bean.SmallVideoInfo;
import com.yy.mobile.ui.mobilelive.smallvideo.livestatus.SmallVideoLiveStatusPresenter;
import com.yy.mobile.ui.mobilelive.smallvideo.player.Size;
import com.yy.mobile.ui.mobilelive.smallvideo.player.SmallVideoPlayerPresenter;
import com.yy.mobile.ui.mobilelive.smallvideo.player.SmallVideoPlayerPresenterImpl;
import com.yy.mobile.ui.mobilelive.smallvideo.player.SmallVideoPlayerUI;
import com.yy.mobile.ui.mobilelive.smallvideo.player.SnapshotTarget;
import com.yy.mobile.ui.mobilelive.smallvideo.programinfo.SmallVideoProgramInfoUI;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.widget.SlideDirection;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB0\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012!\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u001f\u0010\u0014\u001a\u00020\u00132\u0014\b\u0004\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00130\u0005H\u0082\bJ\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\nH\u0002J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0006H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R)\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/yy/mobile/ui/mobilelive/smallvideo/player/SmallVideoPlayerPresenterImpl;", "Lcom/yy/mobile/ui/mobilelive/smallvideo/player/SmallVideoPlayerPresenter;", "ui", "Lcom/yy/mobile/ui/mobilelive/smallvideo/player/SmallVideoPlayerUI;", "fetchVideoInfo", "Lkotlin/Function1;", "Lcom/yy/mobile/widget/SlideDirection;", "Lkotlin/ParameterName;", "name", "direction", "Lcom/yy/mobile/ui/mobilelive/smallvideo/bean/SmallVideoInfo;", "(Lcom/yy/mobile/ui/mobilelive/smallvideo/player/SmallVideoPlayerUI;Lkotlin/jvm/functions/Function1;)V", "expectPlaying", "", "hideSnapshotDis", "Lio/reactivex/disposables/Disposable;", "liveStatus", "Lcom/yy/mobile/ui/mobilelive/smallvideo/livestatus/SmallVideoLiveStatusPresenter;", "completeVisible", "", "getPlayerSize", "onLayoutFinish", "Lcom/yy/mobile/ui/mobilelive/smallvideo/player/Size;", "invisible", "onDestroy", "onPause", "onResume", "preload", "showSnapshot", "videoInfo", "startVisible", "Companion", "pluginunionlive_release"})
public class SmallVideoPlayerPresenterImpl
implements SmallVideoPlayerPresenter {
    public boolean expectPlaying;
    private SmallVideoLiveStatusPresenter liveStatus;
    public Disposable hideSnapshotDis;
    public final SmallVideoPlayerUI ui;
    private final Function1<SlideDirection, SmallVideoInfo> fetchVideoInfo;
    public static final Companion Companion = new Companion(null);

    @Override
    public void onPause() {
        MLog.info((Object)"YvesSmallVideoPresenter", (String)("pause, expectPlaying = " + this.expectPlaying + '.'), (Object[])new Object[0]);
        if (this.expectPlaying) {
            this.ui.getVideoPlayer().pausePlayer();
        }
    }

    @Override
    public void onResume() {
        MLog.info((Object)"YvesSmallVideoPresenter", (String)("resume, expectPlaying = " + this.expectPlaying + '.'), (Object[])new Object[0]);
        if (this.expectPlaying) {
            this.ui.getVideoPlayer().resumePlayer();
        }
    }

    @Override
    public void onDestroy() {
        block2: {
            MLog.info((Object)"YvesSmallVideoPresenter", (String)"destroy, releasePlayer.", (Object[])new Object[0]);
            if (this.expectPlaying) {
                this.ui.getVideoPlayer().stopPlayer();
                this.expectPlaying = false;
            }
            this.ui.getVideoPlayer().releasePlayer();
            Disposable disposable2 = this.hideSnapshotDis;
            if (disposable2 != null) {
                disposable2.dispose();
            }
            SmallVideoLiveStatusPresenter smallVideoLiveStatusPresenter = this.liveStatus;
            if (smallVideoLiveStatusPresenter == null) break block2;
            smallVideoLiveStatusPresenter.onEventUnBind();
        }
    }

    public void startVisible(@NotNull SlideDirection direction) {
        Intrinsics.checkParameterIsNotNull((Object)direction, (String)"direction");
        Activity activity = this.ui.getActivity();
        if (activity == null) {
            return;
        }
        Activity ctx = activity;
        SmallVideoInfo info = (SmallVideoInfo)this.fetchVideoInfo.invoke((Object)direction);
        MLog.info((Object)"YvesSmallVideoPresenter", (String)("startVisible direction = " + direction + ", videoInfo = " + info + '.'), (Object[])new Object[0]);
        this.ui.getSeekBar().setProgress(0);
        this.ui.getDescTextView().setText((CharSequence)info.getDesc());
        SmallVideoProgramInfoUI smallVideoProgramInfoUI = this.ui.getProgramInfoUI();
        if (smallVideoProgramInfoUI != null) {
            smallVideoProgramInfoUI.updateUser(info.getAnchorUid());
        }
        View $this$visible$iv = this.ui.getLoadingView();
        boolean $i$f$visible = false;
        View view = $this$visible$iv;
        boolean bl = false;
        boolean bl2 = false;
        View $this$apply$iv = view;
        boolean bl3 = false;
        View $this$isVisible$iv$iv = $this$apply$iv;
        boolean $i$f$isVisible = false;
        if (!($this$isVisible$iv$iv.getVisibility() == 0)) {
            $this$apply$iv.setVisibility(0);
        }
        this.showSnapshot(info);
        SmallVideoLiveStatusPresenter smallVideoLiveStatusPresenter = this.liveStatus;
        if (smallVideoLiveStatusPresenter == null) {
            SmallVideoLiveStatusPresenter smallVideoLiveStatusPresenter2 = new SmallVideoLiveStatusPresenter(ctx, this.ui.getLiveStatusBtn());
            boolean bl4 = false;
            bl = false;
            SmallVideoLiveStatusPresenter it = smallVideoLiveStatusPresenter2;
            boolean bl5 = false;
            this.liveStatus = it;
            smallVideoLiveStatusPresenter = smallVideoLiveStatusPresenter2;
        }
        SmallVideoLiveStatusPresenter liveStatusPresenter = smallVideoLiveStatusPresenter;
        liveStatusPresenter.updateUser(info.getAnchorUid());
    }

    public void completeVisible(@NotNull SlideDirection direction) {
        Intrinsics.checkParameterIsNotNull((Object)direction, (String)"direction");
        SmallVideoInfo info = (SmallVideoInfo)this.fetchVideoInfo.invoke((Object)direction);
        MLog.info((Object)"YvesSmallVideoPresenter", (String)("onCompleteVisible direction = " + direction + ", info = " + info), (Object[])new Object[0]);
        PlayerPlayInfo playerInfo = new PlayerPlayInfo();
        playerInfo.mPlayUrl = info.getResUrl();
        Object object = info.getResId();
        playerInfo.mResId = object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : 0L;
        playerInfo.mOwnerId = info.getAnchorUid();
        MLog.info((Object)"YvesSmallVideoPresenter", (String)("snapshot = " + this.ui.getSnapshotImageView().getDrawable() + ' ' + "width = " + this.ui.getSnapshotImageView().getWidth() + ' ' + "height = " + this.ui.getSnapshotImageView().getHeight() + ' '), (Object[])new Object[0]);
        this.ui.getVideoPlayer().play(playerInfo);
        this.ui.getVideoPlayer().setPlayerCallback((PlayerCallback)new SimplePlayerCallback(this, info, playerInfo){
            final /* synthetic */ SmallVideoPlayerPresenterImpl this$0;
            final /* synthetic */ SmallVideoInfo $info;
            final /* synthetic */ PlayerPlayInfo $playerInfo;

            public void onVideoPlaying() {
                if (this.this$0.expectPlaying) {
                    MLog.info((Object)"YvesSmallVideoPresenter", (String)"onVideoPlayerStart", (Object[])new Object[0]);
                    View $this$gone$iv = this.this$0.ui.getLoadingView();
                    boolean $i$f$gone = false;
                    View view = $this$gone$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    View $this$apply$iv = view;
                    boolean bl3 = false;
                    View $this$isGone$iv$iv = $this$apply$iv;
                    boolean $i$f$isGone = false;
                    if (!($this$isGone$iv$iv.getVisibility() == 8)) {
                        $this$apply$iv.setVisibility(8);
                    }
                    Disposable disposable2 = this.this$0.hideSnapshotDis;
                    if (disposable2 != null) {
                        disposable2.dispose();
                    }
                    this.this$0.hideSnapshotDis = AndroidSchedulers.mainThread().scheduleDirect(new Runnable(this){
                        final /* synthetic */ completeVisible.1 this$0;

                        public final void run() {
                            View $this$gone$iv = (View)this.this$0.this$0.ui.getSnapshotImageView();
                            boolean $i$f$gone = false;
                            View view = $this$gone$iv;
                            boolean bl = false;
                            boolean bl2 = false;
                            View $this$apply$iv = view;
                            boolean bl3 = false;
                            View $this$isGone$iv$iv = $this$apply$iv;
                            boolean $i$f$isGone = false;
                            if (!($this$isGone$iv$iv.getVisibility() == 8)) {
                                $this$apply$iv.setVisibility(8);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }, 500L, TimeUnit.MILLISECONDS);
                    this.this$0.ui.getSeekBar().setProgress(0);
                }
            }

            public void onPlayEnd() {
                if (this.this$0.expectPlaying) {
                    MLog.info((Object)"YvesSmallVideoPresenter", (String)"onPlayEnd, replay.", (Object[])new Object[0]);
                    this.this$0.showSnapshot(this.$info);
                    View $this$visible$iv = this.this$0.ui.getLoadingView();
                    boolean $i$f$visible = false;
                    View view = $this$visible$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    View $this$apply$iv = view;
                    boolean bl3 = false;
                    View $this$isVisible$iv$iv = $this$apply$iv;
                    boolean $i$f$isVisible = false;
                    if (!($this$isVisible$iv$iv.getVisibility() == 0)) {
                        $this$apply$iv.setVisibility(0);
                    }
                    this.this$0.ui.getVideoPlayer().play(this.$playerInfo);
                    this.this$0.ui.getSeekBar().setProgress(0);
                }
            }

            public void onError(int errorCode) {
                if (this.this$0.expectPlaying) {
                    View $this$gone$iv = this.this$0.ui.getLoadingView();
                    boolean $i$f$gone = false;
                    View view = $this$gone$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    View $this$apply$iv = view;
                    boolean bl3 = false;
                    View $this$isGone$iv$iv = $this$apply$iv;
                    boolean $i$f$isGone = false;
                    if (!($this$isGone$iv$iv.getVisibility() == 8)) {
                        $this$apply$iv.setVisibility(8);
                    }
                    int n = errorCode;
                    if (0 <= n && 9 >= n) {
                        SingleToastUtil.showToast((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u64ad\u653e\u5931\u8d25!");
                    } else {
                        SingleToastUtil.showToast((String)"\u89c6\u9891\u64ad\u653e\u5f02\u5e38!");
                    }
                    MLog.error((Object)"YvesSmallVideoPresenter", (String)("player error code = " + errorCode + '.'), (Object[])new Object[0]);
                }
            }

            public void onProgressUpdate(int totalLength, int playProgress) {
                if (this.this$0.expectPlaying) {
                    this.this$0.ui.getSeekBar().setProgress((int)((float)playProgress * 100.0f / (float)totalLength));
                }
            }
            {
                this.this$0 = $outer;
                this.$info = $captured_local_variable$1;
                this.$playerInfo = $captured_local_variable$2;
            }
        });
        this.expectPlaying = true;
    }

    public final void showSnapshot(SmallVideoInfo videoInfo) {
        SmallVideoPlayerPresenterImpl this_$iv = this;
        boolean $i$f$getPlayerSize = false;
        ViewTarget<View, Drawable> target$iv = new ViewTarget<View, Drawable>(this_$iv, (View)this_$iv.ui.getVideoPlayer()){
            final /* synthetic */ SmallVideoPlayerPresenterImpl this$0;

            public void onResourceReady(@NotNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        target$iv.getSize(new SizeReadyCallback(this, videoInfo){
            final /* synthetic */ SmallVideoPlayerPresenterImpl this$0;
            final /* synthetic */ SmallVideoInfo $videoInfo$inlined;
            {
                this.this$0 = smallVideoPlayerPresenterImpl;
                this.$videoInfo$inlined = smallVideoInfo;
            }

            public final void onSizeReady(int width, int height) {
                Size size = new Size(width, height);
                boolean bl = false;
                Glide.with((View)((View)this.this$0.ui.getSnapshotImageView())).load(this.$videoInfo$inlined.getSnapshot()).into((Target)new SnapshotTarget(this.this$0.ui.getSnapshotImageView(), this.$videoInfo$inlined.getFinalDpi(), size));
            }
        });
    }

    public void invisible(@NotNull SlideDirection direction) {
        Intrinsics.checkParameterIsNotNull((Object)direction, (String)"direction");
        if (this.expectPlaying) {
            MLog.info((Object)"YvesSmallVideoPresenter", (String)("invisible direction = " + direction + ", stopPlay."), (Object[])new Object[0]);
            this.ui.getVideoPlayer().stopPlayer();
            this.expectPlaying = false;
        }
    }

    public void preload(@NotNull SlideDirection direction) {
        Intrinsics.checkParameterIsNotNull((Object)direction, (String)"direction");
        ImageView view = this.ui.getSnapshotImageView();
        SmallVideoInfo preloadInfo = (SmallVideoInfo)this.fetchVideoInfo.invoke((Object)direction);
        SmallVideoPlayerPresenterImpl this_$iv = this;
        boolean $i$f$getPlayerSize = false;
        ViewTarget<View, Drawable> target$iv = new /* invalid duplicate definition of identical inner class */;
        target$iv.getSize(new SizeReadyCallback(view, preloadInfo){
            final /* synthetic */ ImageView $view$inlined;
            final /* synthetic */ SmallVideoInfo $preloadInfo$inlined;
            {
                this.$view$inlined = imageView;
                this.$preloadInfo$inlined = smallVideoInfo;
            }

            public final void onSizeReady(int width, int height) {
                Size size = new Size(width, height);
                boolean bl = false;
                SnapshotTarget viewTarget = new SnapshotTarget(this.$view$inlined, this.$preloadInfo$inlined.getFinalDpi(), size);
                int width2 = viewTarget.getPendingWidth();
                int height2 = viewTarget.getPendingHeight();
                RequestBuilder requestBuilder = Glide.with((View)((View)this.$view$inlined)).load(this.$preloadInfo$inlined.getSnapshot());
                Intrinsics.checkExpressionValueIsNotNull((Object)requestBuilder, (String)"Glide.with(view).load(preloadInfo.snapshot)");
                RequestBuilder requestBuilder2 = requestBuilder;
                if (width2 > 0 && height2 > 0) {
                    requestBuilder2.preload(width2, height2);
                } else {
                    requestBuilder2.preload();
                }
            }
        });
    }

    private final void getPlayerSize(Function1<? super Size, Unit> onLayoutFinish) {
        int $i$f$getPlayerSize = 0;
        ViewTarget<View, Drawable> target2 = new /* invalid duplicate definition of identical inner class */;
        target2.getSize(new SizeReadyCallback(onLayoutFinish){
            final /* synthetic */ Function1 $onLayoutFinish;

            public final void onSizeReady(int width, int height) {
                this.$onLayoutFinish.invoke((Object)new Size(width, height));
            }
            {
                this.$onLayoutFinish = function1;
            }
        });
    }

    public SmallVideoPlayerPresenterImpl(@NotNull SmallVideoPlayerUI ui, @NotNull Function1<? super SlideDirection, SmallVideoInfo> fetchVideoInfo) {
        Intrinsics.checkParameterIsNotNull((Object)ui, (String)"ui");
        Intrinsics.checkParameterIsNotNull(fetchVideoInfo, (String)"fetchVideoInfo");
        this.ui = ui;
        this.fetchVideoInfo = fetchVideoInfo;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/mobile/ui/mobilelive/smallvideo/player/SmallVideoPlayerPresenterImpl$Companion;", "", "()V", "TAG", "", "pluginunionlive_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

