/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mobilelive.replay.util;

import android.graphics.Bitmap;
import android.os.Environment;
import com.yy.mobile.ui.mobilelive.replay.bean.ReplayUrlInfo;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReplayUtil {
    public static List<ReplayUrlInfo> parseReplayMapToList(List<Map<String, String>> replayUrlMapInList, String progamId) {
        MLog.info((Object)"ReplayUtil", (String)("[parseReplayUrlToBean] size =" + replayUrlMapInList.size()), (Object[])new Object[0]);
        try {
            ArrayList<ReplayUrlInfo> list2 = new ArrayList<ReplayUrlInfo>();
            for (int i = 0; i < replayUrlMapInList.size(); ++i) {
                String filePath;
                ReplayUrlInfo replayUrlInfo = new ReplayUrlInfo();
                Map<String, String> info = replayUrlMapInList.get(i);
                if (info.containsKey("cid")) {
                    replayUrlInfo.cid = Long.valueOf(info.get("cid"));
                }
                if (info.containsKey("sid")) {
                    replayUrlInfo.sid = Long.valueOf(info.get("sid"));
                }
                if (info.containsKey("t_begin")) {
                    replayUrlInfo.absoluteStartTime = Long.valueOf(info.get("t_begin"));
                }
                if (info.containsKey("flowflag")) {
                    replayUrlInfo.replayProtocolType = Integer.valueOf(info.get("flowflag"));
                }
                if (info.containsKey("ex_viewer") && info.containsKey("ex_record_viewer")) {
                    replayUrlInfo.viewCount = Long.valueOf(info.get("ex_viewer")) + Long.valueOf(info.get("ex_record_viewer"));
                }
                if (info.containsKey("true_uid")) {
                    replayUrlInfo.trueUid = Long.valueOf(info.get("true_uid"));
                }
                if (info.containsKey("uid")) {
                    replayUrlInfo.mOwnerId = Long.valueOf(info.get("uid"));
                }
                if (info.containsKey("store_reason")) {
                    replayUrlInfo.storeReason = info.get("store_reason");
                }
                replayUrlInfo.mPlayUrl = info.get("video_url");
                replayUrlInfo.programId = info.containsKey("live_id") ? info.get("live_id") : progamId;
                if (info.containsKey("title")) {
                    replayUrlInfo.replayTitle = String.valueOf(info.get("title"));
                }
                replayUrlInfo.isVRPlay = info.get("vr") != null && info.get("vr").equals("1");
                if (replayUrlInfo.isVRPlay && info.containsKey("vr_pids") && !StringUtils.isEmptyString((String)(filePath = ReplayUtil.get1200KpsVideoPlayUrl(info.get("vr_pids"))))) {
                    replayUrlInfo.mPlayUrl = filePath;
                }
                list2.add(replayUrlInfo);
            }
            return list2;
        }
        catch (Throwable throwable) {
            MLog.error((Object)"ReplayUtil", (String)("ex =" + throwable), (Object[])new Object[0]);
            return null;
        }
    }

    private static String get1200KpsVideoPlayUrl(String jsonArray) {
        String ret = "";
        if (StringUtils.isEmptyString((String)jsonArray)) {
            MLog.info((Object)"ReplayUtil", (String)"get1200KpsVideoPlayUrl jsonArray is empty", (Object[])new Object[0]);
            return ret;
        }
        try {
            JSONArray array = new JSONArray(jsonArray);
            int length = array.length();
            MLog.info((Object)"ReplayUtil", (String)"get1200KpsVideoPlayUrl array.length():%d", (Object[])new Object[]{length});
            for (int i = 0; i < length; ++i) {
                JSONObject object = array.getJSONObject(i);
                int kps = object.getInt("kps");
                MLog.info((Object)"ReplayUtil", (String)"get1200KpsVideoPlayUrl i:%d, kps:%d", (Object[])new Object[]{i, kps});
                if (kps != 1200) continue;
                ret = object.getString("url");
                break;
            }
        }
        catch (Exception e) {
            MLog.info((Object)"ReplayUtil", (String)"get1200KpsVideoPlayUrl exception, jsonArray:%s, exception:%s", (Object[])new Object[]{jsonArray, e.toString()});
        }
        MLog.info((Object)"ReplayUtil", (String)"get1200KpsVideoPlayUrl ret:%s", (Object[])new Object[]{ret});
        return ret;
    }

    public static boolean saveBitmapToSdCard(Bitmap desBitmap, String filePath) {
        MLog.info((Object)"ReplayUtil", (String)("[saveBitmapToSdCard],filePath:" + filePath), (Object[])new Object[0]);
        if (desBitmap == null) {
            MLog.info((Object)"ReplayUtil", (String)"[saveBitmapToSdCard],bitmap == null", (Object[])new Object[0]);
            return false;
        }
        boolean result = false;
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        } else {
            try {
                FileOutputStream fileOutputStream = null;
                if (Environment.getExternalStorageState().equals("mounted")) {
                    fileOutputStream = new FileOutputStream(file);
                    desBitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    result = true;
                } else {
                    MLog.error((Object)"ReplayUtil", (String)"[saveBitmapToSdCard] can not find sdcard!", (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                MLog.error((Object)"ReplayUtil", (Throwable)e);
            }
        }
        return result;
    }
}

