/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mobilelive.replay;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.BasePluginEntLiveActivity;
import com.yy.mobile.ui.LiveNavigationUtils;
import com.yy.mobile.ui.mobilelive.clipviewpager.ClipViewPager;
import com.yy.mobile.ui.widget.autoscrollviewpager.RecyclingPagerAdapter;
import com.yy.mobile.util.FP;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.mobilelive.LeaveReplayInfo;
import com.yymobile.core.mobilelive.MobileLiveConstant;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.ArrayList;
import java.util.List;

public class LeaveReplayAdapter
extends RecyclingPagerAdapter {
    private final List<LeaveReplayInfo.LeaveReplayPageInfo> mDataList = new ArrayList<LeaveReplayInfo.LeaveReplayPageInfo>();
    public final Context mContext;
    public final ClipViewPager mViewPager;
    public int mReplayType;
    private String mAnchorName;

    public LeaveReplayAdapter(Context context, ClipViewPager viewPager) {
        this.mContext = context;
        this.mViewPager = viewPager;
    }

    public void setData(List<LeaveReplayInfo.LeaveReplayPageInfo> liveList) {
        if (FP.empty(liveList)) {
            return;
        }
        this.mDataList.clear();
        this.mDataList.addAll(liveList);
        this.notifyDataSetChanged();
    }

    public void setReplayType(int type) {
        this.mReplayType = type;
    }

    public void setReplayAnchorName(String anchor) {
        this.mAnchorName = anchor;
    }

    public void clearData() {
        this.mDataList.clear();
        this.notifyDataSetChanged();
    }

    public void addAll(List<LeaveReplayInfo.LeaveReplayPageInfo> list2) {
        this.mDataList.addAll(list2);
        this.notifyDataSetChanged();
    }

    private String getCountString(int count) {
        if (count <= 0) {
            return "0";
        }
        if (count > 9990000) {
            return "999W+";
        }
        if (count >= 10000) {
            return this.mContext.getResources().getString(R.string.mobile_live_leave_replay_audience_format, new Object[]{Float.valueOf((float)count / 10000.0f)});
        }
        return String.valueOf(count);
    }

    public View getView(int position, View convertView, ViewGroup container) {
        LeaveReplayInfoHolder leaveReplayInfoHolder = null;
        if (convertView == null) {
            leaveReplayInfoHolder = new LeaveReplayInfoHolder();
            convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_leave_replay_adapter, null);
            leaveReplayInfoHolder.viewContainer = (LinearLayout)convertView.findViewById(R.id.leave_replay_container);
            leaveReplayInfoHolder.replayImg = (RecycleImageView)convertView.findViewById(R.id.imgReplay);
            leaveReplayInfoHolder.imgLayout = (RelativeLayout)convertView.findViewById(R.id.image_layout);
            leaveReplayInfoHolder.tvTitle = (TextView)convertView.findViewById(R.id.tv_replayTitle);
            leaveReplayInfoHolder.tvNum = (TextView)convertView.findViewById(R.id.tv_replayNum);
            convertView.setTag((Object)leaveReplayInfoHolder);
        } else {
            leaveReplayInfoHolder = (LeaveReplayInfoHolder)convertView.getTag();
        }
        final LeaveReplayInfo.LeaveReplayPageInfo replayInfo = this.mDataList.get(position);
        if (replayInfo != null) {
            if (replayInfo.title != null && replayInfo.title.length() > 0) {
                leaveReplayInfoHolder.tvTitle.setText((CharSequence)replayInfo.title);
            } else if (this.mAnchorName != null && this.mAnchorName.length() > 0) {
                leaveReplayInfoHolder.tvTitle.setText((CharSequence)(this.mAnchorName + "\u6b63\u5728\u76f4\u64ad"));
            } else {
                leaveReplayInfoHolder.tvTitle.setText((CharSequence)"\u624b\u673aYY\u65b0\u4eba\u6b63\u5728\u76f4\u64ad");
            }
            leaveReplayInfoHolder.tvNum.setText((CharSequence)(this.getCountString(replayInfo.recordViewer + replayInfo.guestCount) + "\u64ad\u653e"));
            ImageLoader.loadImage((String)replayInfo.imageUrl, (RecycleImageView)leaveReplayInfoHolder.replayImg, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_mob_live_drawable);
            leaveReplayInfoHolder.imgLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (LeaveReplayAdapter.this.mViewPager.isChangeCurrentItem().booleanValue()) {
                        return;
                    }
                    if (LeaveReplayAdapter.this.mReplayType == 1) {
                        ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50402", "0003");
                    } else {
                        ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50402", "0009");
                    }
                    ((BasePluginEntLiveActivity)LeaveReplayAdapter.this.mContext).finish();
                    LiveNavigationUtils.toMobileLiveReplayWithTitle(LeaveReplayAdapter.this.mContext, replayInfo.liveId, replayInfo.anchorUid, replayInfo.videoUrl, replayInfo.imageUrl, replayInfo.title, MobileLiveConstant.TO_MOBILE_LIVE_REPLAY_PATH_BY_LEAVE);
                }
            });
        }
        return convertView;
    }

    public int getCount() {
        return this.mDataList.size();
    }

    private static class LeaveReplayInfoHolder {
        LinearLayout viewContainer;
        RecycleImageView replayImg;
        TextView tvTitle;
        TextView tvNum;
        RelativeLayout imgLayout;

        private LeaveReplayInfoHolder() {
        }
    }
}

