/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mobilelive;

import android.content.Context;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import com.yy.mobile.memoryrecycle.views.YYRelativeLayout;

public class ReplayTouchPlayerRelativeLayout
extends YYRelativeLayout {
    private float mDownX;
    private float mDownY;
    private ClickListener mClickListener;

    public ReplayTouchPlayerRelativeLayout(@NonNull Context context) {
        super(context);
    }

    public ReplayTouchPlayerRelativeLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ReplayTouchPlayerRelativeLayout(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setClickListener(ClickListener clickListener) {
        this.mClickListener = clickListener;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.mDownX = ev.getX();
                this.mDownY = ev.getY();
                break;
            }
            case 1: {
                float upX = ev.getX();
                float upY = ev.getY();
                float dis = this.calculateDistance(upX, upY, this.mDownX, this.mDownY);
                if (this.mClickListener == null || !(dis <= (float)ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop())) break;
                this.mClickListener.onClick();
                break;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private float calculateDistance(float x2, float y2, float x1, float y1) {
        float dx = Math.abs(x2 - x1);
        float dy = Math.abs(y2 - y1);
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public static interface ClickListener {
        public void onClick();
    }
}

