/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mobilelive;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.PressedRecycleImageView;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.BasePluginEntLiveActivity;
import com.yy.mobile.ui.LiveNavigationUtils;
import com.yy.mobile.util.FP;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.mobilelive.AnchorReplayInfo;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.mobilelive.MobileLiveConstant;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.ArrayList;
import java.util.List;

public class AnchorReplayAdapter
extends BaseAdapter {
    public Context mContext;
    private DoubleItemViewHolder holder;
    private List<AnchorReplayDoubleItemInfo> mData = new ArrayList<AnchorReplayDoubleItemInfo>();
    private List<AnchorReplayInfo.AnchorReplayPageInfo> mLiveList = new ArrayList<AnchorReplayInfo.AnchorReplayPageInfo>();

    public AnchorReplayAdapter(Context context) {
        this.mContext = context;
    }

    public int getCount() {
        return this.mData.size();
    }

    public AnchorReplayDoubleItemInfo getItem(int position) {
        return this.mData.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public String formatCount(int count) {
        return count < 100000 ? String.valueOf(count) : String.valueOf(count / 10000) + "W";
    }

    public void parseDoubleItemData() {
        if (FP.empty(this.mLiveList)) {
            return;
        }
        AnchorReplayDoubleItemInfo itemInfo = null;
        int nSize = this.mLiveList.size();
        if (nSize % 2 == 0) {
            for (int i = 0; i < nSize - 1; i += 2) {
                itemInfo = new AnchorReplayDoubleItemInfo();
                itemInfo.setLeftData(this.mLiveList.get(i));
                itemInfo.setRightData(this.mLiveList.get(i + 1));
                this.mData.add(itemInfo);
            }
        } else {
            for (int i = 0; i < nSize - 1; i += 2) {
                itemInfo = new AnchorReplayDoubleItemInfo();
                itemInfo.setLeftData(this.mLiveList.get(i));
                itemInfo.setRightData(this.mLiveList.get(i + 1));
                this.mData.add(itemInfo);
            }
            itemInfo = new AnchorReplayDoubleItemInfo();
            itemInfo.setLeftData(this.mLiveList.get(nSize - 1));
            this.mData.add(itemInfo);
        }
    }

    public void setData(List<AnchorReplayInfo.AnchorReplayPageInfo> liveList, boolean clear2) {
        if (FP.empty(liveList)) {
            return;
        }
        if (clear2) {
            this.mLiveList.clear();
        }
        this.mData.clear();
        this.mLiveList.addAll(liveList);
        this.parseDoubleItemData();
        this.notifyDataSetChanged();
    }

    public void clearData() {
        this.mData.clear();
        this.parseDoubleItemData();
        this.notifyDataSetChanged();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_anchor_replay_adapter, parent, false);
            this.holder = new DoubleItemViewHolder();
            this.holder.left.container = convertView.findViewById(R.id.mobile_replay_container_left);
            this.holder.left.thumb = (PressedRecycleImageView)convertView.findViewById(R.id.mob_lvbc_thumb_l);
            this.holder.left.liveDesc = (TextView)convertView.findViewById(R.id.mob_lvbc_replaydesc_l);
            this.holder.left.totalWatch = (TextView)convertView.findViewById(R.id.mob_lvbc_ever_seen_l);
            this.holder.right.container = convertView.findViewById(R.id.mobile_replay_container_right);
            this.holder.right.thumb = (PressedRecycleImageView)convertView.findViewById(R.id.mob_lvbc_thumb_r);
            this.holder.right.liveDesc = (TextView)convertView.findViewById(R.id.mob_lvbc_replaydesc_r);
            this.holder.right.totalWatch = (TextView)convertView.findViewById(R.id.mob_lvbc_ever_seen_r);
            convertView.setTag((Object)this.holder);
        } else {
            this.holder = (DoubleItemViewHolder)convertView.getTag();
        }
        AnchorReplayDoubleItemInfo item2 = this.getItem(position);
        if (item2 == null) {
            return convertView;
        }
        this.setMobileLiveItemLive(position * 2, this.holder.left, item2.left);
        this.setMobileLiveItemLive(position * 2 + 1, this.holder.right, item2.right);
        return convertView;
    }

    public void setMobileLiveItemLive(int position, MobileReplaViewHolder holderItem, final AnchorReplayItemInfo info) {
        if (holderItem != null && info != null) {
            holderItem.container.setVisibility(0);
            holderItem.thumb.setVisibility(0);
            holderItem.liveDesc.setVisibility(0);
            holderItem.totalWatch.setVisibility(0);
            holderItem.totalWatch.setText((CharSequence)this.formatCount(info.recordViewer));
            holderItem.liveDesc.setText((CharSequence)info.title);
            ImageLoader.loadImage((String)info.imageUrl, (RecycleImageView)holderItem.thumb, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_mob_live_drawable);
            holderItem.container.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (!(AnchorReplayAdapter.this.mContext instanceof BasePluginEntLiveActivity) || !((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).isLoginUserMobileLive()) {
                        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1905", "0010");
                        LiveNavigationUtils.toMobileLiveReplayWithTitle(AnchorReplayAdapter.this.mContext, info.liveId, info.anchorUid, info.videoUrl, info.imageUrl, info.title, MobileLiveConstant.TO_MOBILE_LIVE_REPLAY_PATH_BY_TAB);
                    }
                }
            });
        } else if (holderItem != null) {
            holderItem.thumb.setVisibility(8);
            holderItem.liveDesc.setVisibility(8);
            holderItem.totalWatch.setVisibility(8);
            holderItem.container.setOnClickListener(null);
        }
    }

    public class AnchorReplayDoubleItemInfo {
        AnchorReplayItemInfo left = null;
        AnchorReplayItemInfo right = null;

        public void setLeftData(AnchorReplayInfo.AnchorReplayPageInfo info) {
            if (info != null) {
                this.left = new AnchorReplayItemInfo();
                this.left.liveId = info.liveId;
                this.left.imageUrl = info.imageUrl;
                this.left.recordViewer = info.recordViewer + info.guestCount;
                this.left.videoUrl = info.videoUrl;
                this.left.title = info.title;
                this.left.anchorUid = info.anchorUid;
            }
        }

        public void setRightData(AnchorReplayInfo.AnchorReplayPageInfo info) {
            if (info != null) {
                this.right = new AnchorReplayItemInfo();
                this.right.liveId = info.liveId;
                this.right.imageUrl = info.imageUrl;
                this.right.recordViewer = info.recordViewer + info.guestCount;
                this.right.videoUrl = info.videoUrl;
                this.right.title = info.title;
                this.right.anchorUid = info.anchorUid;
            }
        }
    }

    private static class AnchorReplayItemInfo {
        long anchorUid;
        int recordViewer;
        String title;
        String liveId;
        String videoUrl;
        String imageUrl;

        private AnchorReplayItemInfo() {
        }
    }

    private static class MobileReplaViewHolder {
        View container;
        PressedRecycleImageView thumb;
        TextView liveDesc;
        TextView totalWatch;

        private MobileReplaViewHolder() {
        }
    }

    private class DoubleItemViewHolder {
        MobileReplaViewHolder left = new MobileReplaViewHolder();
        MobileReplaViewHolder right = new MobileReplaViewHolder();

        DoubleItemViewHolder() {
        }
    }
}

