/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mic;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ListAdapter;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_updateCurrentChannelInfo_EventArgs;
import com.yy.mobile.plugin.main.events.IMediaClient_onQueneMicSpeakerList_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.mic.MicFreedomSpeakerAdapter;
import com.yy.mobile.ui.mic.MicFreedomSpeakerComponent$$EventBinder;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.widget.FreeMicGridView;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.media.IMediaMicFreeCore;
import com.yymobile.core.media.MicSpeaker;
import java.util.LinkedList;
import java.util.List;

public class MicFreedomSpeakerComponent
extends Component
implements EventCompat {
    protected boolean isLandscape;
    private View rootView;
    private IChannelLinkCore channelCore;
    private IMediaMicFreeCore mediaMicFreeCore;
    private GridView mFreeModeSpeakList;
    private MicFreedomSpeakerAdapter mFreeModeSpeakAdapter;
    private int screenWidth;
    private int horizontalSpacing;
    private int verticalSpacingOne;
    private int verticalSpacingTwo;
    private boolean isNewSpeakShow = false;
    private int landscapeMarginTopDistance;
    private int portraitMarginTopDistance;
    private EventBinder mMicFreedomSpeakerComponentSniperEventBinder;

    public void onEventBind() {
        if (this.mMicFreedomSpeakerComponentSniperEventBinder == null) {
            this.mMicFreedomSpeakerComponentSniperEventBinder = new MicFreedomSpeakerComponent$$EventBinder();
        }
        this.mMicFreedomSpeakerComponentSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mMicFreedomSpeakerComponentSniperEventBinder != null) {
            this.mMicFreedomSpeakerComponentSniperEventBinder.unBindEvent();
        }
    }

    public static MicFreedomSpeakerComponent newInstance() {
        MicFreedomSpeakerComponent f = new MicFreedomSpeakerComponent();
        return f;
    }

    public void setNewSpeakShow(boolean newSpeakShow) {
        this.isNewSpeakShow = newSpeakShow;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        MLog.debug((Object)"MicFreedomSpeakerComponent", (String)"onCreate", (Object[])new Object[0]);
        this.channelCore = ICoreManagerBase.getChannelLinkCore();
        this.mediaMicFreeCore = (IMediaMicFreeCore)ICoreManagerBase.getCore(IMediaMicFreeCore.class);
        this.isLandscape = this.getResources().getConfiguration().orientation == 2;
        this.verticalSpacingOne = DensityUtil.dip2px((Context)this.getActivity(), (float)30.0f);
        this.verticalSpacingTwo = DensityUtil.dip2px((Context)this.getActivity(), (float)50.0f);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        MLog.debug((Object)"MicFreedomSpeakerComponent", (String)"onCreateView", (Object[])new Object[0]);
        this.rootView = inflater.inflate(R.layout.layout_channel_video_free_speaker_grid, container, false);
        this.mFreeModeSpeakList = (FreeMicGridView)this.rootView.findViewById(R.id.lv_free_mode_speaker_list);
        this.mFreeModeSpeakAdapter = new MicFreedomSpeakerAdapter((Activity)this.getActivity());
        if (this.checkActivityValid() && this.getChannelMode() == ChannelInfo.ChannelMode.Free_Mode) {
            this.mFreeModeSpeakAdapter.setNewSpeakShow(this.isNewSpeakShow);
            this.mFreeModeSpeakAdapter.setData(this.mediaMicFreeCore.getQueneMicSpeaker());
        }
        this.mFreeModeSpeakList.setAdapter((ListAdapter)this.mFreeModeSpeakAdapter);
        return this.rootView;
    }

    private void calculateHorizontalSpacing(boolean land) {
        MLog.info((Object)"MicFreedomSpeakerComponent", (String)"calculateHorizontalSpacing screen Width = %d", (Object[])new Object[]{this.screenWidth});
        if (land) {
            this.screenWidth = this.getActivity().getWindowManager().getDefaultDisplay().getHeight();
            this.horizontalSpacing = (this.screenWidth + DensityUtil.dip2px((Context)this.getActivity(), (float)50.0f) - DensityUtil.dip2px((Context)this.getActivity(), (float)219.0f)) / 4;
        } else {
            this.screenWidth = this.getActivity().getWindowManager().getDefaultDisplay().getWidth();
            this.horizontalSpacing = (this.screenWidth - DensityUtil.dip2px((Context)this.getActivity(), (float)219.0f)) / 4;
        }
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.isNewSpeakShow) {
            this.landscapeMarginTopDistance = DensityUtil.dip2px((Context)this.getActivity(), (float)140.0f);
            this.portraitMarginTopDistance = DensityUtil.dip2px((Context)this.getActivity(), (float)60.0f);
        } else {
            this.landscapeMarginTopDistance = DensityUtil.dip2px((Context)this.getActivity(), (float)60.0f);
            this.portraitMarginTopDistance = DensityUtil.dip2px((Context)this.getActivity(), (float)150.0f);
        }
        this.calculateHorizontalSpacing(this.isLandscape);
        if (this.isLandscape) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.screenWidth + DensityUtil.dip2px((Context)this.getActivity(), (float)50.0f), DensityUtil.dip2px((Context)this.getActivity(), (float)280.0f), 49);
            layoutParams.setMargins(this.horizontalSpacing, this.landscapeMarginTopDistance, this.horizontalSpacing, 0);
            this.mFreeModeSpeakList.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mFreeModeSpeakList.setHorizontalSpacing(this.horizontalSpacing);
            this.mFreeModeSpeakList.setVerticalSpacing(this.verticalSpacingOne);
        } else {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.screenWidth - this.horizontalSpacing * 2, DensityUtil.dip2px((Context)this.getActivity(), (float)280.0f), 49);
            layoutParams.setMargins(0, this.portraitMarginTopDistance, 0, 0);
            this.mFreeModeSpeakList.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mFreeModeSpeakList.setHorizontalSpacing(this.horizontalSpacing);
            this.mFreeModeSpeakList.setVerticalSpacing(this.verticalSpacingTwo);
        }
    }

    @BusEvent(sync=true)
    public void onQueneMicSpeakerList(IMediaClient_onQueneMicSpeakerList_EventArgs busEventArgs) {
        LinkedList micInSpeakerLinkedList = busEventArgs.getMicInSpeakerLinkedList();
        if (this.checkActivityValid() && this.getChannelMode() == ChannelInfo.ChannelMode.Free_Mode) {
            if (micInSpeakerLinkedList != null) {
                MLog.info((Object)"MicFreedomSpeakerComponent", (String)"#micInSpeakerLinkedList size = %d", (Object[])new Object[]{micInSpeakerLinkedList.size()});
            }
            this.setFreeModeCurMicDate(micInSpeakerLinkedList);
        }
    }

    public void setFreeModeCurMicDate(List<MicSpeaker> listSpeaker) {
        if (this.mFreeModeSpeakAdapter == null) {
            this.mFreeModeSpeakAdapter = new MicFreedomSpeakerAdapter((Activity)this.getActivity());
        }
        if (listSpeaker != null) {
            this.mFreeModeSpeakAdapter.setNewSpeakShow(this.isNewSpeakShow);
            this.mFreeModeSpeakAdapter.setData(listSpeaker);
            MLog.info((Object)"MicFreedomSpeakerComponent", (String)("setFreeModeCurMicDate size = " + listSpeaker.size()), (Object[])new Object[0]);
        }
    }

    private ChannelInfo.ChannelMode getChannelMode() {
        if (this.channelCore.getCurrentChannelInfo() != null && this.channelCore.getCurrentChannelInfo().channelMode != null) {
            return this.channelCore.getCurrentChannelInfo().channelMode;
        }
        return ChannelInfo.ChannelMode.MicQueue_Mode;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.isLandscape = newConfig.orientation == 2;
        this.calculateHorizontalSpacing(this.isLandscape);
        if (this.isLandscape) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.screenWidth + DensityUtil.dip2px((Context)this.getActivity(), (float)50.0f), DensityUtil.dip2px((Context)this.getActivity(), (float)280.0f), 49);
            layoutParams.setMargins(this.horizontalSpacing, this.landscapeMarginTopDistance, this.horizontalSpacing, 0);
            this.mFreeModeSpeakList.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mFreeModeSpeakList.setHorizontalSpacing(this.horizontalSpacing);
            this.mFreeModeSpeakList.setVerticalSpacing(this.verticalSpacingOne);
        } else {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.screenWidth - this.horizontalSpacing * 2, DensityUtil.dip2px((Context)this.getActivity(), (float)280.0f), 49);
            layoutParams.setMargins(0, this.portraitMarginTopDistance, 0, 0);
            this.mFreeModeSpeakList.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mFreeModeSpeakList.setHorizontalSpacing(this.horizontalSpacing);
            this.mFreeModeSpeakList.setVerticalSpacing(this.verticalSpacingTwo);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mFreeModeSpeakAdapter != null) {
            this.mFreeModeSpeakAdapter.onDestroy();
            this.mFreeModeSpeakAdapter = null;
        }
    }

    @BusEvent
    public void updateCurrentChannelInfo(IChannelLinkClient_updateCurrentChannelInfo_EventArgs busEventArgs) {
        if (this.checkActivityValid() && this.getChannelMode() == ChannelInfo.ChannelMode.Free_Mode) {
            this.mFreeModeSpeakAdapter.setNewSpeakShow(this.isNewSpeakShow);
            if (this.mediaMicFreeCore.getQueneMicSpeaker() != null) {
                MLog.info((Object)"MicFreedomSpeakerComponent", (String)"#updateCurrentChannelInfo MicSpeaker Size = %d", (Object[])new Object[]{this.mediaMicFreeCore.getQueneMicSpeaker().size()});
            }
            this.mFreeModeSpeakAdapter.setData(this.mediaMicFreeCore.getQueneMicSpeaker());
        }
    }
}

