/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.meidabasicvideoview.compat.video;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.AudienceVideoView;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.videoenable.AudienceVideoEnableManager;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoid.AbsVideoId;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoid.MicNoVideoId;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoid.MixVideoId;
import com.yy.mobile.ui.autoui.AutoUIObservableSources;
import com.yy.mobile.ui.autoui.AutoUiModel;
import com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.VideoLayoutController;
import com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.layoutparser.AbsVideoLayoutParser;
import com.yy.mobile.ui.meidabasicvideoview.compat.video.IVideoViewController;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.releasemanager.ObjectReleaseBeforeInitManager;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.flowmanagement.compatiblecore.audience.VideoMixtureManager;
import com.yymobile.core.media.ILiveConfigCore;
import com.yymobile.core.media.LiveConfigType;
import java.util.List;

public class AudienceVideoViewController
implements IVideoViewController,
ObjectReleaseBeforeInitManager.ReleaseBeforeInitObject {
    private AudienceVideoView mAudienceVideoView;
    private ViewGroup mVideoParent;
    private Context mContext;
    private VideoLayoutController mVideoLayoutController;

    public AudienceVideoViewController(ViewGroup videoParent, List<AbsVideoLayoutParser> parsers) {
        this.mContext = videoParent.getContext();
        this.mVideoParent = videoParent;
        this.init(parsers);
    }

    private void init(List<AbsVideoLayoutParser> parsers) {
        this.initVideoView();
        this.mVideoLayoutController = new VideoLayoutController(this.mAudienceVideoView, parsers);
    }

    @Override
    public void switchOrientation(int orientation) {
        if (this.mVideoLayoutController != null) {
            this.mVideoLayoutController.switchOrientation(orientation);
        }
    }

    @Override
    public void setVideoEnable(boolean enable) {
        MLog.info((Object)"AudienceVideoViewController", (String)("setVideoEnable called with: enable = [" + enable + "]"), (Object[])new Object[0]);
        if (this.mAudienceVideoView != null) {
            this.mAudienceVideoView.setVideoEnable(enable);
        }
    }

    @Override
    public void onStop() {
        this.mAudienceVideoView.setVideoEnable(false);
    }

    @Override
    public void onResume() {
        if (AudienceVideoEnableManager.getInstance().isVideoEnable()) {
            this.mAudienceVideoView.setVideoEnable(true);
        } else {
            MLog.info((Object)"AudienceVideoViewController", (String)"onResume, current is not video mode, do not enable video", (Object[])new Object[0]);
        }
    }

    @Override
    public void release() {
        MLog.info((Object)"AudienceVideoViewController", (String)"release called", (Object[])new Object[0]);
        ObjectReleaseBeforeInitManager.getInstance().callRelease((ObjectReleaseBeforeInitManager.ReleaseBeforeInitObject)this);
    }

    private void innerRelease() {
        MLog.info((Object)"AudienceVideoViewController", (String)"innerRelease called", (Object[])new Object[0]);
        this.mVideoLayoutController.release();
        if (this.mAudienceVideoView != null) {
            this.mAudienceVideoView.release();
        }
    }

    @Override
    public void removeVideoView() {
        MLog.info((Object)"AudienceVideoViewController", (String)"removeVideoView called", (Object[])new Object[0]);
        if (this.mAudienceVideoView != null) {
            this.mVideoParent.removeView((View)this.mAudienceVideoView);
            this.mAudienceVideoView.release();
            this.mAudienceVideoView = null;
        }
    }

    @Override
    public void startVideo() {
        MLog.info((Object)"AudienceVideoViewController", (String)"startVideo called", (Object[])new Object[0]);
        this.innerStartVideo();
    }

    @Override
    public void initVideoView() {
        ObjectReleaseBeforeInitManager.getInstance().callInit((ObjectReleaseBeforeInitManager.ReleaseBeforeInitObject)this);
        boolean needMixture = !this.isMeAsLinkUser();
        MLog.info((Object)"AudienceVideoViewController", (String)"initVideoView , video need mixture: %b", (Object[])new Object[]{needMixture});
        VideoMixtureManager.getInstance().setVideoNeedMixture(needMixture);
        this.mAudienceVideoView = new AudienceVideoView(this.mContext);
        this.mAudienceVideoView.setZOrderMediaOverlay(false);
        this.mVideoParent.addView((View)this.mAudienceVideoView);
        this.mAudienceVideoView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                AutoUiModel mode = AutoUiModel.getAutoUiServiceForLiveActivity();
                if (mode != null && (left != oldLeft || top != oldTop || right != oldRight || bottom != oldBottom)) {
                    mode.postSelfLayout(AutoUIObservableSources.LIVE_PLAYER, v);
                }
            }
        });
        this.mAudienceVideoView.setVideoEnable(AudienceVideoEnableManager.getInstance().isVideoEnable());
        this.innerStartVideo();
    }

    private void innerStartVideo() {
        boolean needMixture = !this.isMeAsLinkUser();
        MLog.info((Object)"AudienceVideoViewController", (String)"innerStartVideo called, needMixture: %b", (Object[])new Object[]{needMixture});
        if (this.mAudienceVideoView != null) {
            this.mAudienceVideoView.start((AbsVideoId)(needMixture ? new MixVideoId() : new MicNoVideoId(0)));
        }
    }

    private boolean isMeAsLinkUser() {
        return ((ILiveConfigCore)ICoreManagerBase.getCore(ILiveConfigCore.class)).getLiveType() == LiveConfigType.LianMai;
    }

    public void onInit() {
    }

    public void onRelease() {
        MLog.info((Object)"AudienceVideoViewController", (String)"onRelease called", (Object[])new Object[0]);
        this.innerRelease();
    }

    public String getType() {
        return "AUDIENCE_VIDEO";
    }
}

