/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.meidabasicvideoview.compat.nonmixlayout.layoutparser.horizontal;

import android.content.Context;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoRect;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoScaleMode;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoSizeInfo;
import com.yy.mobile.ui.meidabasicvideoview.MediaVideoViewSite;
import com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.layoutparser.AbsVideoLayoutParser;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;

public class NormalHorizontalSingleParser
extends AbsVideoLayoutParser {
    @Override
    public String getLogTag() {
        return "NormalHorizontalSingleParser";
    }

    @Override
    public boolean intercept(VideoSizeInfo sizeInfo) {
        return !sizeInfo.isVerticalOrientation && sizeInfo.videoCount == 1;
    }

    @Override
    public VideoRect calculateVideoViewRect(Context context, VideoSizeInfo sizeInfo) {
        VideoRect videoRect = new VideoRect();
        boolean isAnchorVertical = sizeInfo.width < sizeInfo.height;
        videoRect.videoScaleMode = isAnchorVertical ? VideoScaleMode.ASPECT_FIT : VideoScaleMode.CLIP_TO_BOUNDS;
        videoRect.left = 0;
        videoRect.top = 0;
        videoRect.width = sizeInfo.parentWidth;
        videoRect.height = sizeInfo.parentHeight;
        return videoRect;
    }

    @Override
    public List<MediaVideoViewSite> calculateMediaVideoViewSiteCompat(Context context, VideoSizeInfo sizeInfo) {
        ArrayList<MediaVideoViewSite> list2 = new ArrayList<MediaVideoViewSite>();
        if (sizeInfo.videoCount == 0) {
            MLog.error((Object)"NormalHorizontalSingleParser", (String)"calculateMediaVideoViewSiteCompat: video count is zero, bug!!!", (Object[])new Object[0]);
            return list2;
        }
        MediaVideoViewSite firstVideo = this.createMediaVideoViewSite(0, 0, sizeInfo.parentWidth / sizeInfo.videoCount, sizeInfo.parentHeight, 0);
        list2.add(firstVideo);
        return list2;
    }
}

