/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.meidabasicvideoview.compat.nonmixlayout.layoutparser.horizontal;

import android.content.Context;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoRect;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoScaleMode;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoSizeInfo;
import com.yy.mobile.ui.meidabasicvideoview.MediaVideoViewSite;
import com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.layoutparser.AbsVideoLayoutParser;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;

public class NormalHorizontal1v1Parser
extends AbsVideoLayoutParser {
    @Override
    public String getLogTag() {
        return "NormalHorizontal1v1Parser";
    }

    @Override
    public boolean intercept(VideoSizeInfo sizeInfo) {
        return !sizeInfo.isVerticalOrientation && sizeInfo.videoCount == 2;
    }

    @Override
    public VideoRect calculateVideoViewRect(Context context, VideoSizeInfo sizeInfo) {
        boolean isFirstMic = sizeInfo.micNo == 0;
        int halfWidth = sizeInfo.parentWidth / 2;
        VideoRect videoRect = new VideoRect();
        videoRect.videoScaleMode = VideoScaleMode.CLIP_TO_BOUNDS;
        videoRect.left = isFirstMic ? 0 : halfWidth;
        videoRect.top = 0;
        videoRect.width = halfWidth;
        videoRect.height = sizeInfo.parentHeight;
        return videoRect;
    }

    @Override
    public List<MediaVideoViewSite> calculateMediaVideoViewSiteCompat(Context context, VideoSizeInfo sizeInfo) {
        boolean isFirstMic;
        ArrayList<MediaVideoViewSite> list2 = new ArrayList<MediaVideoViewSite>();
        if (sizeInfo.videoCount == 0) {
            MLog.error((Object)"NormalHorizontal1v1Parser", (String)"calculateMediaVideoViewSiteCompat: video count is zero, bug!!!", (Object[])new Object[0]);
            return list2;
        }
        boolean bl = isFirstMic = sizeInfo.micNo == 0;
        if (isFirstMic) {
            MediaVideoViewSite firstVideo = this.createMediaVideoViewSite(0, 0, sizeInfo.parentWidth / sizeInfo.videoCount, sizeInfo.parentHeight, 0);
            list2.add(firstVideo);
        } else {
            MediaVideoViewSite secondVideo = this.createMediaVideoViewSite(sizeInfo.parentWidth / 2, 0, sizeInfo.parentWidth / sizeInfo.videoCount, sizeInfo.parentHeight, 0);
            list2.add(secondVideo);
        }
        return list2;
    }
}

