/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.layoutparser.vertical;

import android.app.Activity;
import android.content.Context;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.metadata.AudienceMetadataManager;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoRect;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoScaleMode;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoSizeInfo;
import com.yy.mobile.ui.meidabasicvideoview.MediaVideoViewSite;
import com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.layoutparser.AbsVideoLayoutParser;
import com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.layoutparser.VideoLayoutConstants;
import com.yy.mobile.util.ActivityUtilKt;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;

public class ArenaWatchParser
extends AbsVideoLayoutParser {
    @Override
    public String getLogTag() {
        return "ArenaWatchParser";
    }

    @Override
    public boolean intercept(VideoSizeInfo sizeInfo) {
        boolean isArenaLive = AudienceMetadataManager.getInstance().isArenaLive();
        boolean isExactPixel = sizeInfo.width == 688 && sizeInfo.height == 704;
        MLog.info((Object)"ArenaWatchParser", (String)("intercept: isArenaLive=" + isArenaLive + ", isExactPixel=" + isExactPixel + ", videoSizeInfo:" + sizeInfo.toString()), (Object[])new Object[0]);
        return isArenaLive || isExactPixel;
    }

    @Override
    public VideoRect calculateVideoViewRect(Context context, VideoSizeInfo sizeInfo) {
        VideoRect videoRect = new VideoRect();
        if (ActivityUtilKt.isLandScape((Activity)YYActivityManager.INSTANCE.getCurrentActivity())) {
            videoRect.videoScaleMode = VideoScaleMode.ASPECT_FIT;
            videoRect.top = 0;
            videoRect.height = sizeInfo.parentHeight;
            videoRect.width = (int)((double)videoRect.height / 0.75);
            videoRect.left = (sizeInfo.parentWidth - videoRect.width) / 2;
        } else {
            videoRect.videoScaleMode = VideoScaleMode.ASPECT_FIT;
            videoRect.left = 0;
            videoRect.top = (int)ResolutionUtils.convertDpToPixel((float)VideoLayoutConstants.DEFAULT_VIDEO_TOP, (Context)context);
            videoRect.width = sizeInfo.parentWidth;
            videoRect.height = (int)(0.75 * (double)videoRect.width);
        }
        return videoRect;
    }

    @Override
    public List<MediaVideoViewSite> calculateMediaVideoViewSiteCompat(Context context, VideoSizeInfo sizeInfo) {
        ArrayList<MediaVideoViewSite> list2 = new ArrayList<MediaVideoViewSite>();
        if (sizeInfo.videoCount == 0) {
            MLog.error((Object)"ArenaWatchParser", (String)"calculateMediaVideoViewSiteCompat: video count is zero, bug!!!", (Object[])new Object[0]);
            return list2;
        }
        if (ActivityUtilKt.isLandScape((Activity)YYActivityManager.INSTANCE.getCurrentActivity())) {
            int top = 0;
            int height = sizeInfo.parentHeight;
            int width = (int)((double)height / 0.75) * sizeInfo.videoCount;
            int left = (sizeInfo.parentWidth - width) / 2;
            MediaVideoViewSite firstVideo = this.createMediaVideoViewSite(left, top, width / sizeInfo.videoCount, height, 1);
            list2.add(firstVideo);
            if (sizeInfo.videoCount > 1) {
                MediaVideoViewSite secondVideo = this.createMediaVideoViewSite(left + width, top, width / sizeInfo.videoCount, height, 1);
                list2.add(secondVideo);
            }
        } else {
            MediaVideoViewSite firstVideo = this.createMediaVideoViewSite(0, 0, sizeInfo.parentWidth / sizeInfo.videoCount, (int)(0.75 * (double)sizeInfo.parentWidth), 1);
            list2.add(firstVideo);
            if (sizeInfo.videoCount > 1) {
                MediaVideoViewSite secondVideo = this.createMediaVideoViewSite(sizeInfo.parentWidth / 2, (int)ResolutionUtils.convertDpToPixel((float)VideoLayoutConstants.DEFAULT_VIDEO_TOP, (Context)context), sizeInfo.parentWidth / sizeInfo.videoCount, (int)(0.75 * (double)sizeInfo.parentWidth), 1);
                list2.add(secondVideo);
            }
        }
        return list2;
    }
}

