/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.layoutparser.horizontal;

import android.content.Context;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoRect;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoScaleMode;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoSizeInfo;
import com.yy.mobile.ui.meidabasicvideoview.MediaVideoViewSite;
import com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.layoutparser.AbsVideoLayoutParser;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;

public class HorizontalFullParser
extends AbsVideoLayoutParser {
    @Override
    public String getLogTag() {
        return "HorizontalFullParser";
    }

    @Override
    public boolean intercept(VideoSizeInfo sizeInfo) {
        return !sizeInfo.isVerticalOrientation;
    }

    @Override
    public VideoRect calculateVideoViewRect(Context context, VideoSizeInfo sizeInfo) {
        VideoRect videoRect = new VideoRect();
        videoRect.videoScaleMode = this.getScaleMode(sizeInfo);
        videoRect.left = 0;
        videoRect.top = 0;
        videoRect.width = sizeInfo.parentWidth;
        videoRect.height = sizeInfo.parentHeight;
        return videoRect;
    }

    private VideoScaleMode getScaleMode(VideoSizeInfo sizeInfo) {
        if (sizeInfo.changeFrom == VideoSizeInfo.ChangeFrom.VIDEO_STREAM && sizeInfo.videoCount == 2) {
            return VideoScaleMode.CLIP_TO_BOUNDS;
        }
        boolean isAnchorVertical = sizeInfo.width < sizeInfo.height;
        return isAnchorVertical ? VideoScaleMode.ASPECT_FIT : VideoScaleMode.CLIP_TO_BOUNDS;
    }

    @Override
    public List<MediaVideoViewSite> calculateMediaVideoViewSiteCompat(Context context, VideoSizeInfo sizeInfo) {
        ArrayList<MediaVideoViewSite> list2 = new ArrayList<MediaVideoViewSite>();
        if (sizeInfo.videoCount == 0) {
            MLog.error((Object)"HorizontalFullParser", (String)"calculateMediaVideoViewSiteCompat: video count is zero, bug!!!", (Object[])new Object[0]);
            return list2;
        }
        MediaVideoViewSite firstVideo = this.createMediaVideoViewSite(0, 0, sizeInfo.parentWidth / sizeInfo.videoCount, sizeInfo.parentHeight, 0);
        list2.add(firstVideo);
        if (sizeInfo.videoCount > 1) {
            MediaVideoViewSite secondVideo = this.createMediaVideoViewSite(sizeInfo.parentWidth / 2, 0, sizeInfo.parentWidth / sizeInfo.videoCount, sizeInfo.parentHeight, 0);
            list2.add(secondVideo);
        }
        return list2;
    }
}

