/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout;

import android.content.Context;
import android.view.ViewGroup;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.mobile.RxBus;
import com.yy.mobile.event.video.MediaVideoViewSiteChangeEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.AudienceVideoView;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.streamcompat.VideoStreamCompat;
import com.yy.mobile.sdkwrapper.flowmanagement.api.layout.videosize.AudienceVideoSizeChangeEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoRect;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoSizeInfo;
import com.yy.mobile.sdkwrapper.flowmanagement.base.videolayout.videosize.VideoSizeChangeListener;
import com.yy.mobile.ui.meidabasicvideoview.IMediaAuxiliaryVideoViewFrameCore;
import com.yy.mobile.ui.meidabasicvideoview.MediaVideoViewSite;
import com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.layoutparser.AbsVideoLayoutParser;
import com.yy.mobile.ui.meidabasicvideoview.compat.video.AudienceVideoViewSize;
import com.yy.mobile.ui.meidabasicvideoview.uicore.IMediaVideoBasicCore;
import com.yy.mobile.util.exception.ExceptionUtil;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yyproto.utils.FP;
import java.util.List;

public class VideoLayoutController
implements VideoSizeChangeListener {
    private AudienceVideoView mAudienceVideoView;
    private Context mContext;
    private VideoSizeInfo mCurrentVideoSizeInfo;
    private int mCurrentOrientation = 1;
    private List<AbsVideoLayoutParser> mLayoutParsers;
    public AudienceVideoViewSize audienceVideoViewSize = (AudienceVideoViewSize)Spdt.of(AudienceVideoViewSize.class);

    public VideoLayoutController(AudienceVideoView audienceVideoView, List<AbsVideoLayoutParser> parsers) {
        this.mContext = audienceVideoView.getContext();
        this.mAudienceVideoView = audienceVideoView;
        this.mLayoutParsers = parsers;
        this.init();
    }

    private void init() {
        MLog.info((Object)"VideoLayoutController", (String)"init called", (Object[])new Object[0]);
        this.initOrientation();
        AudienceVideoSizeChangeEventHandler.getInstance().addListener((VideoSizeChangeListener)this);
    }

    private void initOrientation() {
        int orientation = this.mContext.getResources().getConfiguration().orientation;
        MLog.info((Object)"VideoLayoutController", (String)"initOrientation called: %d", (Object[])new Object[]{orientation});
        this.mCurrentOrientation = orientation;
    }

    public void release() {
        MLog.info((Object)"VideoLayoutController", (String)"release called", (Object[])new Object[0]);
        AudienceVideoSizeChangeEventHandler.getInstance().removeListener((VideoSizeChangeListener)this);
    }

    public void switchOrientation(int orientation) {
        if (this.mCurrentVideoSizeInfo == null) {
            MLog.error((Object)"VideoLayoutController", (String)"switchOrientation, video size info is null, orientation: %d", (Object[])new Object[]{orientation});
            this.mCurrentOrientation = orientation;
            return;
        }
        if (orientation != 1 && orientation != 2) {
            ExceptionUtil.throwOrWriteLog((String)"VideoLayoutController", (String)("invalid orientation: " + orientation), (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)"VideoLayoutController", (String)("switchOrientation called with: orientation = [" + orientation + "]"), (Object[])new Object[0]);
        this.updateVideoSizeInfo(orientation);
        this.findParserAndUpdateLayout(this.mCurrentVideoSizeInfo);
    }

    public void refreshLayout() {
        if (this.mCurrentVideoSizeInfo == null) {
            MLog.error((Object)"VideoLayoutController", (String)"refreshLayout, video size info is null", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)"VideoLayoutController", (String)"refreshLayout called", (Object[])new Object[0]);
        this.findParserAndUpdateLayout(this.mCurrentVideoSizeInfo);
    }

    public void onVideoSizeChanged(VideoSizeInfo info) {
        if (!info.shouldUpdateUI) {
            MLog.info((Object)"VideoLayoutController", (String)"onVideoSizeChanged without update ui, info: %s", (Object[])new Object[]{info});
            this.updateVideoSizeInfoV2(info, this.mCurrentOrientation, VideoStreamCompat.getInstance().getVideoStreamListSize());
            this.findParserAndUpdateLayout(info);
            return;
        }
        this.mCurrentVideoSizeInfo = info;
        this.updateVideoSizeInfo(this.mCurrentOrientation);
        MLog.info((Object)"VideoLayoutController", (String)("onVideoSizeChanged called with: info = [" + info + "]"), (Object[])new Object[0]);
        this.findParserAndUpdateLayout(this.mCurrentVideoSizeInfo);
    }

    private void updateVideoSizeInfoV2(VideoSizeInfo info, int orientation, int videoStreamCount) {
        info.videoCount = videoStreamCount;
        info.isVerticalOrientation = orientation == 1;
        this.getWindowHeightIncludeBars(info);
    }

    private void updateVideoSizeInfo(int orientation) {
        MLog.info((Object)"VideoLayoutController", (String)"updateVideoSizeInfo called before: %s, orientation: %d", (Object[])new Object[]{this.mCurrentVideoSizeInfo, orientation});
        this.mCurrentOrientation = orientation;
        this.mCurrentVideoSizeInfo.videoCount = VideoStreamCompat.getInstance().getVideoStreamListSize();
        this.mCurrentVideoSizeInfo.isVerticalOrientation = orientation == 1;
        this.getWindowHeightIncludeBars(this.mCurrentVideoSizeInfo);
        MLog.info((Object)"VideoLayoutController", (String)"updateVideoSizeInfo called after: %s", (Object[])new Object[]{this.mCurrentVideoSizeInfo});
    }

    private void findParserAndUpdateLayout(VideoSizeInfo info) {
        MLog.info((Object)"VideoLayoutController", (String)("findParserAndUpdateLayout called with: sizeInfo = [" + info + "]"), (Object[])new Object[0]);
        boolean parserNoFound = true;
        for (AbsVideoLayoutParser layoutParser : this.mLayoutParsers) {
            if (!layoutParser.intercept(info)) continue;
            VideoRect rect = layoutParser.calculateVideoViewRect(this.mContext, info);
            if (info.shouldUpdateUI) {
                MLog.info((Object)"VideoLayoutController", (String)"findParserAndUpdateLayout, parser: =========%s=========", (Object[])new Object[]{layoutParser.getLogTag()});
                this.innerUpdateVideoLayoutParams(rect, this.mAudienceVideoView);
            } else {
                MLog.info((Object)"VideoLayoutController", (String)"findParserAndUpdateLayout, ignore update ui, parser: =========%s=========", (Object[])new Object[]{layoutParser.getLogTag()});
            }
            List<MediaVideoViewSite> sites = layoutParser.calculateMediaVideoViewSiteCompat(this.mContext, info);
            this.updateVideoViewSite(sites, info);
            parserNoFound = false;
            break;
        }
        if (parserNoFound) {
            MLog.error((Object)"VideoLayoutController", (String)"findParserAndUpdateLayout, parser not found, video layout might not display right!!!!", (Object[])new Object[0]);
        }
    }

    private void updateVideoViewSite(List<MediaVideoViewSite> sites, VideoSizeInfo info) {
        MLog.info((Object)"VideoLayoutController", (String)("updateVideoViewSite called with: sites = [" + sites + "]"), (Object[])new Object[0]);
        MediaVideoViewSiteChangeEvent siteChangeEvent = new MediaVideoViewSiteChangeEvent();
        for (MediaVideoViewSite site : sites) {
            site.clientType = info.clientType;
        }
        if (FP.size(sites) > 0) {
            siteChangeEvent.firstMicVideoViewSite = sites.get(0);
            ((IMediaVideoBasicCore)ICoreManagerBase.getCore(IMediaVideoBasicCore.class)).setFirstVideoViewFrame(sites.get(0));
        }
        if (FP.size(sites) > 1) {
            siteChangeEvent.secondMicVideoViewSite = sites.get(1);
            ((IMediaAuxiliaryVideoViewFrameCore)ICoreManagerBase.getCore(IMediaAuxiliaryVideoViewFrameCore.class)).setAuxiliaryVideoViewFrame(sites.get(1));
        }
        RxBus.getDefault().post((Object)siteChangeEvent);
    }

    private void getWindowHeightIncludeBars(VideoSizeInfo info) {
        this.audienceVideoViewSize.updateVideoInfoSize(info, this.mContext);
    }

    private void innerUpdateVideoLayoutParams(VideoRect videoRect, AudienceVideoView videoView) {
        ViewGroup.LayoutParams params = videoView.getLayoutParams();
        ViewGroup.MarginLayoutParams marginLayoutParams = params instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)params : new ViewGroup.MarginLayoutParams(params);
        marginLayoutParams.leftMargin = videoRect.left;
        marginLayoutParams.topMargin = videoRect.top;
        marginLayoutParams.width = videoRect.width;
        marginLayoutParams.height = videoRect.height;
        videoView.setVisibility(0);
        videoView.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParams);
        videoView.setScaleMode(videoRect.videoScaleMode);
        MLog.info((Object)"VideoLayoutController", (String)("innerUpdateLayoutParams called with: videoRect: %s, videoViewLayoutParams = [" + this.layoutParamsToString(marginLayoutParams) + "]"), (Object[])new Object[]{videoRect});
    }

    private String layoutParamsToString(ViewGroup.MarginLayoutParams params) {
        return "leftMargin=" + params.leftMargin + ", topMargin=" + params.topMargin + ", width=" + params.width + ", height=" + params.height + "";
    }
}

