/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.meidabasicvideoview.compat.loading;

import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.duowan.mobile.entlive.events.IMediaVideoBasicClient_showContentRecommendComponent_EventArgs;
import com.duowan.mobile.entlive.events.IMicAudienceClient_onPreLeaveChannel_EventArgs;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.playstatus.VideoPlayStatusEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.videoenable.AudienceVideoEnableManager;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.playstatus.VideoPlayStatus;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.playstatus.VideoPlayStatusListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoPlayInfo;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.FirstFrameRenderNotifyEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.NoVideoStreamEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.nolive.NoLiveManager;
import com.yy.mobile.ui.gift.widget.RotateCircleProgressBar;
import com.yy.mobile.ui.meidabasicvideoview.compat.loading.AudienceLoadingEffect;
import com.yy.mobile.ui.meidabasicvideoview.compat.loading.AudienceVideoLoadingController$$EventBinder;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.media.ILiveConfigCore;
import com.yymobile.core.media.LiveConfigType;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class AudienceVideoLoadingController
implements VideoPlayStatusListener,
EventCompat {
    protected View mRootView;
    protected ImageView mIvYYLoading;
    protected TextView mTvCodeRateChanging;
    protected View mLoadingRootView;
    protected boolean mIsYYLoadingStart = false;
    protected Disposable mNoLiveLoadingDisposable;
    protected String loadingSnapshot;
    protected Drawable loadingDrawable;
    protected Runnable hideLoading = new Runnable(){

        @Override
        public void run() {
            AudienceVideoLoadingController.this.hideLoading();
        }
    };
    protected boolean isLeaving = false;
    protected RotateCircleProgressBar progressBar = null;
    public AudienceLoadingEffect mLoadingEffect = (AudienceLoadingEffect)Spdt.of(AudienceLoadingEffect.class);
    private EventBinder mAudienceVideoLoadingControllerSniperEventBinder;

    public void onEventBind() {
        if (this.mAudienceVideoLoadingControllerSniperEventBinder == null) {
            this.mAudienceVideoLoadingControllerSniperEventBinder = new AudienceVideoLoadingController$$EventBinder();
        }
        this.mAudienceVideoLoadingControllerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mAudienceVideoLoadingControllerSniperEventBinder != null) {
            this.mAudienceVideoLoadingControllerSniperEventBinder.unBindEvent();
        }
    }

    public AudienceVideoLoadingController(View rootView) {
        this.mRootView = rootView;
        this.initViews();
        VideoPlayStatusEventHandler.getInstance().addVideoPlayStatusListenerToHead((VideoPlayStatusListener)this);
        this.onEventBind();
    }

    public AudienceVideoLoadingController(View rootView, String snapshot) {
        this.mRootView = rootView;
        this.loadingSnapshot = snapshot;
        this.initViews();
        VideoPlayStatusEventHandler.getInstance().addVideoPlayStatusListenerToHead((VideoPlayStatusListener)this);
        this.onEventBind();
    }

    public void release() {
        this.mRootView = null;
        this.onEventUnBind();
        VideoPlayStatusEventHandler.getInstance().removeVideoPlayStatusListener((VideoPlayStatusListener)this);
        if (this.mNoLiveLoadingDisposable != null && !this.mNoLiveLoadingDisposable.isDisposed()) {
            this.mNoLiveLoadingDisposable.dispose();
        }
        this.mLoadingRootView.removeCallbacks(this.hideLoading);
        this.loadingDrawable = null;
    }

    public void updateSnapshot(@Nullable String snapshotUrl) {
        this.loadingSnapshot = snapshotUrl;
    }

    public void updateLoadingDrawable(@Nullable Drawable drawable2) {
        this.loadingDrawable = drawable2;
    }

    public Drawable getLoadingDrawable() {
        return this.loadingDrawable;
    }

    private void initViews() {
        this.mLoadingRootView = this.mRootView.findViewById(R.id.ll_audience_video_loading_root);
        this.mIvYYLoading = (ImageView)this.mRootView.findViewById(R.id.iv_audience_video_loading);
        this.initLoadingImageView();
        this.mTvCodeRateChanging = (TextView)this.mRootView.findViewById(R.id.tv_video_code_rate_changing);
        this.showLoadingAtInitIfNeeded();
    }

    protected void initLoadingImageView() {
    }

    private void showLoadingAtInitIfNeeded() {
        boolean isVideoEnable = AudienceVideoEnableManager.getInstance().isVideoEnable();
        boolean isMeAsLinkUser = this.isMeAsLinkUser();
        boolean isCureentNoLive = NoLiveManager.getInstance().isCurrentNoLive();
        boolean isChannelMicMode = this.isChannelMicMode();
        MLog.info((Object)"AudienceVideoLoadingController", (String)"showLoadingAtInitIfNeeded\uff1aisVideoEnable=%s, isMeAsLinkUser=%s, isCureentNoLive=%s, isChannelMicMode=%s", (Object[])new Object[]{isVideoEnable, isMeAsLinkUser, isCureentNoLive, isChannelMicMode});
        if (isVideoEnable && !isMeAsLinkUser && !isCureentNoLive && isChannelMicMode) {
            this.showLoading();
            this.mLoadingRootView.postDelayed(this.hideLoading, 5000L);
        } else {
            this.hideLoading();
        }
    }

    private boolean isMeAsLinkUser() {
        return ((ILiveConfigCore)ICoreManagerBase.getCore(ILiveConfigCore.class)).getLiveType() == LiveConfigType.LianMai;
    }

    public void onPlayStatusChanged(VideoPlayInfo videoPlayInfo, VideoPlayStatus videoPlayStatus) {
        MLog.info((Object)"AudienceVideoLoadingController", (String)"onPlayStatusChanged, playStatus: %s, playInfo: %s", (Object[])new Object[]{videoPlayStatus, videoPlayInfo});
        if (videoPlayStatus == VideoPlayStatus.LOADING) {
            if (this.mNoLiveLoadingDisposable != null && !this.mNoLiveLoadingDisposable.isDisposed()) {
                this.mNoLiveLoadingDisposable.dispose();
            }
            if (this.isMeAsLinkUser()) {
                MLog.info((Object)"AudienceVideoLoadingController", (String)"on play loading, isMeAsLinkUser, do nothing", (Object[])new Object[0]);
                return;
            }
            this.showLoading();
        } else if (videoPlayStatus == VideoPlayStatus.PLAYING) {
            this.hideLoading();
        } else if (videoPlayStatus == VideoPlayStatus.STOP) {
            this.onVideoPlayStop(videoPlayInfo);
        }
    }

    protected void onVideoPlayStop(VideoPlayInfo videoPlayInfo) {
        if (videoPlayInfo.micPos == 1 && videoPlayInfo.isMixLayout) {
            MLog.info((Object)"AudienceVideoLoadingController", (String)"on play stop, is second mic, do nothing!", (Object[])new Object[0]);
            return;
        }
        this.showLoading();
        this.mLoadingRootView.postDelayed(this.hideLoading, 5000L);
    }

    @BusEvent(busType=1, busName="FlowRxBus", sync=true)
    public void onFirstFrameSee(FirstFrameRenderNotifyEvent event) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.hideLoading();
        } else {
            this.mLoadingRootView.post(new Runnable(){

                @Override
                public void run() {
                    AudienceVideoLoadingController.this.hideLoading();
                }
            });
        }
    }

    @BusEvent
    public void onNoVideoStreamNotify(NoVideoStreamEvent event) {
        MLog.info((Object)"AudienceVideoLoadingController", (String)"onNoVideoStreamNotify called", (Object[])new Object[0]);
        if (!this.isChannelMicMode()) {
            return;
        }
        this.showLoading();
        RxUtils.dispose((Disposable)this.mNoLiveLoadingDisposable);
        this.mNoLiveLoadingDisposable = Observable.timer((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

            public void accept(Long aLong) throws Exception {
                MLog.debug((Object)"AudienceVideoLoadingController", (String)"onNoVideoStreamNotify: accept", (Object[])new Object[0]);
                if (AudienceVideoLoadingController.this.mNoLiveLoadingDisposable != null && !AudienceVideoLoadingController.this.mNoLiveLoadingDisposable.isDisposed()) {
                    AudienceVideoLoadingController.this.hideLoading();
                    AudienceVideoLoadingController.this.mNoLiveLoadingDisposable.dispose();
                }
            }
        }, RxUtils.errorConsumer((String)"AudienceVideoLoadingController"));
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onPreLeaveChannel(IMicAudienceClient_onPreLeaveChannel_EventArgs eventArgs) {
        this.isLeaving = true;
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void showContentRecommendComponent(IMediaVideoBasicClient_showContentRecommendComponent_EventArgs busEventArgs) {
        MLog.info((Object)"AudienceVideoLoadingController", (String)("showContentRecommendComponent called with: busEventArgs = [" + busEventArgs + "]"), (Object[])new Object[0]);
        this.hideLoading();
    }

    protected void hideLoading() {
        MLog.info((Object)"AudienceVideoLoadingController", (String)"hideLoading called", (Object[])new Object[0]);
        this.mLoadingRootView.setVisibility(8);
        this.stopYYLoading();
        if (this.progressBar != null) {
            this.progressBar.stopRotate();
        }
    }

    protected void showLoading() {
        MLog.info((Object)"AudienceVideoLoadingController", (String)"showLoading called", (Object[])new Object[0]);
        this.mLoadingRootView.removeCallbacks(this.hideLoading);
        this.mLoadingRootView.setVisibility(0);
        this.startYYLoading();
        if (this.progressBar != null) {
            this.progressBar.startRotate();
        }
    }

    private void stopYYLoading() {
        if (!this.mIsYYLoadingStart) {
            return;
        }
        MLog.info((Object)"AudienceVideoLoadingController", (String)"stopYYLoading called", (Object[])new Object[0]);
        this.mLoadingEffect.stopLoading(this.mLoadingRootView, this.mIvYYLoading, this.loadingSnapshot);
        this.mIsYYLoadingStart = false;
    }

    private void startYYLoading() {
        if (this.mIsYYLoadingStart) {
            return;
        }
        MLog.info((Object)"AudienceVideoLoadingController", (String)"startYYLoading called", (Object[])new Object[0]);
        this.mLoadingEffect.startLoading(this.mLoadingRootView, this.mIvYYLoading, this.loadingSnapshot, this.loadingDrawable);
        this.mIsYYLoadingStart = true;
    }

    private boolean isChannelMicMode() {
        ChannelInfo channelInfo = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo();
        ChannelInfo.ChannelMode mode = null;
        if (channelInfo != null) {
            mode = channelInfo.channelMode;
        }
        MLog.info((Object)"AudienceVideoLoadingController", (String)"isChannelMicMode: mode:%s", (Object[])new Object[]{mode});
        return channelInfo != null && ChannelInfo.ChannelMode.MicQueue_Mode.equals((Object)mode);
    }
}

