/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.meidabasicvideoview.compat.component;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onRequestJoinChannelExist_EventArgs;
import com.yy.mobile.plugin.main.events.IMediaClient_addChannelMediaAnchorInfoExt_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.videoquality.AudienceVideoQualityManager;
import com.yy.mobile.sdkwrapper.flowmanagement.api.videoinfo.VideoDebugInfoManager;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.videoquality.IAudienceVideoQualityChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.AudienceVideoQuality;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoDebugInfo;
import com.yy.mobile.sdkwrapper.flowmanagement.base.videoinfo.VideoDebugInfoListener;
import com.yy.mobile.sdkwrapper.yylive.media.event.AnchorBroadcastDataEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.NoVideoInfoEventArgs;
import com.yy.mobile.ui.basicchanneltemplate.Temp;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.channeltimestatistics.ChannelTimeStatisticsUtil;
import com.yy.mobile.ui.meidabasicvideoview.compat.component.TestLiveParamComponent$$EventBinder;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreError;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.LiveRxBus;
import com.yymobile.core.channel.ChannelInfo;
import com.yyproto.utils.FP;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import java.util.List;
import java.util.Map;

public class TestLiveParamComponent
extends Component
implements VideoDebugInfoListener,
IAudienceVideoQualityChangeListener {
    private SafeDispatchHandler handler = new SafeDispatchHandler(Looper.getMainLooper());
    private float textSize = 9.0f;
    private String textBackColor = "#e6D6D0D2";
    private int mMediaAudioState = 1;
    private View mRootView;
    protected TextView channelAndMedia;
    protected TextView myUid;
    protected TextView channelInfo;
    protected TextView channelTpl;
    protected TextView audioState;
    protected TextView noVideoInfoView;
    protected TextView slipTime;
    protected TextView joinchannelTime;
    protected TextView leaveChannelTime;
    protected TextView arriveAndfirstFrametime;
    protected TextView totalTime;
    protected TextView auchorInfo;
    protected TextView anchorInfoExt;
    protected TextView gameMinBuffer;
    protected TextView mTvVideoInfo;
    protected TextView mTvStreamName;
    protected TextView lineQuality;
    protected TextView mTvAnchorEndBroadcast;
    private final CompositeDisposable disposables = new CompositeDisposable();
    private EventBinder mTestLiveParamComponentSniperEventBinder;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(R.layout.layout_live_param, container, false);
        this.initTestView();
        return this.mRootView;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        if (this.mTestLiveParamComponentSniperEventBinder == null) {
            this.mTestLiveParamComponentSniperEventBinder = new TestLiveParamComponent$$EventBinder();
        }
        this.mTestLiveParamComponentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, savedInstanceState);
        this.init();
    }

    public void onDestroyView() {
        this.unInit();
        super.onDestroyView();
        Object var2_1 = null;
        if (this.mTestLiveParamComponentSniperEventBinder != null) {
            this.mTestLiveParamComponentSniperEventBinder.unBindEvent();
        }
    }

    private void init() {
        this.addObserver();
        this.setChannelInfo();
        this.setMediaText();
        this.registerMediaVideoEvent();
    }

    private void unInit() {
        this.removeObserver();
    }

    private void initTestView() {
        MLog.info((Object)"TestLiveParamComponent", (String)"initTestView ", (Object[])new Object[0]);
        LinearLayout linearLayout = (LinearLayout)this.mRootView.findViewById(R.id.layout_container);
        this.channelAndMedia = this.initTextView((ViewGroup)linearLayout);
        this.myUid = this.initTextView((ViewGroup)linearLayout);
        this.mTvStreamName = this.initTextView((ViewGroup)linearLayout);
        this.mTvVideoInfo = this.initTextView((ViewGroup)linearLayout);
        this.mTvAnchorEndBroadcast = this.initTextView((ViewGroup)linearLayout);
        this.lineQuality = this.initTextView((ViewGroup)linearLayout);
        this.channelInfo = this.initTextView((ViewGroup)linearLayout);
        this.channelTpl = this.initTextView((ViewGroup)linearLayout);
        this.audioState = this.initTextView((ViewGroup)linearLayout);
        this.noVideoInfoView = this.initTextView((ViewGroup)linearLayout);
        this.slipTime = this.initTextView((ViewGroup)linearLayout);
        this.leaveChannelTime = this.initTextView((ViewGroup)linearLayout);
        this.joinchannelTime = this.initTextView((ViewGroup)linearLayout);
        this.arriveAndfirstFrametime = this.initTextView((ViewGroup)linearLayout);
        this.totalTime = this.initTextView((ViewGroup)linearLayout);
        this.auchorInfo = this.initTextView((ViewGroup)linearLayout);
        this.anchorInfoExt = this.initTextView((ViewGroup)linearLayout);
        this.gameMinBuffer = this.initTextView((ViewGroup)linearLayout);
    }

    private TextView initTextView(ViewGroup viewGroup) {
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
        FragmentActivity context = this.getActivity();
        TextView tv = new TextView((Context)context);
        tv.setPadding((int)ResolutionUtils.convertDpToPixel((float)4.0f, (Context)context), 0, 0, 0);
        tv.setTextSize(this.textSize);
        tv.setBackgroundColor(Color.parseColor((String)this.textBackColor));
        tv.setTextColor(-16777216);
        tv.setLayoutParams((ViewGroup.LayoutParams)lp);
        tv.setVisibility(8);
        tv.setLineSpacing(1.0f, 1.5f);
        viewGroup.addView((View)tv);
        return tv;
    }

    private void registerMediaVideoEvent() {
        this.registerAnchorBroadcastDataEvent();
        this.registerNoVideoInfoEvent();
    }

    private void registerNoVideoInfoEvent() {
        this.disposables.add(LiveRxBus.getInstance().register(NoVideoInfoEventArgs.class).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<NoVideoInfoEventArgs>(){

            public void accept(@io.reactivex.annotations.NonNull NoVideoInfoEventArgs noVideoInfoEventArgs) throws Exception {
                TestLiveParamComponent.this.setTextViewString(TestLiveParamComponent.this.noVideoInfoView, "noVideoInfo:" + noVideoInfoEventArgs.reason);
            }
        }, RxUtils.errorConsumer((String)"TestLiveParamComponent", (String)"NoVideoInfoEventArgs error")));
    }

    private void registerAnchorBroadcastDataEvent() {
        this.disposables.add(LiveRxBus.getInstance().register(AnchorBroadcastDataEventArgs.class).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<AnchorBroadcastDataEventArgs>(){

            public void accept(@io.reactivex.annotations.NonNull AnchorBroadcastDataEventArgs anchorBroadcastData) throws Exception {
                if (anchorBroadcastData != null) {
                    TestLiveParamComponent.this.setTextViewString(TestLiveParamComponent.this.auchorInfo, "auchorInfo:uid:" + anchorBroadcastData.uid + " \nuserGroupId:" + anchorBroadcastData.userGroupId + " \nstreamId:" + anchorBroadcastData.streamId + " \nintDatas:" + anchorBroadcastData.intDatas + " \nstrDatas:" + anchorBroadcastData.strDatas);
                }
            }
        }, RxUtils.errorConsumer((String)"TestLiveParamComponent", (String)"AnchorBroadcastDataEventArgs error")));
    }

    private void setChannelInfo() {
        ChannelInfo currentChannelInfo = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo();
        this.setTextViewString(this.channelAndMedia, "channelState:" + ICoreManagerBase.getChannelLinkCore().getChannelState());
        long userId = LoginUtil.getUid();
        if (userId == 0L) {
            userId = LoginUtil.getAnoymousUid();
        }
        this.setTextViewString(this.myUid, "myUid:" + userId);
        this.setTextViewString(this.channelInfo, "channelInfo:" + currentChannelInfo.topASid + "/" + currentChannelInfo.topSid + "/" + currentChannelInfo.subSid);
        this.setTextViewString(this.channelTpl, "channelTpl:" + ICoreManagerBase.getChannelLinkCore().getTemplateId() + "/" + (Temp.getCurrentBussinessId() == null ? "null" : Temp.getCurrentBussinessId()));
        this.getMediaAudioState(this.mMediaAudioState);
        this.setChannelTime();
    }

    private void setChannelTime() {
        this.setTextViewString(this.slipTime, "slipTime :" + ChannelTimeStatisticsUtil.instance().getSlipTimeOver());
        this.setTextViewString(this.leaveChannelTime, "leaveChannelTime :" + ChannelTimeStatisticsUtil.instance().getLeaveChannelTimeOver());
        this.setTextViewString(this.joinchannelTime, "joinchannelTime :" + ChannelTimeStatisticsUtil.instance().getJoinChannelTimeOver());
        this.setTextViewString(this.arriveAndfirstFrametime, "arriveTime/firstFrametime :" + ChannelTimeStatisticsUtil.instance().getArriveMediaTimeOver() + "/" + ChannelTimeStatisticsUtil.instance().getFirstFrameOver());
        this.setTextViewString(this.totalTime, "totalTime :" + ChannelTimeStatisticsUtil.instance().getAllTimeOver());
        this.setTextViewString(this.gameMinBuffer, "minBuffer :" + ChannelTimeStatisticsUtil.instance().getGameMinBuffer());
    }

    private void getMediaAudioState(int state) {
        switch (state) {
            case 1: {
                this.setTextViewString(this.audioState, "audioState:NoAudio");
                break;
            }
            case 2: {
                this.setTextViewString(this.audioState, "audioState:RecvAudio");
                break;
            }
            case 3: {
                this.setTextViewString(this.audioState, "audioState:RecvNoAudio");
                break;
            }
        }
    }

    public void setTextViewString(final TextView view, final String textString) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            if (view != null) {
                if (!TextUtils.isEmpty((CharSequence)textString)) {
                    view.setVisibility(0);
                    view.setText((CharSequence)textString);
                } else {
                    view.setVisibility(8);
                }
            }
        } else {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (view != null) {
                        if (!TextUtils.isEmpty((CharSequence)textString)) {
                            view.setVisibility(0);
                            view.setText((CharSequence)textString);
                        } else {
                            view.setVisibility(8);
                        }
                    }
                }
            });
        }
    }

    private void setMediaText() {
        this.setTextViewString(this.channelAndMedia, "channelState:" + ICoreManagerBase.getChannelLinkCore().getChannelState());
    }

    private void addObserver() {
        this.removeObserver();
        VideoDebugInfoManager.getInstance().addVideoDebugInfoUpdateListener((VideoDebugInfoListener)this);
        AudienceVideoQualityManager.getInstance().addVideoQualityChangeListener((IAudienceVideoQualityChangeListener)this);
    }

    private void removeObserver() {
        VideoDebugInfoManager.getInstance().removeVideoDebugInfoUpdateListener((VideoDebugInfoListener)this);
        AudienceVideoQualityManager.getInstance().removeVideoQualityChangeListener((IAudienceVideoQualityChangeListener)this);
    }

    private void updateLineQualityInfo() {
        int curLine = AudienceVideoQualityManager.getInstance().getCurrentVideoLine();
        AudienceVideoQuality curQuality = AudienceVideoQualityManager.getInstance().getSelectedVideoQuality();
        String qu = curQuality.getName();
        String s = "\u5f53\u524d\u7ebf\u8def: " + curLine + " \u6e05\u6670\u5ea6: " + qu;
        this.setTextViewString(this.lineQuality, s);
    }

    @BusEvent(sync=true)
    public void onRequestJoinChannelExist(IChannelLinkClient_onRequestJoinChannelExist_EventArgs busEventArgs) {
        ChannelInfo channelInfo = busEventArgs.getChannelInfo();
        CoreError error = busEventArgs.getError();
        this.setChannelInfo();
    }

    @BusEvent(sync=true)
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        ChannelInfo channelInfo = busEventArgs.getInfo();
        this.setChannelInfo();
    }

    @BusEvent(sync=true)
    public void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs busEventArgs) {
        ChannelInfo channelInfo = busEventArgs.getInfo();
        this.mMediaAudioState = 1;
        this.setTextViewString(this.audioState, "audioState:NoAudio");
        this.setTextViewString(this.channelAndMedia, "channelState:" + ICoreManagerBase.getChannelLinkCore().getChannelState());
        this.setTextViewString(this.noVideoInfoView, "");
        this.setTextViewString(this.auchorInfo, "");
        this.setTextViewString(this.anchorInfoExt, "");
    }

    @BusEvent(sync=true)
    public void addChannelMediaAnchorInfoExt(IMediaClient_addChannelMediaAnchorInfoExt_EventArgs busEventArgs) {
        String info = busEventArgs.getInfo();
        boolean superAddition = busEventArgs.getSuperAddition();
        if (superAddition) {
            this.setTextViewString(this.anchorInfoExt, "anchorInfoExt:" + (this.anchorInfoExt.getText() == null ? "" : this.anchorInfoExt.getText()) + info);
        } else {
            this.setTextViewString(this.anchorInfoExt, "anchorInfoExt:" + info);
        }
    }

    public void onVideoDebugInfoUpdate(List<VideoDebugInfo> list2) {
        if (FP.size(list2) > 0) {
            VideoDebugInfo debugInfo = list2.get(0);
            this.setTextViewString(this.mTvStreamName, "\u6d41\u540d\u79f0: " + debugInfo.videoStreamList);
            StringBuilder sb = new StringBuilder();
            sb.append("                  \u5927\u698220\u79d2\u5237\u65b0\u4e00\u6b21").append("\n");
            sb.append("\u7f16\u7801\u5206\u8fa8\u7387: ").append(debugInfo.encodeVideoResolution).append("\n");
            sb.append("\u89e3\u7801\u5206\u8fa8\u7387: ").append(debugInfo.decodeVideoResolution).append("\n");
            sb.append("\u4e3b\u64ad\u7aef\u7f16\u7801\u7801\u7387: ").append(debugInfo.encodeBitRate).append("\n");
            sb.append("\u89c2\u4f17\u7aef\u7801\u7387\u8303\u56f4\uff1a").append(debugInfo.audienceCodeRateRange).append("\n");
            sb.append("\u7801\u7387\u5217\u8868: ").append(debugInfo.bitRateList).append("\n");
            sb.append("\u89c2\u4f17\u7aef\u9009\u62e9\u7801\u7387: ").append(debugInfo.selectedBitRate).append("\n");
            sb.append("\u89c2\u4f17\u7aef\u89e3\u7801\u7801\u7387: ").append(debugInfo.decodeBitRate).append("\n");
            sb.append("\u89c2\u4f17\u7aef\u89e3\u7801\u5e27\u7387: ").append(debugInfo.decodeFrameRate).append("\n");
            sb.append("\u89c2\u4f17\u7aef\u89e3\u7801\u7c7b\u578b: ").append(debugInfo.decodeType).append("\n");
            sb.append("\u4e3b\u64ad\u7aef\u7f16\u7801\u7c7b\u578b: ").append(debugInfo.encodeType).append("\n");
            sb.append("rtt: ").append(debugInfo.rttInMs).append("\n");
            sb.append("\u591a\u4eba\u8fde\u9ea6\u4fe1\u606f\uff1a").append(debugInfo.multiVideoInfo).append("\n");
            sb.append("\u64ad\u653e\u72b6\u6001: ").append(debugInfo.playStatusInfo).append("\n");
            this.setTextViewString(this.mTvVideoInfo, sb.toString());
        }
    }

    public void onUpdateAvaliableVideoQualities(List<AudienceVideoQuality> videoQualities) {
        this.updateLineQualityInfo();
    }

    public void onUpdateStreamLineInfo(Map<Integer, List<AudienceVideoQuality>> lineQuality) {
        this.updateLineQualityInfo();
    }

    public void onUpdateCurStreamLine(Integer curLine, AudienceVideoQuality curVideoQuality) {
        this.updateLineQualityInfo();
    }
}

