/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.marquee;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.widget.WhitespaceSpannable;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;

public class SongChooseSeatMarqueeLayout
extends FrameLayout {
    OnSongSeatWidthListener mWidthListener;
    private Context mContext;
    private TextView mTextView;
    private AnimatorSet animatorSet;
    private boolean isMarque = false;
    private float mSpeed = 3.0f;
    private int mMarqueWidth = 600;
    private long mMaxDuration = 5000L;
    private long mDuration = 3000L;
    private int mMargin = 40;
    private int mScrollWidth = 0;
    private int moveStartX = (int)ResolutionUtils.convertDpToPixel((float)33.0f, (Context)BasicConfig.getInstance().getAppContext());
    private OffsetType type = OffsetType.Cancle;

    public SongChooseSeatMarqueeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mMarqueWidth = ResolutionUtils.getScreenWidth((Context)context) - DensityUtil.dip2px((Context)context, (float)140.0f) - DensityUtil.dip2px((Context)context, (float)this.mMargin);
    }

    public void setType(OffsetType type) {
        this.type = type;
    }

    public void setMarqueWidth(int width) {
        if (width < 0) {
            return;
        }
        this.mMarqueWidth = width;
    }

    private void startMarquee() {
        this.reserverAnimation();
        if (this.mTextView != null) {
            TextPaint paint = this.mTextView.getPaint();
            CharSequence content = this.mTextView.getText();
            float len = Layout.getDesiredWidth((CharSequence)content, (TextPaint)paint);
            if (this.mWidthListener != null) {
                this.mWidthListener.onSongBossSeatWidth(DensityUtil.dip2px((Context)this.getContext(), (float)180.0f));
            }
            if (this.mMarqueWidth <= 0) {
                this.mMarqueWidth = this.getMeasuredWidth();
            }
            int marqueWidth = this.mMarqueWidth;
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"SongChooseSeatMarqueeLayout", (String)(" len = " + len + " ; mMarqueWidth " + marqueWidth), (Object[])new Object[0]);
            }
            if (len > (float)marqueWidth) {
                SpannableStringBuilder spannable;
                SpannableStringBuilder another = spannable = new SpannableStringBuilder(content);
                spannable.append((CharSequence)"[space]").append((CharSequence)another);
                int idx = spannable.toString().indexOf("[space]");
                float spaceWidth = ResolutionUtils.convertDpToPixel((float)60.0f, (Context)this.getContext());
                if (idx >= 0 && idx + "[space]".length() < spannable.length()) {
                    spannable.setSpan((Object)new WhitespaceSpannable(spaceWidth), idx, idx + "[space]".length(), 33);
                }
                this.mTextView.setText((CharSequence)spannable);
                float width = Layout.getDesiredWidth((CharSequence)spannable, (TextPaint)paint);
                this.isMarque = true;
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams((int)width, -2);
                lp.leftMargin = 0;
                this.mTextView.setLayoutParams((ViewGroup.LayoutParams)lp);
                this.animatorSet = new AnimatorSet();
                this.mScrollWidth = (int)(-(len - (float)marqueWidth));
                ObjectAnimator objectAnimator = this.type == OffsetType.Cancle ? ObjectAnimator.ofFloat((Object)this.mTextView, (String)"translationX", (float[])new float[]{0.0f, this.mScrollWidth}) : ObjectAnimator.ofFloat((Object)this.mTextView, (String)"translationX", (float[])new float[]{this.moveStartX, this.mScrollWidth});
                this.mDuration = (long)(this.mSpeed * (float)Math.abs(this.mScrollWidth));
                if (this.mDuration > this.mMaxDuration) {
                    this.mDuration = this.mMaxDuration;
                }
                objectAnimator.setDuration(3000L);
                objectAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
                this.animatorSet.play((Animator)objectAnimator);
                this.animatorSet.start();
            } else {
                this.isMarque = false;
                this.mDuration = 3000L;
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
                if (this.type == OffsetType.Need) {
                    lp.leftMargin = this.moveStartX;
                } else if (this.type == OffsetType.Cancle) {
                    lp.leftMargin = 0;
                }
                this.mTextView.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
        }
    }

    public void reserverAnimation() {
        if (this.animatorSet != null) {
            this.animatorSet.removeAllListeners();
            this.animatorSet.end();
            this.animatorSet = null;
        }
        if (this.mTextView != null) {
            this.mTextView.setTranslationX(0.0f);
        }
    }

    public void setText(Spannable info) {
        if (this.mTextView == null) {
            this.mTextView = (TextView)this.getChildAt(0);
        }
        if (this.mTextView == null && this.mContext != null) {
            this.mTextView = new TextView(this.mContext);
            this.mTextView.setSingleLine(true);
            ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -2);
            this.addView((View)this.mTextView, lp);
        }
        if (this.mTextView != null) {
            if (info != null) {
                this.mTextView.setText((CharSequence)info);
            }
            this.startMarquee();
        }
    }

    public boolean isMarque() {
        return this.isMarque;
    }

    public float getSpeed() {
        return this.mSpeed;
    }

    public void setSpeed(float speed) {
        this.mSpeed = speed;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public void setMaxDuration(long max) {
        this.mMaxDuration = max;
    }

    public void setOnSongSeatWidthListener(OnSongSeatWidthListener listener2) {
        this.mWidthListener = listener2;
    }

    public static interface OnSongSeatWidthListener {
        public void onSongBossSeatWidth(float var1);
    }

    public static enum OffsetType {
        Need,
        Cancle;

    }
}

