/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.guess.result;

import com.yy.mobile.ui.guess.result.GuessResult;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import javax.annotation.Nullable;

public class GuessResultQueueManager {
    private Queue<ArrayList<GuessResult>> mResultsQueue = new LinkedList<ArrayList<GuessResult>>();
    private Callback mCallback;

    public GuessResultQueueManager(Callback callback2) {
        this.mCallback = callback2;
    }

    public void showOrQueue(ArrayList<GuessResult> results) {
        MLog.info((Object)"GameResultQueueManager", (String)"showOrQueue, results: %s", (Object[])new Object[]{results});
        this.addResultsToQueue(results);
        this.tryToShowNextPopup();
    }

    public void tryToShowNextPopup() {
        if (this.canShowNextPopup()) {
            ArrayList<GuessResult> results = this.pollResults();
            MLog.info((Object)"GameResultQueueManager", (String)"show next result popup: %s", (Object[])new Object[]{results});
            this.mCallback.showPopup(results);
        }
    }

    private boolean canShowNextPopup() {
        int resultQueueSize = this.mResultsQueue.size();
        boolean canShowGameResultPopup = this.mCallback.canShowGameResultPopup();
        MLog.info((Object)"GameResultQueueManager", (String)"canShowNextPopup: queue size: %d, can outer show popup: %b", (Object[])new Object[]{resultQueueSize, canShowGameResultPopup});
        return resultQueueSize > 0 && canShowGameResultPopup;
    }

    private void addResultsToQueue(ArrayList<GuessResult> results) {
        MLog.info((Object)"GameResultQueueManager", (String)"addResultsToQueue: %s", (Object[])new Object[]{results});
        this.mResultsQueue.add(results);
    }

    @Nullable
    private ArrayList<GuessResult> pollResults() {
        ArrayList<GuessResult> results = this.mResultsQueue.poll();
        MLog.info((Object)"GameResultQueueManager", (String)"popResults, results: %s", (Object[])new Object[]{results});
        return results;
    }

    public void clear() {
        MLog.info((Object)"GameResultQueueManager", (String)"clear", (Object[])new Object[0]);
        this.mResultsQueue.clear();
    }

    public static interface Callback {
        public boolean canShowGameResultPopup();

        public void showPopup(ArrayList<GuessResult> var1);
    }
}

