/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift.guid;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.duowan.mobile.entlive.events.IPKClient_hidHotGiftGuid_EventArgs;
import com.yy.mobile.RxBus;
import com.yy.mobile.ui.gift.core.IGiftUICore;
import com.yy.mobile.ui.utils.AbstractViewController;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.y2a.Y2AFileDownloader;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.y2aplayerandroid.Y2APlayer;
import com.yy.y2aplayerandroid.Y2APlayerListener;
import com.yymobile.core.ICoreManagerBase;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.File;

public class HotGiftAnimPlayController
extends AbstractViewController {
    int screenWidth;
    PlayerListener y2APlayerListener;
    public Y2APlayer mPlayer;
    public boolean isStop = true;
    private Disposable mDispose;
    private Disposable y2aDisposable;

    protected View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        RelativeLayout relativeLayout = new RelativeLayout((Context)this.getActivity());
        int w = ResolutionUtils.getScreenWidth((Context)this.getActivity());
        int h = ResolutionUtils.getScreenHeight((Context)this.getActivity());
        this.screenWidth = Math.min(w, h);
        return relativeLayout;
    }

    protected void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        if (this.mRootView.getLayoutParams() instanceof RelativeLayout.LayoutParams) {
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.mRootView.getLayoutParams();
            lp.width = -1;
            lp.height = -1;
        }
        this.mPlayer = new Y2APlayer((Context)this.getActivity());
        this.y2APlayerListener = new PlayerListener();
        this.mPlayer.setListener((Y2APlayerListener)this.y2APlayerListener);
        ((RelativeLayout)this.mRootView).addView((View)this.mPlayer);
    }

    protected void onOrientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        this.setLayoutParams("hot_gift_up.y2a".equals(this.y2APlayerListener == null ? "" : this.y2APlayerListener.getFileName()));
    }

    public void setLayoutParams(boolean isUp) {
        if (this.mPlayer.getLayoutParams() instanceof RelativeLayout.LayoutParams) {
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.mPlayer.getLayoutParams();
            if (isUp) {
                lp.height = DensityUtil.dip2px((Context)this.getActivity(), (float)117.5f);
                lp.width = DensityUtil.dip2px((Context)this.getActivity(), (float)45.0f);
                lp.addRule(12);
                lp.addRule(11);
                lp.addRule(13, 0);
                Rect rect = ((IGiftUICore)ICoreManagerBase.getCore(IGiftUICore.class)).getGiftIconPosition();
                int sw = ResolutionUtils.getScreenWidth((Context)this.getActivity());
                if (rect != null) {
                    if (this.isLandScape()) {
                        lp.rightMargin = DensityUtil.dip2px((Context)this.getActivity(), (float)7.0f);
                        lp.bottomMargin = DensityUtil.dip2px((Context)this.getActivity(), (float)40.0f);
                    } else {
                        lp.bottomMargin = DensityUtil.dip2px((Context)this.getActivity(), (float)40.0f);
                        lp.rightMargin = DensityUtil.dip2px((Context)this.getActivity(), (float)3.0f) + (sw - rect.left);
                    }
                }
            } else {
                lp.width = this.screenWidth;
                lp.height = this.screenWidth;
                lp.addRule(12, 0);
                lp.addRule(11, 0);
                lp.addRule(13);
                lp.rightMargin = 0;
                lp.bottomMargin = 0;
            }
            this.mPlayer.requestLayout();
        }
    }

    protected void onPause() {
        super.onPause();
        this.mRootView.setVisibility(8);
    }

    public void playAnim(String fileName) {
        this.show();
        this.y2APlayerListener.setFileName(fileName);
        this.playSvgaAnimation(fileName);
    }

    private void playSvgaAnimation(String fileName) {
        if (StringUtils.isEmpty((String)fileName).booleanValue() || this.mPlayer == null) {
            return;
        }
        this.y2aDisposable = Y2AFileDownloader.downloadY2AFile((String)fileName).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<File>(){

            public void accept(File file) throws Exception {
                if (HotGiftAnimPlayController.this.mPlayer != null) {
                    HotGiftAnimPlayController.this.mPlayer.load(file.getAbsolutePath());
                }
            }
        }, RxUtils.errorConsumer((String)"HotGiftAnimPlayController", (String)"playSvgaAnimation error"));
    }

    protected void onDestroy() {
        if (this.mPlayer != null) {
            this.mPlayer.stop();
            this.mPlayer.close();
            this.mPlayer = null;
            if (this.mDispose != null) {
                this.mDispose.dispose();
                this.mDispose = null;
            }
        }
        if (this.y2aDisposable != null) {
            this.y2aDisposable.dispose();
        }
    }

    public class PlayerListener
    implements Y2APlayerListener {
        String fileName;

        public PlayerListener(String fileName) {
            this.fileName = fileName;
        }

        public PlayerListener() {
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
            if ("hot_gift_up.y2a".equals(fileName)) {
                HotGiftAnimPlayController.this.setLayoutParams(true);
            } else {
                HotGiftAnimPlayController.this.setLayoutParams(false);
            }
        }

        public void onLoaded(int errorCode) {
            MLog.info((Object)"HotGiftAnimPlayController", (String)("ly onLoaded errorCode=" + errorCode), (Object[])new Object[0]);
            if (HotGiftAnimPlayController.this.mPlayer != null) {
                HotGiftAnimPlayController.this.mPlayer.play(1.0f, 1);
            }
        }

        public void onPlayed(int errorCode) {
            MLog.info((Object)"HotGiftAnimPlayController", (String)("ly onPlayed errorCode=" + errorCode), (Object[])new Object[0]);
            HotGiftAnimPlayController.this.isStop = false;
            HotGiftAnimPlayController.this.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    HotGiftAnimPlayController.this.show();
                }
            });
            if ("hot_gift_up.y2a".equals(this.fileName)) {
                HotGiftAnimPlayController.this.getHandler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        RxBus.getDefault().post((Object)new IPKClient_hidHotGiftGuid_EventArgs());
                        HotGiftAnimPlayController.this.playAnim("hot_gift_spark.y2a");
                    }
                }, 2400L);
            }
        }

        public void onStopped() {
            MLog.info((Object)"HotGiftAnimPlayController", (String)"ly Player onStopped!", (Object[])new Object[0]);
            HotGiftAnimPlayController.this.isStop = true;
            if (HotGiftAnimPlayController.this.mPlayer != null) {
                HotGiftAnimPlayController.this.mPlayer.stop();
            }
            HotGiftAnimPlayController.this.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    HotGiftAnimPlayController.this.hide();
                }
            });
        }

        public void onDestroyed() {
        }
    }
}

