/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.bumptech.glide.Glide;
import com.duowan.mobile.entlive.events.IPKClient_onPKStart_EventArgs;
import com.duowan.mobile.entlive.events.IPKClient_onPKStop_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.RxBus;
import com.yy.mobile.liveapi.help.WebViewEventListener;
import com.yy.mobile.liveapi.pk.IPkCore;
import com.yy.mobile.plugin.main.events.Gift_OnGiftBannerStatusListener_args;
import com.yy.mobile.plugin.main.events.IGiftUIListener_onGiftUICreated_EventArgs;
import com.yy.mobile.plugin.main.events.IGiftUIListener_onGiftUIHide_EventArgs;
import com.yy.mobile.plugin.main.events.IGiftUIListener_onGiftUIShow_EventArgs;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.gift.SceneBannerController$$EventBinder;
import com.yy.mobile.ui.scenepacket.IUnionScenePacketCore;
import com.yy.mobile.ui.scenepacket.UnionScenePacketInfo;
import com.yy.mobile.ui.scenepacket.UnionScenePacketMgr;
import com.yy.mobile.util.SyntaxExtendKt;
import com.yy.mobile.util.VivoDataReportUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewEventListener;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewFragmentInterface;
import com.yy.mobile.ylink.bridge.coreapi.WebViewFragmentApi;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.scenepacket.IScenePacketCore;
import com.yymobile.core.scenepacket.ScenePacketQueryNotifyEventArgs;
import io.reactivex.subjects.BehaviorSubject;
import java.util.HashMap;

public class SceneBannerController
implements EventCompat {
    protected int mCurSceneType;
    public Context mContext;
    public ViewGroup mRootView;
    private FragmentManager mFragmentManager;
    public BaseLinkFragment mWebBannerFragment;
    public View mWebBannerView;
    public boolean mIsWebBannerHidden;
    protected boolean mIsGiftUIShown;
    private boolean mIsReocrdFirstRechargeAccessShownCount;
    public String mLastUrl;
    private UnionScenePacketInfo mUnionScenePacketInfo;
    public ImageView bannerImageView;
    private final BehaviorSubject<Boolean> visibleSubject = BehaviorSubject.createDefault((Object)false);
    public String bannerImageUrl = "";
    private EventBinder mSceneBannerControllerSniperEventBinder;

    public void onEventBind() {
        if (this.mSceneBannerControllerSniperEventBinder == null) {
            this.mSceneBannerControllerSniperEventBinder = new SceneBannerController$$EventBinder();
        }
        this.mSceneBannerControllerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mSceneBannerControllerSniperEventBinder != null) {
            this.mSceneBannerControllerSniperEventBinder.unBindEvent();
        }
    }

    public void init(FragmentActivity activity, ViewGroup rootView, FragmentManager fragmentManager) {
        this.mContext = activity;
        this.mRootView = rootView;
        this.mFragmentManager = fragmentManager;
        if (null == this.mFragmentManager) {
            this.mFragmentManager = activity.getSupportFragmentManager();
        }
        this.onEventBind();
        MLog.debug((Object)"SceneBannerController", (String)"init", (Object[])new Object[0]);
    }

    protected void queryScenePacketInfo() {
        this.mCurSceneType = ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).getWillShownSceneType();
        if (this.mCurSceneType == -1) {
            ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).queryScenePacketInfo();
        } else {
            MLog.debug((Object)"SceneBannerController", (String)("post cache sceneType :" + this.mCurSceneType), (Object[])new Object[0]);
            RxBus.getDefault().post((Object)new ScenePacketQueryNotifyEventArgs(this.mCurSceneType));
        }
    }

    @BusEvent(sync=true)
    public void onGiftUICreated(IGiftUIListener_onGiftUICreated_EventArgs busEventArgs) {
    }

    @BusEvent(sync=true)
    public void onGiftUIShow(IGiftUIListener_onGiftUIShow_EventArgs busEventArgs) {
        this.mIsGiftUIShown = true;
        if (!((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).scenePacketIsClose()) {
            this.queryScenePacketInfo();
        } else {
            this.showNewScenePacketBanner();
        }
    }

    private void showNewScenePacketBanner() {
        if (((IPkCore)ICoreManagerBase.getCore(IPkCore.class)).isPkShow()) {
            this.hideWebBanner();
            return;
        }
        this.mUnionScenePacketInfo = ((IUnionScenePacketCore)ICoreManagerBase.getCore(IUnionScenePacketCore.class)).unionScenePacketInfo();
        if (this.mUnionScenePacketInfo != null) {
            if (UnionScenePacketMgr.Companion.getInstance().bannerCertificationInGiftUi(this.mUnionScenePacketInfo)) {
                this.showWebBanner();
                this.addWebBannerIfNotExist(this.mUnionScenePacketInfo.getAdUrl(), this.mUnionScenePacketInfo.getBannerImageUrl());
            } else {
                this.hideWebBanner();
            }
        }
    }

    @BusEvent(sync=true)
    public void onGiftUIHide(IGiftUIListener_onGiftUIHide_EventArgs busEventArgs) {
        this.mIsGiftUIShown = false;
    }

    @BusEvent(sync=true)
    public void onPKStart(IPKClient_onPKStart_EventArgs busEventArgs) {
        this.hideWebBanner();
    }

    @BusEvent(sync=true)
    public void onPKStop(IPKClient_onPKStop_EventArgs busEventArgs) {
        if (this.mIsGiftUIShown) {
            if (!((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).scenePacketIsClose()) {
                if (this.mCurSceneType > 0) {
                    this.showWebBanner();
                    this.addWebBannerIfNotExist(((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).getRechargeBannerUrl(this.mCurSceneType), ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).getRechargeBannerImageUrl(this.mCurSceneType));
                } else {
                    this.hideWebBanner();
                }
            } else {
                this.showNewScenePacketBanner();
            }
        }
    }

    @BusEvent(sync=true)
    public void onQueryScenePacketInfo(ScenePacketQueryNotifyEventArgs eventArgs) {
        MLog.info((Object)"SceneBannerController", (String)("onQueryScenePacketInfo:" + eventArgs.getType()), (Object[])new Object[0]);
        this.mCurSceneType = eventArgs.getType();
        this.onQueryScenePacketInfo();
    }

    protected void onQueryScenePacketInfo() {
        if (this.mIsGiftUIShown) {
            if (this.mCurSceneType == 0) {
                this.removeWebBanner();
            } else if (this.mCurSceneType > 0) {
                if (!((IPkCore)CoreFactory.getCore(IPkCore.class)).isPkShow()) {
                    this.showWebBanner();
                    this.addWebBannerIfNotExist(((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).getRechargeBannerUrl(this.mCurSceneType), ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).getRechargeBannerImageUrl(this.mCurSceneType));
                } else {
                    this.hideWebBanner();
                }
            }
        }
    }

    protected void addWebBannerIfNotExist(String url, String imageUrl) {
        this.bannerImageUrl = imageUrl;
        String bannerUrl = url;
        MLog.info((Object)"SceneBannerController", (String)("addWebBannerIfNotExist url :" + bannerUrl), (Object[])new Object[0]);
        if (null == this.mWebBannerFragment) {
            if (!TextUtils.isEmpty((CharSequence)bannerUrl)) {
                this.mWebBannerFragment = this.getOrCreatWebViewFragment(bannerUrl);
            }
            if (null != this.mWebBannerFragment && this.checkActivityValid() && null != this.mRootView && null != this.mRootView.getParent() && this.mRootView.getId() > 0 && !this.mWebBannerFragment.isAdded() && null != this.mFragmentManager) {
                this.setWebBannerListener((IWebViewFragmentInterface)this.mWebBannerFragment);
                this.setRootViewLayoutParams();
                this.mRootView.setVisibility(0);
                this.visibleSubject.onNext((Object)true);
                this.mFragmentManager.beginTransaction().replace(this.mRootView.getId(), (Fragment)this.mWebBannerFragment, "WEB_BANNER").commitAllowingStateLoss();
                HashMap hashMap = VivoDataReportUtil.INSTANCE.getDefaultDataMap();
                hashMap.putAll(VivoDataReportUtil.INSTANCE.getDefaultDataMapExt());
                hashMap.put("banner_id", this.mCurSceneType + "");
                VivoDataReportUtil.INSTANCE.report("001|008|02|112", 1, hashMap);
                MLog.debug((Object)"SceneBannerController", (String)"show banner>>>>", (Object[])new Object[0]);
                RxBus.getDefault().post((Object)new Gift_OnGiftBannerStatusListener_args(true));
            }
        } else if (null != ((IWebViewFragmentInterface)this.mWebBannerFragment).getWebView() && !TextUtils.isEmpty((CharSequence)bannerUrl) && !bannerUrl.equals(((IWebViewFragmentInterface)this.mWebBannerFragment).getWebView().getUrl())) {
            MLog.debug((Object)"SceneBannerController", (String)("load " + bannerUrl + " again! oldurl :" + ((IWebViewFragmentInterface)this.mWebBannerFragment).getWebView().getUrl()), (Object[])new Object[0]);
            this.setRootViewLayoutParams();
            this.mRootView.setVisibility(0);
            this.visibleSubject.onNext((Object)true);
            this.setWebBannerListener((IWebViewFragmentInterface)this.mWebBannerFragment);
            ((IWebViewFragmentInterface)this.mWebBannerFragment).setUrl(bannerUrl, true);
        } else {
            MLog.debug((Object)"SceneBannerController", (String)"the same url!", (Object[])new Object[0]);
        }
    }

    protected void removeWebBanner() {
        this.mIsWebBannerHidden = false;
        if (null != this.mWebBannerFragment) {
            BaseLinkFragment removeFragment = this.mWebBannerFragment;
            ((IWebViewFragmentInterface)this.mWebBannerFragment).setWebViewEventLister(null);
            this.mWebBannerFragment = null;
            this.mWebBannerView = null;
            if (this.checkActivityValid() && this.mRootView != null && this.mRootView.getParent() != null && this.mRootView.getId() > 0) {
                MLog.info((Object)"SceneBannerController", (String)"removeWebBanner", (Object[])new Object[0]);
                this.mFragmentManager.beginTransaction().remove((Fragment)removeFragment).commitAllowingStateLoss();
                this.mRootView.setVisibility(8);
                this.visibleSubject.onNext((Object)false);
                this.mRootView.removeAllViews();
                this.bannerImageView = null;
                RxBus.getDefault().post((Object)new Gift_OnGiftBannerStatusListener_args(false));
            }
        }
    }

    protected void hideWebBanner() {
        this.mIsWebBannerHidden = true;
        if (null != this.mWebBannerView) {
            this.mWebBannerView.setVisibility(8);
        }
        if (this.mWebBannerFragment != null) {
            this.mFragmentManager.beginTransaction().remove((Fragment)this.mWebBannerFragment).commitAllowingStateLoss();
            this.mWebBannerFragment = null;
        }
    }

    protected void showWebBanner() {
        this.mIsWebBannerHidden = false;
        if (null != this.mWebBannerView) {
            this.mWebBannerView.setVisibility(0);
        }
    }

    private BaseLinkFragment getOrCreatWebViewFragment(String url) {
        BaseLinkFragment wvFragment = ((WebViewFragmentApi)CoreApiManager.getInstance().getApi(WebViewFragmentApi.class)).createWebViewFragment(url, true, false);
        if (wvFragment instanceof IWebViewFragmentInterface) {
            ((IWebViewFragmentInterface)wvFragment).setEnablePullRefresh(false);
        }
        return wvFragment;
    }

    private void setWebBannerListener(@NonNull IWebViewFragmentInterface fragmentInterface) {
        fragmentInterface.setWebViewEventLister((IWebViewEventListener)new WebViewEventListener(){

            public void onPageStarted(WebView view, String url, Bitmap favIcon) {
                if (view != null) {
                    view.setBackgroundColor(0);
                    if (TextUtils.isEmpty((CharSequence)SceneBannerController.this.mLastUrl)) {
                        view.setVisibility(4);
                    }
                }
            }

            public void onPageFinished(WebView view, String url) {
                if (view != null) {
                    view.setBackgroundColor(0);
                    view.setVisibility(0);
                }
                if (null != SceneBannerController.this.mWebBannerFragment) {
                    SceneBannerController.this.mWebBannerView = SceneBannerController.this.mWebBannerFragment.getView();
                    if (null != SceneBannerController.this.mWebBannerView) {
                        SceneBannerController.this.mWebBannerView.setVisibility(SceneBannerController.this.mIsWebBannerHidden ? 4 : 0);
                        SceneBannerController.this.mWebBannerView.setLayoutParams(SceneBannerController.this.genWebBannerViewParams());
                    }
                    if (SceneBannerController.this.bannerImageView == null && SceneBannerController.this.bannerImageUrl != null && !SceneBannerController.this.bannerImageUrl.equals("")) {
                        SceneBannerController.this.bannerImageView = new ImageView(SceneBannerController.this.mContext);
                        Glide.with((Context)SceneBannerController.this.bannerImageView.getContext()).load(SceneBannerController.this.bannerImageUrl).into(SceneBannerController.this.bannerImageView);
                        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
                        SceneBannerController.this.mRootView.addView((View)SceneBannerController.this.bannerImageView, (ViewGroup.LayoutParams)layoutParams);
                    }
                }
                if (SceneBannerController.this.mCurSceneType == 1 && !SceneBannerController.this.mIsWebBannerHidden) {
                    SceneBannerController.this.recordFirstRechargePacketAccessShownCount();
                }
                SceneBannerController.this.mLastUrl = url;
            }
        });
    }

    public void recordFirstRechargePacketAccessShownCount() {
        if (!this.mIsReocrdFirstRechargeAccessShownCount) {
            this.mIsReocrdFirstRechargeAccessShownCount = true;
            ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).recordFirstRechargePacketAccessShownCount1DayOnce();
        }
    }

    public ViewGroup.LayoutParams genWebBannerViewParams() {
        return new RelativeLayout.LayoutParams(-1, -1);
    }

    @TargetApi(value=17)
    protected boolean checkActivityValid() {
        if (null == this.mContext) {
            return false;
        }
        Activity activity = (Activity)this.mContext;
        if (activity.isFinishing()) {
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || !activity.isDestroyed();
    }

    public void destory() {
        MLog.debug((Object)"SceneBannerController", (String)"destory", (Object[])new Object[0]);
        this.onEventUnBind();
        this.removeWebBanner();
        this.mCurSceneType = -1;
        this.mContext = null;
        this.mRootView = null;
        this.mLastUrl = null;
        this.mWebBannerFragment = null;
        this.mWebBannerView = null;
        this.mIsWebBannerHidden = false;
        this.mIsGiftUIShown = false;
        this.mIsReocrdFirstRechargeAccessShownCount = false;
        this.mFragmentManager = null;
    }

    public BehaviorSubject<Boolean> getVisibleSubject() {
        return this.visibleSubject;
    }

    private void setRootViewLayoutParams() {
        if (this.mRootView != null) {
            ViewGroup.LayoutParams params = this.mRootView.getLayoutParams();
            params.height = (int)SyntaxExtendKt.getDpToPx((Number)52);
            this.mRootView.setLayoutParams(params);
        }
    }
}

