/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.duowan.mobile.entlive.events.IGiftClient_onSendPaidGift_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.ent.mobile.activitytemplate.dto.pb.nano.Activity;
import com.yy.live.module.giftmodule.event.NewPkCurrentPersonChooseChangeEvent;
import com.yy.live.module.giftmodule.event.NewPkShowGiftEvent;
import com.yy.mobile.RxBus;
import com.yy.mobile.base.utils.DensityUtils;
import com.yy.mobile.memoryrecycle.views.YYLinearLayout;
import com.yy.mobile.memoryrecycle.views.YYTextView;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.gift.GiftComponent;
import com.yy.mobile.ui.gift.NewPkGiftComponent$$EventBinder;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.widget.AdvancedRadioGroup;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.gift.IGiftCore;
import com.yymobile.core.newpk.NewPkActivitiesGiftDataCore;
import com.yymobile.core.pay.MoneyBalance;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class NewPkGiftComponent
extends GiftComponent {
    public NewPkShowGiftEvent mPullUpEvent;
    public PersonInfo mCurrentPersonChoose;
    private Disposable mExecutePullUpEventDisposable;
    private Disposable mShowPopupPersonListDisposable;
    private RelativeLayout talentScoutSubBarView;
    private AdvancedRadioGroup mTalentScoutGiftTabLayout;
    private TextView mTalentScoutRecharge;
    private TextView mTalentScoutYCurrency;
    private RadioButton mTalentScoutTabGift;
    public ChoosePersonButtonBox mPersonChoose;
    public ChoosePersonButtonBox mPersonChooseLand;
    public PopupWindow mPersonListPopupView;
    private TextView mPersonListPopupTitleTextView;
    public PersonChooseAdapter mPersonListAdapter;
    private AdvancedRadioGroup.OnCheckedChangeListener onTalentScoutCheckedChangeListener = new AdvancedRadioGroup.OnCheckedChangeListener(){

        public void onCheckedChanged(AdvancedRadioGroup group, int checkedId) {
            if (checkedId == R.id.talent_scout_tab_gift) {
                NewPkGiftComponent.this.isTabGift = true;
                NewPkGiftComponent.this.onTalentScoutGiftBagTabChanged(false);
            } else if (checkedId == R.id.talent_scout_tab_bag) {
                NewPkGiftComponent.this.isTabGift = false;
                NewPkGiftComponent.this.onTalentScoutGiftBagTabChanged(true);
            }
        }
    };
    private LinearLayout mGiftRightControllLandLayout;
    private LinearLayout mLandRightView;
    private View llAmountFull;
    private DecimalFormat mMoneyFormat;
    private View mGiftDivLine;
    private View.OnClickListener personChooseClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            NewPkGiftComponent.this.showPopupPersonList(v);
        }
    };
    private EventBinder mNewPkGiftComponentSniperEventBinder;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = super.onCreateView(inflater, container, savedInstanceState);
        if (this.isNewPkNow()) {
            this.initNewPkView();
            this.initData();
            this.renderWhenVisible();
            this.executePullUpEvent(300L);
            this.showPopupPersonListIfUnselected(500L);
        }
        this.mMoneyFormat = new DecimalFormat("#,###.#");
        MLog.info((Object)"NewPkGiftComponent", (String)"onCreateView", (Object[])new Object[0]);
        return rootView;
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        if (this.mExecutePullUpEventDisposable != null && !this.mExecutePullUpEventDisposable.isDisposed()) {
            this.mExecutePullUpEventDisposable.dispose();
        }
        if (this.mShowPopupPersonListDisposable != null && !this.mShowPopupPersonListDisposable.isDisposed()) {
            this.mShowPopupPersonListDisposable.dispose();
        }
        Object var2_1 = null;
        if (this.mNewPkGiftComponentSniperEventBinder != null) {
            this.mNewPkGiftComponentSniperEventBinder.unBindEvent();
        }
    }

    private void showPopupPersonListIfUnselected(long delayMiles) {
        if (this.mShowPopupPersonListDisposable != null && !this.mShowPopupPersonListDisposable.isDisposed()) {
            this.mShowPopupPersonListDisposable.dispose();
        }
        if (this.mCurrentPersonChoose != null) {
            return;
        }
        this.mShowPopupPersonListDisposable = Observable.just((Object)0).delay(delayMiles, TimeUnit.MILLISECONDS).subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).filter((Predicate)new Predicate<Integer>(){

            public boolean test(Integer integer) {
                NewPkGiftComponent.this.updatePopupPersonListData();
                NewPkGiftComponent.this.renderPersonChooseButton();
                return NewPkGiftComponent.this.mCurrentPersonChoose == null;
            }
        }).subscribe((Consumer)new Consumer<Integer>(){

            public void accept(Integer a) {
                NewPkGiftComponent.this.showPopupPersonList((View)(NewPkGiftComponent.this.isLandScapeMode() ? NewPkGiftComponent.this.mPersonChooseLand.chooseLayout : NewPkGiftComponent.this.mPersonChoose.chooseLayout));
            }
        });
    }

    private void initData() {
        this.queryMoneyBalance();
    }

    private void renderWhenVisible() {
        this.updatePopupPersonListData();
        this.renderPersonChooseButton();
    }

    @Override
    public void onQueryMoneyBalance(int result, MoneyBalance moneyBalance) {
        if (!this.isNewPkNow()) {
            return;
        }
        double v = (double)moneyBalance.amount / 1000.0;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"NewPkGiftComponent", (String)("money balance=" + v), (Object[])new Object[0]);
        }
        if (this.mTalentScoutYCurrency != null) {
            this.mTalentScoutYCurrency.setText((CharSequence)this.mMoneyFormat.format(v));
        }
    }

    private void initNewPkView() {
        int w;
        this.giftTabLayout.setVisibility(8);
        this.tvBalance.setVisibility(8);
        this.giftTabLayoutLand.setVisibility(8);
        this.tvBalanceLand.setVisibility(8);
        this.mTvRechargeFull.setVisibility(8);
        this.mFullScreenSendView.setVisibility(8);
        if (this.mBottomView instanceof ViewGroup) {
            this.mPersonChoose = this.createChoosePersonButton(false, 0, 0);
            ((ViewGroup)this.mBottomView).addView((View)this.mPersonChoose.chooseLayout);
        }
        this.talentScoutSubBarView = (RelativeLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.new_pk_subbar_layout, null);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, DensityUtil.dip2px((Context)this.getContext(), (float)40.0f));
        lp.addRule(2, R.id.rl_gift_list);
        this.talentScoutSubBarView.setLayoutParams((ViewGroup.LayoutParams)lp);
        if (this.mRootView != null) {
            this.mRootView.addView((View)this.talentScoutSubBarView);
        }
        if (this.mStarTaskRoot.getLayoutParams() instanceof RelativeLayout.LayoutParams) {
            RelativeLayout.LayoutParams lp2 = (RelativeLayout.LayoutParams)this.mStarTaskRoot.getLayoutParams();
            lp2.addRule(2, R.id.talent_scout_layout);
        }
        this.mGiftRightControllLandLayout = (LinearLayout)this.mRootView.findViewById(R.id.gift_right_controll_land_layout);
        this.mLandRightView = (LinearLayout)this.mRootView.findViewById(R.id.ll_amount_send_layout_full_screen);
        this.llAmountFull = this.mRootView.findViewById(R.id.ll_amount_full);
        this.mLandRightView.setBackgroundColor(this.getResources().getColor(R.color.color_white));
        this.mGiftRightControllLandLayout.getLayoutParams().width = w = DensityUtil.dip2px((Context)this.getContext(), (float)200.0f);
        int h = DensityUtil.dip2px((Context)this.getContext(), (float)34.0f);
        this.mPersonChooseLand = this.createChoosePersonButton(true, 0, h);
        this.mGiftRightControllLandLayout.addView((View)this.mPersonChooseLand.chooseLayout, 0);
        this.mFullScreenAmountTv.getLayoutParams().width = w - DensityUtil.dip2px((Context)this.getContext(), (float)20.0f) - this.mRootView.findViewById((int)R.id.tv_send_gift_full_screen).getLayoutParams().width;
        this.mRootView.findViewById((int)R.id.tv_send_gift_full_screen).getLayoutParams().height = h;
        this.mFullScreenAmountTv.getLayoutParams().height = h;
        View touYin = new View(this.getContext());
        touYin.setBackgroundResource(R.drawable.windows_shadow);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(DensityUtil.dip2px((Context)this.getContext(), (float)2.0f), this.getResources().getDimensionPixelSize(R.dimen.gift_grid_item_height));
        layoutParams.addRule(0, R.id.ll_amount_send_layout_full_screen);
        touYin.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.mGiftPageView instanceof ViewGroup) {
            ((ViewGroup)this.mGiftPageView).addView(touYin);
        }
        this.mTalentScoutGiftTabLayout = (AdvancedRadioGroup)this.talentScoutSubBarView.findViewById(R.id.talent_scout_gift_tab_layout);
        this.mTalentScoutTabGift = (RadioButton)this.talentScoutSubBarView.findViewById(R.id.talent_scout_tab_gift);
        this.mTalentScoutYCurrency = (TextView)this.talentScoutSubBarView.findViewById(R.id.talent_scout_y_currency);
        this.mTalentScoutRecharge = (TextView)this.talentScoutSubBarView.findViewById(R.id.talent_scout_recharge);
        this.mGiftDivLine = this.mRootView.findViewById(R.id.gift_div_line);
        this.mGiftDivLine.setBackgroundResource(R.color.color_white);
        this.mPersonChooseLand.chooseLayout.setVisibility(8);
        this.mPersonChoose.chooseLayout.setVisibility(0);
        this.mTalentScoutYCurrency.setOnClickListener(this.moneyBalanceClick);
        this.mTalentScoutGiftTabLayout.setOnCheckedChangeListener(this.onTalentScoutCheckedChangeListener);
        this.mTalentScoutRecharge.setOnClickListener(this.mRechargeClick);
        this.mPersonChoose.chooseLayout.setOnClickListener(this.personChooseClickListener);
        this.mPersonChooseLand.chooseLayout.setOnClickListener(this.personChooseClickListener);
        if (!this.mIsFullScreen) {
            this.tabGift.setChecked(true);
            this.mTalentScoutTabGift.setChecked(true);
            this.isTabGift = true;
        } else {
            this.tabGiftLand.setChecked(true);
            this.isTabGift = true;
        }
        this.renderPopupPersonList();
    }

    private ChoosePersonButtonBox createChoosePersonButton(boolean isLand, int w, int h) {
        ChoosePersonButtonBox buttonBox = new ChoosePersonButtonBox();
        if (isLand) {
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, h);
            lp.topMargin = DensityUtil.dip2px((Context)this.getContext(), (float)8.0f);
            lp.leftMargin = lp.rightMargin = DensityUtil.dip2px((Context)this.getContext(), (float)10.0f);
            buttonBox.chooseLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
        } else {
            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -2);
            lp.leftMargin = DensityUtil.dip2px((Context)this.getContext(), (float)10.0f);
            lp.rightMargin = 2 * lp.leftMargin;
            lp.addRule(0, R.id.ll_amount);
            lp.addRule(15);
            buttonBox.chooseLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        return buttonBox;
    }

    private void disablePersonChoose() {
        this.mPersonChoose.chooseLayout.setEnabled(false);
        this.mPersonChooseLand.chooseLayout.setEnabled(false);
    }

    private void enablePersonChoose() {
        this.mPersonChoose.chooseLayout.setEnabled(true);
        this.mPersonChooseLand.chooseLayout.setEnabled(true);
    }

    @Override
    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        if (!this.isNewPkNow()) {
            return;
        }
        if (!hidden) {
            this.renderWhenVisible();
            this.executePullUpEvent(300L);
            this.showPopupPersonListIfUnselected(500L);
            if (this.mPersonChoose == null) {
                this.initNewPkView();
                this.initData();
            }
            if (this.mIsFullScreen) {
                this.mPersonChooseLand.chooseLayout.setVisibility(0);
                this.giftTabLayoutLand.setVisibility(8);
                this.tvBalanceLand.setVisibility(8);
                this.mTvRechargeFull.setVisibility(8);
            } else {
                this.mPersonChooseLand.chooseLayout.setVisibility(8);
                this.giftTabLayout.setVisibility(8);
                this.tvBalance.setVisibility(8);
            }
        } else {
            this.mTalentScoutTabGift.setChecked(true);
        }
    }

    public void onOrientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        if (!this.isNewPkNow()) {
            return;
        }
        if (isLandscape) {
            this.mPersonChooseLand.chooseLayout.setVisibility(0);
            this.giftTabLayoutLand.setVisibility(8);
            this.tvBalanceLand.setVisibility(8);
            this.mTvRechargeFull.setVisibility(8);
            this.talentScoutSubBarView.removeView((View)this.mTalentScoutGiftTabLayout);
            this.mTalentScoutGiftTabLayout.setOrientation(1);
            LinearLayout.LayoutParams giftLayoutParams = new LinearLayout.LayoutParams(DensityUtils.dp2px((float)60.0f), DensityUtils.dp2px((float)100.0f));
            this.mTalentScoutGiftTabLayout.setLayoutParams((ViewGroup.LayoutParams)giftLayoutParams);
            this.mLandRightView.addView((View)this.mTalentScoutGiftTabLayout, 0);
            this.mRootView.removeView((View)this.mStarTaskRoot);
            RelativeLayout.LayoutParams starTaskLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
            starTaskLayoutParams.setMargins(0, 0, DensityUtils.dp2px((float)20.0f), 0);
            starTaskLayoutParams.addRule(0, R.id.talent_scout_y_currency);
            this.mStarTaskRoot.setLayoutParams((ViewGroup.LayoutParams)starTaskLayoutParams);
            this.talentScoutSubBarView.addView((View)this.mStarTaskRoot, 0);
            this.talentScoutSubBarView.setBackgroundColor(this.getResources().getColor(R.color.bg_preview_shrink));
        } else {
            this.mPersonChooseLand.chooseLayout.setVisibility(8);
            this.giftTabLayout.setVisibility(8);
            this.tvBalance.setVisibility(8);
            this.mLandRightView.removeView((View)this.mTalentScoutGiftTabLayout);
            this.mTalentScoutGiftTabLayout.setOrientation(0);
            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(DensityUtils.dp2px((float)120.0f), -1);
            this.mTalentScoutGiftTabLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.talentScoutSubBarView.addView((View)this.mTalentScoutGiftTabLayout, 0);
            this.talentScoutSubBarView.removeView((View)this.mStarTaskRoot);
            RelativeLayout.LayoutParams starTaskLayoutParams = new RelativeLayout.LayoutParams(-1, DensityUtils.dp2px((float)44.0f));
            starTaskLayoutParams.addRule(2, R.id.talent_scout_layout);
            this.mStarTaskRoot.setLayoutParams((ViewGroup.LayoutParams)starTaskLayoutParams);
            this.mRootView.addView((View)this.mStarTaskRoot);
            this.talentScoutSubBarView.setBackgroundColor(this.getResources().getColor(R.color.color_bg_lock_gray));
        }
    }

    @Override
    protected boolean isCanSendArGift() {
        this.toast("\u62b1\u6b49,\u661f\u63a2\u8fde\u9ea6\u65f6\u65e0\u6cd5\u8d60\u9001AR\u793c\u7269\uff5e");
        return false;
    }

    public void onTalentScoutGiftBagTabChanged(boolean isCheck) {
        if (isCheck) {
            this.mGiftViewPager.setPagingEnabled(false);
            this.loadGiftBagTab();
            this.toggoleGfitBagTabTip(true);
            this.setAmountButtonStatus(this.mPackageSelectedGiftItem);
            ((IGiftCore)ICoreManagerBase.getCore(IGiftCore.class)).queryFreeGift();
        } else {
            this.mGiftViewPager.setPagingEnabled(true);
            this.hideGiftBagTab();
            this.toggoleGfitBagTabTip(false);
            this.setAmountButtonStatus(this.mGiftItemPagerAdapter.getSelectedItem());
        }
    }

    public void updatePopupPersonListData() {
        if (this.mPersonListAdapter == null) {
            return;
        }
        ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
        Activity.AnchorPickInfo info = NewPkActivitiesGiftDataCore.Companion.getInstance().getMLeftInfo();
        if (info != null && info.aid > 0L) {
            boolean isGiftShow = NewPkActivitiesGiftDataCore.Companion.getInstance().getType() == NewPkActivitiesGiftDataCore.Companion.getInstance().getDRAFT_PK();
            persons.add(new PersonInfo(info, isGiftShow ? R.drawable.new_pk_support_blue : R.drawable.new_pk_support_red));
        }
        if ((info = NewPkActivitiesGiftDataCore.Companion.getInstance().getMRightInfo()) != null && info.aid > 0L) {
            persons.add(new PersonInfo(info, R.drawable.new_pk_support_blue));
        }
        if (!this.mPersonListAdapter.equalsData(persons)) {
            this.setCurrentPersonChoose(persons.size() == 1 ? (PersonInfo)persons.get(0) : null);
            this.mPersonListAdapter.setData(persons);
        }
    }

    private void renderPopupPersonList() {
        if (this.mPersonListAdapter == null) {
            this.mPersonListAdapter = new PersonChooseAdapter();
        }
        if (this.mPersonListPopupView == null) {
            ViewGroup popupRootView = (ViewGroup)this.getActivity().getLayoutInflater().inflate(R.layout.new_pk_amount_list, null);
            this.mPersonListPopupTitleTextView = (TextView)popupRootView.findViewById(R.id.popup_title_tips);
            ListView personListView = (ListView)popupRootView.findViewById(R.id.lv_amount);
            personListView.setAdapter((ListAdapter)this.mPersonListAdapter);
            personListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    if (NewPkGiftComponent.this.mPersonListPopupView != null && NewPkGiftComponent.this.mPersonListPopupView.isShowing()) {
                        NewPkGiftComponent.this.mPersonListPopupView.dismiss();
                    }
                    NewPkGiftComponent.this.setCurrentPersonChoose(NewPkGiftComponent.this.mPersonListAdapter.getItem(position));
                    NewPkGiftComponent.this.renderPersonChooseButton();
                }
            });
            this.mPersonListPopupView = new PopupWindow((Context)this.getActivity());
            this.mPersonListPopupView.setContentView((View)popupRootView);
            this.mPersonListPopupView.setBackgroundDrawable((Drawable)new BitmapDrawable());
            this.mPersonListPopupView.setOutsideTouchable(true);
            this.mPersonListPopupView.setFocusable(true);
            this.mPersonListPopupView.setWidth(this.getActivity().getResources().getDimensionPixelSize(R.dimen.newpk_gift_amount_list_width));
            this.mPersonListPopupView.setHeight(-2);
            this.mPersonListPopupView.setOnDismissListener(new PopupWindow.OnDismissListener(){

                public void onDismiss() {
                }
            });
        }
    }

    public void showPopupPersonList(View anchorView) {
        if (!this.isVisible()) {
            return;
        }
        this.updatePopupPersonListData();
        this.renderPersonChooseButton();
        if (this.mPersonListAdapter.getCount() <= 1) {
            return;
        }
        this.mPersonListAdapter.notifyDataSetChanged();
        int[] location = new int[2];
        anchorView.getLocationOnScreen(location);
        int x = location[0] + anchorView.getWidth() / 2 - this.mPersonListPopupView.getWidth() / 2;
        int y = this.mIsFullScreen ? this.mLandRightView.getHeight() : this.mBottomView.getHeight();
        this.mPersonListPopupView.showAtLocation(anchorView, 83, x, y);
        String tips = NewPkActivitiesGiftDataCore.Companion.getInstance().getMAnchorDsc();
        tips = TextUtils.isEmpty((CharSequence)tips) ? "\u8bf7\u9009\u62e9\u8d60\u9001\u5bf9\u8c61" : tips;
        this.mPersonListPopupTitleTextView.setText((CharSequence)tips);
    }

    public void renderPersonChooseButton() {
        if (this.mCurrentPersonChoose == null) {
            String tips = NewPkActivitiesGiftDataCore.Companion.getInstance().getMAnchorBtnTips();
            tips = TextUtils.isEmpty((CharSequence)tips) ? "\u8bf7\u9009\u62e9\u8d60\u9001\u5bf9\u8c61" : tips;
            this.mPersonChoose.supportTextView.setText((CharSequence)"");
            this.mPersonChoose.circleImageView.setImageBitmap(null);
            this.mPersonChoose.nickNameTextView.setText((CharSequence)tips);
            this.mPersonChooseLand.supportTextView.setText((CharSequence)"");
            this.mPersonChooseLand.circleImageView.setImageBitmap(null);
            this.mPersonChooseLand.nickNameTextView.setText((CharSequence)tips);
            return;
        }
        boolean isNeedDot = NewPkActivitiesGiftDataCore.Companion.getInstance().isDotShow(this.mCurrentPersonChoose.uid);
        if (this.mPersonChoose != null) {
            if (isNeedDot) {
                this.mPersonChoose.supportTextView.setText((CharSequence)"\u652f\u6301");
                this.mPersonChoose.circleImageView.setImageResource(this.mCurrentPersonChoose.iconRes);
            } else {
                this.mPersonChoose.supportTextView.setText((CharSequence)"\u9001\u7ed9");
                this.mPersonChoose.circleImageView.setImageBitmap(null);
            }
            this.mPersonChoose.nickNameTextView.setText((CharSequence)this.mCurrentPersonChoose.info.nick);
        }
        if (this.mPersonChooseLand != null) {
            if (isNeedDot) {
                this.mPersonChooseLand.supportTextView.setText((CharSequence)"\u652f\u6301");
                this.mPersonChooseLand.circleImageView.setImageResource(this.mCurrentPersonChoose.iconRes);
            } else {
                this.mPersonChooseLand.supportTextView.setText((CharSequence)"\u9001\u7ed9");
                this.mPersonChooseLand.circleImageView.setImageBitmap(null);
            }
            this.mPersonChooseLand.nickNameTextView.setText((CharSequence)this.mCurrentPersonChoose.info.nick);
        }
    }

    @Override
    protected int[] createPopupWindownPos(View view, PopupWindow popupWindow) {
        if (view == null) {
            return null;
        }
        if (!this.isNewPkNow()) {
            return null;
        }
        if (this.mIsFullScreen && popupWindow != null && this.llAmountFull != null) {
            int[] location = new int[2];
            view.getLocationOnScreen(location);
            int[] popLocation = new int[]{location[0] + view.getWidth() / 2 - popupWindow.getWidth() / 2, this.llAmountFull.getHeight() + DensityUtil.dip2px((Context)this.getContext(), (float)2.0f)};
            return popLocation;
        }
        return null;
    }

    @Override
    protected long getSendToUid() {
        if (this.mCurrentPersonChoose != null && this.isNewPkNow()) {
            return this.mCurrentPersonChoose.uid;
        }
        return 0L;
    }

    @Override
    protected Map<String, String> getExtendInfo() {
        HashMap<String, String> extendInfo = new HashMap<String, String>();
        if (this.mCurrentPersonChoose != null && this.getSendToUid() != ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId()) {
            extendInfo.put("7", "true");
            extendInfo.put("prop_recipient_sign", this.mCurrentPersonChoose.info.sign);
        }
        return extendInfo;
    }

    public void setPullUpEvent(NewPkShowGiftEvent event) {
        this.mPullUpEvent = event;
    }

    private void executePullUpEvent(long delayMiles) {
        if (this.mPullUpEvent == null) {
            return;
        }
        if (this.mExecutePullUpEventDisposable != null && !this.mExecutePullUpEventDisposable.isDisposed()) {
            this.mExecutePullUpEventDisposable.dispose();
        }
        this.mExecutePullUpEventDisposable = Observable.just((Object)this.mPullUpEvent).delay(delayMiles, TimeUnit.MILLISECONDS).subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<NewPkShowGiftEvent>(){

            public void accept(NewPkShowGiftEvent a) {
                NewPkGiftComponent.this.updatePopupPersonListData();
                NewPkGiftComponent.this.setCurrentPersonChoose(NewPkGiftComponent.this.mPersonListAdapter.getItemByUid(NewPkGiftComponent.this.mPullUpEvent.getAnchor().aid));
                NewPkGiftComponent.this.renderPersonChooseButton();
                final int giftType = (int)NewPkGiftComponent.this.mPullUpEvent.getAnchor().giftType;
                if (giftType > 0) {
                    NewPkGiftComponent.this.mGiftItemPagerAdapter.forceUpdateAllPage();
                    NewPkGiftComponent.this.mRootView.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            NewPkGiftComponent.this.mGiftItemPagerAdapter.setSelectedGiftItemView(giftType);
                            NewPkGiftComponent.this.switchToSelectedItemPage(true);
                        }
                    }, 100L);
                }
                NewPkGiftComponent.this.mPullUpEvent = null;
            }
        });
    }

    private boolean isNewPkNow() {
        return NewPkActivitiesGiftDataCore.Companion.getInstance().getMStatus() != NewPkActivitiesGiftDataCore.Companion.getInstance().getSTATUS_NONE();
    }

    @Override
    protected void sendGift() {
        if (this.mCurrentPersonChoose == null) {
            String tips = NewPkActivitiesGiftDataCore.Companion.getInstance().getMAnchorTips();
            Toast.makeText((Context)this.getActivity().getApplicationContext(), (CharSequence)(TextUtils.isEmpty((CharSequence)tips) ? "\u8bf7\u9009\u62e9\u8d60\u9001\u5bf9\u8c61" : tips), (int)0).show();
            return;
        }
        super.sendGift();
    }

    public void setCurrentPersonChoose(PersonInfo info) {
        this.mCurrentPersonChoose = info;
        if (this.mCurrentPersonChoose == null) {
            return;
        }
        RxBus.getDefault().post((Object)new NewPkCurrentPersonChooseChangeEvent(this.mCurrentPersonChoose.uid));
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onSendPaidGift(IGiftClient_onSendPaidGift_EventArgs busEventArgs) {
        this.queryMoneyBalance();
    }

    @Override
    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mNewPkGiftComponentSniperEventBinder == null) {
            this.mNewPkGiftComponentSniperEventBinder = new NewPkGiftComponent$$EventBinder();
        }
        this.mNewPkGiftComponentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }

    private static class PersonInfo {
        @NonNull
        public Activity.AnchorPickInfo info;
        public long uid;
        @DrawableRes
        public int iconRes;

        private PersonInfo(@NonNull Activity.AnchorPickInfo info, @DrawableRes int iconRes) {
            this.info = info;
            this.iconRes = iconRes;
            this.uid = info.aid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PersonInfo that = (PersonInfo)o;
            return this.uid == that.uid;
        }

        public int hashCode() {
            return (int)(this.uid ^ this.uid >>> 32);
        }
    }

    private class ChoosePersonButtonBox {
        LinearLayout chooseLayout;
        TextView supportTextView;
        ImageView circleImageView;
        TextView nickNameTextView;

        private ChoosePersonButtonBox() {
            this.chooseLayout = new YYLinearLayout(NewPkGiftComponent.this.getContext());
            this.chooseLayout.setGravity(17);
            this.chooseLayout.setOrientation(0);
            this.chooseLayout.setBackgroundResource(R.drawable.bg_choose_person_selector);
            this.supportTextView = new YYTextView(NewPkGiftComponent.this.getContext());
            this.supportTextView.setMaxLines(1);
            this.supportTextView.setGravity(17);
            this.supportTextView.setTextSize(13.0f);
            this.supportTextView.setTextColor(NewPkGiftComponent.this.getResources().getColor(R.color.live_common_color_1));
            this.chooseLayout.addView((View)this.supportTextView);
            this.circleImageView = new ImageView(NewPkGiftComponent.this.getContext());
            this.chooseLayout.addView((View)this.circleImageView);
            this.nickNameTextView = new YYTextView(NewPkGiftComponent.this.getContext());
            this.nickNameTextView.setMaxLines(1);
            this.nickNameTextView.setGravity(17);
            this.nickNameTextView.setTextSize(13.0f);
            this.nickNameTextView.setEllipsize(TextUtils.TruncateAt.END);
            this.nickNameTextView.setTextColor(NewPkGiftComponent.this.getResources().getColor(R.color.live_common_color_1));
            this.nickNameTextView.setText((CharSequence)"\u8bf7\u9009\u62e9\u8d60\u9001\u5bf9\u8c61");
            this.chooseLayout.addView((View)this.nickNameTextView);
        }
    }

    public class PersonChooseAdapter
    extends BaseAdapter {
        public List<PersonInfo> infoList = new ArrayList<PersonInfo>();

        public int getCount() {
            return this.infoList.size();
        }

        public PersonInfo getItem(int position) {
            if (this.infoList.size() > position) {
                return this.infoList.get(position);
            }
            return null;
        }

        public PersonInfo getItemByUid(long uid) {
            for (PersonInfo personInfo : this.infoList) {
                if (personInfo.uid != uid) continue;
                return personInfo;
            }
            return null;
        }

        public long getItemId(int position) {
            return 0L;
        }

        public void setData(List<PersonInfo> data) {
            this.infoList.clear();
            this.infoList.addAll(data);
        }

        boolean equalsData(@NonNull List<PersonInfo> data) {
            if (this.infoList.size() != data.size()) {
                return false;
            }
            for (int index = 0; index < this.infoList.size(); ++index) {
                if (this.infoList.get(index).equals(data.get(index))) continue;
                return false;
            }
            return true;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            PersonInfo info = this.infoList.get(position);
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)NewPkGiftComponent.this.getContext()).inflate(R.layout.new_pk_person_list_item, parent, false);
            }
            TextView textPrefix = (TextView)convertView.findViewById(R.id.new_pk_support_text);
            ImageView colorIcon = (ImageView)convertView.findViewById(R.id.new_pk_color_icon);
            TextView personName = (TextView)convertView.findViewById(R.id.new_pk_person_name);
            boolean isNeedDot = NewPkActivitiesGiftDataCore.Companion.getInstance().isDotShow(info.uid);
            if (isNeedDot) {
                textPrefix.setText((CharSequence)"\u652f\u6301");
                colorIcon.setImageResource(info.iconRes);
            } else {
                textPrefix.setText((CharSequence)"\u9001\u7ed9");
                colorIcon.setImageBitmap(null);
            }
            personName.setText((CharSequence)info.info.nick);
            return convertView;
        }
    }
}

